/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.portal.action.JSONServiceAction;
import com.liferay.portal.jsonwebservice.JSONWebServiceConfigurator;
import com.liferay.portal.jsonwebservice.action.JSONWebServiceInvokerAction;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceAction;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionMapping;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionsManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.util.PropsValues;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class JSONWebServiceServiceAction
extends JSONServiceAction {
    private static final String _REROUTE_PATH = "/jsonws";
    private static Log _log = LogFactoryUtil.getLog(JSONWebServiceServiceAction.class);
    private JSONWebServiceConfigurator _jsonWebServiceConfigurator;

    public JSONWebServiceServiceAction(String servletContextPath, ClassLoader classLoader) {
        this._jsonWebServiceConfigurator = new JSONWebServiceConfigurator(servletContextPath);
        this._jsonWebServiceConfigurator.clean();
        if (PropsValues.JSON_WEB_SERVICE_ENABLED) {
            try {
                this._jsonWebServiceConfigurator.configure(classLoader);
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        } else if (_log.isInfoEnabled()) {
            _log.info((Object)"JSON web service is disabled");
        }
    }

    public void destroy() {
        this._jsonWebServiceConfigurator.clean();
    }

    public String getJSON(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONWebServiceAction jsonWebServiceAction = null;
        String path = GetterUtil.getString((String)request.getPathInfo());
        try {
            jsonWebServiceAction = path.equals("/invoke") ? new JSONWebServiceInvokerAction(request) : JSONWebServiceActionsManagerUtil.getJSONWebServiceAction((HttpServletRequest)request);
            JSONWebServiceActionMapping jsonWebServiceActionMapping = jsonWebServiceAction.getJSONWebServiceActionMapping();
            String actionMethodName = null;
            if (jsonWebServiceActionMapping != null) {
                Method actionMethod = jsonWebServiceActionMapping.getActionMethod();
                actionMethodName = actionMethod.getName();
            }
            this.checkMethodGuestAccess(request, actionMethodName, PropsValues.JSONWS_WEB_SERVICE_PUBLIC_METHODS);
            Object returnObj = jsonWebServiceAction.invoke();
            if (returnObj != null) {
                return this.getReturnValue(returnObj);
            }
            return JSONFactoryUtil.getNullJSON();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            return JSONFactoryUtil.serializeException((Exception)e2);
        }
    }

    protected String getReroutePath() {
        return _REROUTE_PATH;
    }
}

