/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.portal.jsonwebservice.JSONWebServiceServiceAction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ContextPathUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.servlet.JSONServlet;
import com.liferay.portal.servlet.UserResolver;
import com.liferay.portal.struts.JSONAction;
import com.liferay.portal.upload.UploadServletRequestImpl;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class JSONWebServiceServlet
extends JSONServlet {
    private static Log _log = LogFactoryUtil.getLog(JSONWebServiceServlet.class);
    private JSONWebServiceServiceAction _jsonWebServiceServiceAction;

    public void destroy() {
        this._jsonWebServiceServiceAction.destroy();
        super.destroy();
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String path;
        if (PortalUtil.isMultipartRequest((HttpServletRequest)request)) {
            UploadServletRequestImpl uploadServletRequest = new UploadServletRequestImpl((HttpServletRequest)request);
            request = uploadServletRequest;
        }
        if (!(path = GetterUtil.getString((String)request.getPathInfo())).equals("/") && !path.equals("")) {
            super.service((HttpServletRequest)request, response);
            return;
        }
        String uri = request.getRequestURI();
        int pos = uri.indexOf("/secure/");
        if (pos != -1) {
            uri = String.valueOf(uri.substring(0, pos)) + uri.substring(pos + 7);
            String queryString = request.getQueryString();
            if (queryString != null) {
                uri = uri.concat("?").concat(queryString);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Redirect from secure to public");
            }
            response.sendRedirect(uri);
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Servlet context " + request.getContextPath()));
        }
        String apiPath = String.valueOf(PortalUtil.getPathMain()) + "/portal/api/jsonws";
        HttpSession session = request.getSession();
        ServletContext servletContext = session.getServletContext();
        if (servletContext.getContext(PropsValues.PORTAL_CTX) != null) {
            RequestDispatcher requestDispatcher = request.getRequestDispatcher(apiPath);
            requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
        } else {
            String requestURI = request.getRequestURI();
            String requestURL = String.valueOf(request.getRequestURL());
            String serverURL = requestURL.substring(0, requestURL.length() - requestURI.length());
            String queryString = request.getQueryString();
            queryString = Validator.isNull((String)queryString) ? "" : String.valueOf(queryString) + "&";
            String servletContextPath = ContextPathUtil.getContextPath((ServletContext)servletContext);
            queryString = String.valueOf(queryString) + "contextPath=" + HttpUtil.encodeURL((String)servletContextPath);
            apiPath = String.valueOf(serverURL) + apiPath + "?" + queryString;
            URL url = new URL(apiPath);
            InputStream inputStream = null;
            try {
                inputStream = url.openStream();
                ServletOutputStream outputStream = response.getOutputStream();
                StreamUtil.transfer((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                StreamUtil.cleanUp((InputStream)inputStream);
            }
        }
    }

    protected JSONAction getJSONAction(ServletContext servletContext) {
        ClassLoader classLoader = (ClassLoader)servletContext.getAttribute("PLUGIN_CLASS_LOADER");
        this._jsonWebServiceServiceAction = new JSONWebServiceServiceAction(ContextPathUtil.getContextPath((ServletContext)servletContext), classLoader);
        this._jsonWebServiceServiceAction.setServletContext(servletContext);
        return this._jsonWebServiceServiceAction;
    }

    protected void resolveRemoteUser(HttpServletRequest request) throws Exception {
        UserResolver userResolver = new UserResolver(request);
        CompanyThreadLocal.setCompanyId((Long)userResolver.getCompanyId());
        request.setAttribute("companyId", (Object)userResolver.getCompanyId());
        User user = userResolver.getUser();
        if (user != null) {
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            request.setAttribute("user", (Object)user);
            request.setAttribute("userId", (Object)user.getUserId());
        }
    }
}

