/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice.action;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONSerializable;
import com.liferay.portal.kernel.json.JSONSerializer;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceAction;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionMapping;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionsManagerUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import jodd.bean.BeanUtil;
import jodd.servlet.ServletUtil;
import jodd.util.KeyValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONWebServiceInvokerAction
implements JSONWebServiceAction {
    private String _command;
    private HttpServletRequest _request;
    private List<Statement> _statements = new ArrayList<Statement>();

    public JSONWebServiceInvokerAction(HttpServletRequest request) {
        this._request = request;
        this._command = request.getParameter("cmd");
        if (this._command == null) {
            try {
                this._command = ServletUtil.readRequestBody((HttpServletRequest)request);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException(ioe);
            }
        }
    }

    public JSONWebServiceActionMapping getJSONWebServiceActionMapping() {
        return null;
    }

    public Object invoke() throws Exception {
        Object command = JSONFactoryUtil.looseDeserializeSafe((String)this._command);
        ArrayList<Object> list = null;
        boolean batchMode = false;
        if (command instanceof List) {
            list = (ArrayList<Object>)command;
            batchMode = true;
        } else if (command instanceof Map) {
            list = new ArrayList<Object>(1);
            list.add(command);
            batchMode = false;
        } else {
            throw new IllegalArgumentException();
        }
        int i2 = 0;
        while (i2 < list.size()) {
            Map map = (Map)list.get(i2);
            if (map.isEmpty()) {
                throw new IllegalArgumentException();
            }
            Set entrySet = map.entrySet();
            Iterator iterator = entrySet.iterator();
            Map.Entry entry = iterator.next();
            Statement statement = this._parseStatement((String)entry.getKey(), (Map)entry.getValue());
            Object result = this._executeStatement(statement);
            list.set(i2, result);
            ++i2;
        }
        ArrayList<Object> result = null;
        result = !batchMode ? list.get(0) : list;
        return new InvokerResult(result);
    }

    private Object _addVariableStatement(Statement variableStatement, Object result) throws Exception {
        String name = variableStatement.getName();
        Object variableResult = this._executeStatement(variableStatement);
        Map<String, Object> map = this._convertObjectToMap(result);
        map.put(name.substring(1), variableResult);
        return map;
    }

    private Object _addVariableStatementList(Statement variableStatement, Object result, List<Object> results) throws Exception {
        List<Object> list = this._convertObjectToList(result);
        for (Object object : list) {
            Object value;
            if (object instanceof List) {
                value = this._addVariableStatementList(variableStatement, object, results);
                results.add(value);
                continue;
            }
            value = this._addVariableStatement(variableStatement, object);
            results.add(value);
        }
        return results;
    }

    private List<Object> _convertObjectToList(Object object) {
        if (!(object instanceof List)) {
            String json = JSONFactoryUtil.looseSerialize((Object)object);
            object = JSONFactoryUtil.looseDeserialize((String)json, ArrayList.class);
        }
        return (List)object;
    }

    private Map<String, Object> _convertObjectToMap(Object object) {
        if (!(object instanceof Map)) {
            String json = JSONFactoryUtil.looseSerialize((Object)object);
            object = JSONFactoryUtil.looseDeserialize((String)json, HashMap.class);
        }
        return (Map)object;
    }

    private Object _executeStatement(Statement statement) throws Exception {
        JSONWebServiceAction jsonWebServiceAction = JSONWebServiceActionsManagerUtil.getJSONWebServiceAction((HttpServletRequest)this._request, (String)statement.getMethod(), null, statement.getParameterMap());
        List<Object> result = jsonWebServiceAction.invoke();
        if (result instanceof List) {
            result = this._populateFlagsList(statement.getName(), result, new ArrayList<Object>());
            result = this._filterResultList(statement, result, new ArrayList<Object>());
        } else {
            this._populateFlags(statement.getName(), result);
            result = this._filterResult(statement, result);
        }
        List<Statement> variableStatements = statement.getVariableStatements();
        if (variableStatements != null) {
            for (Statement variableStatement : variableStatements) {
                result = result instanceof List ? this._addVariableStatementList(variableStatement, result, new ArrayList<Object>()) : this._addVariableStatement(variableStatement, result);
            }
        }
        return result;
    }

    private Object _filterResult(Statement statement, Object result) {
        if (result == null) {
            return result;
        }
        String[] whitelist = statement.getWhitelist();
        if (whitelist == null) {
            return result;
        }
        Map<String, Object> map = this._convertObjectToMap(result);
        HashMap<String, Object> whitelistMap = new HashMap<String, Object>(whitelist.length);
        String[] stringArray = whitelist;
        int n = whitelist.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            Object value = map.get(key);
            whitelistMap.put(key, value);
            ++n2;
        }
        return whitelistMap;
    }

    private Object _filterResultList(Statement statement, Object result, List<Object> results) {
        List<Object> list = this._convertObjectToList(result);
        for (Object object : list) {
            Object value = this._filterResult(statement, object);
            results.add(value);
        }
        return results;
    }

    private Statement _parseStatement(String assignment, Map<String, Object> parameterMap) {
        Statement statement = new Statement();
        this._statements.add(statement);
        int x = assignment.indexOf("=");
        if (x == -1) {
            statement.setMethod(assignment.trim());
        } else {
            String name = assignment.substring(0, x).trim();
            int y = name.indexOf("[");
            if (y != -1) {
                String whitelistString = name.substring(y + 1, name.length() - 1);
                String[] whiteList = StringUtil.split((String)whitelistString);
                int i2 = 0;
                while (i2 < whiteList.length) {
                    whiteList[i2] = whiteList[i2].trim();
                    ++i2;
                }
                statement.setWhitelist(whiteList);
                name = name.substring(0, y);
            }
            statement.setName(name);
            statement.setMethod(assignment.substring(x + 1).trim());
        }
        statement.setParameterMap(parameterMap);
        Set<String> keySet = parameterMap.keySet();
        Iterator<String> iterator = keySet.iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (key.startsWith("@")) {
                String value = (String)parameterMap.get(key);
                iterator.remove();
                List<Flag> flags = statement.getFlags();
                if (flags == null) {
                    flags = new ArrayList<Flag>();
                    statement.setFlags(flags);
                }
                Flag flag = new Flag();
                flag.setKey(key.substring(1));
                flag.setValue(value);
                flags.add(flag);
                continue;
            }
            if (!key.startsWith("$")) continue;
            Map map = (Map)parameterMap.get(key);
            iterator.remove();
            List<Statement> variableStatements = statement.getVariableStatements();
            if (variableStatements == null) {
                variableStatements = new ArrayList<Statement>();
                statement.setVariableStatements(variableStatements);
            }
            Statement variableStatement = this._parseStatement(key, map);
            variableStatements.add(variableStatement);
        }
        return statement;
    }

    private void _populateFlags(String name, Object object) {
        if (name == null) {
            return;
        }
        name = name.concat(".");
        for (Statement statement : this._statements) {
            List<Flag> flags = statement.getFlags();
            if (flags == null) continue;
            for (Flag flag : flags) {
                String value = (String)flag.getValue();
                if (value == null || !value.startsWith(name)) continue;
                Map<String, Object> parameterMap = statement.getParameterMap();
                Object propertyValue = BeanUtil.getDeclaredProperty((Object)object, (String)value.substring(name.length()));
                parameterMap.put((String)flag.getKey(), propertyValue);
                flag.setValue(null);
            }
        }
    }

    private List<Object> _populateFlagsList(String name, Object result, List<Object> results) {
        List<Object> list = this._convertObjectToList(result);
        for (Object object : list) {
            if (object instanceof List) {
                List<Object> value = this._populateFlagsList(name, object, results);
                results.add(value);
                continue;
            }
            this._populateFlags(name, object);
            results.add(object);
        }
        return results;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Flag
    extends KeyValue<String, String> {
        private Flag() {
        }
    }

    public class InvokerResult
    implements JSONSerializable {
        private Object _result;

        public String toJSONString() {
            if (this._result == null) {
                return JSONFactoryUtil.getNullJSON();
            }
            JSONSerializer jsonSerializer = JSONFactoryUtil.createJSONSerializer();
            jsonSerializer.exclude(new String[]{"*.class"});
            for (Statement statement : JSONWebServiceInvokerAction.this._statements) {
                String name = statement.getName();
                if (name == null) continue;
                jsonSerializer.include(new String[]{name.substring(1)});
            }
            return jsonSerializer.serialize(this._result);
        }

        public Object getResult() {
            return this._result;
        }

        private InvokerResult(Object result) {
            this._result = result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Statement {
        private List<Flag> _flags;
        private String _method;
        private String _name;
        private Map<String, Object> _parameterMap;
        private List<Statement> _variableStatements;
        private String[] _whitelist;

        private Statement() {
        }

        public List<Flag> getFlags() {
            return this._flags;
        }

        public String getMethod() {
            return this._method;
        }

        public String getName() {
            return this._name;
        }

        public Map<String, Object> getParameterMap() {
            return this._parameterMap;
        }

        public List<Statement> getVariableStatements() {
            return this._variableStatements;
        }

        public String[] getWhitelist() {
            return this._whitelist;
        }

        public void setFlags(List<Flag> flags) {
            this._flags = flags;
        }

        public void setMethod(String method) {
            this._method = method;
        }

        public void setName(String name) {
            this._name = name;
        }

        public void setParameterMap(Map<String, Object> parameterMap) {
            this._parameterMap = parameterMap;
        }

        public void setVariableStatements(List<Statement> variableStatements) {
            this._variableStatements = variableStatements;
        }

        public void setWhitelist(String[] whitelist) {
            this._whitelist = whitelist;
        }
    }
}

