/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lar.ImportExportThreadLocal;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.staging.LayoutStagingUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.kernel.zip.ZipWriterFactoryUtil;
import com.liferay.portal.lar.LayoutCache;
import com.liferay.portal.lar.PermissionExporter;
import com.liferay.portal.lar.PortletDataContextImpl;
import com.liferay.portal.lar.PortletDataContextListenerImpl;
import com.liferay.portal.lar.PortletExporter;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.model.LayoutRevision;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.model.LayoutStagingHandler;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.Theme;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutPrototypeLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.service.persistence.LayoutRevisionUtil;
import com.liferay.portal.theme.ThemeLoader;
import com.liferay.portal.theme.ThemeLoaderFactory;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.service.AssetVocabularyLocalServiceUtil;
import com.liferay.portlet.asset.service.persistence.AssetCategoryUtil;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.lar.JournalPortletDataHandlerImpl;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.util.ContentUtil;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.servlet.ServletContext;
import org.apache.commons.lang.time.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutExporter {
    public static final String SAME_GROUP_FRIENDLY_URL = "/[$SAME_GROUP_FRIENDLY_URL$]";
    private static Log _log = LogFactoryUtil.getLog(LayoutExporter.class);
    private PermissionExporter _permissionExporter = new PermissionExporter();
    private PortletExporter _portletExporter = new PortletExporter();

    public static List<Portlet> getAlwaysExportablePortlets(long companyId) throws Exception {
        List portlets = PortletLocalServiceUtil.getPortlets((long)companyId);
        Iterator itr = portlets.iterator();
        while (itr.hasNext()) {
            Portlet portlet = (Portlet)itr.next();
            if (!portlet.isActive()) {
                itr.remove();
                continue;
            }
            PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
            if (portletDataHandler != null && portletDataHandler.isAlwaysExportable()) continue;
            itr.remove();
        }
        return portlets;
    }

    public static void updateLastPublishDate(LayoutSet layoutSet, long lastPublishDate) throws Exception {
        UnicodeProperties settingsProperties = layoutSet.getSettingsProperties();
        if (lastPublishDate <= 0L) {
            settingsProperties.remove((Object)"last-publish-date");
        } else {
            settingsProperties.setProperty("last-publish-date", String.valueOf(lastPublishDate));
        }
        LayoutSetLocalServiceUtil.updateSettings((long)layoutSet.getGroupId(), (boolean)layoutSet.isPrivateLayout(), (String)settingsProperties.toString());
    }

    public byte[] exportLayouts(long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        File file = this.exportLayoutsAsFile(groupId, privateLayout, layoutIds, parameterMap, startDate, endDate);
        try {
            byte[] byArray = FileUtil.getBytes((File)file);
            return byArray;
        }
        finally {
            file.delete();
        }
    }

    public File exportLayoutsAsFile(long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        try {
            ImportExportThreadLocal.setLayoutExportInProcess((boolean)true);
            File file = this.doExportLayoutsAsFile(groupId, privateLayout, layoutIds, parameterMap, startDate, endDate);
            return file;
        }
        finally {
            ImportExportThreadLocal.setLayoutExportInProcess((boolean)false);
        }
    }

    protected File doExportLayoutsAsFile(long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        Image image;
        boolean exportCategories = MapUtil.getBoolean(parameterMap, (String)"CATEGORIES");
        boolean exportIgnoreLastPublishDate = MapUtil.getBoolean(parameterMap, (String)"IGNORE_LAST_PUBLISH_DATE");
        boolean exportPermissions = MapUtil.getBoolean(parameterMap, (String)"PERMISSIONS");
        boolean exportUserPermissions = MapUtil.getBoolean(parameterMap, (String)"USER_PERMISSIONS");
        boolean exportPortletArchivedSetups = MapUtil.getBoolean(parameterMap, (String)"PORTLET_ARCHIVED_SETUPS");
        boolean exportPortletUserPreferences = MapUtil.getBoolean(parameterMap, (String)"PORTLET_USER_PREFERENCES");
        boolean exportTheme = MapUtil.getBoolean(parameterMap, (String)"THEME");
        boolean exportThemeSettings = MapUtil.getBoolean(parameterMap, (String)"THEME_REFERENCE");
        boolean exportLogo = MapUtil.getBoolean(parameterMap, (String)"LOGO");
        boolean exportLayoutSetSettings = MapUtil.getBoolean(parameterMap, (String)"LAYOUT_SET_SETTINGS");
        boolean updateLastPublishDate = MapUtil.getBoolean(parameterMap, (String)"UPDATE_LAST_PUBLISH_DATE");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export categories " + exportCategories));
            _log.debug((Object)("Export permissions " + exportPermissions));
            _log.debug((Object)("Export user permissions " + exportUserPermissions));
            _log.debug((Object)("Export portlet archived setups " + exportPortletArchivedSetups));
            _log.debug((Object)("Export portlet user preferences " + exportPortletUserPreferences));
            _log.debug((Object)("Export theme " + exportTheme));
        }
        LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
        long companyId = layoutSet.getCompanyId();
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setSignedIn(false);
            serviceContext.setUserId(defaultUserId);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        }
        serviceContext.setAttribute("exporting", (Serializable)Boolean.TRUE);
        long layoutSetBranchId = MapUtil.getLong(parameterMap, (String)"layoutSetBranchId");
        serviceContext.setAttribute("layoutSetBranchId", (Serializable)Long.valueOf(layoutSetBranchId));
        long lastPublishDate = System.currentTimeMillis();
        if (endDate != null) {
            lastPublishDate = endDate.getTime();
        }
        if (exportIgnoreLastPublishDate) {
            endDate = null;
            startDate = null;
        }
        StopWatch stopWatch = null;
        if (_log.isInfoEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        LayoutCache layoutCache = new LayoutCache();
        ZipWriter zipWriter = ZipWriterFactoryUtil.getZipWriter();
        PortletDataContextImpl portletDataContext = new PortletDataContextImpl(companyId, groupId, parameterMap, new HashSet<String>(), startDate, endDate, zipWriter);
        portletDataContext.setPortetDataContextListener(new PortletDataContextListenerImpl(portletDataContext));
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("root");
        Element headerElement = rootElement.addElement("header");
        headerElement.addAttribute("available-locales", StringUtil.merge((Object[])LanguageUtil.getAvailableLocales()));
        headerElement.addAttribute("build-number", String.valueOf(ReleaseInfo.getBuildNumber()));
        headerElement.addAttribute("export-date", Time.getRFC822());
        if (portletDataContext.hasDateRange()) {
            headerElement.addAttribute("start-date", String.valueOf(portletDataContext.getStartDate()));
            headerElement.addAttribute("end-date", String.valueOf(portletDataContext.getEndDate()));
        }
        headerElement.addAttribute("group-id", String.valueOf(groupId));
        headerElement.addAttribute("private-layout", String.valueOf(privateLayout));
        Group group = layoutSet.getGroup();
        String type = "layout-set";
        if (group.isLayoutPrototype()) {
            type = "layout-prototype";
            LayoutPrototype layoutPrototype = LayoutPrototypeLocalServiceUtil.getLayoutPrototype((long)group.getClassPK());
            headerElement.addAttribute("type-uuid", layoutPrototype.getUuid());
        } else if (group.isLayoutSetPrototype()) {
            type = "layout-set-prototype";
            LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototype((long)group.getClassPK());
            headerElement.addAttribute("type-uuid", layoutSetPrototype.getUuid());
        }
        headerElement.addAttribute("type", type);
        if (exportTheme || exportThemeSettings) {
            headerElement.addAttribute("theme-id", layoutSet.getThemeId());
            headerElement.addAttribute("color-scheme-id", layoutSet.getColorSchemeId());
        }
        if (exportLogo && (image = ImageLocalServiceUtil.getImage((long)layoutSet.getLogoId())) != null && image.getTextObj() != null) {
            String logoPath = this.getLayoutSetLogoPath(portletDataContext);
            headerElement.addAttribute("logo-path", logoPath);
            portletDataContext.addZipEntry(logoPath, image.getTextObj());
        }
        if (exportLayoutSetSettings) {
            Element settingsElement = headerElement.addElement("settings");
            settingsElement.addCDATA(layoutSet.getSettings());
        }
        Element cssElement = headerElement.addElement("css");
        cssElement.addCDATA(layoutSet.getCss());
        Portlet layoutConfigurationPortlet = PortletLocalServiceUtil.getPortletById((long)portletDataContext.getCompanyId(), (String)"87");
        LinkedHashMap<String, Object[]> portletIds = new LinkedHashMap<String, Object[]>();
        List layouts = null;
        layouts = layoutIds == null || layoutIds.length == 0 ? LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout) : LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout, (long[])layoutIds);
        List<Portlet> portlets = LayoutExporter.getAlwaysExportablePortlets(companyId);
        long plid = 0L;
        if (!layouts.isEmpty()) {
            Layout firstLayout = (Layout)layouts.get(0);
            plid = firstLayout.getPlid();
        }
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        for (Portlet portlet : portlets) {
            String key;
            String portletId = portlet.getRootPortletId();
            if (!group.isStagedPortlet(portletId) || portletIds.get(key = PortletPermissionUtil.getPrimaryKey((long)0L, (String)portletId)) != null) continue;
            portletIds.put(key, new Object[]{portletId, plid, groupId, "", ""});
        }
        Element layoutsElement = rootElement.addElement("layouts");
        String layoutSetPrototypeUuid = layoutSet.getLayoutSetPrototypeUuid();
        if (Validator.isNotNull((String)layoutSetPrototypeUuid)) {
            LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuid((String)layoutSetPrototypeUuid);
            layoutsElement.addAttribute("layout-set-prototype-uuid", layoutSetPrototypeUuid);
            layoutsElement.addAttribute("layout-set-prototype-name", layoutSetPrototype.getName(LocaleUtil.getDefault()));
        }
        for (Layout layout : layouts) {
            this.exportLayout(portletDataContext, layoutConfigurationPortlet, layoutCache, portlets, portletIds, exportPermissions, exportUserPermissions, layout, layoutsElement);
        }
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM < 5) {
            Element rolesElement = rootElement.addElement("roles");
            if (exportPermissions) {
                this._permissionExporter.exportLayoutRoles(layoutCache, companyId, groupId, rolesElement);
            }
        }
        long previousScopeGroupId = portletDataContext.getScopeGroupId();
        Element portletsElement = rootElement.addElement("portlets");
        for (Map.Entry portletIdsEntry : portletIds.entrySet()) {
            Object[] portletObjects = (Object[])portletIdsEntry.getValue();
            String portletId = null;
            plid = 0L;
            long scopeGroupId = 0L;
            String scopeType = "";
            String scopeLayoutUuid = null;
            if (portletObjects.length == 4) {
                portletId = (String)((Object[])portletIdsEntry.getValue())[0];
                plid = (Long)((Object[])portletIdsEntry.getValue())[1];
                scopeGroupId = (Long)((Object[])portletIdsEntry.getValue())[2];
                scopeLayoutUuid = (String)((Object[])portletIdsEntry.getValue())[3];
            } else {
                portletId = (String)((Object[])portletIdsEntry.getValue())[0];
                plid = (Long)((Object[])portletIdsEntry.getValue())[1];
                scopeGroupId = (Long)((Object[])portletIdsEntry.getValue())[2];
                scopeType = (String)((Object[])portletIdsEntry.getValue())[3];
                scopeLayoutUuid = (String)((Object[])portletIdsEntry.getValue())[4];
            }
            Layout layout = LayoutLocalServiceUtil.fetchLayout((long)plid);
            if (layout == null) {
                if (!group.isCompany() && plid <= 0L) continue;
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Assuming global scope because no layout was found");
                }
                layout = new LayoutImpl();
                layout.setGroupId(groupId);
                layout.setCompanyId(companyId);
            }
            portletDataContext.setPlid(plid);
            portletDataContext.setOldPlid(plid);
            portletDataContext.setScopeGroupId(scopeGroupId);
            portletDataContext.setScopeType(scopeType);
            portletDataContext.setScopeLayoutUuid(scopeLayoutUuid);
            boolean[] exportPortletControls = this.getExportPortletControls(companyId, portletId, portletDataContext, parameterMap);
            this._portletExporter.exportPortlet(portletDataContext, layoutCache, portletId, layout, portletsElement, defaultUserId, exportPermissions, exportPortletArchivedSetups, exportPortletControls[0], exportPortletControls[1], exportPortletUserPreferences, exportUserPermissions);
        }
        portletDataContext.setScopeGroupId(previousScopeGroupId);
        if (exportCategories || group.isCompany()) {
            this.exportAssetCategories(portletDataContext);
        }
        this._portletExporter.exportAssetLinks(portletDataContext);
        this._portletExporter.exportAssetTags(portletDataContext);
        this._portletExporter.exportComments(portletDataContext);
        this._portletExporter.exportExpandoTables(portletDataContext);
        this._portletExporter.exportLocks(portletDataContext);
        if (exportPermissions) {
            this._permissionExporter.exportPortletDataPermissions(portletDataContext);
        }
        this._portletExporter.exportRatingsEntries(portletDataContext, rootElement);
        if (exportTheme && !portletDataContext.isPerformDirectBinaryImport()) {
            this.exportTheme(layoutSet, zipWriter);
        }
        if (_log.isInfoEnabled()) {
            if (stopWatch != null) {
                _log.info((Object)("Exporting layouts takes " + stopWatch.getTime() + " ms"));
            } else {
                _log.info((Object)"Exporting layouts is finished");
            }
        }
        portletDataContext.addZipEntry("/manifest.xml", document.formattedString());
        try {
            File file = zipWriter.getFile();
            return file;
        }
        finally {
            if (updateLastPublishDate) {
                LayoutExporter.updateLastPublishDate(layoutSet, lastPublishDate);
            }
        }
    }

    protected void exportAssetCategories(PortletDataContext portletDataContext) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("categories-hierarchy");
        Element assetVocabulariesElement = rootElement.addElement("vocabularies");
        List assetVocabularies = AssetVocabularyLocalServiceUtil.getGroupVocabularies((long)portletDataContext.getGroupId());
        for (AssetVocabulary assetVocabulary : assetVocabularies) {
            this._portletExporter.exportAssetVocabulary(portletDataContext, assetVocabulariesElement, assetVocabulary);
        }
        Element categoriesElement = rootElement.addElement("categories");
        List assetCategories = AssetCategoryUtil.findByGroupId((long)portletDataContext.getGroupId());
        for (AssetCategory assetCategory : assetCategories) {
            this._portletExporter.exportAssetCategory(portletDataContext, assetVocabulariesElement, categoriesElement, assetCategory);
        }
        this._portletExporter.exportAssetCategories(portletDataContext, rootElement);
        portletDataContext.addZipEntry(String.valueOf(portletDataContext.getRootPath()) + "/categories-hierarchy.xml", document.formattedString());
    }

    protected void exportJournalArticle(PortletDataContext portletDataContext, Layout layout, Element layoutElement) throws Exception {
        JournalArticle article;
        block4: {
            UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
            String articleId = typeSettingsProperties.getProperty("article-id", "");
            long articleGroupId = layout.getGroupId();
            if (Validator.isNull((String)articleId) && _log.isWarnEnabled()) {
                _log.warn((Object)("No article id found in typeSettings of layout " + layout.getPlid()));
            }
            article = null;
            try {
                article = JournalArticleLocalServiceUtil.getLatestArticle((long)articleGroupId, (String)articleId, (int)0);
            }
            catch (NoSuchArticleException noSuchArticleException) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)("No approved article found with group id " + articleGroupId + " and article id " + articleId));
            }
        }
        if (article == null) {
            return;
        }
        String path = JournalPortletDataHandlerImpl.getArticlePath(portletDataContext, article);
        Element articleElement = layoutElement.addElement("article");
        articleElement.addAttribute("path", path);
        Element dlFileEntryTypesElement = layoutElement.addElement("dl-file-entry-types");
        Element dlFoldersElement = layoutElement.addElement("dl-folders");
        Element dlFilesElement = layoutElement.addElement("dl-file-entries");
        Element dlFileRanksElement = layoutElement.addElement("dl-file-ranks");
        Element dlRepositoriesElement = layoutElement.addElement("dl-repositories");
        Element dlRepositoryEntriesElement = layoutElement.addElement("dl-repository-entries");
        JournalPortletDataHandlerImpl.exportArticle(portletDataContext, layoutElement, layoutElement, layoutElement, dlFileEntryTypesElement, dlFoldersElement, dlFilesElement, dlFileRanksElement, dlRepositoriesElement, dlRepositoryEntriesElement, article, null, false);
    }

    protected void exportLayout(PortletDataContext portletDataContext, Portlet layoutConfigurationPortlet, LayoutCache layoutCache, List<Portlet> portlets, Map<String, Object[]> portletIds, boolean exportPermissions, boolean exportUserPermissions, Layout layout, Element layoutsElement) throws Exception {
        Image image;
        boolean deleteLayout;
        String layoutPrototypeUuid;
        Layout parentLayout;
        String path = String.valueOf(portletDataContext.getLayoutPath(layout.getLayoutId())) + "/layout.xml";
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        LayoutRevision layoutRevision = null;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        boolean exportLAR = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"exportLAR");
        if (!exportLAR && LayoutStagingUtil.isBranchingLayout((Layout)layout) && !layout.isTypeURL()) {
            long layoutSetBranchId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"layoutSetBranchId");
            if (layoutSetBranchId <= 0L) {
                return;
            }
            layoutRevision = LayoutRevisionUtil.fetchByL_H_P((long)layoutSetBranchId, (boolean)true, (long)layout.getPlid());
            if (layoutRevision == null) {
                return;
            }
            LayoutStagingHandler layoutStagingHandler = LayoutStagingUtil.getLayoutStagingHandler((Layout)layout);
            layoutStagingHandler.setLayoutRevision(layoutRevision);
        }
        Element layoutElement = layoutsElement.addElement("layout");
        if (layoutRevision != null) {
            layoutElement.addAttribute("layout-revision-id", String.valueOf(layoutRevision.getLayoutRevisionId()));
            layoutElement.addAttribute("layout-branch-id", String.valueOf(layoutRevision.getLayoutBranchId()));
            layoutElement.addAttribute("layout-branch-name", String.valueOf(layoutRevision.getLayoutBranch().getName()));
        }
        layoutElement.addAttribute("layout-uuid", layout.getUuid());
        layoutElement.addAttribute("layout-id", String.valueOf(layout.getLayoutId()));
        long parentLayoutId = layout.getParentLayoutId();
        if (parentLayoutId != 0L && (parentLayout = LayoutLocalServiceUtil.getLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)parentLayoutId)) != null) {
            layoutElement.addAttribute("parent-layout-uuid", parentLayout.getUuid());
        }
        if (Validator.isNotNull((String)(layoutPrototypeUuid = layout.getLayoutPrototypeUuid()))) {
            LayoutPrototype layoutPrototype = LayoutPrototypeLocalServiceUtil.getLayoutPrototypeByUuid((String)layoutPrototypeUuid);
            layoutElement.addAttribute("layout-prototype-uuid", layoutPrototypeUuid);
            layoutElement.addAttribute("layout-prototype-name", layoutPrototype.getName(LocaleUtil.getDefault()));
        }
        if (deleteLayout = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)("delete_" + layout.getPlid()))) {
            layoutElement.addAttribute("delete", String.valueOf(true));
            return;
        }
        portletDataContext.setPlid(layout.getPlid());
        if (layout.isIconImage() && (image = ImageLocalServiceUtil.getImage((long)layout.getIconImageId())) != null) {
            String iconPath = this.getLayoutIconPath(portletDataContext, layout, image);
            layoutElement.addElement("icon-image-path").addText(iconPath);
            portletDataContext.addZipEntry(iconPath, image.getTextObj());
        }
        this._portletExporter.exportPortletData(portletDataContext, layoutConfigurationPortlet, layout, null, layoutElement);
        if (exportPermissions) {
            this._permissionExporter.exportLayoutPermissions(portletDataContext, layoutCache, portletDataContext.getCompanyId(), portletDataContext.getScopeGroupId(), layout, layoutElement, exportUserPermissions);
        }
        if (layout.isTypeArticle()) {
            this.exportJournalArticle(portletDataContext, layout, layoutElement);
        } else if (layout.isTypeLinkToLayout()) {
            UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
            long linkToLayoutId = GetterUtil.getLong((String)typeSettingsProperties.getProperty("linkToLayoutId", ""));
            if (linkToLayoutId > 0L) {
                try {
                    Layout linkedToLayout = LayoutLocalServiceUtil.getLayout((long)portletDataContext.getScopeGroupId(), (boolean)layout.isPrivateLayout(), (long)linkToLayoutId);
                    this.exportLayout(portletDataContext, layoutConfigurationPortlet, layoutCache, portlets, portletIds, exportPermissions, exportUserPermissions, linkedToLayout, layoutsElement);
                }
                catch (NoSuchLayoutException noSuchLayoutException) {}
            }
        } else if (layout.isTypePortlet()) {
            for (Portlet portlet : portlets) {
                if (!portlet.isScopeable() || !layout.hasScopeGroup()) continue;
                String key = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portlet.getPortletId());
                portletIds.put(key, new Object[]{portlet.getPortletId(), layout.getPlid(), layout.getScopeGroup().getGroupId(), "", layout.getUuid()});
            }
            LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            for (String portletId : layoutTypePortlet.getPortletIds()) {
                PortletPreferences jxPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
                String scopeType = GetterUtil.getString((String)jxPreferences.getValue("lfrScopeType", null));
                String scopeLayoutUuid = GetterUtil.getString((String)jxPreferences.getValue("lfrScopeLayoutUuid", null));
                long scopeGroupId = portletDataContext.getScopeGroupId();
                if (Validator.isNotNull((String)scopeType)) {
                    Group scopeGroup = null;
                    if (scopeType.equals("company")) {
                        scopeGroup = GroupLocalServiceUtil.getCompanyGroup((long)layout.getCompanyId());
                    } else if (scopeType.equals("layout")) {
                        Layout scopeLayout = null;
                        scopeLayout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)scopeLayoutUuid, (long)portletDataContext.getGroupId());
                        if (scopeLayout == null) continue;
                        scopeGroup = scopeLayout.getScopeGroup();
                    } else {
                        throw new IllegalArgumentException("Scope type " + scopeType + " is invalid");
                    }
                    if (scopeGroup != null) {
                        scopeGroupId = scopeGroup.getGroupId();
                    }
                }
                String key = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId);
                portletIds.put(key, new Object[]{portletId, layout.getPlid(), scopeGroupId, scopeType, scopeLayoutUuid});
            }
        }
        this.fixTypeSettings(layout);
        layoutElement.addAttribute("path", path);
        portletDataContext.addExpando(layoutElement, path, (ClassedModel)layout);
        portletDataContext.addZipEntry(path, (Object)layout);
    }

    protected void exportTheme(LayoutSet layoutSet, ZipWriter zipWriter) throws Exception {
        Theme theme = layoutSet.getTheme();
        String lookAndFeelXML = ContentUtil.get((String)"com/liferay/portal/dependencies/liferay-look-and-feel.xml.tmpl");
        lookAndFeelXML = StringUtil.replace((String)lookAndFeelXML, (String[])new String[]{"[$TEMPLATE_EXTENSION$]", "[$VIRTUAL_PATH$]"}, (String[])new String[]{theme.getTemplateExtension(), theme.getVirtualPath()});
        String servletContextName = theme.getServletContextName();
        ServletContext servletContext = ServletContextPool.get((String)servletContextName);
        if (servletContext == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Servlet context not found for theme " + theme.getThemeId()));
            }
            return;
        }
        File themeZip = new File(String.valueOf(zipWriter.getPath()) + "/theme.zip");
        ZipWriter themeZipWriter = ZipWriterFactoryUtil.getZipWriter((File)themeZip);
        themeZipWriter.addEntry("liferay-look-and-feel.xml", lookAndFeelXML);
        File cssPath = null;
        File imagesPath = null;
        File javaScriptPath = null;
        File templatesPath = null;
        if (!theme.isLoadFromServletContext()) {
            ThemeLoader themeLoader = ThemeLoaderFactory.getThemeLoader(servletContextName);
            if (themeLoader == null) {
                _log.error((Object)(String.valueOf(servletContextName) + " does not map to a theme loader"));
            } else {
                String realPath = String.valueOf(themeLoader.getFileStorage().getPath()) + "/" + theme.getName();
                cssPath = new File(String.valueOf(realPath) + "/css");
                imagesPath = new File(String.valueOf(realPath) + "/images");
                javaScriptPath = new File(String.valueOf(realPath) + "/javascript");
                templatesPath = new File(String.valueOf(realPath) + "/templates");
            }
        } else {
            cssPath = new File(servletContext.getRealPath(theme.getCssPath()));
            imagesPath = new File(servletContext.getRealPath(theme.getImagesPath()));
            javaScriptPath = new File(servletContext.getRealPath(theme.getJavaScriptPath()));
            templatesPath = new File(servletContext.getRealPath(theme.getTemplatesPath()));
        }
        this.exportThemeFiles("css", cssPath, themeZipWriter);
        this.exportThemeFiles("images", imagesPath, themeZipWriter);
        this.exportThemeFiles("javascript", javaScriptPath, themeZipWriter);
        this.exportThemeFiles("templates", templatesPath, themeZipWriter);
    }

    protected void exportThemeFiles(String path, File dir, ZipWriter zipWriter) throws Exception {
        File[] files;
        if (dir == null || !dir.exists()) {
            return;
        }
        File[] fileArray = files = dir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.exportThemeFiles(String.valueOf(path) + "/" + file.getName(), file, zipWriter);
            } else {
                zipWriter.addEntry(String.valueOf(path) + "/" + file.getName(), FileUtil.getBytes((File)file));
            }
            ++n2;
        }
    }

    protected void fixTypeSettings(Layout layout) throws Exception {
        String groupFriendlyURL;
        if (!layout.isTypeURL()) {
            return;
        }
        UnicodeProperties typeSettings = layout.getTypeSettingsProperties();
        String url = GetterUtil.getString((String)typeSettings.getProperty("url"));
        String friendlyURLPrivateGroupPath = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING;
        String friendlyURLPrivateUserPath = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING;
        String friendlyURLPublicPath = PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING;
        if (!(url.startsWith(friendlyURLPrivateGroupPath) || url.startsWith(friendlyURLPrivateUserPath) || url.startsWith(friendlyURLPublicPath))) {
            return;
        }
        int x = url.indexOf(47, 1);
        if (x == -1) {
            return;
        }
        int y = url.indexOf(47, x + 1);
        if (y == -1) {
            return;
        }
        String friendlyURL = url.substring(x, y);
        if (!friendlyURL.equals(groupFriendlyURL = layout.getGroup().getFriendlyURL())) {
            return;
        }
        typeSettings.setProperty("url", String.valueOf(url.substring(0, x)) + SAME_GROUP_FRIENDLY_URL + url.substring(y));
    }

    protected boolean[] getExportPortletControls(long companyId, String portletId, PortletDataContext portletDataContext, Map<String, String[]> parameterMap) throws Exception {
        boolean exportPortletData = MapUtil.getBoolean(parameterMap, (String)"PORTLET_DATA");
        boolean exportPortletDataAll = MapUtil.getBoolean(parameterMap, (String)"PORTLET_DATA_ALL");
        boolean exportPortletSetup = MapUtil.getBoolean(parameterMap, (String)"PORTLET_SETUP");
        boolean exportPortletSetupAll = MapUtil.getBoolean(parameterMap, (String)"PORTLET_SETUP_ALL");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export portlet data " + exportPortletData));
            _log.debug((Object)("Export all portlet data " + exportPortletDataAll));
            _log.debug((Object)("Export portlet setup " + exportPortletSetup));
        }
        boolean exportCurPortletData = exportPortletData;
        boolean exportCurPortletSetup = exportPortletSetup;
        if (exportPortletDataAll) {
            exportCurPortletData = true;
            exportCurPortletSetup = true;
        } else {
            String portletDataHandlerClass;
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
            if (portlet != null && (portletDataHandlerClass = portlet.getPortletDataHandlerClass()) != null) {
                String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
                exportCurPortletData = exportPortletData && MapUtil.getBoolean(parameterMap, (String)("PORTLET_DATA_" + rootPortletId));
                boolean bl = exportCurPortletSetup = exportPortletSetup && MapUtil.getBoolean(parameterMap, (String)("PORTLET_SETUP_" + rootPortletId));
            }
        }
        if (exportPortletSetupAll) {
            exportCurPortletSetup = true;
        }
        return new boolean[]{exportCurPortletData, exportCurPortletSetup};
    }

    protected String getLayoutIconPath(PortletDataContext portletDataContext, Layout layout, Image image) {
        StringBundler sb = new StringBundler(5);
        sb.append(portletDataContext.getLayoutPath(layout.getLayoutId()));
        sb.append("/icons/");
        sb.append(image.getImageId());
        sb.append(".");
        sb.append(image.getType());
        return sb.toString();
    }

    protected String getLayoutSetLogoPath(PortletDataContext portletDataContext) {
        return portletDataContext.getRootPath().concat("/logo/");
    }

    protected String getLayoutSetPrototype(PortletDataContext portletDataContext, String layoutSetPrototypeUuid) {
        StringBundler sb = new StringBundler(3);
        sb.append(portletDataContext.getRootPath());
        sb.append("/layout-set-prototype/");
        sb.append(layoutSetPrototypeUuid);
        return sb.toString();
    }
}

