/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.counter.service.CounterLocalServiceUtil;
import com.liferay.portal.LARFileException;
import com.liferay.portal.LARTypeException;
import com.liferay.portal.LayoutImportException;
import com.liferay.portal.LayoutPrototypeException;
import com.liferay.portal.LocaleException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.NoSuchLayoutPrototypeException;
import com.liferay.portal.NoSuchLayoutSetPrototypeException;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lar.ImportExportThreadLocal;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.UserIdStrategy;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactoryUtil;
import com.liferay.portal.lar.LayoutCache;
import com.liferay.portal.lar.PermissionImporter;
import com.liferay.portal.lar.PortletDataContextImpl;
import com.liferay.portal.lar.PortletDataContextListenerImpl;
import com.liferay.portal.lar.PortletImporter;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.model.LayoutTemplate;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.ColorSchemeImpl;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutPrototypeLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.service.LayoutTemplateLocalServiceUtil;
import com.liferay.portal.service.PermissionLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ResourceLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.persistence.LayoutUtil;
import com.liferay.portal.service.persistence.UserUtil;
import com.liferay.portal.servlet.filters.cache.CacheUtil;
import com.liferay.portal.theme.ThemeLoader;
import com.liferay.portal.theme.ThemeLoaderFactory;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.journal.lar.JournalPortletDataHandlerImpl;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil;
import com.liferay.portlet.journalcontent.util.JournalContentUtil;
import com.liferay.portlet.sites.util.SitesUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.time.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutImporter {
    private static Log _log = LogFactoryUtil.getLog(LayoutImporter.class);
    private static MethodHandler _loadThemesMethodHandler = new MethodHandler(new MethodKey(ThemeLoaderFactory.class.getName(), "loadThemes", new Class[0]), new Object[0]);
    private PermissionImporter _permissionImporter = new PermissionImporter();
    private PortletImporter _portletImporter = new PortletImporter();

    public void importLayouts(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws Exception {
        try {
            ImportExportThreadLocal.setLayoutImportInProcess((boolean)true);
            this.doImportLayouts(userId, groupId, privateLayout, parameterMap, file);
        }
        finally {
            ImportExportThreadLocal.setLayoutImportInProcess((boolean)false);
            CacheUtil.clearCache();
            JournalContentUtil.clearCache();
            PermissionCacheUtil.clearCache();
        }
    }

    protected String[] appendPortletIds(String[] portletIds, String[] newPortletIds, String portletsMergeMode) {
        String[] stringArray = newPortletIds;
        int n = newPortletIds.length;
        int n2 = 0;
        while (n2 < n) {
            String portletId = stringArray[n2];
            if (!ArrayUtil.contains((Object[])portletIds, (Object)portletId)) {
                portletIds = portletsMergeMode.equals("ADD_TO_BOTTOM") ? (String[])ArrayUtil.append((Object[])portletIds, (Object)portletId) : (String[])ArrayUtil.append((Object[])new String[]{portletId}, (Object[])portletIds);
            }
            ++n2;
        }
        return portletIds;
    }

    protected void deleteMissingLayouts(long groupId, boolean privateLayout, Set<Long> newLayoutIds, List<Layout> previousLayouts, ServiceContext serviceContext) throws Exception {
        if (_log.isDebugEnabled() && newLayoutIds.size() > 0) {
            _log.debug((Object)"Delete missing layouts");
        }
        for (Layout layout : previousLayouts) {
            if (newLayoutIds.contains(layout.getLayoutId())) continue;
            try {
                LayoutLocalServiceUtil.deleteLayout((Layout)layout, (boolean)false, (ServiceContext)serviceContext);
            }
            catch (NoSuchLayoutException noSuchLayoutException) {}
        }
        LayoutSetLocalServiceUtil.updatePageCount((long)groupId, (boolean)privateLayout);
    }

    protected void doImportLayouts(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws Exception {
        boolean deleteMissingLayouts = MapUtil.getBoolean(parameterMap, (String)"DELETE_MISSING_LAYOUTS", (boolean)Boolean.TRUE);
        boolean deletePortletData = MapUtil.getBoolean(parameterMap, (String)"DELETE_PORTLET_DATA");
        boolean importCategories = MapUtil.getBoolean(parameterMap, (String)"CATEGORIES");
        boolean importPermissions = MapUtil.getBoolean(parameterMap, (String)"PERMISSIONS");
        boolean importPublicLayoutPermissions = MapUtil.getBoolean(parameterMap, (String)"PUBLIC_LAYOUT_PERMISSIONS");
        boolean importUserPermissions = MapUtil.getBoolean(parameterMap, (String)"USER_PERMISSIONS");
        boolean importPortletData = MapUtil.getBoolean(parameterMap, (String)"PORTLET_DATA");
        boolean importPortletSetup = MapUtil.getBoolean(parameterMap, (String)"PORTLET_SETUP");
        boolean importPortletArchivedSetups = MapUtil.getBoolean(parameterMap, (String)"PORTLET_ARCHIVED_SETUPS");
        boolean importPortletUserPreferences = MapUtil.getBoolean(parameterMap, (String)"PORTLET_USER_PREFERENCES");
        boolean importTheme = MapUtil.getBoolean(parameterMap, (String)"THEME");
        boolean importThemeSettings = MapUtil.getBoolean(parameterMap, (String)"THEME_REFERENCE");
        boolean importLogo = MapUtil.getBoolean(parameterMap, (String)"LOGO");
        boolean importLayoutSetSettings = MapUtil.getBoolean(parameterMap, (String)"LAYOUT_SET_SETTINGS");
        boolean layoutSetPrototypeLinkEnabled = MapUtil.getBoolean(parameterMap, (String)"LAYOUT_SET_PROTOTYPE_LINK_ENABLED", (boolean)true);
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (group.isLayoutSetPrototype()) {
            layoutSetPrototypeLinkEnabled = false;
        }
        String layoutsImportMode = MapUtil.getString(parameterMap, (String)"LAYOUTS_IMPORT_MODE", (String)"MERGE_BY_LAYOUT_UUID");
        String portletsMergeMode = MapUtil.getString(parameterMap, (String)"PORTLETS_MERGE_MODE", (String)"REPLACE");
        String userIdStrategy = MapUtil.getString(parameterMap, (String)"USER_ID_STRATEGY");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Delete portlet data " + deletePortletData));
            _log.debug((Object)("Import categories " + importCategories));
            _log.debug((Object)("Import permissions " + importPermissions));
            _log.debug((Object)("Import user permissions " + importUserPermissions));
            _log.debug((Object)("Import portlet data " + importPortletData));
            _log.debug((Object)("Import portlet setup " + importPortletSetup));
            _log.debug((Object)("Import portlet archived setups " + importPortletArchivedSetups));
            _log.debug((Object)("Import portlet user preferences " + importPortletUserPreferences));
            _log.debug((Object)("Import theme " + importTheme));
        }
        StopWatch stopWatch = null;
        if (_log.isInfoEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        LayoutCache layoutCache = new LayoutCache();
        LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
        long companyId = layoutSet.getCompanyId();
        User user = UserUtil.findByPrimaryKey((long)userId);
        UserIdStrategy strategy = this._portletImporter.getUserIdStrategy(user, userIdStrategy);
        ZipReader zipReader = ZipReaderFactoryUtil.getZipReader((File)file);
        PortletDataContextImpl portletDataContext = new PortletDataContextImpl(companyId, groupId, parameterMap, new HashSet<String>(), strategy, zipReader);
        portletDataContext.setPortetDataContextListener(new PortletDataContextListenerImpl(portletDataContext));
        portletDataContext.setPrivateLayout(privateLayout);
        Element rootElement = null;
        InputStream themeZip = null;
        String xml = portletDataContext.getZipEntryAsString("/manifest.xml");
        if (xml == null) {
            throw new LARFileException("manifest.xml not found in the LAR");
        }
        try {
            Document document = SAXReaderUtil.read((String)xml);
            rootElement = document.getRootElement();
        }
        catch (Exception e2) {
            throw new LARFileException((Throwable)e2);
        }
        Element headerElement = rootElement.element("header");
        int buildNumber = ReleaseInfo.getBuildNumber();
        int importBuildNumber = GetterUtil.getInteger((String)headerElement.attributeValue("build-number"));
        if (buildNumber != importBuildNumber) {
            throw new LayoutImportException("LAR build number " + importBuildNumber + " does not match " + "portal build number " + buildNumber);
        }
        String larType = headerElement.attributeValue("type");
        if (!(larType.equals("layout-prototype") || larType.equals("layout-set") || larType.equals("layout-set-prototype"))) {
            throw new LARTypeException("Invalid type of LAR file (" + larType + ")");
        }
        Locale[] sourceAvailableLocales = LocaleUtil.fromLanguageIds((String[])StringUtil.split((String)headerElement.attributeValue("available-locales")));
        Object[] targetAvailableLocales = LanguageUtil.getAvailableLocales();
        Locale[] localeArray = sourceAvailableLocales;
        int n = sourceAvailableLocales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale sourceAvailableLocale = localeArray[n2];
            if (!ArrayUtil.contains((Object[])targetAvailableLocales, (Object)sourceAvailableLocale)) {
                LocaleException le = new LocaleException();
                le.setSourceAvailableLocales(sourceAvailableLocales);
                le.setTargetAvailableLocales((Locale[])targetAvailableLocales);
                throw le;
            }
            ++n2;
        }
        Element layoutsElement = rootElement.element("layouts");
        List layoutElements = layoutsElement.elements("layout");
        this.validateLayoutPrototypes(layoutsElement, layoutElements);
        long sourceGroupId = GetterUtil.getLong((String)headerElement.attributeValue("group-id"));
        portletDataContext.setSourceGroupId(sourceGroupId);
        String layoutSetPrototypeUuid = layoutsElement.attributeValue("layout-set-prototype-uuid");
        if (group.isLayoutPrototype() && larType.equals("layout-prototype")) {
            LayoutPrototype layoutPrototype = LayoutPrototypeLocalServiceUtil.getLayoutPrototype((long)group.getClassPK());
            String layoutPrototypeUuid = GetterUtil.getString((String)headerElement.attributeValue("type-uuid"));
            LayoutPrototype existingLayoutPrototype = null;
            if (Validator.isNotNull((String)layoutPrototypeUuid)) {
                try {
                    existingLayoutPrototype = LayoutPrototypeLocalServiceUtil.getLayoutPrototypeByUuid((String)layoutPrototypeUuid);
                }
                catch (NoSuchLayoutPrototypeException noSuchLayoutPrototypeException) {}
            }
            if (existingLayoutPrototype == null) {
                layoutPrototype.setUuid(layoutPrototypeUuid);
                LayoutPrototypeLocalServiceUtil.updateLayoutPrototype((LayoutPrototype)layoutPrototype);
            }
        } else if (group.isLayoutSetPrototype() && larType.equals("layout-set-prototype")) {
            LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototype((long)group.getClassPK());
            String importedLayoutSetPrototypeUuid = GetterUtil.getString((String)headerElement.attributeValue("type-uuid"));
            LayoutSetPrototype existingLayoutSetPrototype = null;
            if (Validator.isNotNull((String)importedLayoutSetPrototypeUuid)) {
                try {
                    existingLayoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuid((String)importedLayoutSetPrototypeUuid);
                }
                catch (NoSuchLayoutSetPrototypeException noSuchLayoutSetPrototypeException) {}
            }
            if (existingLayoutSetPrototype == null) {
                layoutSetPrototype.setUuid(importedLayoutSetPrototypeUuid);
                LayoutSetPrototypeLocalServiceUtil.updateLayoutSetPrototype((LayoutSetPrototype)layoutSetPrototype);
            }
        } else if (larType.equals("layout-set-prototype")) {
            layoutSetPrototypeUuid = GetterUtil.getString((String)headerElement.attributeValue("type-uuid"));
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (Validator.isNotNull((String)layoutSetPrototypeUuid)) {
            layoutSet.setLayoutSetPrototypeUuid(layoutSetPrototypeUuid);
            layoutSet.setLayoutSetPrototypeLinkEnabled(layoutSetPrototypeLinkEnabled);
            LayoutSetLocalServiceUtil.updateLayoutSet((LayoutSet)layoutSet);
        }
        if (importTheme) {
            themeZip = portletDataContext.getZipEntryAsInputStream("theme.zip");
        }
        String themeId = layoutSet.getThemeId();
        String colorSchemeId = layoutSet.getColorSchemeId();
        if (importThemeSettings) {
            Attribute colorSchemeIdAttribute;
            Attribute themeIdAttribute = headerElement.attribute("theme-id");
            if (themeIdAttribute != null) {
                themeId = themeIdAttribute.getValue();
            }
            if ((colorSchemeIdAttribute = headerElement.attribute("color-scheme-id")) != null) {
                colorSchemeId = colorSchemeIdAttribute.getValue();
            }
        }
        if (importLogo) {
            String logoPath = headerElement.attributeValue("logo-path");
            byte[] iconBytes = portletDataContext.getZipEntryAsByteArray(logoPath);
            if (iconBytes != null && iconBytes.length > 0) {
                File logo = FileUtil.createTempFile((byte[])iconBytes);
                LayoutSetLocalServiceUtil.updateLogo((long)groupId, (boolean)privateLayout, (boolean)true, (File)logo);
            } else {
                LayoutSetLocalServiceUtil.updateLogo((long)groupId, (boolean)privateLayout, (boolean)false, null);
            }
        }
        if (importLayoutSetSettings) {
            String settings = GetterUtil.getString((String)headerElement.elementText("settings"));
            LayoutSetLocalServiceUtil.updateSettings((long)groupId, (boolean)privateLayout, (String)settings);
        }
        String css = GetterUtil.getString((String)headerElement.elementText("css"));
        if (themeZip != null) {
            String importThemeId = this.importTheme(layoutSet, themeZip);
            if (importThemeId != null) {
                themeId = importThemeId;
                colorSchemeId = ColorSchemeImpl.getDefaultRegularColorSchemeId();
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Importing theme takes " + stopWatch.getTime() + " ms"));
            }
        }
        boolean wapTheme = false;
        LayoutSetLocalServiceUtil.updateLookAndFeel((long)groupId, (boolean)privateLayout, (String)themeId, (String)colorSchemeId, (String)css, (boolean)wapTheme);
        if (importPermissions) {
            this._permissionImporter.readPortletDataPermissions(portletDataContext);
        }
        if (importCategories || group.isCompany()) {
            this._portletImporter.readAssetCategories(portletDataContext);
        }
        this._portletImporter.readAssetTags(portletDataContext);
        this._portletImporter.readComments(portletDataContext);
        this._portletImporter.readExpandoTables(portletDataContext);
        this._portletImporter.readLocks(portletDataContext);
        this._portletImporter.readRatingsEntries(portletDataContext);
        List previousLayouts = LayoutUtil.findByG_P((long)groupId, (boolean)privateLayout);
        if (Validator.isNotNull((String)layoutSetPrototypeUuid) && layoutSetPrototypeLinkEnabled) {
            LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuid((String)layoutSetPrototypeUuid);
            Group layoutSetPrototypeGroup = layoutSetPrototype.getGroup();
            for (Layout layout : previousLayouts) {
                Layout sourcePrototypeLayout;
                String sourcePrototypeLayoutUuid = layout.getSourcePrototypeLayoutUuid();
                if (Validator.isNull((String)layout.getSourcePrototypeLayoutUuid()) || (sourcePrototypeLayout = LayoutUtil.fetchByUUID_G((String)sourcePrototypeLayoutUuid, (long)layoutSetPrototypeGroup.getGroupId())) != null) continue;
                LayoutLocalServiceUtil.deleteLayout((Layout)layout, (boolean)false, (ServiceContext)serviceContext);
            }
        }
        ArrayList<Layout> newLayouts = new ArrayList<Layout>();
        HashSet<Long> newLayoutIds = new HashSet<Long>();
        Map newLayoutsMap = portletDataContext.getNewPrimaryKeysMap(Layout.class);
        if (_log.isDebugEnabled() && layoutElements.size() > 0) {
            _log.debug((Object)"Importing layouts");
        }
        for (Element layoutElement : layoutElements) {
            this.importLayout(portletDataContext, user, layoutCache, previousLayouts, newLayouts, newLayoutsMap, newLayoutIds, portletsMergeMode, themeId, colorSchemeId, layoutsImportMode, privateLayout, importPermissions, importPublicLayoutPermissions, importUserPermissions, importThemeSettings, rootElement, layoutElement);
        }
        Element portletsElement = rootElement.element("portlets");
        List portletElements = portletsElement.elements("portlet");
        if (deletePortletData) {
            if (_log.isDebugEnabled() && portletElements.size() > 0) {
                _log.debug((Object)"Deleting portlet data");
            }
            for (Element portletElement : portletElements) {
                String portletId = portletElement.attributeValue("portlet-id");
                long layoutId = GetterUtil.getLong((String)portletElement.attributeValue("layout-id"));
                long plid = ((Layout)newLayoutsMap.get(layoutId)).getPlid();
                portletDataContext.setPlid(plid);
                this._portletImporter.deletePortletData((PortletDataContext)portletDataContext, portletId, plid);
            }
        }
        if (_log.isDebugEnabled() && portletElements.size() > 0) {
            _log.debug((Object)"Importing portlets");
        }
        for (Element portletElement : portletElements) {
            String portletPath = portletElement.attributeValue("path");
            String portletId = portletElement.attributeValue("portlet-id");
            long layoutId = GetterUtil.getLong((String)portletElement.attributeValue("layout-id"));
            long oldPlid = GetterUtil.getLong((String)portletElement.attributeValue("old-plid"));
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)portletDataContext.getCompanyId(), (String)portletId);
            if (!portlet.isActive() || portlet.isUndeployedPortlet()) continue;
            Layout layout = (Layout)newLayoutsMap.get(layoutId);
            long plid = 0L;
            if (layout != null) {
                plid = layout.getPlid();
            }
            if ((layout = LayoutUtil.fetchByPrimaryKey((long)plid)) == null && !group.isCompany()) continue;
            portletDataContext.setPlid(plid);
            portletDataContext.setOldPlid(oldPlid);
            Document portletDocument = SAXReaderUtil.read((String)portletDataContext.getZipEntryAsString(portletPath));
            portletElement = portletDocument.getRootElement();
            this._portletImporter.setPortletScope(portletDataContext, portletElement);
            long portletPreferencesGroupId = groupId;
            Element portletDataElement = portletElement.element("portlet-data");
            boolean importData = importPortletData && portletDataElement != null;
            try {
                if (layout != null && !group.isCompany()) {
                    portletPreferencesGroupId = layout.getGroupId();
                }
                this._portletImporter.importPortletPreferences(portletDataContext, layoutSet.getCompanyId(), portletPreferencesGroupId, layout, null, portletElement, importPortletSetup, importPortletArchivedSetups, importPortletUserPreferences, false, importData);
                if (importData) {
                    this._portletImporter.importPortletData((PortletDataContext)portletDataContext, portletId, plid, portletDataElement);
                }
            }
            finally {
                this._portletImporter.resetPortletScope(portletDataContext, portletPreferencesGroupId);
            }
            if (importPermissions) {
                this._permissionImporter.importPortletPermissions(layoutCache, companyId, groupId, userId, layout, portletElement, portletId, importUserPermissions);
            }
            this._portletImporter.importPortletPreferences(portletDataContext, layoutSet.getCompanyId(), groupId, null, null, portletElement, importPortletSetup, importPortletArchivedSetups, importPortletUserPreferences, false, importData);
        }
        if (importPermissions && userId > 0L && (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5 || PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6)) {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
            indexer.reindex((Object)userId);
        }
        this._portletImporter.readAssetLinks(portletDataContext);
        if (deleteMissingLayouts) {
            this.deleteMissingLayouts(groupId, privateLayout, newLayoutIds, previousLayouts, serviceContext);
        }
        LayoutSetLocalServiceUtil.updatePageCount((long)groupId, (boolean)privateLayout);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Importing layouts takes " + stopWatch.getTime() + " ms"));
        }
        GroupLocalServiceUtil.updateSite((long)groupId, (boolean)true);
        for (Layout layout : newLayouts) {
            UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
            String articleId = typeSettingsProperties.getProperty("article-id");
            if (!Validator.isNotNull((String)articleId)) continue;
            Map articleIds = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class + ".articleId");
            typeSettingsProperties.setProperty("article-id", MapUtil.getString((Map)articleIds, (String)articleId, (String)articleId));
            LayoutUtil.update((Layout)layout, (boolean)false);
        }
        zipReader.close();
    }

    protected void fixTypeSettings(Layout layout) throws Exception {
        if (!layout.isTypeURL()) {
            return;
        }
        UnicodeProperties typeSettings = layout.getTypeSettingsProperties();
        String url = GetterUtil.getString((String)typeSettings.getProperty("url"));
        String friendlyURLPrivateGroupPath = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING;
        String friendlyURLPrivateUserPath = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING;
        String friendlyURLPublicPath = PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING;
        if (!(url.startsWith(friendlyURLPrivateGroupPath) || url.startsWith(friendlyURLPrivateUserPath) || url.startsWith(friendlyURLPublicPath))) {
            return;
        }
        int x = url.indexOf(47, 1);
        if (x == -1) {
            return;
        }
        int y = url.indexOf(47, x + 1);
        if (y == -1) {
            return;
        }
        String friendlyURL = url.substring(x, y);
        if (!friendlyURL.equals("/[$SAME_GROUP_FRIENDLY_URL$]")) {
            return;
        }
        Group group = layout.getGroup();
        typeSettings.setProperty("url", String.valueOf(url.substring(0, x)) + group.getFriendlyURL() + url.substring(y));
    }

    protected String getLayoutSetPrototype(PortletDataContext portletDataContext, String layoutSetPrototypeUuid) {
        StringBundler sb = new StringBundler(3);
        sb.append(portletDataContext.getSourceRootPath());
        sb.append("/layout-set-prototype/");
        sb.append(layoutSetPrototypeUuid);
        return sb.toString();
    }

    protected void importJournalArticle(PortletDataContext portletDataContext, Layout layout, Element layoutElement) throws Exception {
        Element articleElement;
        Element templateElement;
        UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
        String articleId = typeSettingsProperties.getProperty("article-id", "");
        if (Validator.isNull((String)articleId)) {
            return;
        }
        JournalPortletDataHandlerImpl.importReferencedData(portletDataContext, layoutElement);
        Element structureElement = layoutElement.element("structure");
        if (structureElement != null) {
            JournalPortletDataHandlerImpl.importStructure(portletDataContext, structureElement);
        }
        if ((templateElement = layoutElement.element("template")) != null) {
            JournalPortletDataHandlerImpl.importTemplate(portletDataContext, templateElement);
        }
        if ((articleElement = layoutElement.element("article")) != null) {
            JournalPortletDataHandlerImpl.importArticle(portletDataContext, articleElement);
        }
        Map articleIds = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class + ".articleId");
        articleId = MapUtil.getString((Map)articleIds, (String)articleId, (String)articleId);
        typeSettingsProperties.setProperty("article-id", articleId);
        JournalContentSearchLocalServiceUtil.updateContentSearch((long)portletDataContext.getScopeGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)"", (String)articleId, (boolean)true);
    }

    protected void importLayout(PortletDataContext portletDataContext, User user, LayoutCache layoutCache, List<Layout> previousLayouts, List<Layout> newLayouts, Map<Long, Layout> newLayoutsMap, Set<Long> newLayoutIds, String portletsMergeMode, String themeId, String colorSchemeId, String layoutsImportMode, boolean privateLayout, boolean importPermissions, boolean importPublicLayoutPermissions, boolean importUserPermissions, boolean importThemeSettings, Element rootElement, Element layoutElement) throws Exception {
        long layoutId;
        long groupId = portletDataContext.getGroupId();
        String layoutUuid = GetterUtil.getString((String)layoutElement.attributeValue("layout-uuid"));
        long oldLayoutId = layoutId = (long)GetterUtil.getInteger((String)layoutElement.attributeValue("layout-id"));
        boolean deleteLayout = GetterUtil.getBoolean((String)layoutElement.attributeValue("delete"));
        if (deleteLayout) {
            Layout layout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)layoutUuid, (long)groupId);
            if (layout != null) {
                newLayoutsMap.put(oldLayoutId, layout);
                ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
                LayoutLocalServiceUtil.deleteLayout((Layout)layout, (boolean)false, (ServiceContext)serviceContext);
            }
            return;
        }
        String path = layoutElement.attributeValue("path");
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Layout layout = (Layout)portletDataContext.getZipEntryAsObject(path);
        Layout existingLayout = null;
        Layout importedLayout = null;
        String friendlyURL = layout.getFriendlyURL();
        if (layoutsImportMode.equals("ADD_AS_NEW")) {
            layoutId = LayoutLocalServiceUtil.getNextLayoutId((long)groupId, (boolean)privateLayout);
            friendlyURL = "/" + layoutId;
        } else if (layoutsImportMode.equals("MERGE_BY_LAYOUT_NAME")) {
            Locale locale = LocaleUtil.getDefault();
            String localizedName = layout.getName(locale);
            for (Layout curLayout : previousLayouts) {
                if (!localizedName.equals(curLayout.getName(locale)) && !friendlyURL.equals(curLayout.getFriendlyURL())) continue;
                existingLayout = curLayout;
                break;
            }
            if (existingLayout == null) {
                layoutId = LayoutLocalServiceUtil.getNextLayoutId((long)groupId, (boolean)privateLayout);
            }
        } else if (layoutsImportMode.equals("CREATED_FROM_PROTOTYPE")) {
            existingLayout = LayoutUtil.fetchByG_P_SPLU((long)groupId, (boolean)privateLayout, (String)layout.getUuid());
            if (SitesUtil.isLayoutModifiedSinceLastMerge(existingLayout)) {
                newLayoutsMap.put(oldLayoutId, existingLayout);
                return;
            }
        } else {
            existingLayout = LayoutUtil.fetchByUUID_G((String)layout.getUuid(), (long)groupId);
            if (existingLayout == null) {
                existingLayout = LayoutUtil.fetchByG_P_F((long)groupId, (boolean)privateLayout, (String)friendlyURL);
            }
            if (existingLayout == null) {
                layoutId = LayoutLocalServiceUtil.getNextLayoutId((long)groupId, (boolean)privateLayout);
            }
        }
        if (_log.isDebugEnabled()) {
            if (existingLayout == null) {
                _log.debug((Object)("Layout with {groupId=" + groupId + ",privateLayout=" + privateLayout + ",layoutId=" + layoutId + "} does not exist"));
            } else {
                _log.debug((Object)("Layout with {groupId=" + groupId + ",privateLayout=" + privateLayout + ",layoutId=" + layoutId + "} exists"));
            }
        }
        if (existingLayout == null) {
            long plid = CounterLocalServiceUtil.increment();
            importedLayout = LayoutUtil.create((long)plid);
            if (layoutsImportMode.equals("CREATED_FROM_PROTOTYPE")) {
                importedLayout.setSourcePrototypeLayoutUuid(layout.getUuid());
                layoutId = LayoutLocalServiceUtil.getNextLayoutId((long)groupId, (boolean)privateLayout);
            } else {
                importedLayout.setUuid(layout.getUuid());
                importedLayout.setCreateDate(layout.getCreateDate());
                importedLayout.setModifiedDate(layout.getModifiedDate());
                importedLayout.setLayoutPrototypeUuid(layout.getLayoutPrototypeUuid());
                importedLayout.setLayoutPrototypeLinkEnabled(layout.isLayoutPrototypeLinkEnabled());
                importedLayout.setSourcePrototypeLayoutUuid(layout.getSourcePrototypeLayoutUuid());
            }
            importedLayout.setGroupId(groupId);
            importedLayout.setPrivateLayout(privateLayout);
            importedLayout.setLayoutId(layoutId);
            boolean addGroupPermissions = true;
            Group group = importedLayout.getGroup();
            if (privateLayout && group.isUser()) {
                addGroupPermissions = false;
            }
            boolean addGuestPermissions = false;
            if (!privateLayout || layout.isTypeControlPanel()) {
                addGuestPermissions = true;
            }
            ResourceLocalServiceUtil.addResources((long)user.getCompanyId(), (long)groupId, (long)user.getUserId(), (String)Layout.class.getName(), (long)importedLayout.getPlid(), (boolean)false, (boolean)addGroupPermissions, (boolean)addGuestPermissions);
            LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
            importedLayout.setLayoutSet(layoutSet);
        } else {
            importedLayout = existingLayout;
        }
        newLayoutsMap.put(oldLayoutId, importedLayout);
        long parentLayoutId = layout.getParentLayoutId();
        Node parentLayoutNode = rootElement.selectSingleNode("./layouts/layout[@layout-id='" + parentLayoutId + "']");
        String parentLayoutUuid = GetterUtil.getString((String)layoutElement.attributeValue("parent-layout-uuid"));
        if (parentLayoutId != 0L && parentLayoutNode != null) {
            this.importLayout(portletDataContext, user, layoutCache, previousLayouts, newLayouts, newLayoutsMap, newLayoutIds, portletsMergeMode, themeId, colorSchemeId, layoutsImportMode, privateLayout, importPermissions, importPublicLayoutPermissions, importUserPermissions, importThemeSettings, rootElement, (Element)parentLayoutNode);
            Layout parentLayout = newLayoutsMap.get(parentLayoutId);
            parentLayoutId = parentLayout.getLayoutId();
        } else if (Validator.isNotNull((String)parentLayoutUuid)) {
            Layout parentLayout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)parentLayoutUuid, (long)groupId);
            parentLayoutId = parentLayout.getLayoutId();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Importing layout with layout id " + layoutId + " and parent layout id " + parentLayoutId));
        }
        importedLayout.setCompanyId(user.getCompanyId());
        importedLayout.setParentLayoutId(parentLayoutId);
        importedLayout.setName(layout.getName());
        importedLayout.setTitle(layout.getTitle());
        importedLayout.setDescription(layout.getDescription());
        importedLayout.setKeywords(layout.getKeywords());
        importedLayout.setRobots(layout.getRobots());
        importedLayout.setType(layout.getType());
        if (layout.isTypeArticle()) {
            this.importJournalArticle(portletDataContext, layout, layoutElement);
            importedLayout.setTypeSettings(layout.getTypeSettings());
        } else if (layout.isTypePortlet() && Validator.isNotNull((String)layout.getTypeSettings()) && !portletsMergeMode.equals("REPLACE")) {
            this.mergePortlets(importedLayout, layout.getTypeSettings(), portletsMergeMode);
        } else if (layout.isTypeLinkToLayout()) {
            UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
            long linkToLayoutId = GetterUtil.getLong((String)typeSettingsProperties.getProperty("linkToLayoutId", ""));
            if (linkToLayoutId > 0L) {
                Node linkedLayoutNode = rootElement.selectSingleNode("./layouts/layout[@layout-id='" + linkToLayoutId + "']");
                if (linkedLayoutNode != null) {
                    this.importLayout(portletDataContext, user, layoutCache, previousLayouts, newLayouts, newLayoutsMap, newLayoutIds, portletsMergeMode, themeId, colorSchemeId, layoutsImportMode, privateLayout, importPermissions, importPublicLayoutPermissions, importUserPermissions, importThemeSettings, rootElement, (Element)linkedLayoutNode);
                    Layout linkedLayout = newLayoutsMap.get(linkToLayoutId);
                    typeSettingsProperties.setProperty("privateLayout", String.valueOf(linkedLayout.getPrivateLayout()));
                    typeSettingsProperties.setProperty("linkToLayoutId", String.valueOf(linkedLayout.getLayoutId()));
                } else if (_log.isWarnEnabled()) {
                    StringBundler sb = new StringBundler();
                    sb.append("Unable to link layout with friendly URL ");
                    sb.append(layout.getFriendlyURL());
                    sb.append(" and layout id ");
                    sb.append(layout.getLayoutId());
                    sb.append(" to layout with layout id ");
                    sb.append(linkToLayoutId);
                    _log.warn((Object)sb.toString());
                }
            }
            importedLayout.setTypeSettings(layout.getTypeSettings());
        } else {
            importedLayout.setTypeSettings(layout.getTypeSettings());
        }
        importedLayout.setHidden(layout.isHidden());
        importedLayout.setFriendlyURL(friendlyURL);
        if (importThemeSettings) {
            importedLayout.setThemeId(layout.getThemeId());
            importedLayout.setColorSchemeId(layout.getColorSchemeId());
        } else {
            importedLayout.setThemeId("");
            importedLayout.setColorSchemeId("");
        }
        importedLayout.setWapThemeId(layout.getWapThemeId());
        importedLayout.setWapColorSchemeId(layout.getWapColorSchemeId());
        importedLayout.setCss(layout.getCss());
        importedLayout.setPriority(layout.getPriority());
        importedLayout.setLayoutPrototypeUuid(layout.getLayoutPrototypeUuid());
        importedLayout.setLayoutPrototypeLinkEnabled(layout.isLayoutPrototypeLinkEnabled());
        StagingUtil.updateLastImportSettings((Element)layoutElement, (Layout)importedLayout, (PortletDataContext)portletDataContext);
        this.fixTypeSettings(importedLayout);
        importedLayout.setIconImage(false);
        if (layout.isIconImage()) {
            String iconImagePath = layoutElement.elementText("icon-image-path");
            byte[] iconBytes = portletDataContext.getZipEntryAsByteArray(iconImagePath);
            if (iconBytes != null && iconBytes.length > 0) {
                importedLayout.setIconImage(true);
                if (importedLayout.getIconImageId() == 0L) {
                    long iconImageId = CounterLocalServiceUtil.increment();
                    importedLayout.setIconImageId(iconImageId);
                }
                ImageLocalServiceUtil.updateImage((long)importedLayout.getIconImageId(), (byte[])iconBytes);
            }
        } else {
            ImageLocalServiceUtil.deleteImage((long)importedLayout.getIconImageId());
        }
        ServiceContext serviceContext = portletDataContext.createServiceContext(layoutElement, (ClassedModel)importedLayout, null);
        importedLayout.setExpandoBridgeAttributes(serviceContext);
        LayoutUtil.update((Layout)importedLayout, (boolean)false);
        portletDataContext.setPlid(importedLayout.getPlid());
        portletDataContext.setOldPlid(layout.getPlid());
        newLayoutIds.add(importedLayout.getLayoutId());
        newLayouts.add(importedLayout);
        if (importPermissions) {
            this._permissionImporter.importLayoutPermissions(layoutCache, portletDataContext.getCompanyId(), groupId, user.getUserId(), importedLayout, layoutElement, rootElement, importUserPermissions);
        }
        if (importPublicLayoutPermissions) {
            Resource resource;
            String resourceName = Layout.class.getName();
            String resourcePrimKey = String.valueOf(importedLayout.getPlid());
            Role guestRole = RoleLocalServiceUtil.getRole((long)importedLayout.getCompanyId(), (String)"Guest");
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
                resource = layoutCache.getResource(importedLayout.getCompanyId(), groupId, resourceName, 4, resourcePrimKey, false);
                PermissionLocalServiceUtil.setRolePermissions((long)guestRole.getRoleId(), (String[])new String[]{"VIEW"}, (long)resource.getResourceId());
            } else if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
                ResourcePermissionLocalServiceUtil.setResourcePermissions((long)importedLayout.getCompanyId(), (String)resourceName, (int)4, (String)resourcePrimKey, (long)guestRole.getRoleId(), (String[])new String[]{"VIEW"});
            } else {
                resource = layoutCache.getResource(importedLayout.getCompanyId(), groupId, resourceName, 4, resourcePrimKey, false);
                PermissionLocalServiceUtil.setGroupPermissions((long)groupId, (String[])new String[]{"VIEW"}, (long)resource.getResourceId());
            }
        }
        this._portletImporter.importPortletData(portletDataContext, "87", null, layoutElement);
    }

    protected void importLayoutSetPrototype(PortletDataContext portletDataContext, User user, String layoutSetPrototypeUuid, ServiceContext serviceContext) throws PortalException, SystemException {
        String path = this.getLayoutSetPrototype(portletDataContext, layoutSetPrototypeUuid);
        LayoutSetPrototype layoutSetPrototype = null;
        try {
            layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuid((String)layoutSetPrototypeUuid);
        }
        catch (NoSuchLayoutSetPrototypeException noSuchLayoutSetPrototypeException) {}
        if (layoutSetPrototype == null) {
            layoutSetPrototype = (LayoutSetPrototype)portletDataContext.getZipEntryAsObject(path.concat(".xml"));
            serviceContext.setUuid(layoutSetPrototypeUuid);
            layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.addLayoutSetPrototype((long)user.getUserId(), (long)user.getCompanyId(), (Map)layoutSetPrototype.getNameMap(), (String)layoutSetPrototype.getDescription(), (boolean)layoutSetPrototype.getActive(), (boolean)true, (ServiceContext)serviceContext);
        }
        InputStream inputStream = portletDataContext.getZipEntryAsInputStream(path.concat(".lar"));
        SitesUtil.importLayoutSetPrototype(layoutSetPrototype, inputStream, serviceContext);
    }

    protected String importTheme(LayoutSet layoutSet, InputStream themeZip) throws Exception {
        ThemeLoader themeLoader = ThemeLoaderFactory.getDefaultThemeLoader();
        if (themeLoader == null) {
            _log.error((Object)"No theme loaders are deployed");
            return null;
        }
        ZipReader zipReader = ZipReaderFactoryUtil.getZipReader((InputStream)themeZip);
        String lookAndFeelXML = zipReader.getEntryAsString("liferay-look-and-feel.xml");
        String themeId = String.valueOf(layoutSet.getGroupId());
        themeId = layoutSet.isPrivateLayout() ? String.valueOf(themeId) + "-private" : String.valueOf(themeId) + "-public";
        if (PropsValues.THEME_LOADER_NEW_THEME_ID_ON_IMPORT) {
            Date now = new Date();
            themeId = String.valueOf(themeId) + "-" + Time.getShortTimestamp((Date)now);
        }
        String themeName = themeId;
        lookAndFeelXML = StringUtil.replace((String)lookAndFeelXML, (String[])new String[]{"[$GROUP_ID$]", "[$THEME_ID$]", "[$THEME_NAME$]"}, (String[])new String[]{String.valueOf(layoutSet.getGroupId()), themeId, themeName});
        FileUtil.deltree((String)(themeLoader.getFileStorage() + "/" + themeId));
        List zipEntries = zipReader.getEntries();
        for (String zipEntry : zipEntries) {
            String key = zipEntry;
            if (key.equals("liferay-look-and-feel.xml")) {
                FileUtil.write((String)(themeLoader.getFileStorage() + "/" + themeId + "/" + key), (byte[])lookAndFeelXML.getBytes());
                continue;
            }
            InputStream is = zipReader.getEntryAsInputStream(zipEntry);
            FileUtil.write((String)(themeLoader.getFileStorage() + "/" + themeId + "/" + key), (InputStream)is);
        }
        themeLoader.loadThemes();
        ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((MethodHandler)_loadThemesMethodHandler, (boolean)true);
        clusterRequest.setFireAndForget(true);
        ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
        themeId = String.valueOf(themeId) + "_WAR_" + themeLoader.getServletContextName();
        return PortalUtil.getJsSafePortletId((String)themeId);
    }

    protected void mergePortlets(Layout layout, String newTypeSettings, String portletsMergeMode) {
        try {
            UnicodeProperties previousTypeSettingsProperties = layout.getTypeSettingsProperties();
            LayoutTypePortlet previousLayoutType = (LayoutTypePortlet)layout.getLayoutType();
            LayoutTemplate previousLayoutTemplate = previousLayoutType.getLayoutTemplate();
            List previousColumns = previousLayoutTemplate.getColumns();
            UnicodeProperties newTypeSettingsProperties = new UnicodeProperties(true);
            newTypeSettingsProperties.load(newTypeSettings);
            String layoutTemplateId = newTypeSettingsProperties.getProperty("layout-template-id");
            previousTypeSettingsProperties.setProperty("layout-template-id", layoutTemplateId);
            String nestedColumnIds = newTypeSettingsProperties.getProperty("nested-column-ids");
            if (Validator.isNotNull((String)nestedColumnIds)) {
                String[] nestedColumnIdsArray;
                previousTypeSettingsProperties.setProperty("nested-column-ids", nestedColumnIds);
                String[] stringArray = nestedColumnIdsArray = StringUtil.split((String)nestedColumnIds);
                int n = nestedColumnIdsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String nestedColumnId = stringArray[n2];
                    String nestedColumnValue = newTypeSettingsProperties.getProperty(nestedColumnId);
                    previousTypeSettingsProperties.setProperty(nestedColumnId, nestedColumnValue);
                    ++n2;
                }
            }
            LayoutTemplate newLayoutTemplate = LayoutTemplateLocalServiceUtil.getLayoutTemplate((String)layoutTemplateId, (boolean)false, null);
            Object[] newPortletIds = new String[]{};
            for (String columnId : newLayoutTemplate.getColumns()) {
                String columnValue = newTypeSettingsProperties.getProperty(columnId);
                Object[] portletIds = StringUtil.split((String)columnValue);
                if (!previousColumns.contains(columnId)) {
                    newPortletIds = (String[])ArrayUtil.append((Object[])newPortletIds, (Object[])portletIds);
                    continue;
                }
                String[] previousPortletIds = StringUtil.split((String)previousTypeSettingsProperties.getProperty(columnId));
                portletIds = this.appendPortletIds(previousPortletIds, (String[])portletIds, portletsMergeMode);
                previousTypeSettingsProperties.setProperty(columnId, StringUtil.merge((Object[])portletIds));
            }
            String columnId = (String)previousColumns.get(0);
            Object[] portletIds = StringUtil.split((String)previousTypeSettingsProperties.getProperty(columnId));
            this.appendPortletIds((String[])portletIds, (String[])newPortletIds, portletsMergeMode);
            previousTypeSettingsProperties.setProperty(columnId, StringUtil.merge((Object[])portletIds));
            layout.setTypeSettings(previousTypeSettingsProperties.toString());
        }
        catch (IOException iOException) {
            layout.setTypeSettings(newTypeSettings);
        }
    }

    protected void validateLayoutPrototypes(Element layoutsElement, List<Element> layoutElements) throws Exception {
        ArrayList<Tuple> missingLayoutPrototypes = new ArrayList<Tuple>();
        String layoutSetPrototypeUuid = layoutsElement.attributeValue("layout-set-prototype-uuid");
        if (Validator.isNotNull((String)layoutSetPrototypeUuid)) {
            try {
                LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuid((String)layoutSetPrototypeUuid);
            }
            catch (NoSuchLayoutSetPrototypeException noSuchLayoutSetPrototypeException) {
                String layoutSetPrototypeName = layoutsElement.attributeValue("layout-set-prototype-name");
                missingLayoutPrototypes.add(new Tuple(new Object[]{LayoutSetPrototype.class.getName(), layoutSetPrototypeUuid, layoutSetPrototypeName}));
            }
        }
        for (Element layoutElement : layoutElements) {
            String layoutPrototypeUuid = GetterUtil.getString((String)layoutElement.attributeValue("layout-prototype-uuid"));
            if (!Validator.isNotNull((String)layoutPrototypeUuid)) continue;
            try {
                LayoutPrototypeLocalServiceUtil.getLayoutPrototypeByUuid((String)layoutPrototypeUuid);
            }
            catch (NoSuchLayoutPrototypeException noSuchLayoutPrototypeException) {
                String layoutPrototypeName = GetterUtil.getString((String)layoutElement.attributeValue("layout-prototype-name"));
                missingLayoutPrototypes.add(new Tuple(new Object[]{LayoutPrototype.class.getName(), layoutPrototypeUuid, layoutPrototypeName}));
            }
        }
        if (!missingLayoutPrototypes.isEmpty()) {
            throw new LayoutPrototypeException(missingLayoutPrototypes);
        }
    }
}

