/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PrimitiveLongList;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.lar.LayoutCache;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.PermissionLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.util.PropsValues;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.time.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionExporter {
    public static final String ROLE_TEAM_PREFIX = "ROLE_TEAM_,*";
    private static Log _log = LogFactoryUtil.getLog(PermissionExporter.class);

    protected Element exportGroupPermissions(long companyId, long groupId, String resourceName, String resourcePrimKey, Element parentElement, String elementName) throws Exception {
        Element element = parentElement.addElement(elementName);
        List permissions = PermissionLocalServiceUtil.getGroupPermissions((long)groupId, (long)companyId, (String)resourceName, (int)4, (String)resourcePrimKey);
        List actions = ResourceActionsUtil.getActions((List)permissions);
        for (String action : actions) {
            Element actionKeyElement = element.addElement("action-key");
            actionKeyElement.addText(action);
        }
        return element;
    }

    protected void exportGroupRoles(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String entityName, Element parentElement) throws Exception {
        List<Role> roles = layoutCache.getGroupRoles_1to4(groupId);
        Element groupElement = this.exportRoles(companyId, resourceName, 2, String.valueOf(groupId), parentElement, String.valueOf(entityName) + "-roles", roles);
        if (groupElement.elements().isEmpty()) {
            parentElement.remove(groupElement);
        }
    }

    protected void exportInheritedPermissions(LayoutCache layoutCache, long companyId, String resourceName, String resourcePrimKey, Element parentElement, String entityName) throws Exception {
        Element entityPermissionsElement = SAXReaderUtil.createElement((String)(String.valueOf(entityName) + "-permissions"));
        Map<String, Long> entityMap = layoutCache.getEntityMap(companyId, entityName);
        for (Map.Entry<String, Long> entry : entityMap.entrySet()) {
            String name = entry.getKey();
            long entityGroupId = entry.getValue();
            Element entityElement = this.exportGroupPermissions(companyId, entityGroupId, resourceName, resourcePrimKey, entityPermissionsElement, String.valueOf(entityName) + "-actions");
            if (entityElement.elements().isEmpty()) {
                entityPermissionsElement.remove(entityElement);
                continue;
            }
            entityElement.addAttribute("name", name);
        }
        if (!entityPermissionsElement.elements().isEmpty()) {
            parentElement.add(entityPermissionsElement);
        }
    }

    protected void exportInheritedRoles(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String entityName, Element parentElement) throws Exception {
        Element entityRolesElement = SAXReaderUtil.createElement((String)(String.valueOf(entityName) + "-roles"));
        Map<String, Long> entityMap = layoutCache.getEntityMap(companyId, entityName);
        for (Map.Entry<String, Long> entry : entityMap.entrySet()) {
            String name = entry.getKey();
            long entityGroupId = entry.getValue();
            List<Role> entityRoles = layoutCache.getGroupRoles_1to4(entityGroupId);
            Element entityElement = this.exportRoles(companyId, resourceName, 2, String.valueOf(groupId), entityRolesElement, entityName, entityRoles);
            if (entityElement.elements().isEmpty()) {
                entityRolesElement.remove(entityElement);
                continue;
            }
            entityElement.addAttribute("name", name);
        }
        if (!entityRolesElement.elements().isEmpty()) {
            parentElement.add(entityRolesElement);
        }
    }

    protected void exportLayoutPermissions(PortletDataContext portletDataContext, LayoutCache layoutCache, long companyId, long groupId, Layout layout, Element layoutElement, boolean exportUserPermissions) throws Exception {
        String resourceName = Layout.class.getName();
        String resourcePrimKey = String.valueOf(layout.getPlid());
        Element permissionsElement = layoutElement.addElement("permissions");
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
            this.exportPermissions_5(layoutCache, companyId, groupId, resourceName, resourcePrimKey, permissionsElement, false);
        } else if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            this.exportPermissions_6(layoutCache, companyId, groupId, resourceName, resourcePrimKey, permissionsElement, false);
        } else {
            this.exportPermissions_1to4(layoutCache, companyId, groupId, resourceName, resourcePrimKey, permissionsElement, exportUserPermissions);
        }
    }

    protected void exportLayoutRoles(LayoutCache layoutCache, long companyId, long groupId, Element rolesElement) throws Exception {
        String resourceName = Layout.class.getName();
        this.exportGroupRoles(layoutCache, companyId, groupId, resourceName, "community", rolesElement);
        this.exportUserRoles(layoutCache, companyId, groupId, resourceName, rolesElement);
        this.exportInheritedRoles(layoutCache, companyId, groupId, resourceName, "organization", rolesElement);
        this.exportInheritedRoles(layoutCache, companyId, groupId, resourceName, "user-group", rolesElement);
    }

    protected void exportPermissions_1to4(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String resourcePrimKey, Element permissionsElement, boolean exportUserPermissions) throws Exception {
        Group guestGroup = GroupLocalServiceUtil.getGroup((long)companyId, (String)"Guest");
        this.exportGroupPermissions(companyId, groupId, resourceName, resourcePrimKey, permissionsElement, "community-actions");
        if (groupId != guestGroup.getGroupId()) {
            this.exportGroupPermissions(companyId, guestGroup.getGroupId(), resourceName, resourcePrimKey, permissionsElement, "guest-actions");
        }
        if (exportUserPermissions) {
            this.exportUserPermissions(layoutCache, companyId, groupId, resourceName, resourcePrimKey, permissionsElement);
        }
        this.exportInheritedPermissions(layoutCache, companyId, resourceName, resourcePrimKey, permissionsElement, "organization");
        this.exportInheritedPermissions(layoutCache, companyId, resourceName, resourcePrimKey, permissionsElement, "user-group");
    }

    protected void exportPermissions_5(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String resourcePrimKey, Element permissionsElement, boolean portletActions) throws Exception {
        Resource resource = layoutCache.getResource(companyId, groupId, resourceName, 4, resourcePrimKey, portletActions);
        List<Role> roles = layoutCache.getGroupRoles_5(groupId, resourceName);
        for (Role role : roles) {
            if (role.getName().equals("Administrator")) continue;
            Element roleElement = permissionsElement.addElement("role");
            roleElement.addAttribute("name", role.getName());
            roleElement.addAttribute("title", role.getTitle());
            roleElement.addAttribute("description", role.getDescription());
            roleElement.addAttribute("type", String.valueOf(role.getType()));
            List permissions = PermissionLocalServiceUtil.getRolePermissions((long)role.getRoleId(), (long)resource.getResourceId());
            List actions = ResourceActionsUtil.getActions((List)permissions);
            for (String action : actions) {
                Element actionKeyElement = roleElement.addElement("action-key");
                actionKeyElement.addText(action);
            }
        }
    }

    protected void exportPermissions_6(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String resourcePrimKey, Element permissionsElement, boolean portletActions) throws Exception {
        List<Role> roles = layoutCache.getGroupRoles_5(groupId, resourceName);
        List actionIds = null;
        actionIds = portletActions ? ResourceActionsUtil.getPortletResourceActions((String)resourceName) : ResourceActionsUtil.getModelResourceActions((String)resourceName);
        if (actionIds.isEmpty()) {
            return;
        }
        PrimitiveLongList roleIds = new PrimitiveLongList(roles.size());
        HashMap<Long, Role> roleIdsToRoles = new HashMap<Long, Role>();
        for (Role role : roles) {
            String name = role.getName();
            if (name.equals("Administrator")) continue;
            roleIds.add(role.getRoleId());
            roleIdsToRoles.put(role.getRoleId(), role);
        }
        Map roleIdsToActionIds = ResourcePermissionLocalServiceUtil.getAvailableResourcePermissionActionIds((long)companyId, (String)resourceName, (int)4, (String)resourcePrimKey, (long[])roleIds.getArray(), (Collection)actionIds);
        for (Role role : roleIdsToRoles.values()) {
            Set availableActionIds = (Set)roleIdsToActionIds.get(role.getRoleId());
            Element roleElement = permissionsElement.addElement("role");
            roleElement.addAttribute("name", role.getName());
            roleElement.addAttribute("title", role.getTitle());
            roleElement.addAttribute("description", role.getDescription());
            roleElement.addAttribute("type", String.valueOf(role.getType()));
            if (availableActionIds == null || availableActionIds.isEmpty()) continue;
            for (String action : availableActionIds) {
                Element actionKeyElement = roleElement.addElement("action-key");
                actionKeyElement.addText(action);
            }
        }
    }

    protected void exportPortletDataPermissions(PortletDataContext portletDataContext) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("portlet-data-permissions");
        Map permissionsMap = portletDataContext.getPermissions();
        for (Map.Entry entry : permissionsMap.entrySet()) {
            String[] permissionParts = StringUtil.split((String)((String)entry.getKey()), (char)'#');
            String resourceName = permissionParts[0];
            long resourcePK = GetterUtil.getLong((String)permissionParts[1]);
            Element portletDataElement = rootElement.addElement("portlet-data");
            portletDataElement.addAttribute("resource-name", resourceName);
            portletDataElement.addAttribute("resource-pk", String.valueOf(resourcePK));
            List permissions = (List)entry.getValue();
            for (KeyValuePair permission : permissions) {
                String roleName = permission.getKey();
                String actions = permission.getValue();
                Element permissionsElement = portletDataElement.addElement("permissions");
                permissionsElement.addAttribute("role-name", roleName);
                permissionsElement.addAttribute("actions", actions);
            }
        }
        portletDataContext.addZipEntry(String.valueOf(portletDataContext.getRootPath()) + "/portlet-data-permissions.xml", document.formattedString());
    }

    protected void exportPortletPermissions(PortletDataContext portletDataContext, LayoutCache layoutCache, String portletId, Layout layout, Element portletElement) throws Exception {
        long companyId = portletDataContext.getCompanyId();
        long groupId = portletDataContext.getGroupId();
        String resourceName = PortletConstants.getRootPortletId((String)portletId);
        String resourcePrimKey = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId);
        Element permissionsElement = portletElement.addElement("permissions");
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
            this.exportPermissions_5(layoutCache, companyId, groupId, resourceName, resourcePrimKey, permissionsElement, true);
        } else if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            this.exportPermissions_6(layoutCache, companyId, groupId, resourceName, resourcePrimKey, permissionsElement, true);
        } else {
            boolean exportUserPermissions = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"USER_PERMISSIONS");
            this.exportPermissions_1to4(layoutCache, companyId, groupId, resourceName, resourcePrimKey, permissionsElement, exportUserPermissions);
            Element rolesElement = portletElement.addElement("roles");
            this.exportPortletRoles(layoutCache, companyId, groupId, portletId, rolesElement);
        }
    }

    protected void exportPortletRoles(LayoutCache layoutCache, long companyId, long groupId, String portletId, Element rolesElement) throws Exception {
        String resourceName = PortletConstants.getRootPortletId((String)portletId);
        Element portletElement = rolesElement.addElement("portlet");
        portletElement.addAttribute("portlet-id", portletId);
        this.exportGroupRoles(layoutCache, companyId, groupId, resourceName, "community", portletElement);
        this.exportUserRoles(layoutCache, companyId, groupId, resourceName, portletElement);
        this.exportInheritedRoles(layoutCache, companyId, groupId, resourceName, "organization", portletElement);
        this.exportInheritedRoles(layoutCache, companyId, groupId, resourceName, "user-group", portletElement);
        if (portletElement.elements().isEmpty()) {
            rolesElement.remove(portletElement);
        }
    }

    protected Element exportRoles(long companyId, String resourceName, int scope, String resourcePrimKey, Element parentElement, String elName, List<Role> roles) throws Exception {
        Element element = parentElement.addElement(elName);
        Map resourceRoles = RoleLocalServiceUtil.getResourceRoles((long)companyId, (String)resourceName, (int)scope, (String)resourcePrimKey);
        for (Map.Entry entry : resourceRoles.entrySet()) {
            String roleName = (String)entry.getKey();
            if (!this.hasRole(roles, roleName)) continue;
            Element roleElement = element.addElement("role");
            roleElement.addAttribute("name", roleName);
            List actions = (List)entry.getValue();
            for (String action : actions) {
                Element actionKeyElement = roleElement.addElement("action-key");
                actionKeyElement.addText(action);
                actionKeyElement.addAttribute("scope", String.valueOf(scope));
            }
        }
        return element;
    }

    protected void exportUserPermissions(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String resourcePrimKey, Element parentElement) throws Exception {
        StopWatch stopWatch = null;
        if (_log.isDebugEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        Element userPermissionsElement = SAXReaderUtil.createElement((String)"user-permissions");
        List<User> users = layoutCache.getGroupUsers(groupId);
        for (User user : users) {
            String uuid = user.getUuid();
            Element userActionsElement = SAXReaderUtil.createElement((String)"user-actions");
            List permissions = PermissionLocalServiceUtil.getUserPermissions((long)user.getUserId(), (long)companyId, (String)resourceName, (int)4, (String)resourcePrimKey);
            List actions = ResourceActionsUtil.getActions((List)permissions);
            for (String action : actions) {
                Element actionKeyElement = userActionsElement.addElement("action-key");
                actionKeyElement.addText(action);
            }
            if (userActionsElement.elements().isEmpty()) continue;
            userActionsElement.addAttribute("uuid", uuid);
            userPermissionsElement.add(userActionsElement);
        }
        if (!userPermissionsElement.elements().isEmpty()) {
            parentElement.add(userPermissionsElement);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export user permissions for {" + resourceName + ", " + resourcePrimKey + "} with " + users.size() + " users takes " + stopWatch.getTime() + " ms"));
        }
    }

    protected void exportUserRoles(LayoutCache layoutCache, long companyId, long groupId, String resourceName, Element parentElement) throws Exception {
        Element userRolesElement = SAXReaderUtil.createElement((String)"user-roles");
        List<User> users = layoutCache.getGroupUsers(groupId);
        for (User user : users) {
            long userId = user.getUserId();
            String uuid = user.getUuid();
            List<Role> userRoles = layoutCache.getUserRoles(userId);
            Element userElement = this.exportRoles(companyId, resourceName, 2, String.valueOf(groupId), userRolesElement, "user", userRoles);
            if (userElement.elements().isEmpty()) {
                userRolesElement.remove(userElement);
                continue;
            }
            userElement.addAttribute("uuid", uuid);
        }
        if (!userRolesElement.elements().isEmpty()) {
            parentElement.add(userRolesElement);
        }
    }

    protected boolean hasRole(List<Role> roles, String roleName) {
        if (roles == null || roles.size() == 0) {
            return false;
        }
        for (Role role : roles) {
            if (!roleName.equals(role.getName())) continue;
            return true;
        }
        return false;
    }
}

