/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.NoSuchRoleException;
import com.liferay.portal.NoSuchTeamException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataContextListener;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.lar.UserIdStrategy;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PrimitiveLongList;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.model.AuditedModel;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Lock;
import com.liferay.portal.model.ResourcedModel;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.Team;
import com.liferay.portal.model.impl.LockImpl;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LockLocalServiceUtil;
import com.liferay.portal.service.PermissionLocalServiceUtil;
import com.liferay.portal.service.ResourceBlockLocalServiceUtil;
import com.liferay.portal.service.ResourceBlockPermissionLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.TeamLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.NoSuchEntryException;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetLink;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetLinkLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.blogs.model.impl.BlogsEntryImpl;
import com.liferay.portlet.bookmarks.model.impl.BookmarksEntryImpl;
import com.liferay.portlet.bookmarks.model.impl.BookmarksFolderImpl;
import com.liferay.portlet.calendar.model.impl.CalEventImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFileRankImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFileShortcutImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderImpl;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.model.ExpandoColumn;
import com.liferay.portlet.expando.service.ExpandoColumnLocalServiceUtil;
import com.liferay.portlet.journal.model.impl.JournalArticleImpl;
import com.liferay.portlet.journal.model.impl.JournalFeedImpl;
import com.liferay.portlet.journal.model.impl.JournalStructureImpl;
import com.liferay.portlet.journal.model.impl.JournalTemplateImpl;
import com.liferay.portlet.messageboards.NoSuchDiscussionException;
import com.liferay.portlet.messageboards.model.MBDiscussion;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.model.impl.MBBanImpl;
import com.liferay.portlet.messageboards.model.impl.MBCategoryImpl;
import com.liferay.portlet.messageboards.model.impl.MBMessageImpl;
import com.liferay.portlet.messageboards.model.impl.MBThreadFlagImpl;
import com.liferay.portlet.messageboards.service.MBDiscussionLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadLocalServiceUtil;
import com.liferay.portlet.messageboards.service.persistence.MBDiscussionUtil;
import com.liferay.portlet.messageboards.service.persistence.MBMessageUtil;
import com.liferay.portlet.polls.model.impl.PollsChoiceImpl;
import com.liferay.portlet.polls.model.impl.PollsQuestionImpl;
import com.liferay.portlet.polls.model.impl.PollsVoteImpl;
import com.liferay.portlet.ratings.model.RatingsEntry;
import com.liferay.portlet.ratings.model.impl.RatingsEntryImpl;
import com.liferay.portlet.ratings.service.RatingsEntryLocalServiceUtil;
import com.liferay.portlet.wiki.model.impl.WikiNodeImpl;
import com.liferay.portlet.wiki.model.impl.WikiPageImpl;
import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletDataContextImpl
implements PortletDataContext {
    private static Log _log = LogFactoryUtil.getLog(PortletDataContextImpl.class);
    private Map<String, long[]> _assetCategoryIdsMap = new HashMap<String, long[]>();
    private Map<String, String[]> _assetCategoryUuidsMap = new HashMap<String, String[]>();
    private Map<String, String[]> _assetLinkUuidsMap = new HashMap<String, String[]>();
    private Map<String, String[]> _assetTagNamesMap = new HashMap<String, String[]>();
    private Map<String, List<MBMessage>> _commentsMap = new HashMap<String, List<MBMessage>>();
    private long _companyId;
    private Map<String, List<String>> _companyReferences = new HashMap<String, List<String>>();
    private String _dataStrategy;
    private Date _endDate;
    private Map<String, List<ExpandoColumn>> _expandoColumnsMap = new HashMap<String, List<ExpandoColumn>>();
    private long _groupId;
    private Map<String, Lock> _locksMap = new HashMap<String, Lock>();
    private Map<String, Map<?, ?>> _newPrimaryKeysMaps = new HashMap();
    private Set<String> _notUniquePerLayout = new HashSet<String>();
    private long _oldPlid;
    private Map<String, String[]> _parameterMap;
    private Map<String, List<KeyValuePair>> _permissionsMap = new HashMap<String, List<KeyValuePair>>();
    private long _plid;
    private PortletDataContextListener _portletDataContextListener;
    private Set<String> _primaryKeys;
    private boolean _privateLayout;
    private Map<String, List<RatingsEntry>> _ratingsEntriesMap = new HashMap<String, List<RatingsEntry>>();
    private long _scopeGroupId;
    private String _scopeLayoutUuid;
    private String _scopeType;
    private long _sourceGroupId;
    private Date _startDate;
    private UserIdStrategy _userIdStrategy;
    private XStream _xStream;
    private ZipReader _zipReader;
    private ZipWriter _zipWriter;

    public PortletDataContextImpl(long companyId, long groupId, Map<String, String[]> parameterMap, Set<String> primaryKeys, Date startDate, Date endDate, ZipWriter zipWriter) throws PortletDataException {
        this.validateDateRange(startDate, endDate);
        this._companyId = companyId;
        this._groupId = groupId;
        this._scopeGroupId = groupId;
        this._parameterMap = parameterMap;
        this._primaryKeys = primaryKeys;
        this._dataStrategy = null;
        this._userIdStrategy = null;
        this._startDate = startDate;
        this._endDate = endDate;
        this._zipReader = null;
        this._zipWriter = zipWriter;
        this.initXStream();
    }

    public PortletDataContextImpl(long companyId, long groupId, Map<String, String[]> parameterMap, Set<String> primaryKeys, UserIdStrategy userIdStrategy, ZipReader zipReader) {
        this._companyId = companyId;
        this._groupId = groupId;
        this._scopeGroupId = groupId;
        this._parameterMap = parameterMap;
        this._primaryKeys = primaryKeys;
        this._dataStrategy = MapUtil.getString(parameterMap, (String)"DATA_STRATEGY", (String)"DATA_STRATEGY_MIRROR");
        this._userIdStrategy = userIdStrategy;
        this._zipReader = zipReader;
        this._zipWriter = null;
        this.initXStream();
    }

    public void addAssetCategories(Class<?> clazz, long classPK) throws SystemException {
        List assetCategories = AssetCategoryLocalServiceUtil.getCategories((String)clazz.getName(), (long)classPK);
        this._assetCategoryUuidsMap.put(this.getPrimaryKeyString(clazz, classPK), StringUtil.split((String)ListUtil.toString((List)assetCategories, (Accessor)AssetCategory.UUID_ACCESSOR)));
        this._assetCategoryIdsMap.put(this.getPrimaryKeyString(clazz, classPK), StringUtil.split((String)ListUtil.toString((List)assetCategories, (Accessor)AssetCategory.CATEGORY_ID_ACCESSOR), (long)0L));
    }

    public void addAssetCategories(String className, long classPK, long[] assetCategoryIds) {
        this._assetCategoryIdsMap.put(this.getPrimaryKeyString(className, classPK), assetCategoryIds);
    }

    public void addAssetLinks(Class<?> clazz, long classPK) throws PortalException, SystemException {
        AssetEntry assetEntry = null;
        try {
            assetEntry = AssetEntryLocalServiceUtil.getEntry((String)clazz.getName(), (long)classPK);
        }
        catch (NoSuchEntryException noSuchEntryException) {
            return;
        }
        List directAssetLinks = AssetLinkLocalServiceUtil.getDirectLinks((long)assetEntry.getEntryId());
        if (directAssetLinks.isEmpty()) {
            return;
        }
        HashMap<Integer, ArrayList<AssetLink>> assetLinksMap = new HashMap<Integer, ArrayList<AssetLink>>();
        for (AssetLink assetLink : directAssetLinks) {
            ArrayList<AssetLink> assetLinks = (ArrayList<AssetLink>)assetLinksMap.get(assetLink.getType());
            if (assetLinks == null) {
                assetLinks = new ArrayList<AssetLink>();
                assetLinksMap.put(assetLink.getType(), assetLinks);
            }
            assetLinks.add(assetLink);
        }
        for (Map.Entry entry : assetLinksMap.entrySet()) {
            int assetLinkType = (Integer)entry.getKey();
            List assetLinks = (List)entry.getValue();
            ArrayList<String> assetLinkUuids = new ArrayList<String>(directAssetLinks.size());
            for (AssetLink assetLink : assetLinks) {
                try {
                    AssetEntry assetLinkEntry = AssetEntryLocalServiceUtil.getEntry((long)assetLink.getEntryId2());
                    assetLinkUuids.add(assetLinkEntry.getClassUuid());
                }
                catch (NoSuchEntryException noSuchEntryException) {}
            }
            this._assetLinkUuidsMap.put(this.getPrimaryKeyString(assetEntry.getClassUuid(), String.valueOf(assetLinkType)), assetLinkUuids.toArray(new String[assetLinkUuids.size()]));
        }
    }

    public void addAssetTags(Class<?> clazz, long classPK) throws SystemException {
        String[] tagNames = AssetTagLocalServiceUtil.getTagNames((String)clazz.getName(), (long)classPK);
        this._assetTagNamesMap.put(this.getPrimaryKeyString(clazz, classPK), tagNames);
    }

    public void addAssetTags(String className, long classPK, String[] assetTagNames) {
        this._assetTagNamesMap.put(this.getPrimaryKeyString(className, classPK), assetTagNames);
    }

    public void addClassedModel(Element element, String path, ClassedModel classedModel, String namespace) throws PortalException, SystemException {
        element.addAttribute("path", path);
        if (classedModel instanceof AuditedModel) {
            AuditedModel auditedModel = (AuditedModel)classedModel;
            auditedModel.setUserUuid(auditedModel.getUserUuid());
        }
        if (this.isResourceMain(classedModel)) {
            Class clazz = classedModel.getModelClass();
            long classPK = this.getClassPK(classedModel);
            this.addAssetLinks(clazz, classPK);
            this.addExpando(element, path, classedModel);
            this.addLocks(clazz, String.valueOf(classPK));
            this.addPermissions(clazz, classPK);
            boolean portletMetadataAll = this.getBooleanParameter(namespace, "PORTLET_METADATA_ALL");
            if (portletMetadataAll || this.getBooleanParameter(namespace, "categories")) {
                this.addAssetCategories(clazz, classPK);
            }
            if (portletMetadataAll || this.getBooleanParameter(namespace, "comments")) {
                this.addComments(clazz, classPK);
            }
            if (portletMetadataAll || this.getBooleanParameter(namespace, "ratings")) {
                this.addRatingsEntries(clazz, classPK);
            }
            if (portletMetadataAll || this.getBooleanParameter(namespace, "tags")) {
                this.addAssetTags(clazz, classPK);
            }
        }
        this.addZipEntry(path, classedModel);
    }

    public void addComments(Class<?> clazz, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId(clazz);
        MBDiscussion discussion = MBDiscussionUtil.fetchByC_C((long)classNameId, (long)classPK);
        if (discussion == null) {
            return;
        }
        List messages = MBMessageLocalServiceUtil.getThreadMessages((long)discussion.getThreadId(), (int)0);
        if (messages.size() == 0) {
            return;
        }
        for (MBMessage message : messages) {
            message.setUserUuid(message.getUserUuid());
            this.addRatingsEntries(MBDiscussion.class, message.getPrimaryKey());
        }
        this._commentsMap.put(this.getPrimaryKeyString(clazz, classPK), messages);
    }

    public void addComments(String className, long classPK, List<MBMessage> messages) {
        this._commentsMap.put(this.getPrimaryKeyString(className, classPK), messages);
    }

    public void addCompanyReference(Class<?> clazz, String key) {
        List<String> keys = this._companyReferences.get(clazz.getName());
        if (keys == null) {
            keys = new ArrayList<String>();
            this._companyReferences.put(clazz.getName(), keys);
        }
        keys.add(key);
    }

    public void addExpando(Element element, String path, ClassedModel classedModel) throws PortalException, SystemException {
        ExpandoBridge expandoBridge;
        Map expandoBridgeAttributes;
        Class clazz = classedModel.getModelClass();
        String className = clazz.getName();
        if (!this._expandoColumnsMap.containsKey(className)) {
            List expandoColumns = ExpandoColumnLocalServiceUtil.getDefaultTableColumns((long)this._companyId, (String)className);
            for (ExpandoColumn expandoColumn : expandoColumns) {
                this.addPermissions(ExpandoColumn.class, expandoColumn.getColumnId());
            }
            this._expandoColumnsMap.put(className, expandoColumns);
        }
        if (!(expandoBridgeAttributes = (expandoBridge = classedModel.getExpandoBridge()).getAttributes()).isEmpty()) {
            String expandoPath = this.getExpandoPath(path);
            element.addAttribute("expando-path", expandoPath);
            this.addZipEntry(expandoPath, expandoBridgeAttributes);
        }
    }

    public void addLocks(Class<?> clazz, String key) throws PortalException, SystemException {
        if (!this._locksMap.containsKey(this.getPrimaryKeyString(clazz, key)) && LockLocalServiceUtil.isLocked((String)clazz.getName(), (String)key)) {
            Lock lock = LockLocalServiceUtil.getLock((String)clazz.getName(), (String)key);
            this.addLocks(clazz.getName(), key, lock);
        }
    }

    public void addLocks(String className, String key, Lock lock) {
        this._locksMap.put(this.getPrimaryKeyString(className, key), lock);
    }

    public void addPermissions(Class<?> clazz, long classPK) throws PortalException, SystemException {
        this.addPermissions(clazz.getName(), classPK);
    }

    public void addPermissions(String resourceName, long resourcePK) throws PortalException, SystemException {
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM != 5 && PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM != 6 || !MapUtil.getBoolean(this._parameterMap, (String)"PERMISSIONS")) {
            return;
        }
        ArrayList<KeyValuePair> permissions = new ArrayList<KeyValuePair>();
        Group group = GroupLocalServiceUtil.getGroup((long)this._groupId);
        List roles = RoleLocalServiceUtil.getRoles((long)this._companyId);
        PrimitiveLongList roleIds = new PrimitiveLongList(roles.size());
        HashMap<Long, String> roleIdsToNames = new HashMap<Long, String>();
        for (Role role : roles) {
            Team team;
            int type = role.getType();
            if (type == 1 || type == 3 && group.isOrganization() || type == 2 && (group.isLayoutSetPrototype() || group.isSite())) {
                String name = role.getName();
                roleIds.add(role.getRoleId());
                roleIdsToNames.put(role.getRoleId(), name);
                continue;
            }
            if (type != 4 || !role.isTeam() || (team = TeamLocalServiceUtil.getTeam((long)role.getClassPK())).getGroupId() != this._groupId) continue;
            String name = "ROLE_TEAM_,*" + team.getName();
            roleIds.add(role.getRoleId());
            roleIdsToNames.put(role.getRoleId(), name);
        }
        List actionIds = ResourceActionsUtil.getModelResourceActions((String)resourceName);
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
            for (Map.Entry entry : roleIdsToNames.entrySet()) {
                long roleId = (Long)entry.getKey();
                String name = (String)entry.getValue();
                String availableActionIds = this.getActionIds_5(this._companyId, roleId, resourceName, String.valueOf(resourcePK), actionIds);
                KeyValuePair permission = new KeyValuePair(name, availableActionIds);
                permissions.add(permission);
            }
        } else if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            Map<Long, Set<String>> roleIdsToActionIds = this.getActionIds_6(this._companyId, roleIds.getArray(), resourceName, resourcePK, actionIds);
            for (Map.Entry entry : roleIdsToNames.entrySet()) {
                long roleId = (Long)entry.getKey();
                String name = (String)entry.getValue();
                Set<String> availableActionIds = roleIdsToActionIds.get(roleId);
                if (availableActionIds == null || availableActionIds.isEmpty()) continue;
                KeyValuePair permission = new KeyValuePair(name, StringUtil.merge(availableActionIds));
                permissions.add(permission);
            }
        }
        this._permissionsMap.put(this.getPrimaryKeyString(resourceName, resourcePK), permissions);
    }

    public void addPermissions(String resourceName, long resourcePK, List<KeyValuePair> permissions) {
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM != 5 && PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM != 6) {
            return;
        }
        this._permissionsMap.put(this.getPrimaryKeyString(resourceName, resourcePK), permissions);
    }

    public boolean addPrimaryKey(Class<?> clazz, String primaryKey) {
        boolean value = this.hasPrimaryKey(clazz, primaryKey);
        if (!value) {
            this._primaryKeys.add(this.getPrimaryKeyString(clazz, primaryKey));
        }
        return value;
    }

    public void addRatingsEntries(Class<?> clazz, long classPK) throws SystemException {
        List ratingsEntries = RatingsEntryLocalServiceUtil.getEntries((String)clazz.getName(), (long)classPK);
        if (ratingsEntries.size() == 0) {
            return;
        }
        for (RatingsEntry entry : ratingsEntries) {
            entry.setUserUuid(entry.getUserUuid());
        }
        this._ratingsEntriesMap.put(this.getPrimaryKeyString(clazz, classPK), ratingsEntries);
    }

    public void addRatingsEntries(String className, long classPK, List<RatingsEntry> ratingsEntries) {
        this._ratingsEntriesMap.put(this.getPrimaryKeyString(className, classPK), ratingsEntries);
    }

    public void addZipEntry(String path, byte[] bytes) throws SystemException {
        if (this._portletDataContextListener != null) {
            this._portletDataContextListener.onAddZipEntry(path);
        }
        try {
            ZipWriter zipWriter = this.getZipWriter();
            zipWriter.addEntry(path, bytes);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public void addZipEntry(String path, InputStream is) throws SystemException {
        if (this._portletDataContextListener != null) {
            this._portletDataContextListener.onAddZipEntry(path);
        }
        try {
            ZipWriter zipWriter = this.getZipWriter();
            zipWriter.addEntry(path, is);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public void addZipEntry(String path, Object object) throws SystemException {
        this.addZipEntry(path, this.toXML(object));
    }

    public void addZipEntry(String path, String s) throws SystemException {
        if (this._portletDataContextListener != null) {
            this._portletDataContextListener.onAddZipEntry(path);
        }
        try {
            ZipWriter zipWriter = this.getZipWriter();
            zipWriter.addEntry(path, s);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public void addZipEntry(String path, StringBuilder sb) throws SystemException {
        if (this._portletDataContextListener != null) {
            this._portletDataContextListener.onAddZipEntry(path);
        }
        try {
            ZipWriter zipWriter = this.getZipWriter();
            zipWriter.addEntry(path, sb);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public ServiceContext createServiceContext(Element element, ClassedModel classedModel, String namespace) {
        return this.createServiceContext(element, null, classedModel, namespace);
    }

    public ServiceContext createServiceContext(String path, ClassedModel classedModel, String namespace) {
        return this.createServiceContext(null, path, classedModel, namespace);
    }

    public Object fromXML(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return this._xStream.fromXML(new String(bytes));
    }

    public Object fromXML(String xml) {
        if (Validator.isNull((String)xml)) {
            return null;
        }
        return this._xStream.fromXML(xml);
    }

    public long[] getAssetCategoryIds(Class<?> clazz, long classPK) {
        return this._assetCategoryIdsMap.get(this.getPrimaryKeyString(clazz, classPK));
    }

    public Map<String, long[]> getAssetCategoryIdsMap() {
        return this._assetCategoryIdsMap;
    }

    public Map<String, String[]> getAssetCategoryUuidsMap() {
        return this._assetCategoryUuidsMap;
    }

    public Map<String, String[]> getAssetLinkUuidsMap() {
        return this._assetLinkUuidsMap;
    }

    public String[] getAssetTagNames(Class<?> clazz, long classPK) {
        return this._assetTagNamesMap.get(this.getPrimaryKeyString(clazz, classPK));
    }

    public String[] getAssetTagNames(String className, long classPK) {
        return this._assetTagNamesMap.get(this.getPrimaryKeyString(className, classPK));
    }

    public Map<String, String[]> getAssetTagNamesMap() {
        return this._assetTagNamesMap;
    }

    public boolean getBooleanParameter(String namespace, String name) {
        boolean defaultValue = MapUtil.getBoolean(this.getParameterMap(), (String)"PORTLET_DATA_CONTROL_DEFAULT", (boolean)true);
        return MapUtil.getBoolean(this.getParameterMap(), (String)PortletDataHandlerControl.getNamespacedControlName((String)namespace, (String)name), (boolean)defaultValue);
    }

    public ClassLoader getClassLoader() {
        return this._xStream.getClassLoader();
    }

    public Map<String, List<MBMessage>> getComments() {
        return this._commentsMap;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public String getDataStrategy() {
        return this._dataStrategy;
    }

    public Date getEndDate() {
        return this._endDate;
    }

    public Map<String, List<ExpandoColumn>> getExpandoColumns() {
        return this._expandoColumnsMap;
    }

    public long getGroupId() {
        return this._groupId;
    }

    public String getLayoutPath(long layoutId) {
        return String.valueOf(this.getRootPath()) + "/layouts/" + layoutId;
    }

    public Map<String, Lock> getLocks() {
        return this._locksMap;
    }

    public Map<?, ?> getNewPrimaryKeysMap(Class<?> clazz) {
        return this.getNewPrimaryKeysMap(clazz.getName());
    }

    public Map<?, ?> getNewPrimaryKeysMap(String className) {
        Map<?, ?> map = this._newPrimaryKeysMaps.get(className);
        if (map == null) {
            map = new HashMap();
            this._newPrimaryKeysMaps.put(className, map);
        }
        return map;
    }

    public long getOldPlid() {
        return this._oldPlid;
    }

    public Map<String, String[]> getParameterMap() {
        return this._parameterMap;
    }

    public Map<String, List<KeyValuePair>> getPermissions() {
        return this._permissionsMap;
    }

    public long getPlid() {
        return this._plid;
    }

    public String getPortletPath(String portletId) {
        return String.valueOf(this.getRootPath()) + "/portlets/" + portletId;
    }

    public Set<String> getPrimaryKeys() {
        return this._primaryKeys;
    }

    public Map<String, List<RatingsEntry>> getRatingsEntries() {
        return this._ratingsEntriesMap;
    }

    public String getRootPath() {
        return "/groups/" + this.getScopeGroupId();
    }

    public long getScopeGroupId() {
        return this._scopeGroupId;
    }

    public String getScopeLayoutUuid() {
        return this._scopeLayoutUuid;
    }

    public String getScopeType() {
        return this._scopeType;
    }

    public long getSourceGroupId() {
        return this._sourceGroupId;
    }

    public String getSourceLayoutPath(long layoutId) {
        return String.valueOf(this.getSourceRootPath()) + "/layouts/" + layoutId;
    }

    public String getSourcePortletPath(String portletId) {
        return String.valueOf(this.getSourceRootPath()) + "/portlets/" + portletId;
    }

    public String getSourceRootPath() {
        return "/groups/" + this.getSourceGroupId();
    }

    public Date getStartDate() {
        return this._startDate;
    }

    public long getUserId(String userUuid) throws SystemException {
        return this._userIdStrategy.getUserId(userUuid);
    }

    public UserIdStrategy getUserIdStrategy() {
        return this._userIdStrategy;
    }

    public List<String> getZipEntries() {
        return this.getZipReader().getEntries();
    }

    public byte[] getZipEntryAsByteArray(String path) {
        if (!this.isValidPath(path)) {
            return null;
        }
        if (this._portletDataContextListener != null) {
            this._portletDataContextListener.onGetZipEntry(path);
        }
        return this.getZipReader().getEntryAsByteArray(path);
    }

    public InputStream getZipEntryAsInputStream(String path) {
        if (!this.isValidPath(path)) {
            return null;
        }
        if (this._portletDataContextListener != null) {
            this._portletDataContextListener.onGetZipEntry(path);
        }
        return this.getZipReader().getEntryAsInputStream(path);
    }

    public Object getZipEntryAsObject(String path) {
        return this.fromXML(this.getZipEntryAsString(path));
    }

    public String getZipEntryAsString(String path) {
        if (!this.isValidPath(path)) {
            return null;
        }
        if (this._portletDataContextListener != null) {
            this._portletDataContextListener.onGetZipEntry(path);
        }
        return this.getZipReader().getEntryAsString(path);
    }

    public List<String> getZipFolderEntries() {
        return this.getZipFolderEntries("/");
    }

    public List<String> getZipFolderEntries(String path) {
        if (!this.isValidPath(path)) {
            return null;
        }
        return this.getZipReader().getFolderEntries(path);
    }

    public ZipReader getZipReader() {
        return this._zipReader;
    }

    public ZipWriter getZipWriter() {
        return this._zipWriter;
    }

    public boolean hasDateRange() {
        return this._startDate != null;
    }

    public boolean hasNotUniquePerLayout(String dataKey) {
        return this._notUniquePerLayout.contains(dataKey);
    }

    public boolean hasPrimaryKey(Class<?> clazz, String primaryKey) {
        return this._primaryKeys.contains(this.getPrimaryKeyString(clazz, primaryKey));
    }

    public void importClassedModel(ClassedModel classedModel, ClassedModel newClassedModel, String namespace) throws PortalException, SystemException {
        if (!this.isResourceMain(classedModel)) {
            return;
        }
        Class clazz = classedModel.getModelClass();
        long classPK = this.getClassPK(classedModel);
        long newClassPK = this.getClassPK(newClassedModel);
        Map<?, ?> newPrimaryKeysMap = this.getNewPrimaryKeysMap(clazz);
        newPrimaryKeysMap.put(classPK, newClassPK);
        this.importLocks(clazz, String.valueOf(classPK), String.valueOf(newClassPK));
        this.importPermissions(clazz, classPK, newClassPK);
        boolean portletMetadataAll = this.getBooleanParameter(namespace, "PORTLET_METADATA_ALL");
        if (portletMetadataAll || this.getBooleanParameter(namespace, "comments")) {
            this.importComments(clazz, classPK, newClassPK, this.getScopeGroupId());
        }
        if (portletMetadataAll || this.getBooleanParameter(namespace, "ratings")) {
            this.importRatingsEntries(clazz, classPK, newClassPK);
        }
    }

    public void importComments(Class<?> clazz, long classPK, long newClassPK, long groupId) throws PortalException, SystemException {
        HashMap<Long, Long> messagePKs = new HashMap<Long, Long>();
        HashMap<Long, Long> threadPKs = new HashMap<Long, Long>();
        List<MBMessage> messages = this._commentsMap.get(this.getPrimaryKeyString(clazz, classPK));
        if (messages == null) {
            return;
        }
        MBDiscussion discussion = null;
        try {
            discussion = MBDiscussionLocalServiceUtil.getDiscussion((String)clazz.getName(), (long)newClassPK);
        }
        catch (NoSuchDiscussionException noSuchDiscussionException) {}
        for (MBMessage message : messages) {
            long userId = this.getUserId(message.getUserUuid());
            long parentMessageId = MapUtil.getLong(messagePKs, (long)message.getParentMessageId(), (long)message.getParentMessageId());
            long threadId = MapUtil.getLong(threadPKs, (long)message.getThreadId(), (long)message.getThreadId());
            if (message.getParentMessageId() == 0L && discussion != null) {
                MBThread thread = MBThreadLocalServiceUtil.getThread((long)discussion.getThreadId());
                long rootMessageId = thread.getRootMessageId();
                messagePKs.put(message.getMessageId(), rootMessageId);
                threadPKs.put(message.getThreadId(), thread.getThreadId());
            } else {
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setCreateDate(message.getCreateDate());
                serviceContext.setModifiedDate(message.getModifiedDate());
                serviceContext.setScopeGroupId(groupId);
                MBMessage importedMessage = null;
                if (this._dataStrategy.equals("DATA_STRATEGY_MIRROR") || this._dataStrategy.equals("DATA_STRATEGY_MIRROR_OVERWRITE")) {
                    MBMessage existingMessage = MBMessageUtil.fetchByUUID_G((String)message.getUuid(), (long)groupId);
                    if (existingMessage == null) {
                        serviceContext.setUuid(message.getUuid());
                        importedMessage = MBMessageLocalServiceUtil.addDiscussionMessage((long)userId, (String)message.getUserName(), (long)groupId, (String)clazz.getName(), (long)newClassPK, (long)threadId, (long)parentMessageId, (String)message.getSubject(), (String)message.getBody(), (ServiceContext)serviceContext);
                    } else {
                        serviceContext.setWorkflowAction(1);
                        importedMessage = MBMessageLocalServiceUtil.updateDiscussionMessage((long)userId, (long)existingMessage.getMessageId(), (String)clazz.getName(), (long)newClassPK, (String)message.getSubject(), (String)message.getBody(), (ServiceContext)serviceContext);
                    }
                } else {
                    importedMessage = MBMessageLocalServiceUtil.addDiscussionMessage((long)userId, (String)message.getUserName(), (long)groupId, (String)clazz.getName(), (long)newClassPK, (long)threadId, (long)parentMessageId, (String)message.getSubject(), (String)message.getBody(), (ServiceContext)serviceContext);
                }
                messagePKs.put(message.getMessageId(), importedMessage.getMessageId());
                threadPKs.put(message.getThreadId(), importedMessage.getThreadId());
            }
            this.importRatingsEntries(MBDiscussion.class, message.getPrimaryKey(), (Long)messagePKs.get(message.getPrimaryKey()));
        }
    }

    public void importLocks(Class<?> clazz, String key, String newKey) throws PortalException, SystemException {
        Lock lock = this._locksMap.get(this.getPrimaryKeyString(clazz, key));
        if (lock == null) {
            return;
        }
        long userId = this.getUserId(lock.getUserUuid());
        long expirationTime = 0L;
        if (lock.getExpirationDate() != null) {
            Date expirationDate = lock.getExpirationDate();
            expirationTime = expirationDate.getTime();
        }
        LockLocalServiceUtil.lock((long)userId, (String)clazz.getName(), (String)newKey, (String)lock.getOwner(), (boolean)lock.isInheritable(), (long)expirationTime);
    }

    public void importPermissions(Class<?> clazz, long classPK, long newClassPK) throws PortalException, SystemException {
        this.importPermissions(clazz.getName(), classPK, newClassPK);
    }

    public void importPermissions(String resourceName, long resourcePK, long newResourcePK) throws PortalException, SystemException {
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM != 5 && PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM != 6 || !MapUtil.getBoolean(this._parameterMap, (String)"PERMISSIONS")) {
            return;
        }
        List<KeyValuePair> permissions = this._permissionsMap.get(this.getPrimaryKeyString(resourceName, resourcePK));
        if (permissions == null) {
            return;
        }
        HashMap<Long, String[]> roleIdsToActionIds = new HashMap<Long, String[]>();
        for (KeyValuePair permission : permissions) {
            String roleName = permission.getKey();
            Role role = null;
            Team team = null;
            if (roleName.startsWith("ROLE_TEAM_,*")) {
                roleName = roleName.substring("ROLE_TEAM_,*".length());
                try {
                    team = TeamLocalServiceUtil.getTeam((long)this._groupId, (String)roleName);
                }
                catch (NoSuchTeamException noSuchTeamException) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Team " + roleName + " does not exist"));
                    continue;
                }
            }
            try {
                role = team != null ? RoleLocalServiceUtil.getTeamRole((long)this._companyId, (long)team.getTeamId()) : RoleLocalServiceUtil.getRole((long)this._companyId, (String)roleName);
            }
            catch (NoSuchRoleException noSuchRoleException) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Role " + roleName + " does not exist"));
                continue;
            }
            String[] actionIds = StringUtil.split((String)permission.getValue());
            roleIdsToActionIds.put(role.getRoleId(), actionIds);
        }
        if (roleIdsToActionIds.isEmpty()) {
            return;
        }
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
            PermissionLocalServiceUtil.setRolesPermissions((long)this._companyId, roleIdsToActionIds, (String)resourceName, (int)4, (String)String.valueOf(newResourcePK));
        } else if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            if (ResourceBlockLocalServiceUtil.isSupported((String)resourceName)) {
                ResourceBlockLocalServiceUtil.setIndividualScopePermissions((long)this._companyId, (long)this._groupId, (String)resourceName, (long)newResourcePK, roleIdsToActionIds);
            } else {
                ResourcePermissionLocalServiceUtil.setResourcePermissions((long)this._companyId, (String)resourceName, (int)4, (String)String.valueOf(newResourcePK), roleIdsToActionIds);
            }
        }
    }

    public void importRatingsEntries(Class<?> clazz, long classPK, long newClassPK) throws PortalException, SystemException {
        List<RatingsEntry> ratingsEntries = this._ratingsEntriesMap.get(this.getPrimaryKeyString(clazz, classPK));
        if (ratingsEntries == null) {
            return;
        }
        ServiceContext serviceContext = new ServiceContext();
        for (RatingsEntry ratingsEntry : ratingsEntries) {
            long userId = this.getUserId(ratingsEntry.getUserUuid());
            serviceContext.setCreateDate(ratingsEntry.getCreateDate());
            serviceContext.setModifiedDate(ratingsEntry.getModifiedDate());
            RatingsEntryLocalServiceUtil.updateEntry((long)userId, (String)clazz.getName(), (long)newClassPK, (double)ratingsEntry.getScore(), (ServiceContext)serviceContext);
        }
    }

    public boolean isCompanyReference(Class<?> clazz, String key) {
        List<String> keys = this._companyReferences.get(clazz.getName());
        return keys != null && keys.contains(key);
    }

    public boolean isDataStrategyMirror() {
        return this._dataStrategy.equals("DATA_STRATEGY_MIRROR") || this._dataStrategy.equals("DATA_STRATEGY_MIRROR_OVERWRITE");
    }

    public boolean isDataStrategyMirrorWithOverwriting() {
        return this._dataStrategy.equals("DATA_STRATEGY_MIRROR_OVERWRITE");
    }

    public boolean isPathNotProcessed(String path) {
        return !this.addPrimaryKey(String.class, path);
    }

    public boolean isPerformDirectBinaryImport() {
        return MapUtil.getBoolean(this._parameterMap, (String)"PERFORM_DIRECT_BINARY_IMPORT");
    }

    public boolean isPrivateLayout() {
        return this._privateLayout;
    }

    public boolean isWithinDateRange(Date modifiedDate) {
        if (!this.hasDateRange()) {
            return true;
        }
        return this._startDate.compareTo(modifiedDate) <= 0 && this._endDate.after(modifiedDate);
    }

    public void putNotUniquePerLayout(String dataKey) {
        this._notUniquePerLayout.add(dataKey);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._xStream.setClassLoader(classLoader);
    }

    public void setGroupId(long groupId) {
        this._groupId = groupId;
    }

    public void setOldPlid(long oldPlid) {
        this._oldPlid = oldPlid;
    }

    public void setPlid(long plid) {
        this._plid = plid;
    }

    public void setPortetDataContextListener(PortletDataContextListener portletDataContextListener) {
        this._portletDataContextListener = portletDataContextListener;
    }

    public void setPrivateLayout(boolean privateLayout) {
        this._privateLayout = privateLayout;
    }

    public void setScopeGroupId(long scopeGroupId) {
        this._scopeGroupId = scopeGroupId;
    }

    public void setScopeLayoutUuid(String scopeLayoutUuid) {
        this._scopeLayoutUuid = scopeLayoutUuid;
    }

    public void setScopeType(String scopeType) {
        this._scopeType = scopeType;
    }

    public void setSourceGroupId(long sourceGroupId) {
        this._sourceGroupId = sourceGroupId;
    }

    public void setStartDate(Date startDate) {
        this._startDate = startDate;
    }

    public String toXML(Object object) {
        return this._xStream.toXML(object);
    }

    protected ServiceContext createServiceContext(Element element, String path, ClassedModel classedModel, String namespace) {
        ServiceContext serviceContext;
        block8: {
            Class clazz = classedModel.getModelClass();
            long classPK = this.getClassPK(classedModel);
            serviceContext = new ServiceContext();
            serviceContext.setCompanyId(this.getCompanyId());
            serviceContext.setScopeGroupId(this.getScopeGroupId());
            if (classedModel instanceof AuditedModel) {
                AuditedModel auditedModel = (AuditedModel)classedModel;
                serviceContext.setCreateDate(auditedModel.getCreateDate());
                serviceContext.setModifiedDate(auditedModel.getModifiedDate());
            }
            if (!MapUtil.getBoolean(this._parameterMap, (String)"PERMISSIONS")) {
                serviceContext.setAddGroupPermissions(true);
                serviceContext.setAddGuestPermissions(true);
            }
            boolean portletMetadataAll = this.getBooleanParameter(namespace, "PORTLET_METADATA_ALL");
            if (this.isResourceMain(classedModel)) {
                if (portletMetadataAll || this.getBooleanParameter(namespace, "categories")) {
                    long[] assetCategoryIds = this.getAssetCategoryIds(clazz, classPK);
                    serviceContext.setAssetCategoryIds(assetCategoryIds);
                }
                if (portletMetadataAll || this.getBooleanParameter(namespace, "tags")) {
                    String[] assetTagNames = this.getAssetTagNames(clazz, classPK);
                    serviceContext.setAssetTagNames(assetTagNames);
                }
            }
            String expandoPath = null;
            expandoPath = element != null ? element.attributeValue("expando-path") : this.getExpandoPath(path);
            if (Validator.isNotNull((String)expandoPath)) {
                try {
                    Map expandoBridgeAttributes = (Map)this.getZipEntryAsObject(expandoPath);
                    serviceContext.setExpandoBridgeAttributes(expandoBridgeAttributes);
                }
                catch (Exception e2) {
                    if (!_log.isDebugEnabled()) break block8;
                    _log.debug((Object)e2, (Throwable)e2);
                }
            }
        }
        return serviceContext;
    }

    protected String getActionIds_5(long companyId, long roleId, String className, String primKey, List<String> actionIds) throws SystemException {
        ArrayList<String> availableActionIds = new ArrayList<String>(actionIds.size());
        for (String actionId : actionIds) {
            if (!PermissionLocalServiceUtil.hasRolePermission((long)roleId, (long)companyId, (String)className, (int)4, (String)primKey, (String)actionId)) continue;
            availableActionIds.add(actionId);
        }
        return StringUtil.merge(availableActionIds);
    }

    protected Map<Long, Set<String>> getActionIds_6(long companyId, long[] roleIds, String className, long primKey, List<String> actionIds) throws PortalException, SystemException {
        if (ResourceBlockLocalServiceUtil.isSupported((String)className)) {
            return ResourceBlockPermissionLocalServiceUtil.getAvailableResourceBlockPermissionActionIds((long[])roleIds, (String)className, (long)primKey, actionIds);
        }
        return ResourcePermissionLocalServiceUtil.getAvailableResourcePermissionActionIds((long)companyId, (String)className, (int)4, (String)String.valueOf(primKey), (long[])roleIds, actionIds);
    }

    protected long getClassPK(ClassedModel classedModel) {
        if (classedModel instanceof ResourcedModel) {
            ResourcedModel resourcedModel = (ResourcedModel)classedModel;
            return resourcedModel.getResourcePrimKey();
        }
        return (Long)classedModel.getPrimaryKeyObj();
    }

    protected String getExpandoPath(String path) {
        if (!this.isValidPath(path)) {
            throw new IllegalArgumentException(String.valueOf(path) + " is located outside of the lar");
        }
        int pos = path.lastIndexOf(".xml");
        if (pos == -1) {
            throw new IllegalArgumentException(String.valueOf(path) + " does not end with .xml");
        }
        return path.substring(0, pos).concat("-expando").concat(path.substring(pos));
    }

    protected String getPrimaryKeyString(Class<?> clazz, long classPK) {
        return this.getPrimaryKeyString(clazz.getName(), String.valueOf(classPK));
    }

    protected String getPrimaryKeyString(Class<?> clazz, String primaryKey) {
        return this.getPrimaryKeyString(clazz.getName(), primaryKey);
    }

    protected String getPrimaryKeyString(String className, long classPK) {
        return this.getPrimaryKeyString(className, String.valueOf(classPK));
    }

    protected String getPrimaryKeyString(String className, String primaryKey) {
        return className.concat("#").concat(primaryKey);
    }

    protected void initXStream() {
        this._xStream = new XStream();
        this._xStream.alias("BlogsEntry", BlogsEntryImpl.class);
        this._xStream.alias("BookmarksFolder", BookmarksFolderImpl.class);
        this._xStream.alias("BookmarksEntry", BookmarksEntryImpl.class);
        this._xStream.alias("CalEvent", CalEventImpl.class);
        this._xStream.alias("DLFolder", DLFolderImpl.class);
        this._xStream.alias("DLFileEntry", DLFileEntryImpl.class);
        this._xStream.alias("DLFileShortcut", DLFileShortcutImpl.class);
        this._xStream.alias("DLFileRank", DLFileRankImpl.class);
        this._xStream.alias("JournalArticle", JournalArticleImpl.class);
        this._xStream.alias("JournalFeed", JournalFeedImpl.class);
        this._xStream.alias("JournalStructure", JournalStructureImpl.class);
        this._xStream.alias("JournalTemplate", JournalTemplateImpl.class);
        this._xStream.alias("Lock", LockImpl.class);
        this._xStream.alias("MBBan", MBBanImpl.class);
        this._xStream.alias("MBCategory", MBCategoryImpl.class);
        this._xStream.alias("MBMessage", MBMessageImpl.class);
        this._xStream.alias("MBThreadFlag", MBThreadFlagImpl.class);
        this._xStream.alias("PollsQuestion", PollsQuestionImpl.class);
        this._xStream.alias("PollsChoice", PollsChoiceImpl.class);
        this._xStream.alias("PollsVote", PollsVoteImpl.class);
        this._xStream.alias("RatingsEntry", RatingsEntryImpl.class);
        this._xStream.alias("WikiNode", WikiNodeImpl.class);
        this._xStream.alias("WikiPage", WikiPageImpl.class);
    }

    protected boolean isResourceMain(ClassedModel classedModel) {
        if (classedModel instanceof ResourcedModel) {
            ResourcedModel resourcedModel = (ResourcedModel)classedModel;
            return resourcedModel.isResourceMain();
        }
        return true;
    }

    protected boolean isValidPath(String path) {
        return path != null && !path.contains("..");
    }

    protected void validateDateRange(Date startDate, Date endDate) throws PortletDataException {
        if (startDate == null && endDate != null) {
            throw new PortletDataException(1);
        }
        if (startDate != null && endDate == null) {
            throw new PortletDataException(5);
        }
        if (startDate != null) {
            if (startDate.after(endDate) || startDate.equals(endDate)) {
                throw new PortletDataException(4);
            }
            Date now = new Date();
            if (startDate.after(now)) {
                throw new PortletDataException(3);
            }
            if (endDate.after(now)) {
                throw new PortletDataException(2);
            }
        }
    }
}

