/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.LayoutImportException;
import com.liferay.portal.NoSuchPortletPreferencesException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lar.ImportExportThreadLocal;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.kernel.zip.ZipWriterFactoryUtil;
import com.liferay.portal.lar.LayoutCache;
import com.liferay.portal.lar.PermissionExporter;
import com.liferay.portal.lar.PortletDataContextImpl;
import com.liferay.portal.lar.PortletDataContextListenerImpl;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Lock;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.PortletItem;
import com.liferay.portal.model.User;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.PortletItemLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetCategoryProperty;
import com.liferay.portlet.asset.model.AssetTag;
import com.liferay.portlet.asset.model.AssetTagProperty;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetCategoryPropertyLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagPropertyLocalServiceUtil;
import com.liferay.portlet.asset.service.persistence.AssetCategoryUtil;
import com.liferay.portlet.asset.service.persistence.AssetVocabularyUtil;
import com.liferay.portlet.expando.model.ExpandoColumn;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.service.JournalStructureLocalServiceUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.ratings.model.RatingsEntry;
import com.liferay.util.xml.DocUtil;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.time.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletExporter {
    private static Log _log = LogFactoryUtil.getLog(PortletExporter.class);
    private PermissionExporter _permissionExporter = new PermissionExporter();

    @Deprecated
    public byte[] exportPortletInfo(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        File file = this.exportPortletInfoAsFile(plid, groupId, portletId, parameterMap, startDate, endDate);
        try {
            byte[] byArray = FileUtil.getBytes((File)file);
            return byArray;
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        finally {
            file.delete();
        }
    }

    public File exportPortletInfoAsFile(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        try {
            ImportExportThreadLocal.setPortletExportInProcess((boolean)true);
            File file = this.doExportPortletInfoAsFile(plid, groupId, portletId, parameterMap, startDate, endDate);
            return file;
        }
        finally {
            ImportExportThreadLocal.setPortletExportInProcess((boolean)false);
        }
    }

    protected File doExportPortletInfoAsFile(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        boolean exportCategories = MapUtil.getBoolean(parameterMap, (String)"CATEGORIES");
        boolean exportPermissions = MapUtil.getBoolean(parameterMap, (String)"PERMISSIONS");
        boolean exportPortletArchivedSetups = MapUtil.getBoolean(parameterMap, (String)"PORTLET_ARCHIVED_SETUPS");
        boolean exportPortletData = false;
        exportPortletData = parameterMap.containsKey("PORTLET_DATA_" + PortletConstants.getRootPortletId((String)portletId)) ? MapUtil.getBoolean(parameterMap, (String)("PORTLET_DATA_" + PortletConstants.getRootPortletId((String)portletId))) : MapUtil.getBoolean(parameterMap, (String)"PORTLET_DATA");
        boolean exportPortletDataAll = MapUtil.getBoolean(parameterMap, (String)"PORTLET_DATA_ALL");
        boolean exportPortletSetup = MapUtil.getBoolean(parameterMap, (String)"PORTLET_SETUP");
        boolean exportPortletUserPreferences = MapUtil.getBoolean(parameterMap, (String)"PORTLET_USER_PREFERENCES");
        boolean exportUserPermissions = MapUtil.getBoolean(parameterMap, (String)"USER_PERMISSIONS");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export categories " + exportCategories));
            _log.debug((Object)("Export permissions " + exportPermissions));
            _log.debug((Object)("Export portlet archived setups " + exportPortletArchivedSetups));
            _log.debug((Object)("Export portlet data " + exportPortletData));
            _log.debug((Object)("Export all portlet data " + exportPortletDataAll));
            _log.debug((Object)("Export portlet setup " + exportPortletSetup));
            _log.debug((Object)("Export portlet user preferences " + exportPortletUserPreferences));
            _log.debug((Object)("Export user permissions " + exportUserPermissions));
        }
        if (exportPortletDataAll) {
            exportPortletData = true;
        }
        StopWatch stopWatch = null;
        if (_log.isInfoEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        LayoutCache layoutCache = new LayoutCache();
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        if (!(layout.isTypeControlPanel() || layout.isTypePanel() || layout.isTypePortlet())) {
            throw new LayoutImportException("Layout type " + layout.getType() + " is not valid");
        }
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)layout.getCompanyId());
        ZipWriter zipWriter = ZipWriterFactoryUtil.getZipWriter();
        long scopeGroupId = groupId;
        PortletPreferences jxPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
        String scopeType = GetterUtil.getString((String)jxPreferences.getValue("lfrScopeType", null));
        String scopeLayoutUuid = GetterUtil.getString((String)jxPreferences.getValue("lfrScopeLayoutUuid", null));
        if (Validator.isNotNull((String)scopeType)) {
            Group scopeGroup = null;
            if (scopeType.equals("company")) {
                scopeGroup = GroupLocalServiceUtil.getCompanyGroup((long)layout.getCompanyId());
            } else if (Validator.isNotNull((String)scopeLayoutUuid)) {
                scopeGroup = layout.getScopeGroup();
            }
            if (scopeGroup != null) {
                scopeGroupId = scopeGroup.getGroupId();
            }
        }
        PortletDataContextImpl portletDataContext = new PortletDataContextImpl(layout.getCompanyId(), scopeGroupId, parameterMap, new HashSet<String>(), startDate, endDate, zipWriter);
        portletDataContext.setPortetDataContextListener(new PortletDataContextListenerImpl(portletDataContext));
        portletDataContext.setPlid(plid);
        portletDataContext.setOldPlid(plid);
        portletDataContext.setScopeType(scopeType);
        portletDataContext.setScopeLayoutUuid(scopeLayoutUuid);
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("root");
        Element headerElement = rootElement.addElement("header");
        headerElement.addAttribute("build-number", String.valueOf(ReleaseInfo.getBuildNumber()));
        headerElement.addAttribute("export-date", Time.getRFC822());
        if (portletDataContext.hasDateRange()) {
            headerElement.addAttribute("start-date", String.valueOf(portletDataContext.getStartDate()));
            headerElement.addAttribute("end-date", String.valueOf(portletDataContext.getEndDate()));
        }
        headerElement.addAttribute("type", "portlet");
        headerElement.addAttribute("group-id", String.valueOf(scopeGroupId));
        headerElement.addAttribute("private-layout", String.valueOf(layout.isPrivateLayout()));
        headerElement.addAttribute("root-portlet-id", PortletConstants.getRootPortletId((String)portletId));
        this.exportPortlet(portletDataContext, layoutCache, portletId, layout, rootElement, defaultUserId, exportPermissions, exportPortletArchivedSetups, exportPortletData, exportPortletSetup, exportPortletUserPreferences, exportUserPermissions);
        if (exportCategories) {
            this.exportAssetCategories(portletDataContext);
        }
        this.exportAssetLinks(portletDataContext);
        this.exportAssetTags(portletDataContext);
        this.exportComments(portletDataContext);
        this.exportExpandoTables(portletDataContext);
        this.exportLocks(portletDataContext);
        if (exportPermissions) {
            this._permissionExporter.exportPortletDataPermissions(portletDataContext);
        }
        this.exportRatingsEntries(portletDataContext, rootElement);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Exporting portlet took " + stopWatch.getTime() + " ms"));
        }
        try {
            portletDataContext.addZipEntry("/manifest.xml", document.formattedString());
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        return zipWriter.getFile();
    }

    protected void exportAssetCategories(PortletDataContext portletDataContext) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("categories-hierarchy");
        this.exportAssetCategories(portletDataContext, rootElement);
        portletDataContext.addZipEntry(String.valueOf(portletDataContext.getRootPath()) + "/categories-hierarchy.xml", document.formattedString());
    }

    protected void exportAssetCategories(PortletDataContext portletDataContext, Element rootElement) throws Exception {
        Element assetVocabulariesElement;
        Element assetCategoriesElement;
        Element assetsElement = rootElement.element("assets");
        if (assetsElement == null) {
            assetsElement = rootElement.addElement("assets");
        }
        if ((assetCategoriesElement = rootElement.element("categories")) == null) {
            assetCategoriesElement = rootElement.addElement("categories");
        }
        if ((assetVocabulariesElement = rootElement.element("vocabularies")) == null) {
            assetVocabulariesElement = rootElement.addElement("vocabularies");
        }
        Map assetCategoryUuidsMap = portletDataContext.getAssetCategoryUuidsMap();
        for (Map.Entry entry : assetCategoryUuidsMap.entrySet()) {
            String[] assetCategoryEntryParts = StringUtil.split((String)((String)entry.getKey()), (char)'#');
            String className = assetCategoryEntryParts[0];
            long classPK = GetterUtil.getLong((String)assetCategoryEntryParts[1]);
            Element assetElement = assetsElement.addElement("asset");
            assetElement.addAttribute("class-name", className);
            assetElement.addAttribute("class-pk", String.valueOf(classPK));
            assetElement.addAttribute("category-uuids", StringUtil.merge((Object[])((Object[])entry.getValue())));
            List assetCategories = AssetCategoryLocalServiceUtil.getCategories((String)className, (long)classPK);
            for (AssetCategory assestCategory : assetCategories) {
                this.exportAssetCategory(portletDataContext, assetVocabulariesElement, assetCategoriesElement, assestCategory);
            }
        }
    }

    protected void exportAssetCategory(PortletDataContext portletDataContext, Element assetVocabulariesElement, Element assetCategoriesElement, AssetCategory assetCategory) throws Exception {
        String path;
        this.exportAssetVocabulary(portletDataContext, assetVocabulariesElement, assetCategory.getVocabularyId());
        if (assetCategory.getParentCategoryId() != 0L) {
            this.exportAssetCategory(portletDataContext, assetVocabulariesElement, assetCategoriesElement, assetCategory.getParentCategoryId());
        }
        if (!portletDataContext.isPathNotProcessed(path = this.getAssetCategoryPath(portletDataContext, assetCategory.getCategoryId()))) {
            return;
        }
        Element assetCategoryElement = assetCategoriesElement.addElement("category");
        Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)assetCategory.getCompanyId());
        if (assetCategory.getGroupId() == companyGroup.getGroupId()) {
            assetCategoryElement.addAttribute("global", "true");
        }
        assetCategoryElement.addAttribute("path", path);
        assetCategory.setUserUuid(assetCategory.getUserUuid());
        portletDataContext.addZipEntry(path, (Object)assetCategory);
        List assetCategoryProperties = AssetCategoryPropertyLocalServiceUtil.getCategoryProperties((long)assetCategory.getCategoryId());
        for (AssetCategoryProperty assetCategoryProperty : assetCategoryProperties) {
            Element propertyElement = assetCategoryElement.addElement("property");
            propertyElement.addAttribute("userUuid", assetCategoryProperty.getUserUuid());
            propertyElement.addAttribute("key", assetCategoryProperty.getKey());
            propertyElement.addAttribute("value", assetCategoryProperty.getValue());
        }
        portletDataContext.addPermissions(AssetCategory.class, assetCategory.getCategoryId());
    }

    protected void exportAssetCategory(PortletDataContext portletDataContext, Element assetVocabulariesElement, Element assetCategoriesElement, long assetCategoryId) throws Exception {
        AssetCategory assetCategory = AssetCategoryUtil.fetchByPrimaryKey((long)assetCategoryId);
        if (assetCategory != null) {
            this.exportAssetCategory(portletDataContext, assetVocabulariesElement, assetCategoriesElement, assetCategory);
        }
    }

    protected void exportAssetLinks(PortletDataContext portletDataContext) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("links");
        Map assetLinkUuidsMap = portletDataContext.getAssetLinkUuidsMap();
        for (Map.Entry entry : assetLinkUuidsMap.entrySet()) {
            String[] assetLinkNameParts = StringUtil.split((String)((String)entry.getKey()), (char)'#');
            Object[] targetAssetEntryUuids = (String[])entry.getValue();
            String sourceAssetEntryUuid = assetLinkNameParts[0];
            String assetLinkType = assetLinkNameParts[1];
            Element assetElement = rootElement.addElement("asset-link");
            assetElement.addAttribute("source-uuid", sourceAssetEntryUuid);
            assetElement.addAttribute("target-uuids", StringUtil.merge((Object[])targetAssetEntryUuids));
            assetElement.addAttribute("type", assetLinkType);
        }
        portletDataContext.addZipEntry(String.valueOf(portletDataContext.getRootPath()) + "/links.xml", document.formattedString());
    }

    protected void exportAssetTag(PortletDataContext portletDataContext, AssetTag assetTag, Element assetTagsElement) throws PortalException, SystemException {
        String path = this.getAssetTagPath(portletDataContext, assetTag.getTagId());
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element assetTagElement = assetTagsElement.addElement("tag");
        assetTagElement.addAttribute("path", path);
        assetTag.setUserUuid(assetTag.getUserUuid());
        portletDataContext.addZipEntry(path, (Object)assetTag);
        List assetTagProperties = AssetTagPropertyLocalServiceUtil.getTagProperties((long)assetTag.getTagId());
        for (AssetTagProperty assetTagProperty : assetTagProperties) {
            Element propertyElement = assetTagElement.addElement("property");
            propertyElement.addAttribute("key", assetTagProperty.getKey());
            propertyElement.addAttribute("value", assetTagProperty.getValue());
        }
        portletDataContext.addPermissions(AssetTag.class, assetTag.getTagId());
    }

    protected void exportAssetTags(PortletDataContext portletDataContext) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("tags");
        Map assetTagNamesMap = portletDataContext.getAssetTagNamesMap();
        if (assetTagNamesMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : assetTagNamesMap.entrySet()) {
            String[] assetTagNameParts = StringUtil.split((String)((String)entry.getKey()), (char)'#');
            String className = assetTagNameParts[0];
            String classPK = assetTagNameParts[1];
            Element assetElement = rootElement.addElement("asset");
            assetElement.addAttribute("class-name", className);
            assetElement.addAttribute("class-pk", classPK);
            assetElement.addAttribute("tags", StringUtil.merge((Object[])((Object[])entry.getValue())));
        }
        List assetTags = AssetTagLocalServiceUtil.getGroupTags((long)portletDataContext.getScopeGroupId());
        for (AssetTag assetTag : assetTags) {
            this.exportAssetTag(portletDataContext, assetTag, rootElement);
        }
        portletDataContext.addZipEntry(String.valueOf(portletDataContext.getRootPath()) + "/tags.xml", document.formattedString());
    }

    protected void exportAssetVocabulary(PortletDataContext portletDataContext, Element assetVocabulariesElement, AssetVocabulary assetVocabulary) throws Exception {
        String path = this.getAssetVocabulariesPath(portletDataContext, assetVocabulary.getVocabularyId());
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element assetVocabularyElement = assetVocabulariesElement.addElement("vocabulary");
        Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)assetVocabulary.getCompanyId());
        if (assetVocabulary.getGroupId() == companyGroup.getGroupId()) {
            assetVocabularyElement.addAttribute("global", "true");
        }
        assetVocabularyElement.addAttribute("path", path);
        assetVocabulary.setUserUuid(assetVocabulary.getUserUuid());
        portletDataContext.addZipEntry(path, (Object)assetVocabulary);
        portletDataContext.addPermissions(AssetVocabulary.class, assetVocabulary.getVocabularyId());
    }

    protected void exportAssetVocabulary(PortletDataContext portletDataContext, Element assetVocabulariesElement, long assetVocabularyId) throws Exception {
        AssetVocabulary assetVocabulary = AssetVocabularyUtil.findByPrimaryKey((long)assetVocabularyId);
        this.exportAssetVocabulary(portletDataContext, assetVocabulariesElement, assetVocabulary);
    }

    protected void exportComments(PortletDataContext portletDataContext) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("comments");
        Map commentsMap = portletDataContext.getComments();
        for (Map.Entry entry : commentsMap.entrySet()) {
            String[] commentParts = StringUtil.split((String)((String)entry.getKey()), (char)'#');
            String className = commentParts[0];
            String classPK = commentParts[1];
            String commentsPath = this.getCommentsPath(portletDataContext, className, classPK);
            Element assetElement = rootElement.addElement("asset");
            assetElement.addAttribute("path", commentsPath);
            assetElement.addAttribute("class-name", className);
            assetElement.addAttribute("class-pk", classPK);
            List mbMessages = (List)entry.getValue();
            for (MBMessage mbMessage : mbMessages) {
                String commentPath = this.getCommentPath(portletDataContext, className, classPK, mbMessage);
                if (!portletDataContext.isPathNotProcessed(commentPath)) continue;
                portletDataContext.addZipEntry(commentPath, (Object)mbMessage);
            }
        }
        portletDataContext.addZipEntry(String.valueOf(portletDataContext.getRootPath()) + "/comments.xml", document.formattedString());
    }

    protected void exportExpandoTables(PortletDataContext portletDataContext) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("expando-tables");
        Map expandoColumnsMap = portletDataContext.getExpandoColumns();
        for (Map.Entry entry : expandoColumnsMap.entrySet()) {
            String className = (String)entry.getKey();
            Element expandoTableElement = rootElement.addElement("expando-table");
            expandoTableElement.addAttribute("class-name", className);
            List expandoColumns = (List)entry.getValue();
            for (ExpandoColumn expandoColumn : expandoColumns) {
                Element expandoColumnElement = expandoTableElement.addElement("expando-column");
                expandoColumnElement.addAttribute("column-id", String.valueOf(expandoColumn.getColumnId()));
                expandoColumnElement.addAttribute("name", expandoColumn.getName());
                expandoColumnElement.addAttribute("type", String.valueOf(expandoColumn.getType()));
                DocUtil.add((Element)expandoColumnElement, (String)"default-data", (String)expandoColumn.getDefaultData());
                Element typeSettingsElement = expandoColumnElement.addElement("type-settings");
                UnicodeProperties typeSettingsProperties = expandoColumn.getTypeSettingsProperties();
                typeSettingsElement.addCDATA(typeSettingsProperties.toString());
            }
        }
        portletDataContext.addZipEntry(String.valueOf(portletDataContext.getRootPath()) + "/expando-tables.xml", document.formattedString());
    }

    protected void exportLocks(PortletDataContext portletDataContext) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("locks");
        Map locksMap = portletDataContext.getLocks();
        for (Map.Entry entry : locksMap.entrySet()) {
            Lock lock = (Lock)entry.getValue();
            String entryKey = (String)entry.getKey();
            int pos = entryKey.indexOf(35);
            String className = entryKey.substring(0, pos);
            String key = entryKey.substring(pos + 1);
            String path = this.getLockPath(portletDataContext, className, key, lock);
            Element assetElement = rootElement.addElement("asset");
            assetElement.addAttribute("path", path);
            assetElement.addAttribute("class-name", className);
            assetElement.addAttribute("key", key);
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            portletDataContext.addZipEntry(path, (Object)lock);
        }
        portletDataContext.addZipEntry(String.valueOf(portletDataContext.getRootPath()) + "/locks.xml", document.formattedString());
    }

    protected void exportPortlet(PortletDataContext portletDataContext, LayoutCache layoutCache, String portletId, Layout layout, Element parentElement, long defaultUserId, boolean exportPermissions, boolean exportPortletArchivedSetups, boolean exportPortletData, boolean exportPortletSetup, boolean exportPortletUserPreferences, boolean exportUserPermissions) throws Exception {
        Portlet portlet;
        long plid = 0L;
        long layoutId = 0L;
        if (layout != null) {
            plid = layout.getPlid();
            layoutId = layout.getLayoutId();
        }
        if ((portlet = PortletLocalServiceUtil.getPortletById((long)portletDataContext.getCompanyId(), (String)portletId)) == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not export portlet " + portletId + " because the portlet does not exist"));
            }
            return;
        }
        if (!portlet.isInstanceable() && !portlet.isPreferencesUniquePerLayout() && portletDataContext.hasNotUniquePerLayout(portletId)) {
            return;
        }
        Document document = SAXReaderUtil.createDocument();
        Element portletElement = document.addElement("portlet");
        portletElement.addAttribute("portlet-id", portletId);
        portletElement.addAttribute("root-portlet-id", PortletConstants.getRootPortletId((String)portletId));
        portletElement.addAttribute("old-plid", String.valueOf(plid));
        portletElement.addAttribute("scope-layout-type", portletDataContext.getScopeType());
        portletElement.addAttribute("scope-layout-uuid", portletDataContext.getScopeLayoutUuid());
        if (exportPortletData) {
            PortletPreferences jxPreferences = PortletPreferencesFactoryUtil.getPortletSetup((Layout)layout, (String)portletId, (String)"");
            if (!portlet.isPreferencesUniquePerLayout()) {
                StringBundler sb = new StringBundler(5);
                sb.append(portletId);
                sb.append("@");
                sb.append(portletDataContext.getScopeType());
                sb.append("@");
                sb.append(portletDataContext.getScopeLayoutUuid());
                String dataKey = sb.toString();
                if (!portletDataContext.hasNotUniquePerLayout(dataKey)) {
                    portletDataContext.putNotUniquePerLayout(dataKey);
                    this.exportPortletData(portletDataContext, portlet, layout, jxPreferences, portletElement);
                }
            } else {
                this.exportPortletData(portletDataContext, portlet, layout, jxPreferences, portletElement);
            }
        }
        if (exportPortletSetup) {
            this.exportPortletPreferences(portletDataContext, 0L, 3, false, layout, plid, portletId, portletElement);
            this.exportPortletPreferences(portletDataContext, portletDataContext.getScopeGroupId(), 2, false, layout, plid, portletId, portletElement);
            this.exportPortletPreferences(portletDataContext, portletDataContext.getCompanyId(), 1, false, layout, plid, portletId, portletElement);
        }
        if (exportPortletUserPreferences) {
            List portletPreferencesList = PortletPreferencesLocalServiceUtil.getPortletPreferences((int)4, (long)plid, (String)portletId);
            for (com.liferay.portal.model.PortletPreferences portletPreferences : portletPreferencesList) {
                boolean defaultUser = false;
                if (portletPreferences.getOwnerId() == 0L) {
                    defaultUser = true;
                }
                this.exportPortletPreferences(portletDataContext, portletPreferences.getOwnerId(), 4, defaultUser, layout, plid, portletId, portletElement);
            }
            try {
                com.liferay.portal.model.PortletPreferences groupPortletPreferences = PortletPreferencesLocalServiceUtil.getPortletPreferences((long)portletDataContext.getScopeGroupId(), (int)2, (long)0L, (String)portletId);
                this.exportPortletPreference(portletDataContext, portletDataContext.getScopeGroupId(), 2, false, groupPortletPreferences, portletId, 0L, portletElement);
            }
            catch (NoSuchPortletPreferencesException noSuchPortletPreferencesException) {}
        }
        if (exportPortletArchivedSetups) {
            String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
            List portletItems = PortletItemLocalServiceUtil.getPortletItems((long)portletDataContext.getGroupId(), (String)rootPortletId, (String)com.liferay.portal.model.PortletPreferences.class.getName());
            for (PortletItem portletItem : portletItems) {
                this.exportPortletPreferences(portletDataContext, portletItem.getPortletItemId(), 5, false, null, plid, portletItem.getPortletId(), portletElement);
            }
        }
        if (exportPermissions) {
            this._permissionExporter.exportPortletPermissions(portletDataContext, layoutCache, portletId, layout, portletElement);
        }
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath(portletId));
        sb.append("/");
        sb.append(plid);
        sb.append("/portlet.xml");
        String path = sb.toString();
        Element element = parentElement.addElement("portlet");
        element.addAttribute("portlet-id", portletId);
        element.addAttribute("layout-id", String.valueOf(layoutId));
        element.addAttribute("path", path);
        Element availableLocalesElement = parentElement.addElement("locale");
        availableLocalesElement.addAttribute("available-locales", StringUtil.merge((Object[])LanguageUtil.getAvailableLocales()));
        if (portletDataContext.isPathNotProcessed(path)) {
            block20: {
                try {
                    portletDataContext.addZipEntry(path, document.formattedString());
                }
                catch (IOException ioe) {
                    if (!_log.isWarnEnabled()) break block20;
                    _log.warn((Object)ioe.getMessage());
                }
            }
            portletDataContext.addPrimaryKey(String.class, path);
        }
    }

    protected void exportPortletData(PortletDataContext portletDataContext, Portlet portlet, Layout layout, PortletPreferences jxPreferences, Element parentElement) throws Exception {
        boolean staged;
        if (portlet == null) {
            return;
        }
        PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
        if (portletDataHandler == null) {
            return;
        }
        String portletId = portlet.getPortletId();
        Group liveGroup = layout.getGroup();
        if (liveGroup.isStagingGroup()) {
            liveGroup = liveGroup.getLiveGroup();
        }
        if (!(staged = liveGroup.isStagedPortlet(portlet.getRootPortletId())) && ImportExportThreadLocal.isLayoutExportInProcess()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Not exporting data for " + portletId + " because it is configured not to be staged"));
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Exporting data for " + portletId));
        }
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath(portletId));
        sb.append("/");
        if (portlet.isPreferencesUniquePerLayout()) {
            sb.append(layout.getPlid());
        } else {
            sb.append(portletDataContext.getScopeGroupId());
        }
        sb.append("/portlet-data.xml");
        String path = sb.toString();
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        long lastPublishDate = GetterUtil.getLong((String)jxPreferences.getValue("last-publish-date", ""));
        Date startDate = portletDataContext.getStartDate();
        if (lastPublishDate > 0L && startDate != null && lastPublishDate < startDate.getTime()) {
            portletDataContext.setStartDate(new Date(lastPublishDate));
        }
        String data = null;
        long groupId = portletDataContext.getGroupId();
        portletDataContext.setGroupId(portletDataContext.getScopeGroupId());
        try {
            try {
                data = portletDataHandler.exportData(portletDataContext, portletId, jxPreferences);
            }
            catch (Exception e2) {
                throw new SystemException((Throwable)e2);
            }
        }
        finally {
            portletDataContext.setGroupId(groupId);
            portletDataContext.setStartDate(startDate);
        }
        if (Validator.isNull((String)data)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Not exporting data for " + portletId + " because null data was returned"));
            }
            return;
        }
        Element portletDataElement = parentElement.addElement("portlet-data");
        portletDataElement.addAttribute("path", path);
        portletDataContext.addZipEntry(path, data);
        Date endDate = portletDataContext.getEndDate();
        if (endDate != null) {
            try {
                jxPreferences.setValue("last-publish-date", String.valueOf(endDate.getTime()));
                jxPreferences.store();
            }
            catch (Exception e3) {
                _log.error((Object)e3, (Throwable)e3);
            }
        }
    }

    protected void exportPortletPreference(PortletDataContext portletDataContext, long ownerId, int ownerType, boolean defaultUser, com.liferay.portal.model.PortletPreferences portletPreferences, String portletId, long plid, Element parentElement) throws Exception {
        String rootPotletId;
        String preferencesXML = portletPreferences.getPreferences();
        if (Validator.isNull((String)preferencesXML)) {
            preferencesXML = "<portlet-preferences />";
        }
        if ((rootPotletId = PortletConstants.getRootPortletId((String)portletId)).equals("101")) {
            preferencesXML = this.updateAssetPublisherPortletPreferences(preferencesXML, plid);
        }
        Document document = SAXReaderUtil.read((String)preferencesXML);
        Element rootElement = document.getRootElement();
        rootElement.addAttribute("owner-id", String.valueOf(ownerId));
        rootElement.addAttribute("owner-type", String.valueOf(ownerType));
        rootElement.addAttribute("default-user", String.valueOf(defaultUser));
        rootElement.addAttribute("plid", String.valueOf(plid));
        rootElement.addAttribute("portlet-id", portletId);
        if (ownerType == 5) {
            PortletItem portletItem = PortletItemLocalServiceUtil.getPortletItem((long)ownerId);
            rootElement.addAttribute("archive-user-uuid", portletItem.getUserUuid());
            rootElement.addAttribute("archive-name", portletItem.getName());
        } else if (ownerType == 4) {
            User user = UserLocalServiceUtil.fetchUserById((long)ownerId);
            if (user == null) {
                return;
            }
            rootElement.addAttribute("user-uuid", user.getUserUuid());
        }
        List nodes = document.selectNodes("/portlet-preferences/preference[name/text() = 'last-publish-date']");
        for (Node node : nodes) {
            document.remove(node);
        }
        String path = this.getPortletPreferencesPath(portletDataContext, portletId, ownerId, ownerType, plid);
        Element portletPreferencesElement = parentElement.addElement("portlet-preferences");
        portletPreferencesElement.addAttribute("path", path);
        if (portletDataContext.isPathNotProcessed(path)) {
            portletDataContext.addZipEntry(path, document.formattedString("\t", false, false));
        }
    }

    protected void exportPortletPreferences(PortletDataContext portletDataContext, long ownerId, int ownerType, boolean defaultUser, Layout layout, long plid, String portletId, Element parentElement) throws Exception {
        com.liferay.portal.model.PortletPreferences portletPreferences = null;
        if (ownerType == 1 || ownerType == 2 || ownerType == 5) {
            plid = 0L;
        }
        try {
            portletPreferences = PortletPreferencesLocalServiceUtil.getPortletPreferences((long)ownerId, (int)ownerType, (long)plid, (String)portletId);
        }
        catch (NoSuchPortletPreferencesException noSuchPortletPreferencesException) {
            return;
        }
        LayoutTypePortlet layoutTypePortlet = null;
        if (layout != null) {
            layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        }
        if (layoutTypePortlet == null || layoutTypePortlet.hasPortletId(portletId)) {
            this.exportPortletPreference(portletDataContext, ownerId, ownerType, defaultUser, portletPreferences, portletId, plid, parentElement);
        }
    }

    protected void exportRatingsEntries(PortletDataContext portletDataContext, Element parentElement) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("ratings");
        Map ratingsEntriesMap = portletDataContext.getRatingsEntries();
        for (Map.Entry entry : ratingsEntriesMap.entrySet()) {
            String[] ratingsEntryParts = StringUtil.split((String)((String)entry.getKey()), (char)'#');
            String className = ratingsEntryParts[0];
            String classPK = ratingsEntryParts[1];
            String ratingsEntriesPath = this.getRatingsEntriesPath(portletDataContext, className, classPK);
            Element assetElement = rootElement.addElement("asset");
            assetElement.addAttribute("path", ratingsEntriesPath);
            assetElement.addAttribute("class-name", className);
            assetElement.addAttribute("class-pk", classPK);
            List ratingsEntries = (List)entry.getValue();
            for (RatingsEntry ratingsEntry : ratingsEntries) {
                String ratingsEntryPath = this.getRatingsEntryPath(portletDataContext, className, classPK, ratingsEntry);
                portletDataContext.addZipEntry(ratingsEntryPath, (Object)ratingsEntry);
            }
        }
        portletDataContext.addZipEntry(String.valueOf(portletDataContext.getRootPath()) + "/ratings.xml", document.formattedString());
    }

    protected String getAssetCategoryPath(PortletDataContext portletDataContext, long assetCategoryId) {
        StringBundler sb = new StringBundler(6);
        sb.append(portletDataContext.getRootPath());
        sb.append("/categories/");
        sb.append(assetCategoryId);
        sb.append(".xml");
        return sb.toString();
    }

    protected String getAssetTagPath(PortletDataContext portletDataContext, long assetCategoryId) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getRootPath());
        sb.append("/tags/");
        sb.append(assetCategoryId);
        sb.append(".xml");
        return sb.toString();
    }

    protected String getAssetVocabulariesPath(PortletDataContext portletDataContext, long assetVocabularyId) {
        StringBundler sb = new StringBundler(8);
        sb.append(portletDataContext.getRootPath());
        sb.append("/vocabularies/");
        sb.append(assetVocabularyId);
        sb.append(".xml");
        return sb.toString();
    }

    protected String getCommentPath(PortletDataContext portletDataContext, String className, String classPK, MBMessage mbMessage) {
        StringBundler sb = new StringBundler(8);
        sb.append(portletDataContext.getRootPath());
        sb.append("/comments/");
        sb.append(PortalUtil.getClassNameId((String)className));
        sb.append('/');
        sb.append(classPK);
        sb.append('/');
        sb.append(mbMessage.getMessageId());
        sb.append(".xml");
        return sb.toString();
    }

    protected String getCommentsPath(PortletDataContext portletDataContext, String className, String classPK) {
        StringBundler sb = new StringBundler(6);
        sb.append(portletDataContext.getRootPath());
        sb.append("/comments/");
        sb.append(PortalUtil.getClassNameId((String)className));
        sb.append('/');
        sb.append(classPK);
        sb.append('/');
        return sb.toString();
    }

    protected String getLockPath(PortletDataContext portletDataContext, String className, String key, Lock lock) {
        StringBundler sb = new StringBundler(8);
        sb.append(portletDataContext.getRootPath());
        sb.append("/locks/");
        sb.append(PortalUtil.getClassNameId((String)className));
        sb.append('/');
        sb.append(key);
        sb.append('/');
        sb.append(lock.getLockId());
        sb.append(".xml");
        return sb.toString();
    }

    protected String getPortletDataPath(PortletDataContext portletDataContext, String portletId) {
        return String.valueOf(portletDataContext.getPortletPath(portletId)) + "/portlet-data.xml";
    }

    protected String getPortletPreferencesPath(PortletDataContext portletDataContext, String portletId, long ownerId, int ownerType, long plid) {
        StringBundler sb = new StringBundler(8);
        sb.append(portletDataContext.getPortletPath(portletId));
        sb.append("/preferences/");
        if (ownerType == 1) {
            sb.append("company/");
        } else if (ownerType == 2) {
            sb.append("group/");
        } else if (ownerType == 3) {
            sb.append("layout/");
        } else if (ownerType == 4) {
            sb.append("user/");
        } else if (ownerType == 5) {
            sb.append("archived/");
        }
        sb.append(ownerId);
        sb.append('/');
        sb.append(plid);
        sb.append('/');
        sb.append("portlet-preferences.xml");
        return sb.toString();
    }

    protected String getRatingsEntriesPath(PortletDataContext portletDataContext, String className, String classPK) {
        StringBundler sb = new StringBundler(6);
        sb.append(portletDataContext.getRootPath());
        sb.append("/ratings/");
        sb.append(PortalUtil.getClassNameId((String)className));
        sb.append('/');
        sb.append(classPK);
        sb.append('/');
        return sb.toString();
    }

    protected String getRatingsEntryPath(PortletDataContext portletDataContext, String className, String classPK, RatingsEntry ratingsEntry) {
        StringBundler sb = new StringBundler(8);
        sb.append(portletDataContext.getRootPath());
        sb.append("/ratings/");
        sb.append(PortalUtil.getClassNameId((String)className));
        sb.append('/');
        sb.append(classPK);
        sb.append('/');
        sb.append(ratingsEntry.getEntryId());
        sb.append(".xml");
        return sb.toString();
    }

    protected void updateAssetPublisherClassPKs(PortletPreferences jxPreferences, String key, String className) throws Exception {
        String[] oldValues = jxPreferences.getValues(key, null);
        if (oldValues == null) {
            return;
        }
        String[] newValues = new String[oldValues.length];
        int i2 = 0;
        while (i2 < oldValues.length) {
            String[] primaryKeys;
            String oldValue;
            String newValue = oldValue = oldValues[i2];
            String[] stringArray = primaryKeys = StringUtil.split((String)oldValue);
            int n = primaryKeys.length;
            int n2 = 0;
            while (n2 < n) {
                JournalStructure structure;
                String primaryKey = stringArray[n2];
                if (!Validator.isNumber((String)primaryKey)) break;
                long primaryKeyLong = GetterUtil.getLong((String)primaryKey);
                String uuid = null;
                if (className.equals(AssetCategory.class.getName())) {
                    AssetCategory category = AssetCategoryLocalServiceUtil.fetchCategory((long)primaryKeyLong);
                    if (category != null) {
                        uuid = category.getUuid();
                    }
                } else if (className.equals(JournalStructure.class.getName()) && (structure = JournalStructureLocalServiceUtil.fetchJournalStructure((long)primaryKeyLong)) != null) {
                    uuid = structure.getUuid();
                }
                if (Validator.isNull(uuid)) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Unable to get UUID for class " + className + " with primary key " + primaryKeyLong));
                    }
                } else {
                    newValue = StringUtil.replace((String)newValue, (String)primaryKey, (String)uuid);
                }
                ++n2;
            }
            newValues[i2] = newValue;
            ++i2;
        }
        jxPreferences.setValues(key, newValues);
    }

    protected void updateAssetPublisherGlobalScopeId(PortletPreferences jxPreferences, String key, long plid) throws Exception {
        String[] oldValues = jxPreferences.getValues(key, null);
        if (oldValues == null) {
            return;
        }
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        Company company = CompanyLocalServiceUtil.getCompany((long)layout.getCompanyId());
        Group companyGroup = company.getGroup();
        String[] newValues = new String[oldValues.length];
        int i2 = 0;
        while (i2 < oldValues.length) {
            String oldValue = oldValues[i2];
            newValues[i2] = StringUtil.replace((String)oldValue, (String)("Group_" + companyGroup.getGroupId()), (String)"Group_Company");
            ++i2;
        }
        jxPreferences.setValues(key, newValues);
    }

    protected String updateAssetPublisherPortletPreferences(String xml, long plid) throws Exception {
        PortletPreferences jxPreferences = PortletPreferencesFactoryUtil.fromDefaultXML((String)xml);
        Enumeration enu = jxPreferences.getNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            String value = GetterUtil.getString((String)jxPreferences.getValue(name, null));
            String prefix = "queryName";
            if (value.equalsIgnoreCase("assetCategories") && name.startsWith(prefix)) {
                String index = name.substring(prefix.length());
                this.updateAssetPublisherClassPKs(jxPreferences, "queryValues" + index, AssetCategory.class.getName());
                continue;
            }
            if (name.equals("anyClassTypeJournalArticleAssetRendererFactory") || name.equals("classTypeIdsJournalArticleAssetRendererFactory") || name.equals("classTypeIds")) {
                this.updateAssetPublisherClassPKs(jxPreferences, name, JournalStructure.class.getName());
                continue;
            }
            if (!name.equals("defaultScope") && !name.equals("scopeIds")) continue;
            this.updateAssetPublisherGlobalScopeId(jxPreferences, name, plid);
        }
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)jxPreferences);
    }
}

