/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.LARFileException;
import com.liferay.portal.LARTypeException;
import com.liferay.portal.LayoutImportException;
import com.liferay.portal.LocaleException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.PortletIdException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lar.ImportExportThreadLocal;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandler;
import com.liferay.portal.kernel.lar.UserIdStrategy;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactoryUtil;
import com.liferay.portal.lar.AlwaysCurrentUserIdStrategy;
import com.liferay.portal.lar.CurrentUserIdStrategy;
import com.liferay.portal.lar.LayoutCache;
import com.liferay.portal.lar.PermissionImporter;
import com.liferay.portal.lar.PortletDataContextImpl;
import com.liferay.portal.lar.PortletDataContextListenerImpl;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Lock;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.PortletItem;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.PortletPreferencesImpl;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.PortletItemLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.persistence.PortletPreferencesUtil;
import com.liferay.portal.service.persistence.UserUtil;
import com.liferay.portal.servlet.filters.cache.CacheUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.asset.NoSuchCategoryException;
import com.liferay.portlet.asset.NoSuchEntryException;
import com.liferay.portlet.asset.NoSuchTagException;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetTag;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetLinkLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetVocabularyLocalServiceUtil;
import com.liferay.portlet.asset.service.permission.AssetPermission;
import com.liferay.portlet.asset.service.persistence.AssetCategoryUtil;
import com.liferay.portlet.asset.service.persistence.AssetTagUtil;
import com.liferay.portlet.asset.service.persistence.AssetVocabularyUtil;
import com.liferay.portlet.expando.NoSuchTableException;
import com.liferay.portlet.expando.model.ExpandoColumn;
import com.liferay.portlet.expando.model.ExpandoTable;
import com.liferay.portlet.expando.service.ExpandoColumnLocalServiceUtil;
import com.liferay.portlet.expando.service.ExpandoTableLocalServiceUtil;
import com.liferay.portlet.expando.util.ExpandoConverterUtil;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.service.persistence.JournalStructureUtil;
import com.liferay.portlet.journalcontent.util.JournalContentUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.ratings.model.RatingsEntry;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.time.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletImporter {
    private static Log _log = LogFactoryUtil.getLog(PortletImporter.class);
    private PermissionImporter _permissionImporter = new PermissionImporter();

    public void importPortletInfo(long userId, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, File file) throws Exception {
        try {
            ImportExportThreadLocal.setPortletImportInProcess((boolean)true);
            this.doImportPortletInfo(userId, plid, groupId, portletId, parameterMap, file);
        }
        finally {
            ImportExportThreadLocal.setPortletImportInProcess((boolean)false);
            CacheUtil.clearCache();
            JournalContentUtil.clearCache();
            PermissionCacheUtil.clearCache();
        }
    }

    protected void deletePortletData(PortletDataContext portletDataContext, String portletId, long plid) throws Exception {
        String xml;
        long ownerId = 0L;
        int ownerType = 3;
        com.liferay.portal.model.PortletPreferences portletPreferences = PortletPreferencesUtil.fetchByO_O_P_P((long)ownerId, (int)ownerType, (long)plid, (String)portletId);
        if (portletPreferences == null) {
            portletPreferences = new PortletPreferencesImpl();
        }
        if ((xml = this.deletePortletData(portletDataContext, portletId, portletPreferences)) != null) {
            PortletPreferencesLocalServiceUtil.updatePreferences((long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        }
    }

    protected String deletePortletData(PortletDataContext portletDataContext, String portletId, com.liferay.portal.model.PortletPreferences portletPreferences) throws Exception {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)portletDataContext.getCompanyId(), (String)portletId);
        if (portlet == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not delete portlet data for " + portletId + " because the portlet does not exist"));
            }
            return null;
        }
        PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
        if (portletDataHandler == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not delete portlet data for " + portletId + " because the portlet does not have a " + "PortletDataHandler"));
            }
            return null;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Deleting data for " + portletId));
        }
        com.liferay.portlet.PortletPreferencesImpl portletPreferencesImpl = (com.liferay.portlet.PortletPreferencesImpl)PortletPreferencesFactoryUtil.fromDefaultXML((String)portletPreferences.getPreferences());
        try {
            portletPreferencesImpl = (com.liferay.portlet.PortletPreferencesImpl)portletDataHandler.deleteData(portletDataContext, portletId, (PortletPreferences)portletPreferencesImpl);
        }
        finally {
            portletDataContext.setGroupId(portletDataContext.getScopeGroupId());
        }
        if (portletPreferencesImpl == null) {
            return null;
        }
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferencesImpl);
    }

    protected void doImportPortletInfo(long userId, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, File file) throws Exception {
        boolean deletePortletData = MapUtil.getBoolean(parameterMap, (String)"DELETE_PORTLET_DATA");
        boolean importPermissions = MapUtil.getBoolean(parameterMap, (String)"PERMISSIONS");
        boolean importUserPermissions = MapUtil.getBoolean(parameterMap, (String)"PERMISSIONS");
        boolean importPortletData = MapUtil.getBoolean(parameterMap, (String)"PORTLET_DATA");
        boolean importPortletArchivedSetups = MapUtil.getBoolean(parameterMap, (String)"PORTLET_ARCHIVED_SETUPS");
        boolean importPortletSetup = MapUtil.getBoolean(parameterMap, (String)"PORTLET_SETUP");
        boolean importPortletUserPreferences = MapUtil.getBoolean(parameterMap, (String)"PORTLET_USER_PREFERENCES");
        String userIdStrategyString = MapUtil.getString(parameterMap, (String)"USER_ID_STRATEGY");
        StopWatch stopWatch = null;
        if (_log.isInfoEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        User user = UserUtil.findByPrimaryKey((long)userId);
        UserIdStrategy userIdStrategy = this.getUserIdStrategy(user, userIdStrategyString);
        ZipReader zipReader = ZipReaderFactoryUtil.getZipReader((File)file);
        PortletDataContextImpl portletDataContext = new PortletDataContextImpl(layout.getCompanyId(), groupId, parameterMap, new HashSet<String>(), userIdStrategy, zipReader);
        portletDataContext.setPortetDataContextListener(new PortletDataContextListenerImpl(portletDataContext));
        portletDataContext.setPlid(plid);
        portletDataContext.setPrivateLayout(layout.isPrivateLayout());
        String xml = portletDataContext.getZipEntryAsString("/manifest.xml");
        Element rootElement = null;
        try {
            Document document = SAXReaderUtil.read((String)xml);
            rootElement = document.getRootElement();
        }
        catch (Exception exception) {
            throw new LARFileException("Unable to read /manifest.xml");
        }
        Element headerElement = rootElement.element("header");
        int buildNumber = ReleaseInfo.getBuildNumber();
        int importBuildNumber = GetterUtil.getInteger((String)headerElement.attributeValue("build-number"));
        if (buildNumber != importBuildNumber) {
            throw new LayoutImportException("LAR build number " + importBuildNumber + " does not match " + "portal build number " + buildNumber);
        }
        String type = headerElement.attributeValue("type");
        if (!type.equals("portlet")) {
            throw new LARTypeException("Invalid type of LAR file (" + type + ")");
        }
        String rootPortletId = headerElement.attributeValue("root-portlet-id");
        if (!PortletConstants.getRootPortletId((String)portletId).equals(rootPortletId)) {
            throw new PortletIdException("Invalid portlet id " + rootPortletId);
        }
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)portletDataContext.getCompanyId(), (String)portletId);
        PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
        if (portletDataHandler != null && portletDataHandler.isDataLocalized()) {
            Element sourceAvailableLocalesElement = rootElement.element("locale");
            Locale[] sourceAvailableLocales = LocaleUtil.fromLanguageIds((String[])StringUtil.split((String)sourceAvailableLocalesElement.attributeValue("available-locales")));
            Object[] targetAvailableLocales = LanguageUtil.getAvailableLocales();
            Locale[] localeArray = sourceAvailableLocales;
            int n = sourceAvailableLocales.length;
            int n2 = 0;
            while (n2 < n) {
                Locale sourceAvailableLocale = localeArray[n2];
                if (!ArrayUtil.contains((Object[])targetAvailableLocales, (Object)sourceAvailableLocale)) {
                    LocaleException le = new LocaleException();
                    le.setSourceAvailableLocales(sourceAvailableLocales);
                    le.setTargetAvailableLocales((Locale[])targetAvailableLocales);
                    throw le;
                }
                ++n2;
            }
        }
        long sourceGroupId = GetterUtil.getLong((String)headerElement.attributeValue("group-id"));
        portletDataContext.setSourceGroupId(sourceGroupId);
        if (importPermissions) {
            this._permissionImporter.readPortletDataPermissions(portletDataContext);
        }
        this.readAssetCategories(portletDataContext);
        this.readAssetTags(portletDataContext);
        this.readComments(portletDataContext);
        this.readExpandoTables(portletDataContext);
        this.readLocks(portletDataContext);
        this.readRatingsEntries(portletDataContext);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Deleting portlet data");
        }
        if (deletePortletData) {
            this.deletePortletData((PortletDataContext)portletDataContext, portletId, plid);
        }
        Element portletElement = null;
        try {
            portletElement = rootElement.element("portlet");
            Document portletDocument = SAXReaderUtil.read((String)portletDataContext.getZipEntryAsString(portletElement.attributeValue("path")));
            portletElement = portletDocument.getRootElement();
        }
        catch (DocumentException de) {
            throw new SystemException((Throwable)de);
        }
        this.setPortletScope(portletDataContext, portletElement);
        Element portletDataElement = portletElement.element("portlet-data");
        boolean importData = importPortletData && portletDataElement != null;
        try {
            this.importPortletPreferences(portletDataContext, layout.getCompanyId(), groupId, layout, portletId, portletElement, importPortletSetup, importPortletArchivedSetups, importPortletUserPreferences, true, importData);
            if (importData) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Importing portlet data");
                }
                this.importPortletData((PortletDataContext)portletDataContext, portletId, plid, portletDataElement);
            }
        }
        finally {
            this.resetPortletScope(portletDataContext, groupId);
        }
        if (importPermissions) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Importing portlet permissions");
            }
            LayoutCache layoutCache = new LayoutCache();
            this._permissionImporter.importPortletPermissions(layoutCache, layout.getCompanyId(), groupId, userId, layout, portletElement, portletId, importUserPermissions);
            if (userId > 0L && (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5 || PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6)) {
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
                indexer.reindex((Object)userId);
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Importing asset links");
        }
        this.readAssetLinks(portletDataContext);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Importing portlet takes " + stopWatch.getTime() + " ms"));
        }
        zipReader.close();
    }

    protected String getAssetCategoryName(String uuid, long groupId, long parentCategoryId, String name, int count) throws Exception {
        AssetCategory assetCategory = null;
        try {
            assetCategory = AssetCategoryUtil.findByG_P_N_First((long)groupId, (long)parentCategoryId, (String)name, null);
        }
        catch (NoSuchCategoryException noSuchCategoryException) {
            return name;
        }
        if (Validator.isNotNull((String)uuid) && uuid.equals(assetCategory.getUuid())) {
            return name;
        }
        name = StringUtil.appendParentheticalSuffix((String)name, (int)count);
        return this.getAssetCategoryName(uuid, groupId, parentCategoryId, name, ++count);
    }

    protected String getAssetCategoryPath(PortletDataContext portletDataContext, long assetCategoryId) {
        StringBundler sb = new StringBundler(6);
        sb.append(portletDataContext.getSourceRootPath());
        sb.append("/categories/");
        sb.append(assetCategoryId);
        sb.append(".xml");
        return sb.toString();
    }

    protected Map<Locale, String> getAssetCategoryTitleMap(AssetCategory assetCategory, String name) {
        HashMap<Locale, String> titleMap = assetCategory.getTitleMap();
        if (titleMap == null) {
            titleMap = new HashMap<Locale, String>();
        }
        Locale locale = LocaleUtil.getDefault();
        titleMap.put(locale, name);
        return titleMap;
    }

    protected String getAssetVocabularyName(String uuid, long groupId, String name, int count) throws Exception {
        AssetVocabulary assetVocabulary = AssetVocabularyUtil.fetchByG_N((long)groupId, (String)name);
        if (assetVocabulary == null) {
            return name;
        }
        if (Validator.isNotNull((String)uuid) && uuid.equals(assetVocabulary.getUuid())) {
            return name;
        }
        name = StringUtil.appendParentheticalSuffix((String)name, (int)count);
        return this.getAssetVocabularyName(uuid, groupId, name, ++count);
    }

    protected Map<Locale, String> getAssetVocabularyTitleMap(AssetVocabulary assetVocabulary, String name) {
        HashMap<Locale, String> titleMap = assetVocabulary.getTitleMap();
        if (titleMap == null) {
            titleMap = new HashMap<Locale, String>();
        }
        Locale locale = LocaleUtil.getDefault();
        titleMap.put(locale, name);
        return titleMap;
    }

    protected UserIdStrategy getUserIdStrategy(User user, String userIdStrategy) {
        if ("ALWAYS_CURRENT_USER_ID".equals(userIdStrategy)) {
            return new AlwaysCurrentUserIdStrategy(user);
        }
        return new CurrentUserIdStrategy(user);
    }

    protected void importAssetCategory(PortletDataContext portletDataContext, Map<Long, Long> assetVocabularyPKs, Map<Long, Long> assetCategoryPKs, Map<String, String> assetCategoryUuids, Element assetCategoryElement, AssetCategory assetCategory) throws Exception {
        long userId = portletDataContext.getUserId(assetCategory.getUserUuid());
        long groupId = portletDataContext.getGroupId();
        long assetVocabularyId = MapUtil.getLong(assetVocabularyPKs, (long)assetCategory.getVocabularyId(), (long)assetCategory.getVocabularyId());
        long parentAssetCategoryId = MapUtil.getLong(assetCategoryPKs, (long)assetCategory.getParentCategoryId(), (long)assetCategory.getParentCategoryId());
        if (parentAssetCategoryId != 0L && parentAssetCategoryId == assetCategory.getParentCategoryId()) {
            String path = this.getAssetCategoryPath(portletDataContext, parentAssetCategoryId);
            AssetCategory parentAssetCategory = (AssetCategory)portletDataContext.getZipEntryAsObject(path);
            Node parentCategoryNode = assetCategoryElement.getParent().selectSingleNode("./category[@path='" + path + "']");
            if (parentCategoryNode != null) {
                this.importAssetCategory(portletDataContext, assetVocabularyPKs, assetCategoryPKs, assetCategoryUuids, (Element)parentCategoryNode, parentAssetCategory);
                parentAssetCategoryId = MapUtil.getLong(assetCategoryPKs, (long)assetCategory.getParentCategoryId(), (long)assetCategory.getParentCategoryId());
            }
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setCreateDate(assetCategory.getCreateDate());
        serviceContext.setModifiedDate(assetCategory.getModifiedDate());
        serviceContext.setScopeGroupId(portletDataContext.getScopeGroupId());
        boolean global = GetterUtil.getBoolean((String)assetCategoryElement.attributeValue("global"));
        if (global) {
            Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)portletDataContext.getCompanyId());
            groupId = companyGroup.getGroupId();
        }
        AssetCategory importedAssetCategory = null;
        try {
            String name;
            if (parentAssetCategoryId != 0L) {
                AssetCategoryUtil.findByPrimaryKey((long)parentAssetCategoryId);
            }
            List propertyElements = assetCategoryElement.elements("property");
            String[] properties = new String[propertyElements.size()];
            int i2 = 0;
            while (i2 < propertyElements.size()) {
                Element propertyElement = (Element)propertyElements.get(i2);
                String key = propertyElement.attributeValue("key");
                String value = propertyElement.attributeValue("value");
                properties[i2] = key.concat(":").concat(value);
                ++i2;
            }
            AssetCategory existingAssetCategory = AssetCategoryUtil.fetchByUUID_G((String)assetCategory.getUuid(), (long)groupId);
            if (existingAssetCategory == null) {
                name = this.getAssetCategoryName(null, portletDataContext.getGroupId(), parentAssetCategoryId, assetCategory.getName(), 2);
                serviceContext.setUuid(assetCategory.getUuid());
                if (global) {
                    if (AssetPermission.contains(PermissionThreadLocal.getPermissionChecker(), groupId, "ADD_CATEGORY")) {
                        serviceContext.setScopeGroupId(groupId);
                    } else {
                        StringBundler sb = new StringBundler(6);
                        sb.append("Category ");
                        sb.append(assetCategory.getName());
                        sb.append(" could not be imported to the Global ");
                        sb.append("scope because the user does not have ");
                        sb.append("permissions. It will be imported into the ");
                        sb.append("current scope.");
                        _log.error((Object)sb.toString());
                    }
                }
                importedAssetCategory = AssetCategoryLocalServiceUtil.addCategory((long)userId, (long)parentAssetCategoryId, this.getAssetCategoryTitleMap(assetCategory, name), (Map)assetCategory.getDescriptionMap(), (long)assetVocabularyId, (String[])properties, (ServiceContext)serviceContext);
            } else {
                name = this.getAssetCategoryName(assetCategory.getUuid(), assetCategory.getGroupId(), parentAssetCategoryId, assetCategory.getName(), 2);
                boolean updateAssetCategory = true;
                if (global) {
                    PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
                    if (permissionChecker.hasPermission(groupId, AssetCategory.class.getName(), existingAssetCategory.getCategoryId(), "UPDATE")) {
                        serviceContext.setScopeGroupId(groupId);
                    } else {
                        updateAssetCategory = false;
                    }
                }
                if (updateAssetCategory) {
                    importedAssetCategory = AssetCategoryLocalServiceUtil.updateCategory((long)userId, (long)existingAssetCategory.getCategoryId(), (long)parentAssetCategoryId, this.getAssetCategoryTitleMap(assetCategory, name), (Map)assetCategory.getDescriptionMap(), (long)assetVocabularyId, (String[])properties, (ServiceContext)serviceContext);
                } else {
                    StringBundler sb = new StringBundler(4);
                    sb.append("Category ");
                    sb.append(existingAssetCategory.getName());
                    sb.append(" could not be updated in the Global scope ");
                    sb.append("because the user does not have permissions.");
                    _log.error((Object)sb.toString());
                }
            }
            assetCategoryPKs.put(assetCategory.getCategoryId(), importedAssetCategory.getCategoryId());
            assetCategoryUuids.put(assetCategory.getUuid(), importedAssetCategory.getUuid());
            portletDataContext.importPermissions(AssetCategory.class, assetCategory.getCategoryId(), importedAssetCategory.getCategoryId());
        }
        catch (NoSuchCategoryException noSuchCategoryException) {
            _log.error((Object)("Could not find the parent category for category " + assetCategory.getCategoryId()));
        }
    }

    protected void importAssetTag(PortletDataContext portletDataContext, Map<Long, Long> assetTagPKs, Element assetTagElement, AssetTag assetTag) throws PortalException, SystemException {
        AssetTag existingAssetTag;
        String[] properties;
        AssetTag importedAssetTag;
        ServiceContext serviceContext;
        long userId;
        block5: {
            userId = portletDataContext.getUserId(assetTag.getUserUuid());
            serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            serviceContext.setCreateDate(assetTag.getCreateDate());
            serviceContext.setModifiedDate(assetTag.getModifiedDate());
            serviceContext.setScopeGroupId(portletDataContext.getScopeGroupId());
            importedAssetTag = null;
            List propertyElements = assetTagElement.elements("property");
            properties = new String[propertyElements.size()];
            int i2 = 0;
            while (i2 < propertyElements.size()) {
                Element propertyElement = (Element)propertyElements.get(i2);
                String key = propertyElement.attributeValue("key");
                String value = propertyElement.attributeValue("value");
                properties[i2] = key.concat(":").concat(value);
                ++i2;
            }
            existingAssetTag = null;
            try {
                existingAssetTag = AssetTagUtil.findByG_N((long)portletDataContext.getScopeGroupId(), (String)assetTag.getName());
            }
            catch (NoSuchTagException noSuchTagException) {
                if (!_log.isDebugEnabled()) break block5;
                StringBundler sb = new StringBundler(5);
                sb.append("No AssetTag exists with the key {groupId=");
                sb.append(portletDataContext.getScopeGroupId());
                sb.append(", name=");
                sb.append(assetTag.getName());
                sb.append("}");
                _log.debug((Object)sb.toString());
            }
        }
        try {
            importedAssetTag = existingAssetTag == null ? AssetTagLocalServiceUtil.addTag((long)userId, (String)assetTag.getName(), (String[])properties, (ServiceContext)serviceContext) : AssetTagLocalServiceUtil.updateTag((long)userId, (long)existingAssetTag.getTagId(), (String)assetTag.getName(), (String[])properties, (ServiceContext)serviceContext);
            assetTagPKs.put(assetTag.getTagId(), importedAssetTag.getTagId());
            portletDataContext.importPermissions(AssetTag.class, assetTag.getTagId(), importedAssetTag.getTagId());
        }
        catch (NoSuchTagException noSuchTagException) {
            _log.error((Object)("Could not find the parent category for category " + assetTag.getTagId()));
        }
    }

    protected void importAssetVocabulary(PortletDataContext portletDataContext, Map<Long, Long> assetVocabularyPKs, Element assetVocabularyElement, AssetVocabulary assetVocabulary) throws Exception {
        long userId = portletDataContext.getUserId(assetVocabulary.getUserUuid());
        long groupId = portletDataContext.getScopeGroupId();
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setCreateDate(assetVocabulary.getCreateDate());
        serviceContext.setModifiedDate(assetVocabulary.getModifiedDate());
        serviceContext.setScopeGroupId(portletDataContext.getScopeGroupId());
        boolean global = GetterUtil.getBoolean((String)assetVocabularyElement.attributeValue("global"));
        if (global) {
            Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)portletDataContext.getCompanyId());
            groupId = companyGroup.getGroupId();
        }
        AssetVocabulary importedAssetVocabulary = null;
        AssetVocabulary existingAssetVocabulary = AssetVocabularyUtil.fetchByUUID_G((String)assetVocabulary.getUuid(), (long)groupId);
        if (existingAssetVocabulary == null) {
            String name = this.getAssetVocabularyName(null, groupId, assetVocabulary.getName(), 2);
            serviceContext.setUuid(assetVocabulary.getUuid());
            if (global) {
                if (AssetPermission.contains(PermissionThreadLocal.getPermissionChecker(), groupId, "ADD_VOCABULARY")) {
                    serviceContext.setScopeGroupId(groupId);
                } else {
                    StringBundler sb = new StringBundler(5);
                    sb.append("Vocabulary ");
                    sb.append(assetVocabulary.getName());
                    sb.append(" could not be imported to the Global scope ");
                    sb.append("because the user does not have permissions. ");
                    sb.append("It will be imported into the current scope.");
                    _log.error((Object)sb.toString());
                }
            }
            importedAssetVocabulary = AssetVocabularyLocalServiceUtil.addVocabulary((long)userId, (String)"", this.getAssetVocabularyTitleMap(assetVocabulary, name), (Map)assetVocabulary.getDescriptionMap(), (String)assetVocabulary.getSettings(), (ServiceContext)serviceContext);
        } else {
            String name = this.getAssetVocabularyName(assetVocabulary.getUuid(), groupId, assetVocabulary.getName(), 2);
            boolean updateVocabulary = true;
            if (global) {
                PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
                if (permissionChecker.hasPermission(groupId, AssetVocabulary.class.getName(), existingAssetVocabulary.getVocabularyId(), "UPDATE")) {
                    serviceContext.setScopeGroupId(groupId);
                } else {
                    updateVocabulary = false;
                }
            }
            if (updateVocabulary) {
                importedAssetVocabulary = AssetVocabularyLocalServiceUtil.updateVocabulary((long)existingAssetVocabulary.getVocabularyId(), (String)"", this.getAssetVocabularyTitleMap(assetVocabulary, name), (Map)assetVocabulary.getDescriptionMap(), (String)assetVocabulary.getSettings(), (ServiceContext)serviceContext);
            } else {
                StringBundler sb = new StringBundler(4);
                sb.append("Vocabulary ");
                sb.append(existingAssetVocabulary.getName());
                sb.append(" could not be updated in the Global scope because ");
                sb.append("the user does not have permissions.");
                _log.error((Object)sb.toString());
            }
        }
        assetVocabularyPKs.put(assetVocabulary.getVocabularyId(), importedAssetVocabulary.getVocabularyId());
        portletDataContext.importPermissions(AssetVocabulary.class, assetVocabulary.getVocabularyId(), importedAssetVocabulary.getVocabularyId());
    }

    protected void importPortletData(PortletDataContext portletDataContext, String portletId, long plid, Element portletDataElement) throws Exception {
        String xml;
        long ownerId = 0L;
        int ownerType = 3;
        com.liferay.portal.model.PortletPreferences portletPreferences = PortletPreferencesUtil.fetchByO_O_P_P((long)ownerId, (int)ownerType, (long)plid, (String)portletId);
        if (portletPreferences == null) {
            portletPreferences = new PortletPreferencesImpl();
        }
        if ((xml = this.importPortletData(portletDataContext, portletId, portletPreferences, portletDataElement)) != null) {
            PortletPreferencesLocalServiceUtil.updatePreferences((long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        }
    }

    protected String importPortletData(PortletDataContext portletDataContext, String portletId, com.liferay.portal.model.PortletPreferences portletPreferences, Element portletDataElement) throws Exception {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)portletDataContext.getCompanyId(), (String)portletId);
        if (portlet == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not import portlet data for " + portletId + " because the portlet does not exist"));
            }
            return null;
        }
        PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
        if (portletDataHandler == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not import portlet data for " + portletId + " because the portlet does not have a " + "PortletDataHandler"));
            }
            return null;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Importing data for " + portletId));
        }
        com.liferay.portlet.PortletPreferencesImpl portletPreferencesImpl = null;
        if (portletPreferences != null) {
            portletPreferencesImpl = (com.liferay.portlet.PortletPreferencesImpl)PortletPreferencesFactoryUtil.fromDefaultXML((String)portletPreferences.getPreferences());
        }
        String portletData = portletDataContext.getZipEntryAsString(portletDataElement.attributeValue("path"));
        portletPreferencesImpl = (com.liferay.portlet.PortletPreferencesImpl)portletDataHandler.importData(portletDataContext, portletId, (PortletPreferences)portletPreferencesImpl, portletData);
        if (portletPreferencesImpl == null) {
            return null;
        }
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferencesImpl);
    }

    protected void importPortletPreferences(PortletDataContext portletDataContext, long companyId, long groupId, Layout layout, String portletId, Element parentElement, boolean importPortletSetup, boolean importPortletArchivedSetups, boolean importPortletUserPreferences, boolean preserveScopeLayoutId, boolean importPortletData) throws Exception {
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
        long plid = 0L;
        String scopeType = "";
        String scopeLayoutUuid = "";
        if (layout != null) {
            plid = layout.getPlid();
            if (preserveScopeLayoutId && portletId != null) {
                PortletPreferences jxPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
                scopeType = GetterUtil.getString((String)jxPreferences.getValue("lfrScopeType", null));
                scopeLayoutUuid = GetterUtil.getString((String)jxPreferences.getValue("lfrScopeLayoutUuid", null));
                portletDataContext.setScopeType(scopeType);
                portletDataContext.setScopeLayoutUuid(scopeLayoutUuid);
            }
        }
        List portletPreferencesElements = parentElement.elements("portlet-preferences");
        for (Element portletPreferencesElement : portletPreferencesElements) {
            String rootPotletId;
            String userUuid;
            String path = portletPreferencesElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            String xml = null;
            Element element = null;
            try {
                xml = portletDataContext.getZipEntryAsString(path);
                Document preferencesDocument = SAXReaderUtil.read((String)xml);
                element = preferencesDocument.getRootElement();
            }
            catch (DocumentException de) {
                throw new SystemException((Throwable)de);
            }
            long ownerId = GetterUtil.getLong((String)element.attributeValue("owner-id"));
            int ownerType = GetterUtil.getInteger((String)element.attributeValue("owner-type"));
            if (ownerType == 1 || (ownerType == 2 || ownerType == 3) && !importPortletSetup || ownerType == 5 && !importPortletArchivedSetups || ownerType == 4 && ownerId != 0L && !importPortletUserPreferences) continue;
            if (ownerType == 2) {
                plid = 0L;
                ownerId = portletDataContext.getScopeGroupId();
            }
            boolean defaultUser = GetterUtil.getBoolean((String)element.attributeValue("default-user"));
            if (portletId == null) {
                portletId = element.attributeValue("portlet-id");
            }
            if (ownerType == 5) {
                portletId = PortletConstants.getRootPortletId((String)portletId);
                userUuid = element.attributeValue("archive-user-uuid");
                String name = element.attributeValue("archive-name");
                long userId = portletDataContext.getUserId(userUuid);
                PortletItem portletItem = PortletItemLocalServiceUtil.updatePortletItem((long)userId, (long)groupId, (String)name, (String)portletId, (String)com.liferay.portal.model.PortletPreferences.class.getName());
                plid = 0L;
                ownerId = portletItem.getPortletItemId();
            } else if (ownerType == 4) {
                userUuid = element.attributeValue("user-uuid");
                ownerId = portletDataContext.getUserId(userUuid);
            }
            if (defaultUser) {
                ownerId = defaultUserId;
            }
            if ((rootPotletId = PortletConstants.getRootPortletId((String)portletId)).equals("101")) {
                xml = this.updateAssetPublisherPortletPreferences(portletDataContext, companyId, ownerId, ownerType, plid, portletId, xml);
            }
            this.updatePortletPreferences(portletDataContext, ownerId, ownerType, plid, portletId, xml, importPortletData);
        }
        if (preserveScopeLayoutId && layout != null) {
            PortletPreferences jxPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
            try {
                jxPreferences.setValue("lfrScopeType", scopeType);
                jxPreferences.setValue("lfrScopeLayoutUuid", scopeLayoutUuid);
                jxPreferences.store();
            }
            finally {
                portletDataContext.setScopeType(scopeType);
                portletDataContext.setScopeLayoutUuid(scopeLayoutUuid);
            }
        }
    }

    protected void readAssetCategories(PortletDataContext portletDataContext) throws Exception {
        String xml = portletDataContext.getZipEntryAsString(String.valueOf(portletDataContext.getSourceRootPath()) + "/categories-hierarchy.xml");
        if (xml == null) {
            return;
        }
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        Element assetVocabulariesElement = rootElement.element("vocabularies");
        List assetVocabularyElements = assetVocabulariesElement.elements("vocabulary");
        Map assetVocabularyPKs = portletDataContext.getNewPrimaryKeysMap(AssetVocabulary.class);
        for (Element assetVocabularyElement : assetVocabularyElements) {
            String path = assetVocabularyElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            AssetVocabulary assetVocabulary = (AssetVocabulary)portletDataContext.getZipEntryAsObject(path);
            this.importAssetVocabulary(portletDataContext, assetVocabularyPKs, assetVocabularyElement, assetVocabulary);
        }
        Element assetCategoriesElement = rootElement.element("categories");
        List assetCategoryElements = assetCategoriesElement.elements("category");
        Map assetCategoryPKs = portletDataContext.getNewPrimaryKeysMap(AssetCategory.class);
        Map assetCategoryUuids = portletDataContext.getNewPrimaryKeysMap(String.valueOf(AssetCategory.class.getName()) + "uuid");
        for (Element assetCategoryElement : assetCategoryElements) {
            String path = assetCategoryElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            AssetCategory assetCategory = (AssetCategory)portletDataContext.getZipEntryAsObject(path);
            this.importAssetCategory(portletDataContext, assetVocabularyPKs, assetCategoryPKs, assetCategoryUuids, assetCategoryElement, assetCategory);
        }
        Element assetsElement = rootElement.element("assets");
        List assetElements = assetsElement.elements("asset");
        for (Element assetElement : assetElements) {
            String className = GetterUtil.getString((String)assetElement.attributeValue("class-name"));
            long classPK = GetterUtil.getLong((String)assetElement.attributeValue("class-pk"));
            String[] assetCategoryUuidArray = StringUtil.split((String)GetterUtil.getString((String)assetElement.attributeValue("category-uuids")));
            long[] assetCategoryIds = new long[]{};
            String[] stringArray = assetCategoryUuidArray;
            int n = assetCategoryUuidArray.length;
            int n2 = 0;
            while (n2 < n) {
                String assetCategoryUuid = stringArray[n2];
                AssetCategory assetCategory = AssetCategoryUtil.fetchByUUID_G((String)(assetCategoryUuid = MapUtil.getString((Map)assetCategoryUuids, (String)assetCategoryUuid, (String)assetCategoryUuid)), (long)portletDataContext.getScopeGroupId());
                if (assetCategory == null) {
                    Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)portletDataContext.getCompanyId());
                    assetCategory = AssetCategoryUtil.fetchByUUID_G((String)assetCategoryUuid, (long)companyGroup.getGroupId());
                }
                if (assetCategory != null) {
                    assetCategoryIds = ArrayUtil.append((long[])assetCategoryIds, (long)assetCategory.getCategoryId());
                }
                ++n2;
            }
            portletDataContext.addAssetCategories(className, classPK, assetCategoryIds);
        }
    }

    protected void readAssetLinks(PortletDataContext portletDataContext) throws Exception {
        String xml = portletDataContext.getZipEntryAsString(String.valueOf(portletDataContext.getSourceRootPath()) + "/links.xml");
        if (xml == null) {
            return;
        }
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        List assetLinkElements = rootElement.elements("asset-link");
        for (Element assetLinkElement : assetLinkElements) {
            String sourceUuid = GetterUtil.getString((String)assetLinkElement.attributeValue("source-uuid"));
            String[] assetEntryUuidArray = StringUtil.split((String)GetterUtil.getString((String)assetLinkElement.attributeValue("target-uuids")));
            int assetLinkType = GetterUtil.getInteger((String)assetLinkElement.attributeValue("type"));
            ArrayList<Long> assetEntryIds = new ArrayList<Long>();
            String[] stringArray = assetEntryUuidArray;
            int n = assetEntryUuidArray.length;
            int n2 = 0;
            while (n2 < n) {
                String assetEntryUuid = stringArray[n2];
                try {
                    AssetEntry assetEntry = AssetEntryLocalServiceUtil.getEntry((long)portletDataContext.getScopeGroupId(), (String)assetEntryUuid);
                    assetEntryIds.add(assetEntry.getEntryId());
                }
                catch (NoSuchEntryException noSuchEntryException) {}
                ++n2;
            }
            if (assetEntryIds.isEmpty()) continue;
            long[] assetEntryIdsArray = ArrayUtil.toArray((Long[])assetEntryIds.toArray(new Long[assetEntryIds.size()]));
            try {
                AssetEntry assetEntry = AssetEntryLocalServiceUtil.getEntry((long)portletDataContext.getScopeGroupId(), (String)sourceUuid);
                AssetLinkLocalServiceUtil.updateLinks((long)assetEntry.getUserId(), (long)assetEntry.getEntryId(), (long[])assetEntryIdsArray, (int)assetLinkType);
            }
            catch (NoSuchEntryException noSuchEntryException) {}
        }
    }

    protected void readAssetTags(PortletDataContext portletDataContext) throws Exception {
        String xml = portletDataContext.getZipEntryAsString(String.valueOf(portletDataContext.getSourceRootPath()) + "/tags.xml");
        if (xml == null) {
            return;
        }
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        List assetTagElements = rootElement.elements("tag");
        for (Element assetTagElement : assetTagElements) {
            String path = assetTagElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            AssetTag assetTag = (AssetTag)portletDataContext.getZipEntryAsObject(path);
            Map assetTagPKs = portletDataContext.getNewPrimaryKeysMap(AssetTag.class);
            this.importAssetTag(portletDataContext, assetTagPKs, assetTagElement, assetTag);
        }
        List assetElements = rootElement.elements("asset");
        for (Element assetElement : assetElements) {
            String className = GetterUtil.getString((String)assetElement.attributeValue("class-name"));
            long classPK = GetterUtil.getLong((String)assetElement.attributeValue("class-pk"));
            String assetTagNames = GetterUtil.getString((String)assetElement.attributeValue("tags"));
            portletDataContext.addAssetTags(className, classPK, StringUtil.split((String)assetTagNames));
        }
    }

    protected void readComments(PortletDataContext portletDataContext) throws Exception {
        String xml = portletDataContext.getZipEntryAsString(String.valueOf(portletDataContext.getSourceRootPath()) + "/comments.xml");
        if (xml == null) {
            return;
        }
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        List assetElements = rootElement.elements("asset");
        for (Element assetElement : assetElements) {
            String path = assetElement.attributeValue("path");
            String className = assetElement.attributeValue("class-name");
            long classPK = GetterUtil.getLong((String)assetElement.attributeValue("class-pk"));
            List zipFolderEntries = portletDataContext.getZipFolderEntries(path);
            ArrayList<MBMessage> mbMessages = new ArrayList<MBMessage>();
            for (String zipFolderEntry : zipFolderEntries) {
                MBMessage mbMessage = (MBMessage)portletDataContext.getZipEntryAsObject(zipFolderEntry);
                if (mbMessage == null) continue;
                mbMessages.add(mbMessage);
            }
            portletDataContext.addComments(className, classPK, mbMessages);
        }
    }

    protected void readExpandoTables(PortletDataContext portletDataContext) throws Exception {
        String xml = portletDataContext.getZipEntryAsString(String.valueOf(portletDataContext.getSourceRootPath()) + "/expando-tables.xml");
        if (xml == null) {
            return;
        }
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        List expandoTableElements = rootElement.elements("expando-table");
        for (Element expandoTableElement : expandoTableElements) {
            String className = expandoTableElement.attributeValue("class-name");
            ExpandoTable expandoTable = null;
            try {
                expandoTable = ExpandoTableLocalServiceUtil.getDefaultTable((long)portletDataContext.getCompanyId(), (String)className);
            }
            catch (NoSuchTableException noSuchTableException) {
                expandoTable = ExpandoTableLocalServiceUtil.addDefaultTable((long)portletDataContext.getCompanyId(), (String)className);
            }
            List expandoColumnElements = expandoTableElement.elements("expando-column");
            for (Element expandoColumnElement : expandoColumnElements) {
                long columnId = GetterUtil.getLong((String)expandoColumnElement.attributeValue("column-id"));
                String name = expandoColumnElement.attributeValue("name");
                int type = GetterUtil.getInteger((String)expandoColumnElement.attributeValue("type"));
                String defaultData = expandoColumnElement.elementText("default-data");
                String typeSettings = expandoColumnElement.elementText("type-settings");
                Serializable defaultDataObject = ExpandoConverterUtil.getAttributeFromString(type, defaultData);
                ExpandoColumn expandoColumn = ExpandoColumnLocalServiceUtil.getColumn((long)expandoTable.getTableId(), (String)name);
                if (expandoColumn != null) {
                    ExpandoColumnLocalServiceUtil.updateColumn((long)expandoColumn.getColumnId(), (String)name, (int)type, (Object)defaultDataObject);
                } else {
                    expandoColumn = ExpandoColumnLocalServiceUtil.addColumn((long)expandoTable.getTableId(), (String)name, (int)type, (Object)defaultDataObject);
                }
                ExpandoColumnLocalServiceUtil.updateTypeSettings((long)expandoColumn.getColumnId(), (String)typeSettings);
                portletDataContext.importPermissions(ExpandoColumn.class, columnId, expandoColumn.getColumnId());
            }
        }
    }

    protected void readLocks(PortletDataContext portletDataContext) throws Exception {
        String xml = portletDataContext.getZipEntryAsString(String.valueOf(portletDataContext.getSourceRootPath()) + "/locks.xml");
        if (xml == null) {
            return;
        }
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        List assetElements = rootElement.elements("asset");
        for (Element assetElement : assetElements) {
            String path = assetElement.attributeValue("path");
            String className = assetElement.attributeValue("class-name");
            String key = assetElement.attributeValue("key");
            Lock lock = (Lock)portletDataContext.getZipEntryAsObject(path);
            if (lock == null) continue;
            portletDataContext.addLocks(className, key, lock);
        }
    }

    protected void readRatingsEntries(PortletDataContext portletDataContext) throws Exception {
        String xml = portletDataContext.getZipEntryAsString(String.valueOf(portletDataContext.getSourceRootPath()) + "/ratings.xml");
        if (xml == null) {
            return;
        }
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        List assetElements = rootElement.elements("asset");
        for (Element assetElement : assetElements) {
            String path = assetElement.attributeValue("path");
            String className = assetElement.attributeValue("class-name");
            long classPK = GetterUtil.getLong((String)assetElement.attributeValue("class-pk"));
            List zipFolderEntries = portletDataContext.getZipFolderEntries(path);
            ArrayList<RatingsEntry> ratingsEntries = new ArrayList<RatingsEntry>();
            for (String zipFolderEntry : zipFolderEntries) {
                RatingsEntry ratingsEntry = (RatingsEntry)portletDataContext.getZipEntryAsObject(zipFolderEntry);
                if (ratingsEntry == null) continue;
                ratingsEntries.add(ratingsEntry);
            }
            portletDataContext.addRatingsEntries(className, classPK, ratingsEntries);
        }
    }

    protected void resetPortletScope(PortletDataContext portletDataContext, long groupId) {
        portletDataContext.setScopeGroupId(groupId);
        portletDataContext.setScopeLayoutUuid("");
        portletDataContext.setScopeType("");
    }

    protected void setPortletScope(PortletDataContext portletDataContext, Element portletElement) {
        block9: {
            String scopeLayoutUuid = GetterUtil.getString((String)portletElement.attributeValue("scope-layout-uuid"));
            String scopeLayoutType = GetterUtil.getString((String)portletElement.attributeValue("scope-layout-type"));
            portletDataContext.setScopeLayoutUuid(scopeLayoutUuid);
            portletDataContext.setScopeType(scopeLayoutType);
            try {
                Group scopeGroup;
                block10: {
                    scopeGroup = null;
                    if (scopeLayoutType.equals("company")) {
                        scopeGroup = GroupLocalServiceUtil.getCompanyGroup((long)portletDataContext.getCompanyId());
                        break block9;
                    }
                    if (!Validator.isNotNull((String)scopeLayoutUuid)) break block9;
                    Layout scopeLayout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)scopeLayoutUuid, (long)portletDataContext.getGroupId());
                    if (scopeLayout.hasScopeGroup()) {
                        scopeGroup = scopeLayout.getScopeGroup();
                    } else {
                        String name = String.valueOf(scopeLayout.getPlid());
                        scopeGroup = GroupLocalServiceUtil.addGroup((long)portletDataContext.getUserId(null), (String)Layout.class.getName(), (long)scopeLayout.getPlid(), (String)name, null, (int)0, null, (boolean)false, (boolean)true, null);
                    }
                    Group group = scopeLayout.getGroup();
                    if (group.isStaged() && !group.isStagedRemotely()) {
                        try {
                            Layout oldLayout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)scopeLayoutUuid, (long)portletDataContext.getSourceGroupId());
                            Group oldScopeGroup = oldLayout.getScopeGroup();
                            oldScopeGroup.setLiveGroupId(scopeGroup.getGroupId());
                            GroupLocalServiceUtil.updateGroup((Group)oldScopeGroup, (boolean)true);
                        }
                        catch (NoSuchLayoutException nsle) {
                            if (!_log.isWarnEnabled()) break block10;
                            _log.warn((Throwable)nsle);
                        }
                    }
                }
                portletDataContext.setScopeGroupId(scopeGroup.getGroupId());
            }
            catch (PortalException portalException) {
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        }
    }

    protected void updateAssetPublisherClassPKs(PortletDataContext portletDataContext, PortletPreferences jxPreferences, String key, Class<?> clazz, long companyGroupId) throws Exception {
        String[] oldValues = jxPreferences.getValues(key, null);
        if (oldValues == null) {
            return;
        }
        Map primaryKeysMap = portletDataContext.getNewPrimaryKeysMap(clazz);
        String[] newValues = new String[oldValues.length];
        int i2 = 0;
        while (i2 < oldValues.length) {
            String[] uuids;
            String oldValue;
            String newValue = oldValue = oldValues[i2];
            String[] stringArray = uuids = StringUtil.split((String)oldValue);
            int n = uuids.length;
            int n2 = 0;
            while (n2 < n) {
                String uuid = stringArray[n2];
                Long newPrimaryKey = null;
                if (Validator.isNumber((String)uuid)) {
                    long oldPrimaryKey = GetterUtil.getLong((String)uuid);
                    newPrimaryKey = MapUtil.getLong((Map)primaryKeysMap, (long)oldPrimaryKey, (long)oldPrimaryKey);
                } else {
                    String className = clazz.getName();
                    if (className.equals(AssetCategory.class.getName())) {
                        AssetCategory category = AssetCategoryUtil.fetchByUUID_G((String)uuid, (long)portletDataContext.getScopeGroupId());
                        if (category == null) {
                            category = AssetCategoryUtil.fetchByUUID_G((String)uuid, (long)companyGroupId);
                        }
                        if (category != null) {
                            newPrimaryKey = category.getCategoryId();
                        }
                    } else if (className.equals(JournalStructure.class.getName())) {
                        JournalStructure structure = JournalStructureUtil.fetchByUUID_G((String)uuid, (long)portletDataContext.getScopeGroupId());
                        if (structure == null) {
                            structure = JournalStructureUtil.fetchByUUID_G((String)uuid, (long)companyGroupId);
                        }
                        if (structure != null) {
                            newPrimaryKey = structure.getId();
                        }
                    }
                }
                if (Validator.isNull((Long)newPrimaryKey)) {
                    if (_log.isWarnEnabled()) {
                        StringBundler sb = new StringBundler(8);
                        sb.append("Unable to get primary key for ");
                        sb.append(clazz);
                        sb.append(" with UUID ");
                        sb.append(uuid);
                        sb.append(" in company group ");
                        sb.append(companyGroupId);
                        sb.append(" or in group ");
                        sb.append(portletDataContext.getScopeGroupId());
                        _log.warn((Object)sb.toString());
                    }
                } else {
                    newValue = StringUtil.replace((String)newValue, (String)uuid, (String)newPrimaryKey.toString());
                }
                ++n2;
            }
            newValues[i2] = newValue;
            ++i2;
        }
        jxPreferences.setValues(key, newValues);
    }

    protected void updateAssetPublisherGlobalScopeId(PortletPreferences jxPreferences, String key, long groupId) throws Exception {
        String[] oldValues = jxPreferences.getValues(key, null);
        if (oldValues == null) {
            return;
        }
        String newValue = "Group_" + groupId;
        String[] newValues = new String[oldValues.length];
        int i2 = 0;
        while (i2 < oldValues.length) {
            String oldValue = oldValues[i2];
            newValues[i2] = StringUtil.replace((String)oldValue, (String)"Group_Company", (String)newValue);
            ++i2;
        }
        jxPreferences.setValues(key, newValues);
    }

    protected String updateAssetPublisherPortletPreferences(PortletDataContext portletDataContext, long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws Exception {
        Company company = CompanyLocalServiceUtil.getCompanyById((long)companyId);
        Group companyGroup = company.getGroup();
        PortletPreferences jxPreferences = PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        Enumeration enu = jxPreferences.getNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            String value = GetterUtil.getString((String)jxPreferences.getValue(name, null));
            String prefix = "queryName";
            if (value.equalsIgnoreCase("assetCategories") && name.startsWith(prefix)) {
                String index = name.substring(prefix.length(), name.length());
                this.updateAssetPublisherClassPKs(portletDataContext, jxPreferences, "queryValues" + index, AssetCategory.class, companyGroup.getGroupId());
                continue;
            }
            if (name.equals("anyClassTypeJournalArticleAssetRendererFactory") || name.equals("classTypeIdsJournalArticleAssetRendererFactory") || name.equals("classTypeIds")) {
                this.updateAssetPublisherClassPKs(portletDataContext, jxPreferences, name, JournalStructure.class, companyGroup.getGroupId());
                continue;
            }
            if (!name.equals("defaultScope") && !name.equals("scopeIds")) continue;
            this.updateAssetPublisherGlobalScopeId(jxPreferences, name, companyGroup.getGroupId());
        }
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)jxPreferences);
    }

    protected void updatePortletPreferences(PortletDataContext portletDataContext, long ownerId, int ownerType, long plid, String portletId, String xml, boolean importData) throws Exception {
        if (importData) {
            PortletPreferencesLocalServiceUtil.updatePreferences((long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        } else {
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)portletDataContext.getCompanyId(), (String)portletId);
            if (portlet == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Do not update portlet preferences for " + portletId + " because the portlet does not exist"));
                }
                return;
            }
            PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
            if (portletDataHandler == null) {
                PortletPreferencesLocalServiceUtil.updatePreferences((long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
                return;
            }
            Object[] dataPortletPreferences = portletDataHandler.getDataPortletPreferences();
            PortletPreferences portletPreferences = PortletPreferencesLocalServiceUtil.getPreferences((long)portletDataContext.getCompanyId(), (long)ownerId, (int)ownerType, (long)plid, (String)portletId);
            PortletPreferences jxPreferences = PortletPreferencesFactoryUtil.fromXML((long)portletDataContext.getCompanyId(), (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
            Enumeration enu = jxPreferences.getNames();
            while (enu.hasMoreElements()) {
                String name = (String)enu.nextElement();
                if (ArrayUtil.contains((Object[])dataPortletPreferences, (Object)name)) continue;
                String value = GetterUtil.getString((String)jxPreferences.getValue(name, null));
                portletPreferences.setValue(name, value);
            }
            PortletPreferencesLocalServiceUtil.updatePreferences((long)ownerId, (int)ownerType, (long)plid, (String)portletId, (PortletPreferences)portletPreferences);
        }
    }
}

