/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.microsofttranslator;

import com.liferay.portal.kernel.microsofttranslator.MicrosoftTranslator;
import com.liferay.portal.kernel.microsofttranslator.MicrosoftTranslatorException;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.microsofttranslator.MicrosoftTranslatorAuthenticator;

public class MicrosoftTranslatorImpl
implements MicrosoftTranslator {
    private MicrosoftTranslatorAuthenticator _microsoftTranslatorAuthenticator;

    public MicrosoftTranslatorImpl() {
        this._microsoftTranslatorAuthenticator = new MicrosoftTranslatorAuthenticator();
    }

    public MicrosoftTranslatorImpl(String clientId, String clientSecret) {
        this._microsoftTranslatorAuthenticator = new MicrosoftTranslatorAuthenticator(clientId, clientSecret);
    }

    public MicrosoftTranslatorAuthenticator getMicrosoftTranslatorAuthenticator() {
        return this._microsoftTranslatorAuthenticator;
    }

    public String translate(String fromLanguage, String toLanguage, String fromText) throws MicrosoftTranslatorException {
        try {
            return this.doTranslate(fromLanguage, toLanguage, fromText);
        }
        catch (MicrosoftTranslatorException mte) {
            throw mte;
        }
        catch (Exception e2) {
            throw new MicrosoftTranslatorException((Throwable)e2);
        }
    }

    protected String doTranslate(String fromLanguage, String toLanguage, String fromText) throws Exception {
        fromLanguage = this.getMicrosoftLanguageCode(fromLanguage);
        toLanguage = this.getMicrosoftLanguageCode(toLanguage);
        Http.Options options = new Http.Options();
        StringBundler sb = new StringBundler(7);
        sb.append("http://api.microsofttranslator.com/v2/Http.svc/Translate?");
        sb.append("text=");
        sb.append(HttpUtil.encodeURL((String)fromText));
        sb.append("&from=");
        sb.append(fromLanguage);
        sb.append("&to=");
        sb.append(toLanguage);
        options.setLocation(sb.toString());
        String accessToken = this._microsoftTranslatorAuthenticator.getAccessToken();
        if (Validator.isNull((String)accessToken)) {
            throw new MicrosoftTranslatorException(this._microsoftTranslatorAuthenticator.getError());
        }
        options.addHeader("Authorization", "Bearer " + accessToken);
        String text = HttpUtil.URLtoString((Http.Options)options);
        int x = text.indexOf(">") + 1;
        int y = text.indexOf("</string>", x);
        if (x == -1 || y == -1) {
            x = text.indexOf("Message: ");
            y = text.indexOf("<", x);
            if (x > -1 && y > -1) {
                text = text.substring(x, y);
            }
            throw new MicrosoftTranslatorException(text);
        }
        String toText = text.substring(x, y);
        toText = toText.trim();
        return StringUtil.replace((String)toText, (char)'\n', (char)' ');
    }

    protected String getMicrosoftLanguageCode(String languageId) {
        if (languageId.equals("pt_BR") || languageId.equals("pt_PT")) {
            return "pt";
        }
        if (languageId.equals("hi_IN")) {
            return "hi";
        }
        if (languageId.equals("zh_CN")) {
            return "zh-CHS";
        }
        if (languageId.equals("zh_TW")) {
            return "zh-CHT";
        }
        return languageId;
    }
}

