/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.mobile.device.rulegroup;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mobile.device.rulegroup.RuleGroupProcessor;
import com.liferay.portal.kernel.mobile.device.rulegroup.rule.RuleHandler;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.mobiledevicerules.model.MDRRule;
import com.liferay.portlet.mobiledevicerules.model.MDRRuleGroup;
import com.liferay.portlet.mobiledevicerules.model.MDRRuleGroupInstance;
import com.liferay.portlet.mobiledevicerules.service.MDRRuleGroupInstanceLocalService;
import com.liferay.portlet.mobiledevicerules.service.MDRRuleGroupLocalService;
import com.liferay.portlet.mobiledevicerules.util.RuleGroupInstancePriorityComparator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRuleGroupProcessorImpl
implements RuleGroupProcessor {
    private static Log _log = LogFactoryUtil.getLog(DefaultRuleGroupProcessorImpl.class);
    @BeanReference(type=MDRRuleGroupInstanceLocalService.class)
    private MDRRuleGroupInstanceLocalService _mdrRuleGroupInstanceLocalService;
    @BeanReference(type=MDRRuleGroupLocalService.class)
    private MDRRuleGroupLocalService _mdrRuleGroupLocalService;
    private Map<String, RuleHandler> _ruleHandlers = new HashMap<String, RuleHandler>();

    public MDRRuleGroupInstance evaluateRuleGroups(ThemeDisplay themeDisplay) throws SystemException {
        Layout layout = themeDisplay.getLayout();
        MDRRuleGroupInstance mdrRuleGroupInstance = this.evaluateRuleGroupInstances(Layout.class.getName(), layout.getPlid(), themeDisplay);
        if (mdrRuleGroupInstance != null) {
            return mdrRuleGroupInstance;
        }
        LayoutSet layoutSet = themeDisplay.getLayoutSet();
        mdrRuleGroupInstance = this.evaluateRuleGroupInstances(LayoutSet.class.getName(), layoutSet.getLayoutSetId(), themeDisplay);
        return mdrRuleGroupInstance;
    }

    public RuleHandler getRuleHandler(String ruleType) {
        return this._ruleHandlers.get(ruleType);
    }

    public Collection<RuleHandler> getRuleHandlers() {
        return Collections.unmodifiableCollection(this._ruleHandlers.values());
    }

    public Collection<String> getRuleHandlerTypes() {
        return this._ruleHandlers.keySet();
    }

    public void registerRuleHandler(RuleHandler ruleHandler) {
        RuleHandler oldRuleHandler = this._ruleHandlers.put(ruleHandler.getType(), ruleHandler);
        if (oldRuleHandler != null && _log.isWarnEnabled()) {
            _log.warn((Object)("Replacing existing rule handler type " + ruleHandler.getType()));
        }
    }

    public void setMDRRuleGroupInstanceLocalService(MDRRuleGroupInstanceLocalService mdrRuleGroupInstanceLocalService) {
        this._mdrRuleGroupInstanceLocalService = mdrRuleGroupInstanceLocalService;
    }

    public void setMDRRuleGroupLocalService(MDRRuleGroupLocalService mdrRuleGroupLocalService) {
        this._mdrRuleGroupLocalService = mdrRuleGroupLocalService;
    }

    public void setRuleHandlers(Collection<RuleHandler> ruleHandlers) {
        for (RuleHandler ruleHandler : ruleHandlers) {
            this.registerRuleHandler(ruleHandler);
        }
    }

    public RuleHandler unregisterRuleHandler(String ruleType) {
        return this._ruleHandlers.remove(ruleType);
    }

    protected boolean evaluateRule(MDRRule rule, ThemeDisplay themeDisplay) {
        RuleHandler ruleHandler = this._ruleHandlers.get(rule.getType());
        if (ruleHandler != null) {
            return ruleHandler.evaluateRule(rule, themeDisplay);
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)("No rule handler registered for type " + rule.getType()));
        }
        return false;
    }

    protected MDRRuleGroupInstance evaluateRuleGroupInstances(String className, long classPK, ThemeDisplay themeDisplay) throws SystemException {
        List mdrRuleGroupInstances = this._mdrRuleGroupInstanceLocalService.getRuleGroupInstances(className, classPK, -1, -1, (OrderByComparator)new RuleGroupInstancePriorityComparator());
        for (MDRRuleGroupInstance mdrRuleGroupInstance : mdrRuleGroupInstances) {
            MDRRuleGroup mdrRuleGroup = this._mdrRuleGroupLocalService.fetchRuleGroup(mdrRuleGroupInstance.getRuleGroupId());
            if (mdrRuleGroup == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Rule group instance " + mdrRuleGroupInstance.getRuleGroupInstanceId() + " has invalid rule group"));
                continue;
            }
            List mdrRules = mdrRuleGroup.getRules();
            for (MDRRule mdrRule : mdrRules) {
                if (!this.evaluateRule(mdrRule, themeDisplay)) continue;
                return mdrRuleGroupInstance;
            }
        }
        return null;
    }
}

