/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.mobile.device.rulegroup.action.impl;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.mobile.device.rulegroup.action.ActionHandler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.ColorScheme;
import com.liferay.portal.model.Theme;
import com.liferay.portal.model.impl.ColorSchemeImpl;
import com.liferay.portal.service.ThemeLocalService;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.mobiledevicerules.model.MDRAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThemeModificationActionHandler
implements ActionHandler {
    private static Collection<String> _propertyNames = new ArrayList<String>(2);
    @BeanReference(type=ThemeLocalService.class)
    private ThemeLocalService _themeLocalService;

    static {
        _propertyNames.add("colorSchemeId");
        _propertyNames.add("themeId");
        _propertyNames = Collections.unmodifiableCollection(_propertyNames);
    }

    public static String getHandlerType() {
        return ThemeModificationActionHandler.class.getName();
    }

    public void applyAction(MDRAction mdrAction, HttpServletRequest request, HttpServletResponse response) {
        UnicodeProperties typeSettingsProperties;
        String themeId;
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        Theme theme = this._themeLocalService.fetchTheme(companyId, themeId = GetterUtil.getString((String)(typeSettingsProperties = mdrAction.getTypeSettingsProperties()).getProperty("themeId")));
        if (theme == null) {
            return;
        }
        request.setAttribute("THEME", (Object)theme);
        String colorSchemeId = GetterUtil.getString((String)typeSettingsProperties.getProperty("colorSchemeId"));
        ColorScheme colorScheme = this._themeLocalService.fetchColorScheme(companyId, themeId, colorSchemeId);
        if (colorScheme == null) {
            colorScheme = ColorSchemeImpl.getNullColorScheme();
        }
        request.setAttribute("COLOR_SCHEME", (Object)colorScheme);
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        themeDisplay.setLookAndFeel(theme, colorScheme);
    }

    public Collection<String> getPropertyNames() {
        return _propertyNames;
    }

    public String getType() {
        return ThemeModificationActionHandler.getHandlerType();
    }

    public void setThemeLocalService(ThemeLocalService themeLocalService) {
        this._themeLocalService = themeLocalService;
    }
}

