/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.BaseModelListener;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutRevision;
import com.liferay.portal.model.PortletPreferences;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.persistence.LayoutRevisionUtil;
import com.liferay.portal.service.persistence.LayoutUtil;
import com.liferay.portal.servlet.filters.cache.CacheUtil;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletPreferencesListener
extends BaseModelListener<PortletPreferences> {
    private static Log _log = LogFactoryUtil.getLog(PortletPreferencesListener.class);

    public void onAfterRemove(PortletPreferences portletPreferences) {
        this.clearCache(portletPreferences);
    }

    public void onAfterUpdate(PortletPreferences portletPreferences) {
        this.clearCache(portletPreferences);
        this.updateLayout(portletPreferences);
    }

    protected void clearCache(PortletPreferences portletPreferences) {
        try {
            long companyId = 0L;
            Layout layout = LayoutUtil.fetchByPrimaryKey((long)portletPreferences.getPlid());
            if (layout != null && !layout.isPrivateLayout()) {
                companyId = layout.getCompanyId();
            } else {
                LayoutRevision layoutRevision = LayoutRevisionUtil.fetchByPrimaryKey((long)portletPreferences.getPlid());
                if (layoutRevision != null && !layoutRevision.isPrivateLayout()) {
                    companyId = layoutRevision.getCompanyId();
                }
            }
            if (companyId > 0L) {
                CacheUtil.clearCache(companyId);
            }
        }
        catch (Exception exception) {
            CacheUtil.clearCache();
        }
    }

    protected void updateLayout(PortletPreferences portletPreferences) {
        try {
            if (portletPreferences.getOwnerType() == 3 && portletPreferences.getPlid() > 0L) {
                Layout layout = LayoutLocalServiceUtil.fetchLayout((long)portletPreferences.getPlid());
                if (layout == null) {
                    return;
                }
                layout.setModifiedDate(new Date());
                LayoutLocalServiceUtil.updateLayout((Layout)layout, (boolean)true);
            }
        }
        catch (Exception e2) {
            _log.error((Object)"Unable to update the layout's modified date", (Throwable)e2);
        }
    }
}

