/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.GroupConstants;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.model.UserPersonalSite;
import com.liferay.portal.model.impl.GroupBaseImpl;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupImpl
extends GroupBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(GroupImpl.class);
    private Group _liveGroup;
    private Group _stagingGroup;
    private UnicodeProperties _typeSettingsProperties;

    public long getDefaultPrivatePlid() {
        return this.getDefaultPlid(true);
    }

    public long getDefaultPublicPlid() {
        return this.getDefaultPlid(false);
    }

    public String getDescriptiveName() throws PortalException, SystemException {
        return this.getDescriptiveName(LocaleUtil.getDefault());
    }

    public String getDescriptiveName(Locale locale) throws PortalException, SystemException {
        return GroupLocalServiceUtil.getGroupDescriptiveName((Group)this, (Locale)locale);
    }

    public Group getLiveGroup() {
        if (!this.isStagingGroup()) {
            return null;
        }
        try {
            if (this._liveGroup == null) {
                this._liveGroup = GroupLocalServiceUtil.getGroup((long)this.getLiveGroupId());
            }
            return this._liveGroup;
        }
        catch (Exception e2) {
            _log.error((Object)("Error getting live group for " + this.getLiveGroupId()), (Throwable)e2);
            return null;
        }
    }

    public long getOrganizationId() {
        if (this.isOrganization()) {
            if (this.isStagingGroup()) {
                Group liveGroup = this.getLiveGroup();
                return liveGroup.getClassPK();
            }
            return this.getClassPK();
        }
        return 0L;
    }

    public Group getParentGroup() throws PortalException, SystemException {
        long parentGroupId = this.getParentGroupId();
        if (parentGroupId <= 0L) {
            return null;
        }
        return GroupLocalServiceUtil.getGroup((long)parentGroupId);
    }

    public String getPathFriendlyURL(boolean privateLayout, ThemeDisplay themeDisplay) {
        if (privateLayout) {
            if (this.isUser()) {
                return themeDisplay.getPathFriendlyURLPrivateUser();
            }
            return themeDisplay.getPathFriendlyURLPrivateGroup();
        }
        return themeDisplay.getPathFriendlyURLPublic();
    }

    public LayoutSet getPrivateLayoutSet() {
        LayoutSet layoutSet = null;
        try {
            layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)this.getGroupId(), (boolean)true);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return layoutSet;
    }

    public int getPrivateLayoutsPageCount() {
        try {
            return LayoutLocalServiceUtil.getLayoutsCount((Group)this, (boolean)true);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            return 0;
        }
    }

    public LayoutSet getPublicLayoutSet() {
        LayoutSet layoutSet = null;
        try {
            layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)this.getGroupId(), (boolean)false);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return layoutSet;
    }

    public int getPublicLayoutsPageCount() {
        try {
            return LayoutLocalServiceUtil.getLayoutsCount((Group)this, (boolean)false);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            return 0;
        }
    }

    public Group getStagingGroup() {
        if (this.isStagingGroup()) {
            return null;
        }
        try {
            if (this._stagingGroup == null) {
                this._stagingGroup = GroupLocalServiceUtil.getStagingGroup((long)this.getGroupId());
            }
            return this._stagingGroup;
        }
        catch (Exception e2) {
            _log.error((Object)("Error getting staging group for " + this.getGroupId()), (Throwable)e2);
            return null;
        }
    }

    public String getTypeLabel() {
        return GroupConstants.getTypeLabel((int)this.getType());
    }

    @Override
    public String getTypeSettings() {
        if (this._typeSettingsProperties == null) {
            return super.getTypeSettings();
        }
        return this._typeSettingsProperties.toString();
    }

    public UnicodeProperties getTypeSettingsProperties() {
        if (this._typeSettingsProperties == null) {
            this._typeSettingsProperties = new UnicodeProperties(true);
            try {
                this._typeSettingsProperties.load(super.getTypeSettings());
            }
            catch (IOException ioe) {
                _log.error((Object)ioe, (Throwable)ioe);
            }
        }
        return this._typeSettingsProperties;
    }

    public String getTypeSettingsProperty(String key) {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        return typeSettingsProperties.getProperty(key);
    }

    public boolean hasPrivateLayouts() {
        return this.getPrivateLayoutsPageCount() > 0;
    }

    public boolean hasPublicLayouts() {
        return this.getPublicLayoutsPageCount() > 0;
    }

    public boolean hasStagingGroup() {
        if (this.isStagingGroup()) {
            return false;
        }
        if (this._stagingGroup != null) {
            return true;
        }
        try {
            return GroupLocalServiceUtil.hasStagingGroup((long)this.getGroupId());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isCommunity() {
        return this.isRegularSite();
    }

    public boolean isCompany() {
        return this.hasClassName(Company.class);
    }

    public boolean isControlPanel() {
        String name = this.getName();
        return name.equals("Control Panel");
    }

    public boolean isGuest() {
        String name = this.getName();
        return name.equals("Guest");
    }

    public boolean isLayout() {
        return this.hasClassName(Layout.class);
    }

    public boolean isLayoutPrototype() {
        return this.hasClassName(LayoutPrototype.class);
    }

    public boolean isLayoutSetPrototype() {
        return this.hasClassName(LayoutSetPrototype.class);
    }

    public boolean isOrganization() {
        return this.hasClassName(Organization.class);
    }

    public boolean isRegularSite() {
        return this.hasClassName(Group.class);
    }

    public boolean isStaged() {
        return GetterUtil.getBoolean((String)this.getTypeSettingsProperty("staged"));
    }

    public boolean isStagedPortlet(String portletId) {
        String portletDataHandlerClass;
        block8: {
            try {
                if (this.isLayout()) {
                    Group parentGroup = GroupLocalServiceUtil.getGroup((long)this.getParentGroupId());
                    return parentGroup.isStagedPortlet(portletId);
                }
            }
            catch (Exception exception) {}
            portletId = PortletConstants.getRootPortletId((String)portletId);
            String typeSettingsProperty = this.getTypeSettingsProperty("staged-portlet_".concat(portletId));
            if (Validator.isNotNull((String)typeSettingsProperty)) {
                return GetterUtil.getBoolean((String)typeSettingsProperty);
            }
            Portlet portlet = PortletLocalServiceUtil.getPortletById((String)portletId);
            portletDataHandlerClass = portlet.getPortletDataHandlerClass();
            if (!Validator.isNull((String)portletDataHandlerClass)) break block8;
            return true;
        }
        try {
            UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
            for (Map.Entry entry : typeSettingsProperties.entrySet()) {
                String stagedPortletId;
                Portlet stagedPortlet;
                String key = (String)entry.getKey();
                if (!key.contains("staged-portlet_") || !portletDataHandlerClass.equals((stagedPortlet = PortletLocalServiceUtil.getPortletById((String)(stagedPortletId = StringUtil.replace((String)key, (String)"staged-portlet_", (String)"")))).getPortletDataHandlerClass())) continue;
                return GetterUtil.getBoolean((String)((String)entry.getValue()));
            }
        }
        catch (Exception exception) {}
        return true;
    }

    public boolean isStagedRemotely() {
        return GetterUtil.getBoolean((String)this.getTypeSettingsProperty("stagedRemotely"));
    }

    public boolean isStagingGroup() {
        return this.getLiveGroupId() != 0L;
    }

    public boolean isUser() {
        return this.hasClassName(User.class);
    }

    public boolean isUserGroup() {
        return this.hasClassName(UserGroup.class);
    }

    public boolean isUserPersonalSite() {
        return this.hasClassName(UserPersonalSite.class);
    }

    @Override
    public void setTypeSettings(String typeSettings) {
        this._typeSettingsProperties = null;
        super.setTypeSettings(typeSettings);
    }

    public void setTypeSettingsProperties(UnicodeProperties typeSettingsProperties) {
        this._typeSettingsProperties = typeSettingsProperties;
        super.setTypeSettings(this._typeSettingsProperties.toString());
    }

    protected long getDefaultPlid(boolean privateLayout) {
        block3: {
            try {
                Layout firstLayout = LayoutLocalServiceUtil.fetchFirstLayout((long)this.getGroupId(), (boolean)privateLayout, (long)0L);
                if (firstLayout != null) {
                    return firstLayout.getPlid();
                }
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)e2.getMessage());
            }
        }
        return 0L;
    }

    protected boolean hasClassName(Class<?> clazz) {
        long classNameId = this.getClassNameId();
        return classNameId == PortalUtil.getClassNameId(clazz);
    }
}

