/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletLayoutListener;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.CustomizedPages;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutTemplate;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.PortletPreferences;
import com.liferay.portal.model.PortletPreferencesIds;
import com.liferay.portal.model.Theme;
import com.liferay.portal.model.impl.LayoutTemplateImpl;
import com.liferay.portal.model.impl.LayoutTypeImpl;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.LayoutTemplateLocalServiceUtil;
import com.liferay.portal.service.PluginSettingLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.service.ResourceLocalServiceUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortalPreferences;
import com.liferay.portlet.PortletInstanceFactoryUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.sites.util.SitesUtil;
import com.liferay.util.JS;
import com.liferay.util.PwdGenerator;
import java.text.DateFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutTypePortletImpl
extends LayoutTypeImpl
implements LayoutTypePortlet {
    private static final String _MODIFIED_DATE = "modifiedDate";
    private static final String _NULL_DATE = "00000000000000";
    private static Log _log = LogFactoryUtil.getLog(LayoutTypePortletImpl.class);
    private static String _nestedPortletsNamespace;
    private boolean _customizedView;
    private Format _dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat((String)PropsValues.INDEX_DATE_FORMAT_PATTERN);
    private boolean _enablePortletLayoutListener = true;
    private Layout _layoutSetPrototypeLayout;
    private PortalPreferences _portalPreferences;
    private boolean _updatePermission;

    public static String getFullInstanceSeparator() {
        String instanceId = PwdGenerator.getPassword((String)"0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz", (int)12);
        return "_INSTANCE_" + instanceId;
    }

    public LayoutTypePortletImpl(Layout layout) {
        super(layout);
        if (_nestedPortletsNamespace == null) {
            _nestedPortletsNamespace = PortalUtil.getPortletNamespace((String)"118");
        }
        this._layoutSetPrototypeLayout = SitesUtil.getLayoutSetPrototypeLayout(layout);
    }

    public void addModeAboutPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModeAbout(StringUtil.add((String)this.getModeAbout(), (String)portletId));
    }

    public void addModeConfigPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModeConfig(StringUtil.add((String)this.getModeConfig(), (String)portletId));
    }

    public void addModeEditDefaultsPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModeEditDefaults(StringUtil.add((String)this.getModeEditDefaults(), (String)portletId));
    }

    public void addModeEditGuestPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModeEditGuest(StringUtil.add((String)this.getModeEditGuest(), (String)portletId));
    }

    public void addModeEditPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModeEdit(StringUtil.add((String)this.getModeEdit(), (String)portletId));
    }

    public void addModeHelpPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModeHelp(StringUtil.add((String)this.getModeHelp(), (String)portletId));
    }

    public void addModePreviewPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModePreview(StringUtil.add((String)this.getModePreview(), (String)portletId));
    }

    public void addModePrintPortletId(String portletId) {
        this.removeModesPortletId(portletId);
        this.setModePrint(StringUtil.add((String)this.getModePrint(), (String)portletId));
    }

    public String addPortletId(long userId, String portletId) throws PortalException, SystemException {
        return this.addPortletId(userId, portletId, true);
    }

    public String addPortletId(long userId, String portletId, boolean checkPermission) throws PortalException, SystemException {
        return this.addPortletId(userId, portletId, null, -1, checkPermission);
    }

    public String addPortletId(long userId, String portletId, String columnId, int columnPos) throws PortalException, SystemException {
        return this.addPortletId(userId, portletId, columnId, columnPos, true);
    }

    public String addPortletId(long userId, String portletId, String columnId, int columnPos, boolean checkPermission) throws PortalException, SystemException {
        LayoutTemplate layoutTemplate;
        List columns;
        Portlet portlet;
        Layout layout;
        block21: {
            portletId = JS.getSafeName((String)portletId);
            layout = this.getLayout();
            portlet = null;
            portlet = PortletLocalServiceUtil.getPortletById((long)layout.getCompanyId(), (String)portletId);
            if (portlet != null) break block21;
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Portlet " + portletId + " cannot be added because it is not registered"));
            }
            return null;
        }
        try {
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (checkPermission && !PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (Portlet)portlet, (String)"ADD_TO_PAGE")) {
                return null;
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        if (portlet.isSystem()) {
            return null;
        }
        if (portlet.isInstanceable() && !PortletConstants.hasInstanceId((String)portletId)) {
            portletId = String.valueOf(portletId) + LayoutTypePortletImpl.getFullInstanceSeparator();
        }
        if (this.hasPortletId(portletId)) {
            return null;
        }
        if (columnId == null && (columns = (layoutTemplate = this.getLayoutTemplate()).getColumns()).size() > 0) {
            columnId = (String)columns.get(0);
        }
        if (columnId != null) {
            if (this.isCustomizable() && this.isColumnDisabled(columnId)) {
                return null;
            }
            String columnValue = "";
            columnValue = this.hasUserPreferences() ? this.getUserPreference(columnId) : this.getTypeSettingsProperty(columnId);
            if (columnValue == null && columnId.startsWith(_nestedPortletsNamespace)) {
                this.addNestedColumn(columnId);
            }
            if (columnPos >= 0) {
                List portletIds = ListUtil.fromArray((Object[])StringUtil.split((String)columnValue));
                if (columnPos <= portletIds.size()) {
                    portletIds.add(columnPos, portletId);
                } else {
                    portletIds.add(portletId);
                }
                columnValue = StringUtil.merge((Collection)portletIds);
            } else {
                columnValue = StringUtil.add((String)columnValue, (String)portletId);
            }
            if (this.hasUserPreferences()) {
                this.setUserPreference(columnId, columnValue);
            } else {
                this.setTypeSettingsProperty(columnId, columnValue);
            }
        }
        try {
            PortletLayoutListener portletLayoutListener = portlet.getPortletLayoutListenerInstance();
            if (this._enablePortletLayoutListener && portletLayoutListener != null) {
                portletLayoutListener.onAddToLayout(portletId, layout.getPlid());
            }
        }
        catch (Exception e3) {
            _log.error((Object)"Unable to fire portlet layout listener event", (Throwable)e3);
        }
        return portletId;
    }

    public void addPortletIds(long userId, String[] portletIds, boolean checkPermission) throws PortalException, SystemException {
        String[] stringArray = portletIds;
        int n = portletIds.length;
        int n2 = 0;
        while (n2 < n) {
            String portletId = stringArray[n2];
            this.addPortletId(userId, portletId, checkPermission);
            ++n2;
        }
    }

    public void addPortletIds(long userId, String[] portletIds, String columnId, boolean checkPermission) throws PortalException, SystemException {
        String[] stringArray = portletIds;
        int n = portletIds.length;
        int n2 = 0;
        while (n2 < n) {
            String portletId = stringArray[n2];
            this.addPortletId(userId, portletId, columnId, -1, checkPermission);
            ++n2;
        }
    }

    public void addStateMaxPortletId(String portletId) {
        this.removeStatesPortletId(portletId);
        this.setStateMax(StringUtil.add((String)"", (String)portletId));
    }

    public void addStateMinPortletId(String portletId) {
        this.removeStateMaxPortletId(portletId);
        this.setStateMin(StringUtil.add((String)this.getStateMin(), (String)portletId));
    }

    public List<Portlet> addStaticPortlets(List<Portlet> portlets, List<Portlet> startPortlets, List<Portlet> endPortlets) {
        if (startPortlets == null) {
            startPortlets = new ArrayList<Portlet>();
        }
        if (endPortlets == null) {
            endPortlets = new ArrayList<Portlet>();
        }
        if (startPortlets.isEmpty() && endPortlets.isEmpty()) {
            return portlets;
        }
        ArrayList<Portlet> list = new ArrayList<Portlet>(portlets.size() + startPortlets.size() + endPortlets.size());
        if (!startPortlets.isEmpty()) {
            list.addAll(startPortlets);
        }
        int i2 = 0;
        while (i2 < portlets.size()) {
            Portlet portlet = portlets.get(i2);
            if (!startPortlets.contains(portlet) && !endPortlets.contains(portlet)) {
                list.add(portlet);
            }
            ++i2;
        }
        if (!endPortlets.isEmpty()) {
            list.addAll(endPortlets);
        }
        return list;
    }

    public List<Portlet> getAllPortlets() throws PortalException, SystemException {
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        List<String> columns = this.getColumns();
        int i2 = 0;
        while (i2 < columns.size()) {
            String columnId = columns.get(i2);
            portlets.addAll(this.getAllPortlets(columnId));
            ++i2;
        }
        List<Portlet> staticPortlets = this.getStaticPortlets("layout.static.portlets.all");
        return this.addStaticPortlets(portlets, staticPortlets, null);
    }

    public List<Portlet> getAllPortlets(String columnId) throws PortalException, SystemException {
        String columnValue = this.getColumnValue(columnId);
        String[] portletIds = StringUtil.split((String)columnValue);
        ArrayList<Portlet> portlets = new ArrayList<Portlet>(portletIds.length);
        String[] stringArray = portletIds;
        int n = portletIds.length;
        int n2 = 0;
        while (n2 < n) {
            String portletId = stringArray[n2];
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)this.getCompanyId(), (String)portletId);
            if (portlet != null) {
                portlets.add(portlet);
            }
            ++n2;
        }
        List<Portlet> startPortlets = this.getStaticPortlets("layout.static.portlets.start." + columnId);
        List<Portlet> endPortlets = this.getStaticPortlets("layout.static.portlets.end." + columnId);
        return this.addStaticPortlets(portlets, startPortlets, endPortlets);
    }

    public Layout getLayoutSetPrototypeLayout() {
        return this._layoutSetPrototypeLayout;
    }

    public String getLayoutSetPrototypeLayoutProperty(String key) {
        if (this._layoutSetPrototypeLayout == null) {
            return "";
        }
        UnicodeProperties typeSettingsProperties = this._layoutSetPrototypeLayout.getTypeSettingsProperties();
        return typeSettingsProperties.getProperty(key);
    }

    public LayoutTemplate getLayoutTemplate() {
        String themeId = this.getThemeId();
        LayoutTemplate layoutTemplate = LayoutTemplateLocalServiceUtil.getLayoutTemplate((String)this.getLayoutTemplateId(), (boolean)false, (String)themeId);
        if (layoutTemplate == null) {
            layoutTemplate = new LayoutTemplateImpl("", "");
            ArrayList<String> columns = new ArrayList<String>();
            int i2 = 1;
            while (i2 <= 10) {
                columns.add("column-" + i2);
                ++i2;
            }
            layoutTemplate.setColumns(columns);
        }
        return layoutTemplate;
    }

    public String getLayoutTemplateId() {
        String layoutTemplateId = "";
        layoutTemplateId = this.hasLayoutSetPrototypeLayout() ? this.getLayoutSetPrototypeLayoutProperty("layout-template-id") : this.getTypeSettingsProperty("layout-template-id");
        if (Validator.isNull((String)layoutTemplateId)) {
            layoutTemplateId = "";
        }
        return layoutTemplateId;
    }

    public String getModeAbout() {
        return this.getTypeSettingsProperty("mode-about");
    }

    public String getModeConfig() {
        return this.getTypeSettingsProperty("mode-config");
    }

    public String getModeEdit() {
        return this.getTypeSettingsProperty("mode-edit");
    }

    public String getModeEditDefaults() {
        return this.getTypeSettingsProperty("mode-edit-defaults");
    }

    public String getModeEditGuest() {
        return this.getTypeSettingsProperty("mode-edit-guest");
    }

    public String getModeHelp() {
        return this.getTypeSettingsProperty("mode-help");
    }

    public String getModePreview() {
        return this.getTypeSettingsProperty("mode-preview");
    }

    public String getModePrint() {
        return this.getTypeSettingsProperty("mode-print");
    }

    public int getNumOfColumns() {
        return this.getLayoutTemplate().getColumns().size();
    }

    public PortalPreferences getPortalPreferences() {
        return this._portalPreferences;
    }

    public List<String> getPortletIds() {
        ArrayList<String> portletIds = new ArrayList<String>();
        List<String> columns = this.getColumns();
        int i2 = 0;
        while (i2 < columns.size()) {
            String columnId = columns.get(i2);
            String columnValue = this.getColumnValue(columnId);
            portletIds.addAll(ListUtil.fromArray((Object[])StringUtil.split((String)columnValue)));
            ++i2;
        }
        return portletIds;
    }

    public List<Portlet> getPortlets() throws SystemException {
        List<String> portletIds = this.getPortletIds();
        ArrayList<Portlet> portlets = new ArrayList<Portlet>(portletIds.size());
        int i2 = 0;
        while (i2 < portletIds.size()) {
            String portletId = portletIds.get(i2);
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)this.getCompanyId(), (String)portletId);
            if (portlet != null) {
                portlets.add(portlet);
            }
            ++i2;
        }
        return portlets;
    }

    public String getStateMax() {
        return this.getTypeSettingsProperty("state-max");
    }

    public String getStateMaxPortletId() {
        String[] stateMax = StringUtil.split((String)this.getStateMax());
        if (stateMax.length > 0) {
            return stateMax[0];
        }
        return "";
    }

    public String getStateMin() {
        return this.getTypeSettingsProperty("state-min");
    }

    public boolean hasDefaultScopePortletId(long groupId, String portletId) throws PortalException, SystemException {
        long scopeGroupId;
        return this.hasPortletId(portletId) && groupId == (scopeGroupId = PortalUtil.getScopeGroupId((Layout)this.getLayout(), (String)portletId));
    }

    public boolean hasLayoutSetPrototypeLayout() {
        return this._layoutSetPrototypeLayout != null;
    }

    public boolean hasModeAboutPortletId(String portletId) {
        return StringUtil.contains((String)this.getModeAbout(), (String)portletId);
    }

    public boolean hasModeConfigPortletId(String portletId) {
        return StringUtil.contains((String)this.getModeConfig(), (String)portletId);
    }

    public boolean hasModeEditDefaultsPortletId(String portletId) {
        return StringUtil.contains((String)this.getModeEditDefaults(), (String)portletId);
    }

    public boolean hasModeEditGuestPortletId(String portletId) {
        return StringUtil.contains((String)this.getModeEditGuest(), (String)portletId);
    }

    public boolean hasModeEditPortletId(String portletId) {
        return StringUtil.contains((String)this.getModeEdit(), (String)portletId);
    }

    public boolean hasModeHelpPortletId(String portletId) {
        return StringUtil.contains((String)this.getModeHelp(), (String)portletId);
    }

    public boolean hasModePreviewPortletId(String portletId) {
        return StringUtil.contains((String)this.getModePreview(), (String)portletId);
    }

    public boolean hasModePrintPortletId(String portletId) {
        return StringUtil.contains((String)this.getModePrint(), (String)portletId);
    }

    public boolean hasModeViewPortletId(String portletId) {
        return !this.hasModeAboutPortletId(portletId) && !this.hasModeConfigPortletId(portletId) && !this.hasModeEditPortletId(portletId) && !this.hasModeEditDefaultsPortletId(portletId) && !this.hasModeEditGuestPortletId(portletId) && !this.hasModeHelpPortletId(portletId) && !this.hasModePreviewPortletId(portletId) && !this.hasModePrintPortletId(portletId);
    }

    public boolean hasPortletId(String portletId) throws PortalException, SystemException {
        List<String> columns = this.getColumns();
        for (String columnId : columns) {
            if (this.hasNonstaticPortletId(columnId, portletId)) {
                return true;
            }
            if (!this.hasStaticPortletId(columnId, portletId)) continue;
            return true;
        }
        Layout layout = this.getLayout();
        return layout.isTypeControlPanel() || layout.isTypePanel();
    }

    public boolean hasStateMax() {
        String[] stateMax = StringUtil.split((String)this.getStateMax());
        return stateMax.length > 0;
    }

    public boolean hasStateMaxPortletId(String portletId) {
        return StringUtil.contains((String)this.getStateMax(), (String)portletId);
    }

    public boolean hasStateMin() {
        String[] stateMin = StringUtil.split((String)this.getStateMin());
        return stateMin.length > 0;
    }

    public boolean hasStateMinPortletId(String portletId) {
        return StringUtil.contains((String)this.getStateMin(), (String)portletId);
    }

    public boolean hasStateNormalPortletId(String portletId) {
        return !this.hasStateMaxPortletId(portletId) && !this.hasStateMinPortletId(portletId);
    }

    public boolean hasUpdatePermission() {
        return this._updatePermission;
    }

    public boolean isColumnCustomizable(String columnId) {
        if (!this.isLayoutSetPrototype()) {
            String columnValue;
            String customizableString = this.getTypeSettingsProperty(CustomizedPages.namespaceColumnId((String)columnId));
            boolean customizable = GetterUtil.getBoolean((String)customizableString);
            if (!customizable && this.hasUserPreferences() && !Validator.equals((Object)(columnValue = this._portalPreferences.getValue(CustomizedPages.namespacePlid((long)this.getPlid()), columnId, "null")), (Object)"null")) {
                this.setUserPreference(columnId, null);
            }
            return customizable;
        }
        return false;
    }

    public boolean isColumnDisabled(String columnId) {
        return this.isCustomizedView() && !this.isColumnCustomizable(columnId) || !this.isCustomizedView() && !this.hasUpdatePermission();
    }

    public boolean isCustomizable() {
        for (String columnId : this.getColumns()) {
            if (!this.isColumnCustomizable(columnId)) continue;
            return true;
        }
        return false;
    }

    public boolean isCustomizedView() {
        return this._customizedView;
    }

    public boolean isDefaultUpdated() {
        if (!this.isCustomizedView() || !this.hasUserPreferences()) {
            return false;
        }
        String preferencesModifiedDateString = this._portalPreferences.getValue(CustomizedPages.namespacePlid((long)this.getPlid()), _MODIFIED_DATE, _NULL_DATE);
        DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)PropsValues.INDEX_DATE_FORMAT_PATTERN);
        try {
            Date preferencesModifiedDate = dateFormat.parse(preferencesModifiedDateString);
            if (this.hasLayoutSetPrototypeLayout()) {
                String propertiesModifiedDateString = this._layoutSetPrototypeLayout.getTypeSettingsProperty(_MODIFIED_DATE, _NULL_DATE);
                Date propertiesModifiedDate = dateFormat.parse(propertiesModifiedDateString);
                return propertiesModifiedDate.after(preferencesModifiedDate);
            }
            Layout layout = this.getLayout();
            String propertiesModifiedDateString = layout.getTypeSettingsProperty(_MODIFIED_DATE, _NULL_DATE);
            Date propertiesModifiedDate = dateFormat.parse(propertiesModifiedDateString);
            return propertiesModifiedDate.after(preferencesModifiedDate);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            return false;
        }
    }

    public boolean isPortletCustomizable(String portletId) {
        return this.isColumnCustomizable(this.getColumn(portletId));
    }

    public void movePortletId(long userId, String portletId, String columnId, int columnPos) throws PortalException, SystemException {
        this._enablePortletLayoutListener = false;
        try {
            this.removePortletId(userId, portletId, false);
            this.addPortletId(userId, portletId, columnId, columnPos, false);
        }
        finally {
            this._enablePortletLayoutListener = true;
        }
        Layout layout = this.getLayout();
        try {
            PortletLayoutListener portletLayoutListener;
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)layout.getCompanyId(), (String)portletId);
            if (portlet != null && (portletLayoutListener = portlet.getPortletLayoutListenerInstance()) != null) {
                portletLayoutListener.onMoveInLayout(portletId, layout.getPlid());
            }
        }
        catch (Exception e2) {
            _log.error((Object)"Unable to fire portlet layout listener event", (Throwable)e2);
        }
    }

    public void removeModeAboutPortletId(String portletId) {
        this.setModeAbout(StringUtil.remove((String)this.getModeAbout(), (String)portletId));
    }

    public void removeModeConfigPortletId(String portletId) {
        this.setModeConfig(StringUtil.remove((String)this.getModeConfig(), (String)portletId));
    }

    public void removeModeEditDefaultsPortletId(String portletId) {
        this.setModeEditDefaults(StringUtil.remove((String)this.getModeEditDefaults(), (String)portletId));
    }

    public void removeModeEditGuestPortletId(String portletId) {
        this.setModeEditGuest(StringUtil.remove((String)this.getModeEditGuest(), (String)portletId));
    }

    public void removeModeEditPortletId(String portletId) {
        this.setModeEdit(StringUtil.remove((String)this.getModeEdit(), (String)portletId));
    }

    public void removeModeHelpPortletId(String portletId) {
        this.setModeHelp(StringUtil.remove((String)this.getModeHelp(), (String)portletId));
    }

    public void removeModePreviewPortletId(String portletId) {
        this.setModePreview(StringUtil.remove((String)this.getModePreview(), (String)portletId));
    }

    public void removeModePrintPortletId(String portletId) {
        this.setModePrint(StringUtil.remove((String)this.getModePrint(), (String)portletId));
    }

    public void removeModesPortletId(String portletId) {
        this.removeModeAboutPortletId(portletId);
        this.removeModeConfigPortletId(portletId);
        this.removeModeEditPortletId(portletId);
        this.removeModeEditDefaultsPortletId(portletId);
        this.removeModeEditGuestPortletId(portletId);
        this.removeModeHelpPortletId(portletId);
        this.removeModePreviewPortletId(portletId);
        this.removeModePrintPortletId(portletId);
    }

    public void removeNestedColumns(String portletNamespace) {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        UnicodeProperties newTypeSettingsProperties = new UnicodeProperties();
        for (Map.Entry entry : typeSettingsProperties.entrySet()) {
            String key = (String)entry.getKey();
            if (key.startsWith(portletNamespace)) continue;
            newTypeSettingsProperties.setProperty(key, (String)entry.getValue());
        }
        Layout layout = this.getLayout();
        layout.setTypeSettingsProperties(newTypeSettingsProperties);
        String nestedColumnIds = GetterUtil.getString((String)this.getTypeSettingsProperty("nested-column-ids"));
        Object[] nestedColumnIdsArray = ArrayUtil.removeByPrefix((String[])StringUtil.split((String)nestedColumnIds), (String)portletNamespace);
        this.setTypeSettingsProperty("nested-column-ids", StringUtil.merge((Object[])nestedColumnIdsArray));
    }

    public void removePortletId(long userId, String portletId) {
        this.removePortletId(userId, portletId, true);
    }

    public void removePortletId(long userId, String portletId, boolean cleanUp) {
        try {
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)this.getCompanyId(), (String)portletId);
            if (portlet == null) {
                _log.error((Object)("Portlet " + portletId + " cannot be removed because it is not registered"));
                return;
            }
            PortletInstanceFactoryUtil.delete((Portlet)portlet);
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (!LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)this.getLayout(), (String)"UPDATE") && !this.isCustomizable()) {
                return;
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        List<String> columns = this.getColumns();
        int i2 = 0;
        while (i2 < columns.size()) {
            String columnId = columns.get(i2);
            if (!this.isCustomizable() || !this.isColumnDisabled(columnId)) {
                String columnValue = "";
                columnValue = this.hasUserPreferences() ? this.getUserPreference(columnId) : this.getTypeSettingsProperty(columnId);
                columnValue = StringUtil.remove((String)columnValue, (String)portletId);
                if (this.hasUserPreferences()) {
                    this.setUserPreference(columnId, columnValue);
                    try {
                        String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
                        ResourceLocalServiceUtil.deleteResource((long)this.getCompanyId(), (String)rootPortletId, (int)4, (String)PortletPermissionUtil.getPrimaryKey((long)this.getPlid(), (String)portletId));
                    }
                    catch (Exception exception) {}
                } else {
                    this.setTypeSettingsProperty(columnId, columnValue);
                }
            }
            ++i2;
        }
        if (cleanUp) {
            this.removeStatesPortletId(portletId);
            this.removeModesPortletId(portletId);
            try {
                this.onRemoveFromLayout(portletId);
            }
            catch (Exception e3) {
                _log.error((Object)"Unable to fire portlet layout listener event", (Throwable)e3);
            }
        }
    }

    public void removeStateMaxPortletId(String portletId) {
        this.setStateMax(StringUtil.remove((String)this.getStateMax(), (String)portletId));
    }

    public void removeStateMinPortletId(String portletId) {
        this.setStateMin(StringUtil.remove((String)this.getStateMin(), (String)portletId));
    }

    public void removeStatesPortletId(String portletId) {
        this.removeStateMaxPortletId(portletId);
        this.removeStateMinPortletId(portletId);
    }

    public void reorganizePortlets(List<String> newColumns, List<String> oldColumns) {
        String lastNewColumnId = newColumns.get(newColumns.size() - 1);
        String lastNewColumnValue = this.getTypeSettingsProperty(lastNewColumnId);
        for (String oldColumnId : oldColumns) {
            String[] portletIds;
            if (newColumns.contains(oldColumnId)) continue;
            String oldColumnValue = this.getTypeSettingsProperties().remove((Object)oldColumnId);
            String[] stringArray = portletIds = StringUtil.split((String)oldColumnValue);
            int n = portletIds.length;
            int n2 = 0;
            while (n2 < n) {
                String portletId = stringArray[n2];
                lastNewColumnValue = StringUtil.add((String)lastNewColumnValue, (String)portletId);
                ++n2;
            }
        }
        this.setTypeSettingsProperty(lastNewColumnId, lastNewColumnValue);
    }

    public void resetModes() {
        this.setModeAbout("");
        this.setModeConfig("");
        this.setModeEdit("");
        this.setModeEditDefaults("");
        this.setModeEditGuest("");
        this.setModeHelp("");
        this.setModePreview("");
        this.setModePrint("");
    }

    public void resetStates() {
        this.setStateMax("");
        this.setStateMin("");
    }

    public void resetUserPreferences() {
        if (this.hasUserPreferences()) {
            Layout layout = this.getLayout();
            long plid = layout.getPlid();
            this._portalPreferences.resetValues(CustomizedPages.namespacePlid((long)plid));
            this._portalPreferences.setValue(CustomizedPages.namespacePlid((long)plid), _MODIFIED_DATE, this._dateFormat.format(new Date()));
        }
    }

    public void setCustomizedView(boolean customizedView) {
        this._customizedView = customizedView;
    }

    public void setLayoutTemplateId(long userId, String newLayoutTemplateId) {
        this.setLayoutTemplateId(userId, newLayoutTemplateId, true);
    }

    public void setLayoutTemplateId(long userId, String newLayoutTemplateId, boolean checkPermission) {
        if (checkPermission && !PluginSettingLocalServiceUtil.hasPermission((long)userId, (String)newLayoutTemplateId, (String)"layouttpl")) {
            return;
        }
        String oldLayoutTemplateId = this.getLayoutTemplateId();
        if (Validator.isNull((String)oldLayoutTemplateId)) {
            oldLayoutTemplateId = PropsValues.DEFAULT_LAYOUT_TEMPLATE_ID;
        }
        this.setTypeSettingsProperty("layout-template-id", newLayoutTemplateId);
        String themeId = this.getThemeId();
        LayoutTemplate oldLayoutTemplate = LayoutTemplateLocalServiceUtil.getLayoutTemplate((String)oldLayoutTemplateId, (boolean)false, (String)themeId);
        if (oldLayoutTemplate == null) {
            return;
        }
        LayoutTemplate newLayoutTemplate = LayoutTemplateLocalServiceUtil.getLayoutTemplate((String)newLayoutTemplateId, (boolean)false, (String)themeId);
        List oldColumns = oldLayoutTemplate.getColumns();
        List newColumns = newLayoutTemplate.getColumns();
        this.reorganizePortlets(newColumns, oldColumns);
    }

    public void setModeAbout(String modeAbout) {
        this.setTypeSettingsProperty("mode-about", modeAbout);
    }

    public void setModeConfig(String modeConfig) {
        this.setTypeSettingsProperty("mode-config", modeConfig);
    }

    public void setModeEdit(String modeEdit) {
        this.setTypeSettingsProperty("mode-edit", modeEdit);
    }

    public void setModeEditDefaults(String modeEditDefaults) {
        this.setTypeSettingsProperty("mode-edit-defaults", modeEditDefaults);
    }

    public void setModeEditGuest(String modeEditGuest) {
        this.setTypeSettingsProperty("mode-edit-guest", modeEditGuest);
    }

    public void setModeHelp(String modeHelp) {
        this.setTypeSettingsProperty("mode-help", modeHelp);
    }

    public void setModePreview(String modePreview) {
        this.setTypeSettingsProperty("mode-preview", modePreview);
    }

    public void setModePrint(String modePrint) {
        this.setTypeSettingsProperty("mode-print", modePrint);
    }

    public void setPortalPreferences(PortalPreferences portalPreferences) {
        this._portalPreferences = portalPreferences;
    }

    public void setPortletIds(String columnId, String portletIds) {
        this.setTypeSettingsProperty(columnId, portletIds);
        if (!columnId.startsWith("runtime-column-")) {
            return;
        }
        String runtimeColumnIds = this.getTypeSettingsProperty("runtime-column-ids", "");
        int pos = runtimeColumnIds.indexOf(columnId);
        if (pos == -1 && Validator.isNotNull((String)portletIds)) {
            runtimeColumnIds = StringUtil.add((String)runtimeColumnIds, (String)columnId);
            this.setTypeSettingsProperty("runtime-column-ids", runtimeColumnIds);
        } else if (pos != -1 && Validator.isNull((String)portletIds)) {
            runtimeColumnIds = StringUtil.remove((String)runtimeColumnIds, (String)columnId);
            this.setTypeSettingsProperty("runtime-column-ids", runtimeColumnIds);
        }
    }

    public void setStateMax(String stateMax) {
        this.setTypeSettingsProperty("state-max", stateMax);
    }

    public void setStateMin(String stateMin) {
        this.setTypeSettingsProperty("state-min", stateMin);
    }

    public void setUpdatePermission(boolean updatePermission) {
        this._updatePermission = updatePermission;
    }

    protected void addNestedColumn(String columnId) {
        String nestedColumnIds = this.getTypeSettingsProperty("nested-column-ids", "");
        if (nestedColumnIds.indexOf(columnId) == -1) {
            nestedColumnIds = StringUtil.add((String)nestedColumnIds, (String)columnId);
            this.setTypeSettingsProperty("nested-column-ids", nestedColumnIds);
        }
    }

    protected void copyPreferences(String sourcePortletId, String targetPortletId) {
        Layout layout = this.getLayout();
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        try {
            PortletPreferencesIds portletPreferencesIds = PortletPreferencesFactoryUtil.getPortletPreferencesIds((long)layout.getGroupId(), (long)permissionChecker.getUserId(), (Layout)layout, (String)sourcePortletId, (boolean)false);
            javax.portlet.PortletPreferences sourcePortletPreferences = PortletPreferencesLocalServiceUtil.getPreferences((PortletPreferencesIds)portletPreferencesIds);
            portletPreferencesIds = PortletPreferencesFactoryUtil.getPortletPreferencesIds((long)layout.getGroupId(), (long)permissionChecker.getUserId(), (Layout)layout, (String)targetPortletId, (boolean)false);
            PortletPreferencesLocalServiceUtil.updatePreferences((long)portletPreferencesIds.getOwnerId(), (int)portletPreferencesIds.getOwnerType(), (long)portletPreferencesIds.getPlid(), (String)portletPreferencesIds.getPortletId(), (javax.portlet.PortletPreferences)sourcePortletPreferences);
        }
        catch (Exception exception) {}
    }

    protected void deletePortletSetup(String portletId) {
        try {
            List portletPreferencesList = PortletPreferencesLocalServiceUtil.getPortletPreferences((long)this.getPlid(), (String)portletId);
            for (PortletPreferences portletPreferences : portletPreferencesList) {
                PortletPreferencesLocalServiceUtil.deletePortletPreferences((long)portletPreferences.getPortletPreferencesId());
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    protected String getColumn(String portletId) {
        String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
        List<String> columns = this.getColumns();
        for (String columnId : columns) {
            String[] portletIds;
            String columnValue = this.getColumnValue(columnId);
            String[] stringArray = portletIds = StringUtil.split((String)columnValue);
            int n = portletIds.length;
            int n2 = 0;
            while (n2 < n) {
                String columnPortletId = stringArray[n2];
                if (portletId.equals(columnPortletId) || portletId.equals(rootPortletId) && columnPortletId.startsWith(rootPortletId)) {
                    return columnId;
                }
                ++n2;
            }
        }
        return "";
    }

    protected List<String> getColumns() {
        LayoutTemplate layoutTemplate = this.getLayoutTemplate();
        ArrayList<String> columns = new ArrayList<String>();
        columns.addAll(layoutTemplate.getColumns());
        columns.addAll(this.getNestedColumns());
        columns.addAll(this.getRuntimeColumns());
        return columns;
    }

    protected String getColumnValue(String columnId) {
        Boolean customizable = null;
        Boolean columnDisabled = null;
        if (this.hasLayoutSetPrototypeLayout() && (customizable = Boolean.valueOf(this.isCustomizable())).booleanValue() && (columnDisabled = Boolean.valueOf(this.isColumnDisabled(columnId))).booleanValue()) {
            return this.getLayoutSetPrototypeLayoutProperty(columnId);
        }
        if (this.hasUserPreferences() && (customizable == null ? this.isCustomizable() : customizable != false) && (columnDisabled == null ? !this.isColumnDisabled(columnId) : columnDisabled == false)) {
            return this.getUserPreference(columnId);
        }
        return this.getTypeSettingsProperty(columnId);
    }

    protected long getCompanyId() {
        Layout layout = this.getLayout();
        return layout.getCompanyId();
    }

    protected List<String> getNestedColumns() {
        String nestedColumnIds = this.getTypeSettingsProperty("nested-column-ids");
        return ListUtil.fromArray((Object[])StringUtil.split((String)nestedColumnIds));
    }

    protected long getPlid() {
        Layout layout = this.getLayout();
        return layout.getPlid();
    }

    protected List<String> getRuntimeColumns() {
        String runtimePortletIds = this.getTypeSettingsProperty("runtime-column-ids");
        return ListUtil.fromArray((Object[])StringUtil.split((String)runtimePortletIds));
    }

    protected String[] getStaticPortletIds(String position) throws PortalException, SystemException {
        Layout layout = this.getLayout();
        if (this.hasLayoutSetPrototypeLayout()) {
            layout = this._layoutSetPrototypeLayout;
        }
        String selector1 = "";
        Group group = layout.getGroup();
        if (group.isUser()) {
            selector1 = "user";
        } else if (group.isOrganization()) {
            selector1 = "organization";
        } else if (group.isRegularSite()) {
            selector1 = "regular-site";
        }
        String selector2 = layout.getFriendlyURL();
        String[] portletIds = PropsUtil.getArray(position, new Filter(selector1, selector2));
        int i2 = 0;
        while (i2 < portletIds.length) {
            portletIds[i2] = JS.getSafeName((String)portletIds[i2]);
            ++i2;
        }
        return portletIds;
    }

    protected List<Portlet> getStaticPortlets(String position) throws PortalException, SystemException {
        String[] portletIds = this.getStaticPortletIds(position);
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        String[] stringArray = portletIds;
        int n = portletIds.length;
        int n2 = 0;
        while (n2 < n) {
            Portlet portlet;
            String portletId = stringArray[n2];
            if (!Validator.isNull((String)portletId) && !this.hasNonstaticPortletId(portletId) && (portlet = PortletLocalServiceUtil.getPortletById((long)this.getCompanyId(), (String)portletId)) != null) {
                Portlet staticPortlet = portlet;
                if (!portlet.isInstanceable()) {
                    staticPortlet = (Portlet)staticPortlet.clone();
                }
                staticPortlet.setStatic(true);
                if (position.startsWith("layout.static.portlets.start")) {
                    staticPortlet.setStaticStart(true);
                }
                portlets.add(staticPortlet);
            }
            ++n2;
        }
        return portlets;
    }

    protected String getThemeId() {
        String themeId = null;
        try {
            Layout layout = this.getLayout();
            Theme theme = layout.getTheme();
            themeId = theme != null ? theme.getThemeId() : layout.getThemeId();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return themeId;
    }

    protected String getUserPreference(String key) {
        String value = "";
        if (!this.hasUserPreferences()) {
            return value;
        }
        value = this._portalPreferences.getValue(CustomizedPages.namespacePlid((long)this.getPlid()), key, "null");
        if (!value.equals("null")) {
            return value;
        }
        value = this.hasLayoutSetPrototypeLayout() ? this.getLayoutSetPrototypeLayoutProperty(key) : this.getTypeSettingsProperty(key);
        if (Validator.isNull((String)value)) {
            return value;
        }
        String[] portletIds = StringUtil.split((String)value);
        Object[] newPortletIds = new String[portletIds.length];
        int i2 = 0;
        while (i2 < portletIds.length) {
            if (portletIds[i2].contains("_INSTANCE_")) {
                String rootPortletId = PortletConstants.getRootPortletId((String)portletIds[i2]);
                newPortletIds[i2] = String.valueOf(rootPortletId) + LayoutTypePortletImpl.getFullInstanceSeparator();
                this.copyPreferences(portletIds[i2], (String)newPortletIds[i2]);
            } else {
                newPortletIds[i2] = portletIds[i2];
            }
            ++i2;
        }
        value = StringUtil.merge((Object[])newPortletIds);
        this.setUserPreference(key, value);
        return value;
    }

    protected boolean hasNonstaticPortletId(String portletId) {
        LayoutTemplate layoutTemplate = this.getLayoutTemplate();
        List columns = layoutTemplate.getColumns();
        int i2 = 0;
        while (i2 < columns.size()) {
            String columnId = (String)columns.get(i2);
            if (this.hasNonstaticPortletId(columnId, portletId)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    protected boolean hasNonstaticPortletId(String columnId, String portletId) {
        String[] columnValues;
        String columnValue = this.getColumnValue(columnId);
        String[] stringArray = columnValues = StringUtil.split((String)columnValue);
        int n = columnValues.length;
        int n2 = 0;
        while (n2 < n) {
            String nonstaticPortletId = stringArray[n2];
            if (nonstaticPortletId.equals(portletId) || nonstaticPortletId.startsWith(portletId.concat("_INSTANCE_"))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean hasStaticPortletId(String columnId, String portletId) throws PortalException, SystemException {
        String staticPortletId;
        String[] staticPortletIdsStart = this.getStaticPortletIds("layout.static.portlets.start." + columnId);
        String[] staticPortletIdsEnd = this.getStaticPortletIds("layout.static.portlets.end." + columnId);
        String[] stringArray = staticPortletIdsStart;
        int n = staticPortletIdsStart.length;
        int n2 = 0;
        while (n2 < n) {
            staticPortletId = stringArray[n2];
            if (staticPortletId.equals(portletId) || staticPortletId.startsWith(portletId.concat("_INSTANCE_"))) {
                return true;
            }
            ++n2;
        }
        stringArray = staticPortletIdsEnd;
        n = staticPortletIdsEnd.length;
        n2 = 0;
        while (n2 < n) {
            staticPortletId = stringArray[n2];
            if (staticPortletId.equals(portletId) || staticPortletId.startsWith(portletId.concat("_INSTANCE_"))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean hasUserPreferences() {
        return this._portalPreferences != null;
    }

    protected boolean isLayoutSetPrototype() {
        try {
            Layout layout = this.getLayout();
            LayoutSet layoutSet = layout.getLayoutSet();
            Group group = layoutSet.getGroup();
            return group.isLayoutSetPrototype();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            return false;
        }
    }

    protected void onRemoveFromLayout(String portletId) throws SystemException {
        PortletLayoutListener portletLayoutListener;
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)this.getCompanyId(), (String)portletId);
        if (portlet == null) {
            return;
        }
        if (portlet.getRootPortletId().equals("118")) {
            String portletNamespace = PortalUtil.getPortletNamespace((String)portletId);
            UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
            for (Map.Entry entry : typeSettingsProperties.entrySet()) {
                String[] portletIdsArray;
                String key = (String)entry.getKey();
                if (!key.startsWith(portletNamespace)) continue;
                String portletIds = (String)entry.getValue();
                String[] stringArray = portletIdsArray = StringUtil.split((String)portletIds);
                int n = portletIdsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String curPortletId = stringArray[n2];
                    this.onRemoveFromLayout(curPortletId);
                    ++n2;
                }
            }
            this.removeNestedColumns(portletNamespace);
        }
        if (this._enablePortletLayoutListener && (portletLayoutListener = portlet.getPortletLayoutListenerInstance()) != null) {
            portletLayoutListener.onRemoveFromLayout(portletId, this.getPlid());
        }
        this.deletePortletSetup(portletId);
    }

    protected void setUserPreference(String key, String value) {
        if (!this.hasUserPreferences()) {
            return;
        }
        this._portalPreferences.setValue(CustomizedPages.namespacePlid((long)this.getPlid()), key, value);
        this._portalPreferences.setValue(CustomizedPages.namespacePlid((long)this.getPlid()), _MODIFIED_DATE, this._dateFormat.format(new Date()));
    }
}

