/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.Repository;
import com.liferay.portal.model.RepositoryModel;
import com.liferay.portal.model.RepositorySoap;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.model.impl.RepositoryCacheModel;
import com.liferay.portal.model.impl.RepositoryImpl;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JSON(strict=true)
public class RepositoryModelImpl
extends BaseModelImpl<Repository>
implements RepositoryModel {
    public static final String TABLE_NAME = "Repository";
    public static final Object[][] TABLE_COLUMNS = new Object[][]{{"uuid_", 12}, {"repositoryId", -5}, {"groupId", -5}, {"companyId", -5}, {"userId", -5}, {"userName", 12}, {"createDate", 93}, {"modifiedDate", 93}, {"classNameId", -5}, {"name", 12}, {"description", 12}, {"portletId", 12}, {"typeSettings", 2005}, {"dlFolderId", -5}};
    public static final String TABLE_SQL_CREATE = "create table Repository (uuid_ VARCHAR(75) null,repositoryId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,classNameId LONG,name VARCHAR(75) null,description STRING null,portletId VARCHAR(75) null,typeSettings TEXT null,dlFolderId LONG)";
    public static final String TABLE_SQL_DROP = "drop table Repository";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get("value.object.entity.cache.enabled.com.liferay.portal.model.Repository"), (boolean)true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get("value.object.finder.cache.enabled.com.liferay.portal.model.Repository"), (boolean)true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get("value.object.column.bitmask.enabled.com.liferay.portal.model.Repository"), (boolean)true);
    public static long GROUPID_COLUMN_BITMASK = 1L;
    public static long UUID_COLUMN_BITMASK = 2L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong((String)PropsUtil.get("lock.expiration.time.com.liferay.portal.model.Repository"));
    private static ClassLoader _classLoader = Repository.class.getClassLoader();
    private static Class<?>[] _escapedModelProxyInterfaces = new Class[]{Repository.class};
    private String _uuid;
    private String _originalUuid;
    private long _repositoryId;
    private long _groupId;
    private long _originalGroupId;
    private boolean _setOriginalGroupId;
    private long _companyId;
    private long _userId;
    private String _userUuid;
    private String _userName;
    private Date _createDate;
    private Date _modifiedDate;
    private long _classNameId;
    private String _name;
    private String _description;
    private String _portletId;
    private String _typeSettings;
    private long _dlFolderId;
    private long _columnBitmask;
    private Repository _escapedModelProxy;

    public static Repository toModel(RepositorySoap soapModel) {
        if (soapModel == null) {
            return null;
        }
        RepositoryImpl model = new RepositoryImpl();
        model.setUuid(soapModel.getUuid());
        model.setRepositoryId(soapModel.getRepositoryId());
        model.setGroupId(soapModel.getGroupId());
        model.setCompanyId(soapModel.getCompanyId());
        model.setUserId(soapModel.getUserId());
        model.setUserName(soapModel.getUserName());
        model.setCreateDate(soapModel.getCreateDate());
        model.setModifiedDate(soapModel.getModifiedDate());
        model.setClassNameId(soapModel.getClassNameId());
        model.setName(soapModel.getName());
        model.setDescription(soapModel.getDescription());
        model.setPortletId(soapModel.getPortletId());
        model.setTypeSettings(soapModel.getTypeSettings());
        model.setDlFolderId(soapModel.getDlFolderId());
        return model;
    }

    public static List<Repository> toModels(RepositorySoap[] soapModels) {
        if (soapModels == null) {
            return null;
        }
        ArrayList<Repository> models = new ArrayList<Repository>(soapModels.length);
        RepositorySoap[] repositorySoapArray = soapModels;
        int n = soapModels.length;
        int n2 = 0;
        while (n2 < n) {
            RepositorySoap soapModel = repositorySoapArray[n2];
            models.add(RepositoryModelImpl.toModel(soapModel));
            ++n2;
        }
        return models;
    }

    public long getPrimaryKey() {
        return this._repositoryId;
    }

    public void setPrimaryKey(long primaryKey) {
        this.setRepositoryId(primaryKey);
    }

    public Serializable getPrimaryKeyObj() {
        return new Long(this._repositoryId);
    }

    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        this.setPrimaryKey((Long)primaryKeyObj);
    }

    public Class<?> getModelClass() {
        return Repository.class;
    }

    public String getModelClassName() {
        return Repository.class.getName();
    }

    public Map<String, Object> getModelAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("uuid", this.getUuid());
        attributes.put("repositoryId", this.getRepositoryId());
        attributes.put("groupId", this.getGroupId());
        attributes.put("companyId", this.getCompanyId());
        attributes.put("userId", this.getUserId());
        attributes.put("userName", this.getUserName());
        attributes.put("createDate", this.getCreateDate());
        attributes.put("modifiedDate", this.getModifiedDate());
        attributes.put("classNameId", this.getClassNameId());
        attributes.put("name", this.getName());
        attributes.put("description", this.getDescription());
        attributes.put("portletId", this.getPortletId());
        attributes.put("typeSettings", this.getTypeSettings());
        attributes.put("dlFolderId", this.getDlFolderId());
        return attributes;
    }

    public void setModelAttributes(Map<String, Object> attributes) {
        Long dlFolderId;
        String typeSettings;
        String portletId;
        String description;
        String name;
        Long classNameId;
        Date modifiedDate;
        Date createDate;
        String userName;
        Long userId;
        Long companyId;
        Long groupId;
        Long repositoryId;
        String uuid = (String)attributes.get("uuid");
        if (uuid != null) {
            this.setUuid(uuid);
        }
        if ((repositoryId = (Long)attributes.get("repositoryId")) != null) {
            this.setRepositoryId(repositoryId);
        }
        if ((groupId = (Long)attributes.get("groupId")) != null) {
            this.setGroupId(groupId);
        }
        if ((companyId = (Long)attributes.get("companyId")) != null) {
            this.setCompanyId(companyId);
        }
        if ((userId = (Long)attributes.get("userId")) != null) {
            this.setUserId(userId);
        }
        if ((userName = (String)attributes.get("userName")) != null) {
            this.setUserName(userName);
        }
        if ((createDate = (Date)attributes.get("createDate")) != null) {
            this.setCreateDate(createDate);
        }
        if ((modifiedDate = (Date)attributes.get("modifiedDate")) != null) {
            this.setModifiedDate(modifiedDate);
        }
        if ((classNameId = (Long)attributes.get("classNameId")) != null) {
            this.setClassNameId(classNameId);
        }
        if ((name = (String)attributes.get("name")) != null) {
            this.setName(name);
        }
        if ((description = (String)attributes.get("description")) != null) {
            this.setDescription(description);
        }
        if ((portletId = (String)attributes.get("portletId")) != null) {
            this.setPortletId(portletId);
        }
        if ((typeSettings = (String)attributes.get("typeSettings")) != null) {
            this.setTypeSettings(typeSettings);
        }
        if ((dlFolderId = (Long)attributes.get("dlFolderId")) != null) {
            this.setDlFolderId(dlFolderId);
        }
    }

    @JSON
    public String getUuid() {
        if (this._uuid == null) {
            return "";
        }
        return this._uuid;
    }

    public void setUuid(String uuid) {
        if (this._originalUuid == null) {
            this._originalUuid = this._uuid;
        }
        this._uuid = uuid;
    }

    public String getOriginalUuid() {
        return GetterUtil.getString((String)this._originalUuid);
    }

    @JSON
    public long getRepositoryId() {
        return this._repositoryId;
    }

    public void setRepositoryId(long repositoryId) {
        this._repositoryId = repositoryId;
    }

    @JSON
    public long getGroupId() {
        return this._groupId;
    }

    public void setGroupId(long groupId) {
        this._columnBitmask |= GROUPID_COLUMN_BITMASK;
        if (!this._setOriginalGroupId) {
            this._setOriginalGroupId = true;
            this._originalGroupId = this._groupId;
        }
        this._groupId = groupId;
    }

    public long getOriginalGroupId() {
        return this._originalGroupId;
    }

    @JSON
    public long getCompanyId() {
        return this._companyId;
    }

    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }

    @JSON
    public long getUserId() {
        return this._userId;
    }

    public void setUserId(long userId) {
        this._userId = userId;
    }

    public String getUserUuid() throws SystemException {
        return PortalUtil.getUserValue((long)this.getUserId(), (String)"uuid", (String)this._userUuid);
    }

    public void setUserUuid(String userUuid) {
        this._userUuid = userUuid;
    }

    @JSON
    public String getUserName() {
        if (this._userName == null) {
            return "";
        }
        return this._userName;
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    @JSON
    public Date getCreateDate() {
        return this._createDate;
    }

    public void setCreateDate(Date createDate) {
        this._createDate = createDate;
    }

    @JSON
    public Date getModifiedDate() {
        return this._modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this._modifiedDate = modifiedDate;
    }

    public String getClassName() {
        if (this.getClassNameId() <= 0L) {
            return "";
        }
        return PortalUtil.getClassName((long)this.getClassNameId());
    }

    public void setClassName(String className) {
        long classNameId = 0L;
        if (Validator.isNotNull((String)className)) {
            classNameId = PortalUtil.getClassNameId((String)className);
        }
        this.setClassNameId(classNameId);
    }

    @JSON
    public long getClassNameId() {
        return this._classNameId;
    }

    public void setClassNameId(long classNameId) {
        this._classNameId = classNameId;
    }

    @JSON
    public String getName() {
        if (this._name == null) {
            return "";
        }
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @JSON
    public String getDescription() {
        if (this._description == null) {
            return "";
        }
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    @JSON
    public String getPortletId() {
        if (this._portletId == null) {
            return "";
        }
        return this._portletId;
    }

    public void setPortletId(String portletId) {
        this._portletId = portletId;
    }

    @JSON
    public String getTypeSettings() {
        if (this._typeSettings == null) {
            return "";
        }
        return this._typeSettings;
    }

    public void setTypeSettings(String typeSettings) {
        this._typeSettings = typeSettings;
    }

    @JSON
    public long getDlFolderId() {
        return this._dlFolderId;
    }

    public void setDlFolderId(long dlFolderId) {
        this._dlFolderId = dlFolderId;
    }

    public long getColumnBitmask() {
        return this._columnBitmask;
    }

    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge((long)this.getCompanyId(), (String)Repository.class.getName(), (long)this.getPrimaryKey());
    }

    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = this.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
    }

    public Repository toEscapedModel() {
        if (this._escapedModelProxy == null) {
            this._escapedModelProxy = (Repository)ProxyUtil.newProxyInstance((ClassLoader)_classLoader, (Class[])_escapedModelProxyInterfaces, (InvocationHandler)new AutoEscapeBeanHandler((Object)this));
        }
        return this._escapedModelProxy;
    }

    public Object clone() {
        RepositoryImpl repositoryImpl = new RepositoryImpl();
        repositoryImpl.setUuid(this.getUuid());
        repositoryImpl.setRepositoryId(this.getRepositoryId());
        repositoryImpl.setGroupId(this.getGroupId());
        repositoryImpl.setCompanyId(this.getCompanyId());
        repositoryImpl.setUserId(this.getUserId());
        repositoryImpl.setUserName(this.getUserName());
        repositoryImpl.setCreateDate(this.getCreateDate());
        repositoryImpl.setModifiedDate(this.getModifiedDate());
        repositoryImpl.setClassNameId(this.getClassNameId());
        repositoryImpl.setName(this.getName());
        repositoryImpl.setDescription(this.getDescription());
        repositoryImpl.setPortletId(this.getPortletId());
        repositoryImpl.setTypeSettings(this.getTypeSettings());
        repositoryImpl.setDlFolderId(this.getDlFolderId());
        repositoryImpl.resetOriginalValues();
        return repositoryImpl;
    }

    public int compareTo(Repository repository) {
        long primaryKey = repository.getPrimaryKey();
        if (this.getPrimaryKey() < primaryKey) {
            return -1;
        }
        if (this.getPrimaryKey() > primaryKey) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Repository repository = null;
        try {
            repository = (Repository)obj;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        long primaryKey = repository.getPrimaryKey();
        return this.getPrimaryKey() == primaryKey;
    }

    public int hashCode() {
        return (int)this.getPrimaryKey();
    }

    public void resetOriginalValues() {
        RepositoryModelImpl repositoryModelImpl = this;
        repositoryModelImpl._originalUuid = repositoryModelImpl._uuid;
        repositoryModelImpl._originalGroupId = repositoryModelImpl._groupId;
        repositoryModelImpl._setOriginalGroupId = false;
        repositoryModelImpl._columnBitmask = 0L;
    }

    public CacheModel<Repository> toCacheModel() {
        String typeSettings;
        String portletId;
        String description;
        Date createDate;
        RepositoryCacheModel repositoryCacheModel = new RepositoryCacheModel();
        repositoryCacheModel.uuid = this.getUuid();
        String uuid = repositoryCacheModel.uuid;
        if (uuid != null && uuid.length() == 0) {
            repositoryCacheModel.uuid = null;
        }
        repositoryCacheModel.repositoryId = this.getRepositoryId();
        repositoryCacheModel.groupId = this.getGroupId();
        repositoryCacheModel.companyId = this.getCompanyId();
        repositoryCacheModel.userId = this.getUserId();
        repositoryCacheModel.userName = this.getUserName();
        String userName = repositoryCacheModel.userName;
        if (userName != null && userName.length() == 0) {
            repositoryCacheModel.userName = null;
        }
        repositoryCacheModel.createDate = (createDate = this.getCreateDate()) != null ? createDate.getTime() : Long.MIN_VALUE;
        Date modifiedDate = this.getModifiedDate();
        repositoryCacheModel.modifiedDate = modifiedDate != null ? modifiedDate.getTime() : Long.MIN_VALUE;
        repositoryCacheModel.classNameId = this.getClassNameId();
        repositoryCacheModel.name = this.getName();
        String name = repositoryCacheModel.name;
        if (name != null && name.length() == 0) {
            repositoryCacheModel.name = null;
        }
        if ((description = (repositoryCacheModel.description = this.getDescription())) != null && description.length() == 0) {
            repositoryCacheModel.description = null;
        }
        if ((portletId = (repositoryCacheModel.portletId = this.getPortletId())) != null && portletId.length() == 0) {
            repositoryCacheModel.portletId = null;
        }
        if ((typeSettings = (repositoryCacheModel.typeSettings = this.getTypeSettings())) != null && typeSettings.length() == 0) {
            repositoryCacheModel.typeSettings = null;
        }
        repositoryCacheModel.dlFolderId = this.getDlFolderId();
        return repositoryCacheModel;
    }

    public String toString() {
        StringBundler sb = new StringBundler(29);
        sb.append("{uuid=");
        sb.append(this.getUuid());
        sb.append(", repositoryId=");
        sb.append(this.getRepositoryId());
        sb.append(", groupId=");
        sb.append(this.getGroupId());
        sb.append(", companyId=");
        sb.append(this.getCompanyId());
        sb.append(", userId=");
        sb.append(this.getUserId());
        sb.append(", userName=");
        sb.append(this.getUserName());
        sb.append(", createDate=");
        sb.append((Object)this.getCreateDate());
        sb.append(", modifiedDate=");
        sb.append((Object)this.getModifiedDate());
        sb.append(", classNameId=");
        sb.append(this.getClassNameId());
        sb.append(", name=");
        sb.append(this.getName());
        sb.append(", description=");
        sb.append(this.getDescription());
        sb.append(", portletId=");
        sb.append(this.getPortletId());
        sb.append(", typeSettings=");
        sb.append(this.getTypeSettings());
        sb.append(", dlFolderId=");
        sb.append(this.getDlFolderId());
        sb.append("}");
        return sb.toString();
    }

    public String toXmlString() {
        StringBundler sb = new StringBundler(46);
        sb.append("<model><model-name>");
        sb.append("com.liferay.portal.model.Repository");
        sb.append("</model-name>");
        sb.append("<column><column-name>uuid</column-name><column-value><![CDATA[");
        sb.append(this.getUuid());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>repositoryId</column-name><column-value><![CDATA[");
        sb.append(this.getRepositoryId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>groupId</column-name><column-value><![CDATA[");
        sb.append(this.getGroupId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>companyId</column-name><column-value><![CDATA[");
        sb.append(this.getCompanyId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>userId</column-name><column-value><![CDATA[");
        sb.append(this.getUserId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>userName</column-name><column-value><![CDATA[");
        sb.append(this.getUserName());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>createDate</column-name><column-value><![CDATA[");
        sb.append((Object)this.getCreateDate());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>modifiedDate</column-name><column-value><![CDATA[");
        sb.append((Object)this.getModifiedDate());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>classNameId</column-name><column-value><![CDATA[");
        sb.append(this.getClassNameId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>name</column-name><column-value><![CDATA[");
        sb.append(this.getName());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>description</column-name><column-value><![CDATA[");
        sb.append(this.getDescription());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>portletId</column-name><column-value><![CDATA[");
        sb.append(this.getPortletId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>typeSettings</column-name><column-value><![CDATA[");
        sb.append(this.getTypeSettings());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>dlFolderId</column-name><column-value><![CDATA[");
        sb.append(this.getDlFolderId());
        sb.append("]]></column-value></column>");
        sb.append("</model>");
        return sb.toString();
    }
}

