/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.RoleConstants;
import com.liferay.portal.model.Team;
import com.liferay.portal.model.impl.RoleBaseImpl;
import com.liferay.portal.service.TeamLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleImpl
extends RoleBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(RoleImpl.class);

    public String getDescriptiveName() throws PortalException, SystemException {
        String name = this.getName();
        if (this.isTeam()) {
            Team team = TeamLocalServiceUtil.getTeam((long)this.getClassPK());
            name = team.getName();
        }
        return name;
    }

    @Override
    public String getTitle(String languageId) {
        String value = super.getTitle(languageId);
        if (Validator.isNull((String)value)) {
            try {
                value = this.getDescriptiveName();
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        }
        return value;
    }

    @Override
    public String getTitle(String languageId, boolean useDefault) {
        String value = super.getTitle(languageId, useDefault);
        if (Validator.isNull((String)value)) {
            try {
                value = this.getDescriptiveName();
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        }
        return value;
    }

    public String getTypeLabel() {
        return RoleConstants.getTypeLabel((int)this.getType());
    }

    public boolean isTeam() {
        return this.hasClassName(Team.class);
    }

    protected boolean hasClassName(Class<?> clazz) {
        long classNameId = this.getClassNameId();
        return classNameId == PortalUtil.getClassNameId(clazz);
    }
}

