/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.module.framework;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogBridge
implements BundleActivator,
LogListener,
ServiceTrackerCustomizer<LogReaderService, LogReaderService> {
    private BundleContext _bundleContext;
    private ServiceTracker<LogReaderService, LogReaderService> _serviceTracker;

    public LogReaderService addingService(ServiceReference<LogReaderService> serviceReference) {
        LogReaderService logReaderService = (LogReaderService)this._bundleContext.getService(serviceReference);
        logReaderService.addLogListener((LogListener)this);
        return logReaderService;
    }

    public void logged(LogEntry logEntry) {
        int level = logEntry.getLevel();
        Bundle bundle = logEntry.getBundle();
        String symbolicName = StringUtil.replace((String)bundle.getSymbolicName(), (String)".", (String)"_");
        Log log = LogFactoryUtil.getLog((String)("osgi.logging." + symbolicName));
        String message = logEntry.getMessage();
        ServiceReference serviceReference = logEntry.getServiceReference();
        if (serviceReference != null) {
            message = String.valueOf(message) + " " + serviceReference.toString();
        }
        if (level == 4 && log.isDebugEnabled()) {
            log.debug((Object)message, logEntry.getException());
        } else if (level == 1 && log.isErrorEnabled()) {
            log.error((Object)message, logEntry.getException());
        } else if (level == 3 && log.isInfoEnabled()) {
            log.info((Object)message, logEntry.getException());
        } else if (level == 2 && log.isWarnEnabled()) {
            log.warn((Object)message, logEntry.getException());
        }
    }

    public void modifiedService(ServiceReference<LogReaderService> serviceReference, LogReaderService logReaderService) {
    }

    public void removedService(ServiceReference<LogReaderService> serviceReference, LogReaderService logReaderService) {
        logReaderService.removeLogListener((LogListener)this);
    }

    public void start(BundleContext bundleContext) throws Exception {
        this._bundleContext = bundleContext;
        this._serviceTracker = new ServiceTracker(bundleContext, LogReaderService.class, (ServiceTrackerCustomizer)this);
        this._serviceTracker.open();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this._serviceTracker.close();
        this._serviceTracker = null;
        this._bundleContext = null;
    }
}

