/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.jmx;

import com.liferay.portal.kernel.monitoring.MonitoringException;
import com.liferay.portal.kernel.monitoring.statistics.SummaryStatistics;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.monitoring.jmx.PortalManagerMBean;
import com.liferay.portal.monitoring.statistics.portal.ServerStatistics;
import java.util.Set;

public class PortalManager
implements PortalManagerMBean {
    private ServerStatistics _serverStatistics;
    private SummaryStatistics _summaryStatistics;

    public long getAverageTime() throws MonitoringException {
        return this._summaryStatistics.getAverageTime();
    }

    public long getAverageTimeByCompany(long companyId) throws MonitoringException {
        return this._summaryStatistics.getAverageTimeByCompany(companyId);
    }

    public long getAverageTimeByCompany(String webId) throws MonitoringException {
        return this._summaryStatistics.getAverageTimeByCompany(webId);
    }

    public long[] getCompanyIds() {
        Set<Long> companyIds = this._serverStatistics.getCompanyIds();
        return ArrayUtil.toArray((Long[])companyIds.toArray(new Long[companyIds.size()]));
    }

    public long getErrorCount() throws MonitoringException {
        return this._summaryStatistics.getErrorCount();
    }

    public long getErrorCountByCompany(long companyId) throws MonitoringException {
        return this._summaryStatistics.getErrorCountByCompany(companyId);
    }

    public long getErrorCountByCompany(String webId) throws MonitoringException {
        return this._summaryStatistics.getErrorCountByCompany(webId);
    }

    public long getMaxTime() throws MonitoringException {
        return this._summaryStatistics.getMaxTime();
    }

    public long getMaxTimeByCompany(long companyId) throws MonitoringException {
        return this._summaryStatistics.getMaxTimeByCompany(companyId);
    }

    public long getMaxTimeByCompany(String webId) throws MonitoringException {
        return this._summaryStatistics.getMaxTimeByCompany(webId);
    }

    public long getMinTime() throws MonitoringException {
        return this._summaryStatistics.getMinTime();
    }

    public long getMinTimeByCompany(long companyId) throws MonitoringException {
        return this._summaryStatistics.getMinTimeByCompany(companyId);
    }

    public long getMinTimeByCompany(String webId) throws MonitoringException {
        return this._summaryStatistics.getMinTimeByCompany(webId);
    }

    public long getRequestCount() throws MonitoringException {
        return this._summaryStatistics.getRequestCount();
    }

    public long getRequestCountByCompany(long companyId) throws MonitoringException {
        return this._summaryStatistics.getRequestCountByCompany(companyId);
    }

    public long getRequestCountByCompany(String webId) throws MonitoringException {
        return this._summaryStatistics.getRequestCountByCompany(webId);
    }

    public long getStartTime(long companyId) throws MonitoringException {
        return this._serverStatistics.getCompanyStatistics(companyId).getStartTime();
    }

    public long getStartTime(String webId) throws MonitoringException {
        return this._serverStatistics.getCompanyStatistics(webId).getStartTime();
    }

    public long getSuccessCount() throws MonitoringException {
        return this._summaryStatistics.getSuccessCount();
    }

    public long getSuccessCountByCompany(long companyId) throws MonitoringException {
        return this._summaryStatistics.getSuccessCountByCompany(companyId);
    }

    public long getSuccessCountByCompany(String webId) throws MonitoringException {
        return this._summaryStatistics.getSuccessCountByCompany(webId);
    }

    public long getTimeoutCount() throws MonitoringException {
        return this._summaryStatistics.getTimeoutCount();
    }

    public long getTimeoutCountByCompany(long companyId) throws MonitoringException {
        return this._summaryStatistics.getTimeoutCountByCompany(companyId);
    }

    public long getTimeoutCountByCompany(String webId) throws MonitoringException {
        return this._summaryStatistics.getTimeoutCountByCompany(webId);
    }

    public long getUptime(long companyId) throws MonitoringException {
        return this._serverStatistics.getCompanyStatistics(companyId).getUptime();
    }

    public long getUptime(String webId) throws MonitoringException {
        return this._serverStatistics.getCompanyStatistics(webId).getUptime();
    }

    public String[] getWebIds() {
        Set<String> webIds = this._serverStatistics.getWebIds();
        return webIds.toArray(new String[webIds.size()]);
    }

    public void reset() {
        this._serverStatistics.reset();
    }

    public void reset(long companyId) {
        this._serverStatistics.reset(companyId);
    }

    public void reset(String webId) {
        this._serverStatistics.reset(webId);
    }

    public void setServerStatistics(ServerStatistics serverStatistics) {
        this._serverStatistics = serverStatistics;
    }

    public void setSummaryStatistics(SummaryStatistics summaryStatistics) {
        this._summaryStatistics = summaryStatistics;
    }
}

