/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.statistics.portlet;

import com.liferay.portal.kernel.monitoring.MonitoringException;
import com.liferay.portal.kernel.monitoring.statistics.DataSampleProcessor;
import com.liferay.portal.model.Company;
import com.liferay.portal.monitoring.statistics.portlet.CompanyStatistics;
import com.liferay.portal.monitoring.statistics.portlet.PortletRequestDataSample;
import com.liferay.portal.service.CompanyLocalService;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerStatistics
implements DataSampleProcessor<PortletRequestDataSample> {
    private CompanyLocalService _companyLocalService;
    private Map<Long, CompanyStatistics> _companyStatisticsByCompanyId = new TreeMap<Long, CompanyStatistics>();
    private Map<String, CompanyStatistics> _companyStatisticsByWebId = new TreeMap<String, CompanyStatistics>();

    public void afterPropertiesSet() {
        CompanyStatistics systemCompanyStatistics = new CompanyStatistics();
        this._companyStatisticsByCompanyId.put(systemCompanyStatistics.getCompanyId(), systemCompanyStatistics);
        this._companyStatisticsByWebId.put(systemCompanyStatistics.getWebId(), systemCompanyStatistics);
    }

    public Set<Long> getCompanyIds() {
        return this._companyStatisticsByCompanyId.keySet();
    }

    public CompanyStatistics getCompanyStatistics(long companyId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._companyStatisticsByCompanyId.get(companyId);
        if (companyStatistics == null) {
            throw new MonitoringException("No statistics found for company id " + companyId);
        }
        return companyStatistics;
    }

    public CompanyStatistics getCompanyStatistics(String webId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._companyStatisticsByWebId.get(webId);
        if (companyStatistics == null) {
            throw new MonitoringException("No statistics found for web id " + webId);
        }
        return companyStatistics;
    }

    public Set<CompanyStatistics> getCompanyStatisticsSet() {
        return new HashSet<CompanyStatistics>(this._companyStatisticsByWebId.values());
    }

    public Set<String> getPortletIds() {
        HashSet<String> portletIds = new HashSet<String>();
        for (CompanyStatistics containerStatistics : this._companyStatisticsByWebId.values()) {
            portletIds.addAll(containerStatistics.getPortletIds());
        }
        return portletIds;
    }

    public Set<String> getWebIds() {
        return this._companyStatisticsByWebId.keySet();
    }

    public void processDataSample(PortletRequestDataSample portletRequestDataSample) throws MonitoringException {
        long companyId = portletRequestDataSample.getCompanyId();
        CompanyStatistics companyStatistics = this._companyStatisticsByCompanyId.get(companyId);
        if (companyStatistics == null) {
            try {
                Company company = this._companyLocalService.getCompany(companyId);
                companyStatistics = this.register(company.getWebId());
            }
            catch (Exception e2) {
                throw new IllegalStateException("Unable to get company with company id " + companyId, e2);
            }
        }
        companyStatistics.processDataSample(portletRequestDataSample);
    }

    public synchronized CompanyStatistics register(String webId) {
        CompanyStatistics companyStatistics = new CompanyStatistics(this._companyLocalService, webId);
        this._companyStatisticsByCompanyId.put(companyStatistics.getCompanyId(), companyStatistics);
        this._companyStatisticsByWebId.put(webId, companyStatistics);
        return companyStatistics;
    }

    public void reset() {
        for (long companyId : this._companyStatisticsByCompanyId.keySet()) {
            this.reset(companyId);
        }
    }

    public void reset(long companyId) {
        CompanyStatistics companyStatistics = this._companyStatisticsByCompanyId.get(companyId);
        if (companyStatistics == null) {
            return;
        }
        companyStatistics.reset();
    }

    public void reset(String webId) {
        CompanyStatistics companyStatistics = this._companyStatisticsByWebId.get(webId);
        if (companyStatistics == null) {
            return;
        }
        companyStatistics.reset();
    }

    public void setCompanyLocalService(CompanyLocalService companyLocalService) {
        this._companyLocalService = companyLocalService;
    }

    public synchronized void unregister(String webId) {
        CompanyStatistics companyStatistics = this._companyStatisticsByWebId.remove(webId);
        if (companyStatistics != null) {
            this._companyStatisticsByCompanyId.remove(companyStatistics.getCompanyId());
        }
    }
}

