/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.statistics.service;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.monitoring.MonitoringProcessor;
import com.liferay.portal.kernel.monitoring.RequestStatus;
import com.liferay.portal.kernel.monitoring.statistics.DataSample;
import com.liferay.portal.kernel.monitoring.statistics.DataSampleThreadLocal;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.monitoring.statistics.service.ServiceRequestDataSample;
import com.liferay.portal.spring.aop.ChainableMethodAdvice;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.aopalliance.intercept.MethodInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceMonitorAdvice
extends ChainableMethodAdvice {
    private static ThreadLocal<ServiceRequestDataSample> _serviceRequestDataSampleThreadLocal = new AutoResetThreadLocal(ServiceRequestDataSample.class + "._serviceRequestDataSampleThreadLocal");
    private static boolean _active;
    private static Set<String> _monitoredClasses;
    private static Set<MethodKey> _monitoredMethods;
    private static String _monitoringDestinationName;
    private static boolean _permissiveMode;

    static {
        _monitoredClasses = new HashSet<String>();
        _monitoredMethods = new HashSet<MethodKey>();
    }

    public static ServiceMonitorAdvice getInstance() {
        return new ServiceMonitorAdvice();
    }

    public void addMonitoredClass(String className) {
        _monitoredClasses.add(className);
    }

    public void addMonitoredMethod(String className, String methodName, String[] parameterTypes) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(className, methodName, parameterTypes);
            _monitoredMethods.add(methodKey);
        }
        catch (ClassNotFoundException cnfe) {
            throw new SystemException("Unable to add method", (Throwable)cnfe);
        }
    }

    @Override
    public void afterReturning(MethodInvocation methodInvocation, Object result) throws Throwable {
        ServiceRequestDataSample serviceRequestDataSample = _serviceRequestDataSampleThreadLocal.get();
        if (serviceRequestDataSample != null) {
            serviceRequestDataSample.capture(RequestStatus.SUCCESS);
        }
    }

    @Override
    public boolean afterThrowing(MethodInvocation methodInvocation, Throwable throwable) throws Throwable {
        ServiceRequestDataSample serviceRequestDataSample = _serviceRequestDataSampleThreadLocal.get();
        if (serviceRequestDataSample != null) {
            serviceRequestDataSample.capture(RequestStatus.ERROR);
        }
        return true;
    }

    @Override
    public Object before(MethodInvocation methodInvocation) throws Throwable {
        if (!_active) {
            return null;
        }
        Object thisObject = methodInvocation.getThis();
        Class<?> clazz = thisObject.getClass();
        Class<?>[] interfaces = clazz.getInterfaces();
        int i2 = 0;
        while (i2 < interfaces.length) {
            if (interfaces[i2].isAssignableFrom(MonitoringProcessor.class)) {
                return null;
            }
            ++i2;
        }
        if (!_permissiveMode && !this.isMonitored(methodInvocation)) {
            return null;
        }
        ServiceRequestDataSample serviceRequestDataSample = new ServiceRequestDataSample(methodInvocation);
        serviceRequestDataSample.prepare();
        _serviceRequestDataSampleThreadLocal.set(serviceRequestDataSample);
        return null;
    }

    @Override
    public void duringFinally(MethodInvocation methodInvocation) {
        ServiceRequestDataSample serviceRequestDataSample = _serviceRequestDataSampleThreadLocal.get();
        if (serviceRequestDataSample != null) {
            _serviceRequestDataSampleThreadLocal.remove();
            DataSampleThreadLocal.addDataSample((DataSample)serviceRequestDataSample);
            MessageBusUtil.sendMessage((String)_monitoringDestinationName, (Object)serviceRequestDataSample);
        }
    }

    public Set<String> getMonitoredClasses() {
        return _monitoredClasses;
    }

    public Set<MethodKey> getMonitoredMethods() {
        return _monitoredMethods;
    }

    public String getMonitoringDestinationName() {
        return _monitoringDestinationName;
    }

    public boolean isActive() {
        return _active;
    }

    public boolean isPermissiveMode() {
        return _permissiveMode;
    }

    public void setActive(boolean active) {
        _active = active;
    }

    public void setMonitoredClasses(Set<String> monitoredClasses) {
        _monitoredClasses = monitoredClasses;
    }

    public void setMonitoredMethods(Set<MethodKey> monitoredMethods) {
        _monitoredMethods = monitoredMethods;
    }

    public void setMonitoringDestinationName(String monitoringDestinationName) {
        _monitoringDestinationName = monitoringDestinationName;
    }

    public void setPermissiveMode(boolean permissiveMode) {
        _permissiveMode = permissiveMode;
    }

    protected boolean isMonitored(MethodInvocation methodInvocation) {
        Class[] parameterTypes;
        Method method = methodInvocation.getMethod();
        Class<?> declaringClass = method.getDeclaringClass();
        String className = declaringClass.getName();
        if (_monitoredClasses.contains(className)) {
            return true;
        }
        String methodName = method.getName();
        MethodKey methodKey = new MethodKey(className, methodName, parameterTypes = method.getParameterTypes());
        return _monitoredMethods.contains(methodKey);
    }
}

