/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.parsers.bbcode;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.IntegerWrapper;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.parsers.bbcode.BBCodeItem;
import com.liferay.portal.parsers.bbcode.BBCodeLexer;
import com.liferay.portal.parsers.bbcode.BBCodeToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBCodeParser {
    public static final int TYPE_DATA = 4;
    public static final int TYPE_TAG_END = 2;
    public static final int TYPE_TAG_START = 1;
    public static final int TYPE_TAG_START_END = 3;
    private Set<String> _blockElements = SetUtil.fromArray((Object[])new String[]{"*", "center", "code", "justify", "left", "li", "list", "q", "quote", "right", "table", "td", "th", "tr"});
    private Set<String> _inlineElements = SetUtil.fromArray((Object[])new String[]{"b", "color", "font", "i", "img", "s", "size", "u", "url"});
    private Set<String> _selfCloseElements = SetUtil.fromArray((Object[])new String[]{"*"});

    public List<BBCodeItem> parse(String text) {
        ArrayList<BBCodeItem> bbCodeItems = new ArrayList<BBCodeItem>();
        BBCodeLexer bbCodeLexer = new BBCodeLexer(text);
        Stack<String> tags = new Stack<String>();
        IntegerWrapper marker = new IntegerWrapper();
        BBCodeToken bbCodeToken = null;
        while ((bbCodeToken = bbCodeLexer.getNextBBCodeToken()) != null) {
            String endTag;
            this.handleData(bbCodeItems, bbCodeLexer, marker, bbCodeToken, text);
            if (bbCodeToken.getStartTag() == null) {
                this.handleTagEnd(bbCodeItems, tags, bbCodeToken);
                continue;
            }
            this.handleTagStart(bbCodeItems, tags, bbCodeToken);
            String startTag = bbCodeToken.getStartTag();
            if (!startTag.equals("code")) continue;
            while ((bbCodeToken = bbCodeLexer.getNextBBCodeToken()) != null && !(endTag = GetterUtil.getString((String)bbCodeToken.getEndTag())).equals("code")) {
            }
            this.handleData(bbCodeItems, bbCodeLexer, marker, bbCodeToken, text);
            if (bbCodeToken == null) break;
            this.handleTagEnd(bbCodeItems, tags, bbCodeToken);
        }
        this.handleData(bbCodeItems, bbCodeLexer, marker, null, text);
        this.handleTagEnd(bbCodeItems, tags, null);
        return bbCodeItems;
    }

    protected void handleData(List<BBCodeItem> bbCodeItems, BBCodeLexer bbCodeLexer, IntegerWrapper marker, BBCodeToken bbCodeToken, String data) {
        int length;
        int lastIndex = length = data.length();
        if (bbCodeToken != null) {
            length = bbCodeToken.getStart();
            lastIndex = bbCodeLexer.getLastIndex();
        }
        if (length > marker.getValue()) {
            BBCodeItem bbCodeItem = new BBCodeItem(4, null, data.substring(marker.getValue(), length));
            bbCodeItems.add(bbCodeItem);
        }
        marker.setValue(lastIndex);
    }

    protected void handleTagEnd(List<BBCodeItem> bbCodeItems, Stack<String> tags, BBCodeToken bbCodeToken) {
        int size = 0;
        if (bbCodeToken != null) {
            String endTag = bbCodeToken.getEndTag();
            size = tags.size() - 1;
            while (size >= 0) {
                if (endTag.equals(tags.elementAt(size))) break;
                --size;
            }
        }
        if (size >= 0) {
            int i2 = tags.size() - 1;
            while (i2 >= size) {
                BBCodeItem bbCodeItem = new BBCodeItem(2, null, (String)tags.elementAt(i2));
                bbCodeItems.add(bbCodeItem);
                --i2;
            }
            tags.setSize(size);
        }
    }

    protected void handleTagStart(List<BBCodeItem> bbCodeItems, Stack<String> tags, BBCodeToken bbCodeToken) {
        String startTag = bbCodeToken.getStartTag();
        if (this._blockElements.contains(startTag)) {
            String currentTag = null;
            while (!tags.isEmpty() && (currentTag = (String)tags.lastElement()) != null && this._inlineElements.contains(currentTag)) {
                BBCodeToken currentTagBBCodeToken = new BBCodeToken(currentTag);
                this.handleTagEnd(bbCodeItems, tags, currentTagBBCodeToken);
            }
        }
        if (this._selfCloseElements.contains(startTag) && startTag.equals(tags.lastElement())) {
            BBCodeToken tagBBCodeToken = new BBCodeToken(startTag);
            this.handleTagEnd(bbCodeItems, tags, tagBBCodeToken);
        }
        tags.push(startTag);
        BBCodeItem bbCodeItem = new BBCodeItem(1, bbCodeToken.getAttribute(), startTag);
        bbCodeItems.add(bbCodeItem);
    }
}

