/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.parsers.bbcode;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.parsers.bbcode.BBCodeTranslator;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.IntegerWrapper;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.parsers.bbcode.BBCodeItem;
import com.liferay.portal.parsers.bbcode.BBCodeParser;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlBBCodeTranslatorImpl
implements BBCodeTranslator {
    private static final String[][] _EMOTICONS = new String[][]{{"happy.gif", ":)", "happy"}, {"smile.gif", ":D", "smile"}, {"cool.gif", "B)", "cool"}, {"sad.gif", ":(", "sad"}, {"tongue.gif", ":P", "tongue"}, {"laugh.gif", ":lol:", "laugh"}, {"kiss.gif", ":#", "kiss"}, {"blush.gif", ":*)", "blush"}, {"bashful.gif", ":bashful:", "bashful"}, {"smug.gif", ":smug:", "smug"}, {"blink.gif", ":blink:", "blink"}, {"huh.gif", ":huh:", "huh"}, {"mellow.gif", ":mellow:", "mellow"}, {"unsure.gif", ":unsure:", "unsure"}, {"mad.gif", ":mad:", "mad"}, {"oh_my.gif", ":O", "oh-my-goodness"}, {"roll_eyes.gif", ":rolleyes:", "roll-eyes"}, {"angry.gif", ":angry:", "angry"}, {"suspicious.gif", "8o", "suspicious"}, {"big_grin.gif", ":grin:", "grin"}, {"in_love.gif", ":love:", "in-love"}, {"bored.gif", ":bored:", "bored"}, {"closed_eyes.gif", "-_-", "closed-eyes"}, {"cold.gif", ":cold:", "cold"}, {"sleep.gif", ":sleep:", "sleep"}, {"glare.gif", ":glare:", "glare"}, {"darth_vader.gif", ":vader:", "darth-vader"}, {"dry.gif", ":dry:", "dry"}, {"exclamation.gif", ":what:", "what"}, {"girl.gif", ":girl:", "girl"}, {"karate_kid.gif", ":kid:", "karate-kid"}, {"ninja.gif", ":ph34r:", "ninja"}, {"pac_man.gif", ":V", "pac-man"}, {"wacko.gif", ":wacko:", "wacko"}, {"wink.gif", ":wink:", "wink"}, {"wub.gif", ":wub:", "wub"}};
    private static Log _log = LogFactoryUtil.getLog(HtmlBBCodeTranslatorImpl.class);
    private Map<String, String> _bbCodeCharacters;
    private BBCodeParser _bbCodeParser = new BBCodeParser();
    private Pattern _bbCodePattern = Pattern.compile("[]&<>'\"`\\[()]");
    private Pattern _colorPattern = Pattern.compile("^(:?aqua|black|blue|fuchsia|gray|green|lime|maroon|navy|olive|purple|red|silver|teal|white|yellow|#(?:[0-9a-f]{3})?[0-9a-f]{3})$", 2);
    private String[] _emoticonDescriptions = new String[_EMOTICONS.length];
    private String[] _emoticonFiles = new String[_EMOTICONS.length];
    private String[] _emoticonSymbols = new String[_EMOTICONS.length];
    private Map<String, Integer> _excludeNewLineTypes;
    private int[] _fontSizes = new int[]{10, 12, 16, 18, 24, 32, 48};
    private Pattern _imagePattern = Pattern.compile("^(?:https?://|/)[-;/?:@&=+$,_.!~*'()%0-9a-z]{1,512}$", 2);
    private Map<String, String> _listStyles;
    private Pattern _tagPattern = Pattern.compile("^/?(?:b|center|code|colou?r|email|i|img|justify|left|pre|q|quote|right|\\*|s|size|table|tr|th|td|li|list|font|u|url)$", 2);
    private Pattern _urlPattern = Pattern.compile("^[-;/?:@&=+$,_.!~*'()%0-9a-z#]{1,512}$", 2);

    public HtmlBBCodeTranslatorImpl() {
        this._listStyles = new HashMap<String, String>();
        this._listStyles.put("a", "list-style: lower-alpha inside;");
        this._listStyles.put("A", "list-style: upper-alpha inside;");
        this._listStyles.put("1", "list-style: decimal inside;");
        this._listStyles.put("i", "list-style: lower-roman inside;");
        this._listStyles.put("I", "list-style: upper-roman inside;");
        this._excludeNewLineTypes = new HashMap<String, Integer>();
        this._excludeNewLineTypes.put("*", 3);
        this._excludeNewLineTypes.put("li", 3);
        this._excludeNewLineTypes.put("table", 2);
        this._excludeNewLineTypes.put("td", 3);
        this._excludeNewLineTypes.put("th", 3);
        this._excludeNewLineTypes.put("tr", 3);
        this._bbCodeCharacters = new HashMap<String, String>();
        this._bbCodeCharacters.put("&", "&amp;");
        this._bbCodeCharacters.put("<", "&lt;");
        this._bbCodeCharacters.put(">", "&gt;");
        this._bbCodeCharacters.put("\"", "&#034;");
        this._bbCodeCharacters.put("'", "&#039;");
        this._bbCodeCharacters.put("/", "&#047;");
        this._bbCodeCharacters.put("`", "&#096;");
        this._bbCodeCharacters.put("[", "&#91;");
        this._bbCodeCharacters.put("]", "&#93;");
        this._bbCodeCharacters.put("(", "&#40;");
        this._bbCodeCharacters.put(")", "&#41;");
        int i2 = 0;
        while (i2 < _EMOTICONS.length) {
            String[] emoticon = _EMOTICONS[i2];
            this._emoticonDescriptions[i2] = emoticon[2];
            this._emoticonFiles[i2] = emoticon[0];
            this._emoticonSymbols[i2] = emoticon[1];
            String image = emoticon[0];
            emoticon[0] = "<img alt=\"emoticon\" src=\"@theme_images_path@/emoticons/" + image + "\" >";
            ++i2;
        }
    }

    public String[] getEmoticonDescriptions() {
        return this._emoticonDescriptions;
    }

    public String[] getEmoticonFiles() {
        return this._emoticonFiles;
    }

    public String[][] getEmoticons() {
        return _EMOTICONS;
    }

    public String[] getEmoticonSymbols() {
        return this._emoticonSymbols;
    }

    public String getHTML(String bbcode) {
        try {
            bbcode = this.parse(bbcode);
        }
        catch (Exception e2) {
            _log.error((Object)("Unable to parse: " + bbcode), (Throwable)e2);
            bbcode = HtmlUtil.escape((String)bbcode);
        }
        return bbcode;
    }

    public String parse(String text) {
        StringBundler sb = new StringBundler();
        List<BBCodeItem> bbCodeItems = this._bbCodeParser.parse(text);
        Stack<String> tags = new Stack<String>();
        IntegerWrapper marker = new IntegerWrapper();
        while (marker.getValue() < bbCodeItems.size()) {
            BBCodeItem bbCodeItem = bbCodeItems.get(marker.getValue());
            int type = bbCodeItem.getType();
            if (type == 4) {
                this.handleData(sb, bbCodeItems, tags, marker, bbCodeItem);
            } else if (type == 2) {
                this.handleTagEnd(sb, tags, bbCodeItem);
            } else if (type == 1) {
                this.handleTagStart(sb, bbCodeItems, tags, marker, bbCodeItem);
            }
            marker.increment();
        }
        return sb.toString();
    }

    protected String escapeQuote(String quote) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        Matcher matcher = this._bbCodePattern.matcher(quote);
        Collection<String> values = this._bbCodeCharacters.values();
        while (matcher.find()) {
            String value;
            String match = matcher.group();
            int matchStartIndex = matcher.start();
            int nextSemicolonIndex = quote.indexOf(";", matchStartIndex);
            sb.append(quote.substring(index, matchStartIndex));
            boolean entityFound = false;
            if (nextSemicolonIndex >= 0 && values.contains(value = quote.substring(matchStartIndex, nextSemicolonIndex + 1))) {
                sb.append(value);
                index = matchStartIndex + value.length();
                entityFound = true;
            }
            if (entityFound) continue;
            String escapedValue = this._bbCodeCharacters.get(match);
            sb.append(escapedValue);
            index = matchStartIndex + match.length();
        }
        if (index < quote.length()) {
            sb.append(quote.substring(index, quote.length()));
        }
        return sb.toString();
    }

    protected String extractData(List<BBCodeItem> bbCodeItems, IntegerWrapper marker, String tag, int type, boolean consume) {
        StringBundler sb = new StringBundler();
        int index = marker.getValue() + 1;
        BBCodeItem bbCodeItem = null;
        do {
            if (((bbCodeItem = bbCodeItems.get(index++)).getType() & type) <= 0) continue;
            sb.append(bbCodeItem.getValue());
        } while (bbCodeItem.getType() != 2 && !tag.equals(bbCodeItem.getValue()));
        if (consume) {
            marker.setValue(index - 1);
        }
        return sb.toString();
    }

    protected void handleBold(StringBundler sb, Stack<String> tags) {
        this.handleSimpleTag(sb, tags, "strong");
    }

    protected void handleCode(StringBundler sb, List<BBCodeItem> bbCodeItems, IntegerWrapper marker) {
        sb.append("<div class=\"code\">");
        String code = this.extractData(bbCodeItems, marker, "code", 4, true);
        code = HtmlUtil.escape((String)code);
        code = code.replaceAll("\t", "    ");
        String[] lines = code.split("\r?\n");
        String digits = String.valueOf(lines.length + 1);
        int i2 = 0;
        while (i2 < lines.length) {
            String index = String.valueOf(i2 + 1);
            sb.append("<span class=\"code-lines\">");
            int j = 0;
            while (j < digits.length() - index.length()) {
                sb.append("&nbsp;");
                ++j;
            }
            lines[i2] = StringUtil.replace((String)lines[i2], (String)"   ", (String)"&nbsp; &nbsp;");
            lines[i2] = StringUtil.replace((String)lines[i2], (String)"  ", (String)"&nbsp; ");
            sb.append(index);
            sb.append("</span>");
            sb.append(lines[i2]);
            if (index.length() < lines.length) {
                sb.append("<br />");
            }
            ++i2;
        }
        sb.append("</div>");
    }

    protected void handleColor(StringBundler sb, Stack<String> tags, BBCodeItem bbCodeItem) {
        sb.append("<span style=\"color: ");
        String color = bbCodeItem.getAttribute();
        if (color == null) {
            color = "inherit";
        } else {
            Matcher matcher = this._colorPattern.matcher(color);
            if (!matcher.matches()) {
                color = "inherit";
            }
        }
        sb.append(color);
        sb.append("\">");
        tags.push("</span>");
    }

    protected void handleData(StringBundler sb, List<BBCodeItem> bbCodeItems, Stack<String> tags, IntegerWrapper marker, BBCodeItem bbCodeItem) {
        String value = HtmlUtil.escape((String)bbCodeItem.getValue());
        value = this.handleNewLine(bbCodeItems, tags, marker, value);
        int i2 = 0;
        while (i2 < _EMOTICONS.length) {
            String[] emoticon = _EMOTICONS[i2];
            value = StringUtil.replace((String)value, (String)emoticon[1], (String)emoticon[0]);
            ++i2;
        }
        sb.append(value);
    }

    protected void handleEmail(StringBundler sb, List<BBCodeItem> bbCodeItems, Stack<String> tags, IntegerWrapper marker, BBCodeItem bbCodeItem) {
        sb.append("<a href=\"");
        String href = bbCodeItem.getAttribute();
        if (href == null) {
            href = this.extractData(bbCodeItems, marker, "email", 4, false);
        }
        if (!href.startsWith("mailto:")) {
            href = "mailto:" + href;
        }
        sb.append(HtmlUtil.escapeHREF((String)href));
        sb.append("\">");
        tags.push("</a>");
    }

    protected void handleFontFamily(StringBundler sb, Stack<String> tags, BBCodeItem bbCodeItem) {
        sb.append("<span style=\"font-family: ");
        sb.append(HtmlUtil.escapeAttribute((String)bbCodeItem.getAttribute()));
        sb.append("\">");
        tags.push("</span>");
    }

    protected void handleFontSize(StringBundler sb, Stack<String> tags, BBCodeItem bbCodeItem) {
        sb.append("<span style=\"font-size: ");
        int size = GetterUtil.getInteger((String)bbCodeItem.getAttribute());
        if (size >= 1 && size <= this._fontSizes.length) {
            sb.append(this._fontSizes[size - 1]);
        } else {
            sb.append(this._fontSizes[1]);
        }
        sb.append("px\">");
        tags.push("</span>");
    }

    protected void handleImage(StringBundler sb, List<BBCodeItem> bbCodeItems, IntegerWrapper marker) {
        sb.append("<img src=\"");
        String src = this.extractData(bbCodeItems, marker, "img", 4, true);
        Matcher matcher = this._imagePattern.matcher(src);
        if (matcher.matches()) {
            sb.append(HtmlUtil.escapeAttribute((String)src));
        }
        sb.append("\" />");
    }

    protected void handleItalic(StringBundler sb, Stack<String> tags) {
        this.handleSimpleTag(sb, tags, "em");
    }

    protected void handleList(StringBundler sb, Stack<String> tags, BBCodeItem bbCodeItem) {
        String listStyle = null;
        String tag = null;
        String listAttribute = bbCodeItem.getAttribute();
        if (listAttribute != null) {
            listStyle = this._listStyles.get(listAttribute);
            tag = "ol";
        } else {
            tag = "ul style=\"list-style: disc inside;\"";
        }
        if (listStyle == null) {
            sb.append("<");
            sb.append(tag);
            sb.append(">");
        } else {
            sb.append("<");
            sb.append(tag);
            sb.append(" style=\"");
            sb.append(listStyle);
            sb.append("\">");
        }
        tags.push("</" + tag + ">");
    }

    protected void handleListItem(StringBundler sb, Stack<String> tags) {
        this.handleSimpleTag(sb, tags, "li");
    }

    protected String handleNewLine(List<BBCodeItem> bbCodeItems, Stack<String> tags, IntegerWrapper marker, String data) {
        String value;
        BBCodeItem bbCodeItem = null;
        if (data.matches("\\A\r?\n\\z")) {
            int excludeNewLineType;
            int type;
            String value2;
            bbCodeItem = bbCodeItems.get(marker.getValue() + 1);
            if (bbCodeItem != null && this._excludeNewLineTypes.containsKey(value2 = bbCodeItem.getValue()) && ((type = bbCodeItem.getType()) & (excludeNewLineType = this._excludeNewLineTypes.get(value2).intValue())) > 0) {
                data = "";
            }
        } else if (data.matches("(?s).*\r?\n\\z") && (bbCodeItem = bbCodeItems.get(marker.getValue() + 1)) != null && bbCodeItem.getType() == 2 && (value = bbCodeItem.getValue()).equals("*")) {
            data = data.substring(0, data.length() - 1);
        }
        if (data.length() > 0) {
            data = data.replaceAll("\r?\n", "<br />");
        }
        return data;
    }

    protected void handleQuote(StringBundler sb, Stack<String> tags, BBCodeItem bbCodeItem) {
        String quote = bbCodeItem.getAttribute();
        if (quote != null && quote.length() > 0) {
            sb.append("<div class=\"quote-title\">");
            sb.append(this.escapeQuote(quote));
            sb.append(":</div>");
        }
        sb.append("<div class=\"quote\"><div class=\"quote-content\">");
        tags.push("</div></div>");
    }

    protected void handleSimpleTag(StringBundler sb, Stack<String> tags, BBCodeItem bbCodeItem) {
        this.handleSimpleTag(sb, tags, bbCodeItem.getValue());
    }

    protected void handleSimpleTag(StringBundler sb, Stack<String> tags, String tag) {
        sb.append("<");
        sb.append(tag);
        sb.append(">");
        tags.push("</" + tag + ">");
    }

    protected void handleStrikeThrough(StringBundler sb, Stack<String> tags) {
        this.handleSimpleTag(sb, tags, "strike");
    }

    protected void handleTable(StringBundler sb, Stack<String> tags) {
        this.handleSimpleTag(sb, tags, "table");
    }

    protected void handleTableCell(StringBundler sb, Stack<String> tags) {
        this.handleSimpleTag(sb, tags, "td");
    }

    protected void handleTableHeader(StringBundler sb, Stack<String> tags) {
        this.handleSimpleTag(sb, tags, "th");
    }

    protected void handleTableRow(StringBundler sb, Stack<String> tags) {
        this.handleSimpleTag(sb, tags, "tr");
    }

    protected void handleTagEnd(StringBundler sb, Stack<String> tags, BBCodeItem bbCodeItem) {
        String tag = bbCodeItem.getValue();
        if (this.isValidTag(tag)) {
            sb.append(tags.pop());
        }
    }

    protected void handleTagStart(StringBundler sb, List<BBCodeItem> bbCodeItems, Stack<String> tags, IntegerWrapper marker, BBCodeItem bbCodeItem) {
        String tag = bbCodeItem.getValue();
        if (!this.isValidTag(tag)) {
            return;
        }
        if (tag.equals("b")) {
            this.handleBold(sb, tags);
        } else if (tag.equals("center") || tag.equals("justify") || tag.equals("left") || tag.equals("right")) {
            this.handleTextAlign(sb, tags, bbCodeItem);
        } else if (tag.equals("code")) {
            this.handleCode(sb, bbCodeItems, marker);
        } else if (tag.equals("color") || tag.equals("colour")) {
            this.handleColor(sb, tags, bbCodeItem);
        } else if (tag.equals("email")) {
            this.handleEmail(sb, bbCodeItems, tags, marker, bbCodeItem);
        } else if (tag.equals("font")) {
            this.handleFontFamily(sb, tags, bbCodeItem);
        } else if (tag.equals("i")) {
            this.handleItalic(sb, tags);
        } else if (tag.equals("img")) {
            this.handleImage(sb, bbCodeItems, marker);
        } else if (tag.equals("li") || tag.equals("*")) {
            this.handleListItem(sb, tags);
        } else if (tag.equals("list")) {
            this.handleList(sb, tags, bbCodeItem);
        } else if (tag.equals("q") || tag.equals("quote")) {
            this.handleQuote(sb, tags, bbCodeItem);
        } else if (tag.equals("s")) {
            this.handleStrikeThrough(sb, tags);
        } else if (tag.equals("size")) {
            this.handleFontSize(sb, tags, bbCodeItem);
        } else if (tag.equals("table")) {
            this.handleTable(sb, tags);
        } else if (tag.equals("td")) {
            this.handleTableCell(sb, tags);
        } else if (tag.equals("th")) {
            this.handleTableHeader(sb, tags);
        } else if (tag.equals("tr")) {
            this.handleTableRow(sb, tags);
        } else if (tag.equals("url")) {
            this.handleURL(sb, bbCodeItems, tags, marker, bbCodeItem);
        } else {
            this.handleSimpleTag(sb, tags, bbCodeItem);
        }
    }

    protected void handleTextAlign(StringBundler sb, Stack<String> tags, BBCodeItem bbCodeItem) {
        sb.append("<p style=\"text-align: ");
        sb.append(bbCodeItem.getValue());
        sb.append("\">");
        tags.push("</p>");
    }

    protected void handleURL(StringBundler sb, List<BBCodeItem> bbCodeItems, Stack<String> tags, IntegerWrapper marker, BBCodeItem bbCodeItem) {
        Matcher matcher;
        sb.append("<a href=\"");
        String href = bbCodeItem.getAttribute();
        if (href == null) {
            href = this.extractData(bbCodeItems, marker, "url", 4, false);
        }
        if ((matcher = this._urlPattern.matcher(href)).matches()) {
            sb.append(HtmlUtil.escapeHREF((String)href));
        }
        sb.append("\">");
        tags.push("</a>");
    }

    protected boolean isValidTag(String tag) {
        if (tag != null && tag.length() > 0) {
            Matcher matcher = this._tagPattern.matcher(tag);
            return matcher.matches();
        }
        return false;
    }
}

