/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.poller;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.poller.DefaultPollerResponse;
import com.liferay.portal.kernel.poller.PollerHeader;
import com.liferay.portal.kernel.poller.PollerProcessor;
import com.liferay.portal.kernel.poller.PollerRequest;
import com.liferay.portal.kernel.poller.PollerResponse;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.model.BrowserTracker;
import com.liferay.portal.model.Company;
import com.liferay.portal.poller.PollerProcessorUtil;
import com.liferay.portal.poller.PollerRequestHandler;
import com.liferay.portal.poller.PollerRequestResponsePair;
import com.liferay.portal.poller.PollerSession;
import com.liferay.portal.service.BrowserTrackerLocalServiceUtil;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.util.Encryptor;
import java.security.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollerRequestHandlerImpl
implements PollerRequestHandler,
MessageListener {
    private static final String _ESCAPED_CLOSE_CURLY_BRACE = "[$CLOSE_CURLY_BRACE$]";
    private static final String _ESCAPED_OPEN_CURLY_BRACE = "[$OPEN_CURLY_BRACE$]";
    private static final String _OPEN_HASH_MAP_WRAPPER = "{\"javaClass\":\"java.util.HashMap\",\"map\":{";
    private static final String _PATH_RECEIVE = "/receive";
    private static Log _log = LogFactoryUtil.getLog(PollerRequestHandlerImpl.class);
    private Map<String, PollerSession> _pollerSessions = new HashMap<String, PollerSession>();

    @Override
    public PollerHeader getPollerHeader(String pollerRequestString) {
        if (Validator.isNull((String)pollerRequestString)) {
            return null;
        }
        Map<String, Object>[] pollerRequestChunks = this.parsePollerRequestParameters(pollerRequestString);
        return this.parsePollerRequestHeader(pollerRequestChunks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject processRequest(HttpServletRequest request, String pollerRequestString) throws Exception {
        if (Validator.isNull((String)pollerRequestString)) {
            return null;
        }
        Map<String, Object>[] pollerRequestChunks = this.parsePollerRequestParameters(pollerRequestString);
        PollerHeader pollerHeader = this.parsePollerRequestHeader(pollerRequestChunks);
        if (pollerHeader == null) {
            return null;
        }
        boolean receiveRequest = this.isReceiveRequest(request.getPathInfo());
        String pollerSessionId = this.getPollerSessionId(pollerHeader);
        PollerSession pollerSession = null;
        Map<String, PollerSession> map = this._pollerSessions;
        synchronized (map) {
            pollerSession = this._pollerSessions.get(pollerSessionId);
            if (pollerSession == null && receiveRequest) {
                pollerSession = new PollerSession(pollerSessionId);
                this._pollerSessions.put(pollerSessionId, pollerSession);
            }
        }
        List<PollerRequest> pollerRequests = this.createPollerRequests(request, pollerHeader, pollerRequestChunks, receiveRequest);
        this.executePollerRequests(pollerSession, pollerRequests);
        if (receiveRequest) {
            return this.createPollerResponseHeader(pollerHeader);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(Message message) {
        Object messagePayload = message.getPayload();
        if (!(messagePayload instanceof PollerResponse)) {
            return;
        }
        PollerResponse pollerResponse = (PollerResponse)messagePayload;
        PollerHeader pollerHeader = pollerResponse.getPollerHeader();
        String pollerSessionId = this.getPollerSessionId(pollerHeader);
        Map<String, PollerSession> map = this._pollerSessions;
        synchronized (map) {
            PollerSession pollerSession = this._pollerSessions.get(pollerSessionId);
            if (pollerSession != null && pollerSession.completePortletProcessing(pollerResponse.getPortletId(), message.getResponseId())) {
                this._pollerSessions.remove(pollerSessionId);
            }
        }
    }

    protected PollerRequest createPollerRequest(HttpServletRequest request, boolean receiveRequest, PollerHeader pollerHeader, String portletId) throws Exception {
        return this.createPollerRequest(request, receiveRequest, pollerHeader, portletId, new HashMap<String, String>(), null);
    }

    protected PollerRequest createPollerRequest(HttpServletRequest request, boolean receiveRequest, PollerHeader pollerHeader, String portletId, Map<String, String> parameterMap, String chunkId) throws Exception {
        PollerProcessor pollerProcessor = PollerProcessorUtil.getPollerProcessor(portletId);
        if (pollerProcessor == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Poller processor not found for portlet " + portletId));
            }
            return null;
        }
        return new PollerRequest(request, pollerHeader, portletId, parameterMap, chunkId, receiveRequest);
    }

    protected List<PollerRequest> createPollerRequests(HttpServletRequest request, PollerHeader pollerHeader, Map<String, Object>[] pollerRequestChunks, boolean receiveRequest) throws Exception {
        String[] portletIds = pollerHeader.getPortletIds();
        ArrayList<PollerRequest> pollerRequests = new ArrayList<PollerRequest>(portletIds.length);
        HashSet<String> receiveRequestPortletIds = null;
        if (receiveRequest) {
            receiveRequestPortletIds = new HashSet<String>((int)((double)pollerRequestChunks.length / 0.75) + 1);
        }
        int i2 = 1;
        while (i2 < pollerRequestChunks.length) {
            Map<String, Object> pollerRequestChunk = pollerRequestChunks[i2];
            String portletId = (String)pollerRequestChunk.get("portletId");
            Map<String, String> parameterMap = this.parseData(pollerRequestChunk);
            String chunkId = (String)pollerRequestChunk.get("chunkId");
            try {
                PollerRequest pollerRequest = this.createPollerRequest(request, receiveRequest, pollerHeader, portletId, parameterMap, chunkId);
                pollerRequests.add(pollerRequest);
                if (receiveRequest) {
                    receiveRequestPortletIds.add(portletId);
                }
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
            ++i2;
        }
        if (receiveRequest) {
            String[] stringArray = portletIds;
            int n = portletIds.length;
            int n2 = 0;
            while (n2 < n) {
                String portletId = stringArray[n2];
                if (!receiveRequestPortletIds.contains(portletId)) {
                    try {
                        PollerRequest pollerRequest = this.createPollerRequest(request, receiveRequest, pollerHeader, portletId);
                        pollerRequests.add(pollerRequest);
                    }
                    catch (Exception e3) {
                        _log.error((Object)e3, (Throwable)e3);
                    }
                }
                ++n2;
            }
        }
        return pollerRequests;
    }

    protected JSONObject createPollerResponseHeader(PollerHeader pollerHeader) throws SystemException {
        if (pollerHeader == null) {
            return null;
        }
        boolean suspendPolling = false;
        if (pollerHeader.isStartPolling()) {
            BrowserTrackerLocalServiceUtil.updateBrowserTracker((long)pollerHeader.getUserId(), (long)pollerHeader.getBrowserKey());
        } else {
            BrowserTracker browserTracker = BrowserTrackerLocalServiceUtil.getBrowserTracker((long)pollerHeader.getUserId(), (long)pollerHeader.getBrowserKey());
            if (browserTracker.getBrowserKey() != pollerHeader.getBrowserKey()) {
                suspendPolling = true;
            }
        }
        JSONObject pollerResponseHeaderJSONObject = JSONFactoryUtil.createJSONObject();
        pollerResponseHeaderJSONObject.put("userId", pollerHeader.getUserId());
        pollerResponseHeaderJSONObject.put("initialRequest", pollerHeader.isInitialRequest());
        pollerResponseHeaderJSONObject.put("suspendPolling", suspendPolling);
        return pollerResponseHeaderJSONObject;
    }

    protected void executePollerRequests(PollerSession pollerSession, List<PollerRequest> pollerRequests) {
        for (PollerRequest pollerRequest : pollerRequests) {
            PollerRequestResponsePair pollerRequestResponsePair = new PollerRequestResponsePair(pollerRequest);
            String responseId = null;
            if (pollerRequest.isReceiveRequest()) {
                responseId = PortalUUIDUtil.generate();
                DefaultPollerResponse pollerResponse = new DefaultPollerResponse(pollerRequest.getPollerHeader(), pollerRequest.getPortletId(), pollerRequest.getChunkId());
                pollerRequestResponsePair.setPollerResponse((PollerResponse)pollerResponse);
                if (!pollerSession.beginPortletProcessing(pollerRequestResponsePair, responseId)) continue;
            }
            Message message = new Message();
            message.setPayload((Object)pollerRequestResponsePair);
            if (pollerRequest.isReceiveRequest()) {
                message.setResponseId(responseId);
                message.setResponseDestinationName("liferay/poller_response");
            }
            MessageBusUtil.sendMessage((String)"liferay/poller", (Message)message);
        }
    }

    protected String fixPollerRequestString(String pollerRequestString) {
        if (Validator.isNull((String)pollerRequestString)) {
            return null;
        }
        return StringUtil.replace((String)pollerRequestString, (String[])new String[]{"{", "}", _ESCAPED_OPEN_CURLY_BRACE, _ESCAPED_CLOSE_CURLY_BRACE}, (String[])new String[]{_OPEN_HASH_MAP_WRAPPER, "}}", "{", "}"});
    }

    protected String getPollerSessionId(PollerHeader pollerHeader) {
        return String.valueOf(pollerHeader.getUserId());
    }

    protected long getUserId(long companyId, String userIdString) {
        long userId = 0L;
        try {
            Company company = CompanyLocalServiceUtil.getCompany((long)companyId);
            userId = GetterUtil.getLong((String)Encryptor.decrypt((Key)company.getKeyObj(), (String)userIdString));
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid credentials for company id " + companyId + " and user id " + userIdString));
        }
        return userId;
    }

    protected boolean isReceiveRequest(String path) {
        return path != null && path.endsWith(_PATH_RECEIVE);
    }

    protected Map<String, String> parseData(Map<String, Object> pollerRequestChunk) throws Exception {
        Map oldParameterMap = (Map)pollerRequestChunk.get("data");
        HashMap<String, String> newParameterMap = new HashMap<String, String>();
        if (oldParameterMap == null) {
            return newParameterMap;
        }
        for (Map.Entry entry : oldParameterMap.entrySet()) {
            newParameterMap.put((String)entry.getKey(), String.valueOf(entry.getValue()));
        }
        return newParameterMap;
    }

    protected PollerHeader parsePollerRequestHeader(Map<String, Object>[] pollerRequestChunks) {
        if (pollerRequestChunks == null || pollerRequestChunks.length < 1) {
            return null;
        }
        Map<String, Object> pollerRequestChunk = pollerRequestChunks[0];
        long companyId = GetterUtil.getLong((String)String.valueOf(pollerRequestChunk.get("companyId")));
        String userIdString = GetterUtil.getString((String)String.valueOf(pollerRequestChunk.get("userId")));
        long browserKey = GetterUtil.getLong((String)String.valueOf(pollerRequestChunk.get("browserKey")));
        String[] portletIds = StringUtil.split((String)String.valueOf(pollerRequestChunk.get("portletIds")));
        boolean initialRequest = GetterUtil.getBoolean((String)String.valueOf(pollerRequestChunk.get("initialRequest")));
        boolean startPolling = GetterUtil.getBoolean((String)String.valueOf(pollerRequestChunk.get("startPolling")));
        long userId = this.getUserId(companyId, userIdString);
        if (userId == 0L) {
            return null;
        }
        return new PollerHeader(companyId, userId, browserKey, portletIds, initialRequest, startPolling);
    }

    protected Map<String, Object>[] parsePollerRequestParameters(String pollerRequestString) {
        String fixedPollerRequestString = this.fixPollerRequestString(pollerRequestString);
        return (Map[])JSONFactoryUtil.deserialize((String)fixedPollerRequestString);
    }
}

