/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.cmis;

import com.liferay.portal.InvalidRepositoryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.cmis.CMISRepositoryHandler;
import com.liferay.portal.kernel.repository.cmis.Session;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.repository.cmis.CMISRepositoryUtil;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import java.util.HashMap;
import java.util.Locale;
import org.apache.chemistry.opencmis.commons.enums.BindingType;

public class CMISWebServicesRepository
extends CMISRepositoryHandler {
    private static final String _CONFIGURATION_WEBSERVICES = "WEBSERVICES";
    private static final String _REPOSITORY_ID = "REPOSITORY_ID";
    private static final String[] _SUPPORTED_CONFIGURATIONS = new String[]{"WEBSERVICES"};
    private static final String[][] _SUPPORTED_PARAMETERS = new String[][]{{"REPOSITORY_ID", "WEBSERVICES_ACL_SERVICE", "WEBSERVICES_DISCOVERY_SERVICE", "WEBSERVICES_MULTIFILING_SERVICE", "WEBSERVICES_NAVIGATION_SERVICE", "WEBSERVICES_OBJECT_SERVICE", "WEBSERVICES_POLICY_SERVICE", "WEBSERVICES_RELATIONSHIP_SERVICE", "WEBSERVICES_REPOSITORY_SERVICE", "WEBSERVICES_VERSIONING_SERVICE"}};
    private static final String _WEBSERVICES_ACL_SERVICE = "WEBSERVICES_ACL_SERVICE";
    private static final String _WEBSERVICES_DISCOVERY_SERVICE = "WEBSERVICES_DISCOVERY_SERVICE";
    private static final String _WEBSERVICES_MULTIFILING_SERVICE = "WEBSERVICES_MULTIFILING_SERVICE";
    private static final String _WEBSERVICES_NAVIGATION_SERVICE = "WEBSERVICES_NAVIGATION_SERVICE";
    private static final String _WEBSERVICES_OBJECT_SERVICE = "WEBSERVICES_OBJECT_SERVICE";
    private static final String _WEBSERVICES_POLICY_SERVICE = "WEBSERVICES_POLICY_SERVICE";
    private static final String _WEBSERVICES_RELATIONSHIP_SERVICE = "WEBSERVICES_RELATIONSHIP_SERVICE";
    private static final String _WEBSERVICES_REPOSITORY_SERVICE = "WEBSERVICES_REPOSITORY_SERVICE";
    private static final String _WEBSERVICES_VERSIONING_SERVICE = "WEBSERVICES_VERSIONING_SERVICE";

    public Session getSession() throws PortalException, SystemException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.WEBSERVICES.value());
        parameters.put("org.apache.chemistry.opencmis.binding.compression", Boolean.TRUE.toString());
        Locale locale = LocaleUtil.getDefault();
        parameters.put("org.apache.chemistry.opencmis.locale.iso3166", locale.getCountry());
        parameters.put("org.apache.chemistry.opencmis.locale.iso639", locale.getLanguage());
        String password = PrincipalThreadLocal.getPassword();
        parameters.put("org.apache.chemistry.opencmis.password", password);
        String login = this.getLogin();
        parameters.put("org.apache.chemistry.opencmis.user", login);
        parameters.put("org.apache.chemistry.opencmis.binding.webservices.ACLService", this.getTypeSettingsValue(_WEBSERVICES_ACL_SERVICE));
        parameters.put("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", this.getTypeSettingsValue(_WEBSERVICES_DISCOVERY_SERVICE));
        parameters.put("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", this.getTypeSettingsValue(_WEBSERVICES_MULTIFILING_SERVICE));
        parameters.put("org.apache.chemistry.opencmis.binding.webservices.NavigationService", this.getTypeSettingsValue(_WEBSERVICES_NAVIGATION_SERVICE));
        parameters.put("org.apache.chemistry.opencmis.binding.webservices.ObjectService", this.getTypeSettingsValue(_WEBSERVICES_OBJECT_SERVICE));
        parameters.put("org.apache.chemistry.opencmis.binding.webservices.PolicyService", this.getTypeSettingsValue(_WEBSERVICES_POLICY_SERVICE));
        parameters.put("org.apache.chemistry.opencmis.binding.webservices.RelationshipService", this.getTypeSettingsValue(_WEBSERVICES_RELATIONSHIP_SERVICE));
        parameters.put("org.apache.chemistry.opencmis.binding.webservices.RepositoryService", this.getTypeSettingsValue(_WEBSERVICES_REPOSITORY_SERVICE));
        parameters.put("org.apache.chemistry.opencmis.binding.webservices.VersioningService", this.getTypeSettingsValue(_WEBSERVICES_VERSIONING_SERVICE));
        CMISRepositoryUtil.checkRepository(this.getRepositoryId(), parameters, this.getTypeSettingsProperties(), _REPOSITORY_ID);
        return CMISRepositoryUtil.createSession(parameters);
    }

    public String[] getSupportedConfigurations() {
        return _SUPPORTED_CONFIGURATIONS;
    }

    public String[][] getSupportedParameters() {
        return _SUPPORTED_PARAMETERS;
    }

    protected String getTypeSettingsValue(String typeSettingsKey) throws InvalidRepositoryException {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        return CMISRepositoryUtil.getTypeSettingsValue(typeSettingsProperties, typeSettingsKey);
    }
}

