/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.cmis.model;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.RepositoryException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Lock;
import com.liferay.portal.model.User;
import com.liferay.portal.repository.cmis.CMISRepository;
import com.liferay.portal.repository.cmis.model.CMISModel;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.CMISRepositoryLocalServiceUtil;
import com.liferay.portal.service.persistence.LockUtil;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFileVersionException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.service.DLAppHelperLocalServiceUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISFileEntry
extends CMISModel
implements FileEntry {
    private static Log _log = LogFactoryUtil.getLog(CMISFileEntry.class);
    private List<Document> _allVersions;
    private CMISRepository _cmisRepository;
    private Document _document;
    private long _fileEntryId;
    private FileVersion _latestFileVersion;
    private String _uuid;

    public CMISFileEntry(CMISRepository cmisRepository, String uuid, long fileEntryId, Document document) {
        this._cmisRepository = cmisRepository;
        this._uuid = uuid;
        this._fileEntryId = fileEntryId;
        this._document = document;
    }

    public boolean containsPermission(PermissionChecker permissionChecker, String actionId) throws SystemException {
        return this.containsPermission((CmisObject)this._document, actionId);
    }

    public Map<String, Serializable> getAttributes() {
        return new HashMap<String, Serializable>();
    }

    @Override
    public long getCompanyId() {
        return this._cmisRepository.getCompanyId();
    }

    public InputStream getContentStream() {
        ContentStream contentStream = this._document.getContentStream();
        try {
            DLAppHelperLocalServiceUtil.getFileAsStream((long)PrincipalThreadLocal.getUserId(), (FileEntry)this, (boolean)true);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return contentStream.getStream();
    }

    public InputStream getContentStream(String version) throws PortalException {
        if (Validator.isNull((String)version)) {
            return this.getContentStream();
        }
        for (Document document : this.getAllVersions()) {
            if (!version.equals(document.getVersionLabel())) continue;
            ContentStream contentStream = document.getContentStream();
            try {
                DLAppHelperLocalServiceUtil.getFileAsStream((long)PrincipalThreadLocal.getUserId(), (FileEntry)this, (boolean)true);
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
            return contentStream.getStream();
        }
        throw new NoSuchFileVersionException("No CMIS file version with {fileEntryId=" + this.getFileEntryId() + ", version=" + version + "}");
    }

    public Date getCreateDate() {
        return this._document.getCreationDate().getTime();
    }

    public String getExtension() {
        return FileUtil.getExtension((String)this.getTitle());
    }

    public long getFileEntryId() {
        return this._fileEntryId;
    }

    public FileVersion getFileVersion() throws PortalException, SystemException {
        return this.getLatestFileVersion();
    }

    public FileVersion getFileVersion(String version) throws PortalException, SystemException {
        if (Validator.isNull((String)version)) {
            return this.getFileVersion();
        }
        for (Document document : this.getAllVersions()) {
            if (!version.equals(document.getVersionLabel())) continue;
            return CMISRepositoryLocalServiceUtil.toFileVersion((long)this.getRepositoryId(), (Object)document);
        }
        throw new NoSuchFileVersionException("No CMIS file version with {fileEntryId=" + this.getFileEntryId() + ", version=" + version + "}");
    }

    public List<FileVersion> getFileVersions(int status) throws SystemException {
        try {
            List<Document> documents = this.getAllVersions();
            ArrayList<FileVersion> fileVersions = new ArrayList<FileVersion>(documents.size());
            for (Document document : documents) {
                FileVersion fileVersion = CMISRepositoryLocalServiceUtil.toFileVersion((long)this.getRepositoryId(), (Object)document);
                fileVersions.add(fileVersion);
            }
            return fileVersions;
        }
        catch (PortalException pe) {
            throw new RepositoryException((Throwable)pe);
        }
    }

    public Folder getFolder() {
        Folder parentFolder = null;
        try {
            parentFolder = super.getParentFolder();
            if (parentFolder != null) {
                return parentFolder;
            }
        }
        catch (Exception exception) {}
        try {
            List cmisParentFolders = this._document.getParents();
            if (cmisParentFolders.isEmpty()) {
                this._document = this._document.getObjectOfLatestVersion(false);
                cmisParentFolders = this._document.getParents();
            }
            parentFolder = CMISRepositoryLocalServiceUtil.toFolder((long)this.getRepositoryId(), cmisParentFolders.get(0));
            this.setParentFolder(parentFolder);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return parentFolder;
    }

    public long getFolderId() {
        Folder folder = this.getFolder();
        return folder.getFolderId();
    }

    public long getGroupId() {
        return this._cmisRepository.getGroupId();
    }

    public String getIcon() {
        return DLUtil.getFileIcon((String)this.getExtension());
    }

    public FileVersion getLatestFileVersion() throws PortalException, SystemException {
        if (this._latestFileVersion != null) {
            return this._latestFileVersion;
        }
        List<Document> documents = this.getAllVersions();
        if (!documents.isEmpty()) {
            Document latestDocumentVersion = documents.get(0);
            this._latestFileVersion = CMISRepositoryLocalServiceUtil.toFileVersion((long)this.getRepositoryId(), (Object)latestDocumentVersion);
        } else {
            this._latestFileVersion = CMISRepositoryLocalServiceUtil.toFileVersion((long)this.getRepositoryId(), (Object)this._document);
        }
        return this._latestFileVersion;
    }

    public Lock getLock() {
        if (!this.isCheckedOut()) {
            return null;
        }
        String checkedOutBy = this._document.getVersionSeriesCheckedOutBy();
        User user = this.getUser(checkedOutBy);
        Lock lock = LockUtil.create((long)0L);
        lock.setCompanyId(this.getCompanyId());
        if (user != null) {
            lock.setUserId(user.getUserId());
            lock.setUserName(user.getFullName());
        }
        lock.setCreateDate(new Date());
        return lock;
    }

    public String getMimeType() {
        String mimeType = this._document.getContentStreamMimeType();
        if (Validator.isNotNull((String)mimeType)) {
            return mimeType;
        }
        return MimeTypesUtil.getContentType((String)this.getTitle());
    }

    public String getMimeType(String version) {
        if (Validator.isNull((String)version)) {
            return this.getMimeType();
        }
        try {
            for (Document document : this.getAllVersions()) {
                if (!version.equals(document.getVersionLabel())) continue;
                String mimeType = document.getContentStreamMimeType();
                if (Validator.isNotNull((String)mimeType)) {
                    return mimeType;
                }
                return MimeTypesUtil.getContentType((String)document.getName());
            }
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
        }
        return "application/octet-stream";
    }

    public Object getModel() {
        return this._document;
    }

    public Class<?> getModelClass() {
        return DLFileEntry.class;
    }

    @Override
    public String getModelClassName() {
        return DLFileEntry.class.getName();
    }

    public Date getModifiedDate() {
        return this._document.getLastModificationDate().getTime();
    }

    @Override
    public long getPrimaryKey() {
        return this._fileEntryId;
    }

    public Serializable getPrimaryKeyObj() {
        return Long.valueOf(this.getPrimaryKey());
    }

    public int getReadCount() {
        return 0;
    }

    public long getRepositoryId() {
        return this._cmisRepository.getRepositoryId();
    }

    public long getSize() {
        return this._document.getContentStreamLength();
    }

    public String getTitle() {
        return this._document.getName();
    }

    public long getUserId() {
        User user = this.getUser(this._document.getCreatedBy());
        if (user == null) {
            return 0L;
        }
        return user.getUserId();
    }

    public String getUserName() {
        User user = this.getUser(this._document.getCreatedBy());
        if (user == null) {
            return "";
        }
        return user.getFullName();
    }

    public String getUserUuid() {
        User user = this.getUser(this._document.getCreatedBy());
        try {
            return user.getUserUuid();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getUuid() {
        return this._uuid;
    }

    public String getVersion() {
        return GetterUtil.getString((String)this._document.getVersionLabel(), null);
    }

    public long getVersionUserId() {
        return 0L;
    }

    public String getVersionUserName() {
        return this._document.getLastModifiedBy();
    }

    public String getVersionUserUuid() {
        return "";
    }

    public boolean hasLock() {
        if (!this.isCheckedOut()) {
            return false;
        }
        AllowableActions allowableActions = this._document.getAllowableActions();
        Set allowableActionsSet = allowableActions.getAllowableActions();
        if (allowableActionsSet.contains(Action.CAN_CHECK_IN)) {
            return true;
        }
        List cmisExtensionElements = allowableActions.getExtensions();
        for (CmisExtensionElement cmisExtensionElement : cmisExtensionElements) {
            String name = cmisExtensionElement.getName();
            if (!name.equals("canCheckInSpecified")) continue;
            return GetterUtil.getBoolean((String)cmisExtensionElement.getValue());
        }
        return false;
    }

    public boolean isCheckedOut() {
        return this._document.isVersionSeriesCheckedOut();
    }

    public boolean isDefaultRepository() {
        return false;
    }

    public boolean isEscapedModel() {
        return false;
    }

    public boolean isSupportsLocking() {
        return true;
    }

    public boolean isSupportsMetadata() {
        return false;
    }

    public boolean isSupportsSocial() {
        return false;
    }

    public void setCompanyId(long companyId) {
        this._cmisRepository.setCompanyId(companyId);
    }

    public void setCreateDate(Date date) {
    }

    public void setFileEntryId(long fileEntryId) {
        this._fileEntryId = fileEntryId;
    }

    public void setGroupId(long groupId) {
        this._cmisRepository.setGroupId(groupId);
    }

    public void setModifiedDate(Date date) {
    }

    public void setPrimaryKey(long primaryKey) {
        this.setFileEntryId(primaryKey);
    }

    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        this.setPrimaryKey((Long)primaryKeyObj);
    }

    public void setUserId(long userId) {
    }

    public void setUserName(String userName) {
    }

    public void setUserUuid(String userUuid) {
    }

    public FileEntry toEscapedModel() {
        return this;
    }

    protected List<Document> getAllVersions() throws PortalException {
        if (this._allVersions == null) {
            try {
                this._document.refresh();
                this._allVersions = this._document.getAllVersions();
            }
            catch (CmisObjectNotFoundException confe) {
                throw new NoSuchFileEntryException((Throwable)confe);
            }
        }
        return this._allVersions;
    }

    @Override
    protected CMISRepository getCmisRepository() {
        return this._cmisRepository;
    }
}

