/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.liferayrepository;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.SortedArrayList;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.Repository;
import com.liferay.portal.repository.liferayrepository.LiferayRepositoryBase;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portal.service.RepositoryLocalService;
import com.liferay.portal.service.RepositoryService;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFileVersionException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLAppHelperLocalService;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalService;
import com.liferay.portlet.documentlibrary.service.DLFileEntryService;
import com.liferay.portlet.documentlibrary.service.DLFileVersionLocalService;
import com.liferay.portlet.documentlibrary.service.DLFileVersionService;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalService;
import com.liferay.portlet.documentlibrary.service.DLFolderService;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiferayLocalRepository
extends LiferayRepositoryBase
implements LocalRepository {
    private static Log _log = LogFactoryUtil.getLog(LiferayLocalRepository.class);

    public LiferayLocalRepository(RepositoryLocalService repositoryLocalService, RepositoryService repositoryService, DLAppHelperLocalService dlAppHelperLocalService, DLFileEntryLocalService dlFileEntryLocalService, DLFileEntryService dlFileEntryService, DLFileVersionLocalService dlFileVersionLocalService, DLFileVersionService dlFileVersionService, DLFolderLocalService dlFolderLocalService, DLFolderService dlFolderService, long repositoryId) {
        super(repositoryLocalService, repositoryService, dlAppHelperLocalService, dlFileEntryLocalService, dlFileEntryService, dlFileVersionLocalService, dlFileVersionService, dlFolderLocalService, dlFolderService, repositoryId);
    }

    public LiferayLocalRepository(RepositoryLocalService repositoryLocalService, RepositoryService repositoryService, DLAppHelperLocalService dlAppHelperLocalService, DLFileEntryLocalService dlFileEntryLocalService, DLFileEntryService dlFileEntryService, DLFileVersionLocalService dlFileVersionLocalService, DLFileVersionService dlFileVersionService, DLFolderLocalService dlFolderLocalService, DLFolderService dlFolderService, long folderId, long fileEntryId, long fileVersionId) {
        super(repositoryLocalService, repositoryService, dlAppHelperLocalService, dlFileEntryLocalService, dlFileEntryService, dlFileVersionLocalService, dlFileVersionService, dlFolderLocalService, dlFolderService, folderId, fileEntryId, fileVersionId);
    }

    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, File file, ServiceContext serviceContext) throws PortalException, SystemException {
        long fileEntryTypeId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"fileEntryTypeId", (long)-1L);
        HashMap<String, Fields> fieldsMap = this.getFieldsMap(serviceContext, fileEntryTypeId);
        long size = 0L;
        if (file != null) {
            size = file.length();
        }
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.addFileEntry(userId, this.getGroupId(), this.getRepositoryId(), this.toFolderId(folderId), sourceFileName, mimeType, title, description, changeLog, fileEntryTypeId, fieldsMap, file, null, size, serviceContext);
        this.addFileEntryResources(dlFileEntry, serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, InputStream is, long size, ServiceContext serviceContext) throws PortalException, SystemException {
        long fileEntryTypeId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"fileEntryTypeId", (long)-1L);
        HashMap<String, Fields> fieldsMap = this.getFieldsMap(serviceContext, fileEntryTypeId);
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.addFileEntry(userId, this.getGroupId(), this.getRepositoryId(), this.toFolderId(folderId), sourceFileName, mimeType, title, description, changeLog, fileEntryTypeId, fieldsMap, null, is, size, serviceContext);
        this.addFileEntryResources(dlFileEntry, serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    public Folder addFolder(long userId, long parentFolderId, String title, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        boolean mountPoint = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"mountPoint");
        DLFolder dlFolder = this.dlFolderLocalService.addFolder(userId, this.getGroupId(), this.getRepositoryId(), mountPoint, this.toFolderId(parentFolderId), title, description, serviceContext);
        return new LiferayFolder(dlFolder);
    }

    public void addRepository(long groupId, String name, String description, String portletKey, UnicodeProperties typeSettingsProperties) {
    }

    public void deleteAll() throws PortalException, SystemException {
        this.dlFolderLocalService.deleteAll(this.getGroupId());
    }

    public void deleteFileEntry(long fileEntryId) throws PortalException, SystemException {
        this.dlFileEntryLocalService.deleteFileEntry(fileEntryId);
    }

    public void deleteFolder(long folderId) throws PortalException, SystemException {
        this.dlFolderLocalService.deleteFolder(folderId);
    }

    public List<FileEntry> getFileEntries(long folderId, int start, int end, OrderByComparator obc) throws SystemException {
        List dlFileEntries = this.dlFileEntryLocalService.getFileEntries(this.getGroupId(), this.toFolderId(folderId), start, end, obc);
        return this.toFileEntries(dlFileEntries);
    }

    public List<Object> getFileEntriesAndFileShortcuts(long folderId, int status, int start, int end) throws SystemException {
        List dlFileEntriesAndFileShortcuts = this.dlFolderLocalService.getFileEntriesAndFileShortcuts(this.getGroupId(), this.toFolderId(folderId), status, start, end);
        return this.toFileEntriesAndFolders(dlFileEntriesAndFileShortcuts);
    }

    public int getFileEntriesAndFileShortcutsCount(long folderId, int status) throws SystemException {
        return this.dlFolderLocalService.getFileEntriesAndFileShortcutsCount(this.getGroupId(), this.toFolderId(folderId), status);
    }

    public int getFileEntriesCount(long folderId) throws SystemException {
        return this.dlFileEntryLocalService.getFileEntriesCount(this.getGroupId(), this.toFolderId(folderId));
    }

    public FileEntry getFileEntry(long fileEntryId) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.getFileEntry(fileEntryId);
        return new LiferayFileEntry(dlFileEntry);
    }

    public FileEntry getFileEntry(long folderId, String title) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.getFileEntry(this.getGroupId(), this.toFolderId(folderId), title);
        return new LiferayFileEntry(dlFileEntry);
    }

    public FileEntry getFileEntryByUuid(String uuid) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.getFileEntryByUuidAndGroupId(uuid, this.getGroupId());
        return new LiferayFileEntry(dlFileEntry);
    }

    public FileVersion getFileVersion(long fileVersionId) throws PortalException, SystemException {
        DLFileVersion dlFileVersion = this.dlFileVersionLocalService.getFileVersion(fileVersionId);
        return new LiferayFileVersion(dlFileVersion);
    }

    public Folder getFolder(long folderId) throws PortalException, SystemException {
        DLFolder dlFolder = this.dlFolderLocalService.getFolder(folderId);
        return new LiferayFolder(dlFolder);
    }

    public Folder getFolder(long parentFolderId, String title) throws PortalException, SystemException {
        DLFolder dlFolder = this.dlFolderLocalService.getFolder(this.getGroupId(), this.toFolderId(parentFolderId), title);
        return new LiferayFolder(dlFolder);
    }

    public List<Folder> getFolders(long parentFolderId, boolean includeMountfolders, int start, int end, OrderByComparator obc) throws SystemException {
        List dlFolders = this.dlFolderLocalService.getFolders(this.getGroupId(), this.toFolderId(parentFolderId), includeMountfolders, start, end, obc);
        return this.toFolders(dlFolders);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long folderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator obc) throws SystemException {
        List dlFoldersAndFileEntriesAndFileShortcuts = this.dlFolderLocalService.getFoldersAndFileEntriesAndFileShortcuts(this.getGroupId(), this.toFolderId(folderId), status, includeMountFolders, start, end, obc);
        return this.toFileEntriesAndFolders(dlFoldersAndFileEntriesAndFileShortcuts);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long folderId, int status, String[] mimeTypes, boolean includeMountFolders, int start, int end, OrderByComparator obc) throws SystemException {
        List dlFoldersAndFileEntriesAndFileShortcuts = this.dlFolderLocalService.getFoldersAndFileEntriesAndFileShortcuts(this.getGroupId(), this.toFolderId(folderId), status, mimeTypes, includeMountFolders, start, end, obc);
        return this.toFileEntriesAndFolders(dlFoldersAndFileEntriesAndFileShortcuts);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long folderId, int status, boolean includeMountFolders) throws SystemException {
        return this.dlFolderLocalService.getFoldersAndFileEntriesAndFileShortcutsCount(this.getGroupId(), this.toFolderId(folderId), status, includeMountFolders);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long folderId, int status, String[] mimeTypes, boolean includeMountFolders) throws SystemException {
        return this.dlFolderLocalService.getFoldersAndFileEntriesAndFileShortcutsCount(this.getGroupId(), this.toFolderId(folderId), status, mimeTypes, includeMountFolders);
    }

    public int getFoldersCount(long parentFolderId, boolean includeMountfolders) throws SystemException {
        return this.dlFolderLocalService.getFoldersCount(this.getGroupId(), this.toFolderId(parentFolderId), includeMountfolders);
    }

    public int getFoldersFileEntriesCount(List<Long> folderIds, int status) throws SystemException {
        return this.dlFolderLocalService.getFoldersFileEntriesCount(this.getGroupId(), this.toFolderIds(folderIds), status);
    }

    public List<Folder> getMountFolders(long parentFolderId, int start, int end, OrderByComparator obc) throws SystemException {
        List dlFolders = this.dlFolderLocalService.getMountFolders(this.getGroupId(), this.toFolderId(parentFolderId), start, end, obc);
        return this.toFolders(dlFolders);
    }

    public int getMountFoldersCount(long parentFolderId) throws SystemException {
        return this.dlFolderLocalService.getMountFoldersCount(this.getGroupId(), this.toFolderId(parentFolderId));
    }

    public FileEntry moveFileEntry(long userId, long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.moveFileEntry(userId, fileEntryId, this.toFolderId(newFolderId), serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    public void updateAsset(long userId, FileEntry fileEntry, FileVersion fileVersion, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException, SystemException {
        this.dlAppHelperLocalService.updateAsset(userId, fileEntry, fileVersion, assetCategoryIds, assetTagNames, assetLinkEntryIds);
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, File file, ServiceContext serviceContext) throws PortalException, SystemException {
        long fileEntryTypeId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"fileEntryTypeId", (long)-1L);
        HashMap<String, Fields> fieldsMap = this.getFieldsMap(serviceContext, fileEntryTypeId);
        long size = 0L;
        if (file != null) {
            size = file.length();
        }
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, fileEntryTypeId, fieldsMap, file, null, size, serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, InputStream is, long size, ServiceContext serviceContext) throws PortalException, SystemException {
        long fileEntryTypeId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"fileEntryTypeId", (long)-1L);
        HashMap<String, Fields> fieldsMap = this.getFieldsMap(serviceContext, fileEntryTypeId);
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, fileEntryTypeId, fieldsMap, null, is, size, serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    public Folder updateFolder(long folderId, long parentFolderId, String title, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        long defaultFileEntryTypeId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"defaultFileEntryTypeId");
        SortedArrayList<Long> fileEntryTypeIds = this.getLongList(serviceContext, "dlFileEntryTypesSearchContainerPrimaryKeys");
        boolean overrideFileEntryTypes = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"overrideFileEntryTypes");
        DLFolder dlFolder = this.dlFolderLocalService.updateFolder(this.toFolderId(folderId), this.toFolderId(parentFolderId), title, description, defaultFileEntryTypeId, fileEntryTypeIds, overrideFileEntryTypes, serviceContext);
        return new LiferayFolder(dlFolder);
    }

    public UnicodeProperties updateRepository(UnicodeProperties typeSettingsProperties) {
        return typeSettingsProperties;
    }

    @Override
    protected void initByFileEntryId(long fileEntryId) {
        block3: {
            try {
                DLFileEntry dlFileEntry = this.dlFileEntryLocalService.getFileEntry(fileEntryId);
                this.initByRepositoryId(dlFileEntry.getRepositoryId());
            }
            catch (Exception e2) {
                if (!_log.isTraceEnabled()) break block3;
                if (e2 instanceof NoSuchFileEntryException) {
                    _log.trace((Object)e2.getMessage());
                }
                _log.trace((Object)e2, (Throwable)e2);
            }
        }
    }

    @Override
    protected void initByFileVersionId(long fileVersionId) {
        block3: {
            try {
                DLFileVersion dlFileVersion = this.dlFileVersionLocalService.getFileVersion(fileVersionId);
                this.initByRepositoryId(dlFileVersion.getRepositoryId());
            }
            catch (Exception e2) {
                if (!_log.isTraceEnabled()) break block3;
                if (e2 instanceof NoSuchFileVersionException) {
                    _log.trace((Object)e2.getMessage());
                }
                _log.trace((Object)e2, (Throwable)e2);
            }
        }
    }

    @Override
    protected void initByFolderId(long folderId) {
        block3: {
            try {
                DLFolder dlFolder = this.dlFolderLocalService.getFolder(folderId);
                this.initByRepositoryId(dlFolder.getRepositoryId());
            }
            catch (Exception e2) {
                if (!_log.isTraceEnabled()) break block3;
                if (e2 instanceof NoSuchFolderException) {
                    _log.trace((Object)e2.getMessage());
                }
                _log.trace((Object)e2, (Throwable)e2);
            }
        }
    }

    @Override
    protected void initByRepositoryId(long repositoryId) {
        this.setGroupId(repositoryId);
        this.setRepositoryId(repositoryId);
        try {
            Repository repository = this.repositoryLocalService.getRepository(repositoryId);
            this.setDlFolderId(repository.getDlFolderId());
            this.setGroupId(repository.getGroupId());
            this.setRepositoryId(repository.getRepositoryId());
        }
        catch (Exception exception) {}
    }
}

