/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scheduler;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.bean.IdentifiableBean;
import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.BaseClusterResponseCallback;
import com.liferay.portal.kernel.cluster.ClusterEvent;
import com.liferay.portal.kernel.cluster.ClusterEventListener;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import com.liferay.portal.kernel.cluster.ClusterNodeResponses;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.ClusterResponseCallback;
import com.liferay.portal.kernel.cluster.Clusterable;
import com.liferay.portal.kernel.cluster.FutureClusterResponses;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.scheduler.SchedulerEngine;
import com.liferay.portal.kernel.scheduler.SchedulerEngineClusterManager;
import com.liferay.portal.kernel.scheduler.SchedulerEngineUtil;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactoryUtil;
import com.liferay.portal.kernel.scheduler.TriggerState;
import com.liferay.portal.kernel.scheduler.TriggerType;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerResponse;
import com.liferay.portal.kernel.servlet.PluginContextLifecycleThreadLocal;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.messaging.proxy.ProxyModeThreadLocal;
import com.liferay.portal.model.Lock;
import com.liferay.portal.service.LockLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterSchedulerEngine
implements IdentifiableBean,
SchedulerEngine,
SchedulerEngineClusterManager {
    @BeanReference(name="com.liferay.portal.scheduler.ClusterSchedulerEngineService")
    protected SchedulerEngine schedulerEngine;
    private static final String _LOCK_CLASS_NAME = SchedulerEngine.class.getName();
    private static Log _log = LogFactoryUtil.getLog(ClusterSchedulerEngine.class);
    private static MethodKey _getScheduledJobMethodKey = new MethodKey(SchedulerEngine.class.getName(), "getScheduledJob", new Class[]{String.class, String.class});
    private static MethodKey _getScheduledJobsMethodKey1 = new MethodKey(SchedulerEngine.class.getName(), "getScheduledJobs", new Class[0]);
    private static MethodKey _getScheduledJobsMethodKey2 = new MethodKey(SchedulerEngine.class.getName(), "getScheduledJobs", new Class[]{String.class});
    private static MethodKey _getScheduledJobsMethodKey3 = new MethodKey(SchedulerEngineUtil.class.getName(), "getScheduledJobs", new Class[]{StorageType.class});
    private String _beanIdentifier;
    private ClusterEventListener _clusterEventListener;
    private volatile String _localClusterNodeAddress;
    private volatile boolean _master;
    private Map<String, ObjectValuePair<SchedulerResponse, TriggerState>> _memoryClusteredJobs = new ConcurrentHashMap<String, ObjectValuePair<SchedulerResponse, TriggerState>>();
    private java.util.concurrent.locks.Lock _readLock;
    private SchedulerEngine _schedulerEngine;
    private java.util.concurrent.locks.Lock _writeLock;

    public static SchedulerEngine createClusterSchedulerEngine(SchedulerEngine schedulerEngine) {
        if (PropsValues.CLUSTER_LINK_ENABLED && PropsValues.SCHEDULER_ENABLED) {
            schedulerEngine = new ClusterSchedulerEngine(schedulerEngine);
        }
        return schedulerEngine;
    }

    public ClusterSchedulerEngine(SchedulerEngine schedulerEngine) {
        this._schedulerEngine = schedulerEngine;
    }

    @Clusterable
    public void delete(String groupName) throws SchedulerException {
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(groupName);
        this._readLock.lock();
        try {
            if (memoryClusteredSlaveJob) {
                this.removeMemoryClusteredJobs(groupName);
            } else {
                this._schedulerEngine.delete(groupName);
            }
        }
        finally {
            this._readLock.unlock();
        }
        this.skipClusterInvoking(groupName);
    }

    @Clusterable
    public void delete(String jobName, String groupName) throws SchedulerException {
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(groupName);
        this._readLock.lock();
        try {
            if (memoryClusteredSlaveJob) {
                this._memoryClusteredJobs.remove(this.getFullName(jobName, groupName));
            } else {
                this._schedulerEngine.delete(jobName, groupName);
            }
        }
        finally {
            this._readLock.unlock();
        }
        this.skipClusterInvoking(groupName);
    }

    public String getBeanIdentifier() {
        return this._beanIdentifier;
    }

    public SchedulerResponse getScheduledJob(String jobName, String groupName) throws SchedulerException {
        String masterAddressString;
        StorageType storageType = this.getStorageType(groupName);
        if (storageType.equals((Object)StorageType.MEMORY_CLUSTERED) && !this._localClusterNodeAddress.equals(masterAddressString = this.getMasterAddressString(false))) {
            return (SchedulerResponse)this.callMaster(masterAddressString, _getScheduledJobMethodKey, jobName, groupName);
        }
        this._readLock.lock();
        try {
            SchedulerResponse schedulerResponse = this._schedulerEngine.getScheduledJob(jobName, groupName);
            return schedulerResponse;
        }
        finally {
            this._readLock.unlock();
        }
    }

    public List<SchedulerResponse> getScheduledJobs() throws SchedulerException {
        String masterAddressString = this.getMasterAddressString(false);
        if (!this._localClusterNodeAddress.equals(masterAddressString)) {
            return (List)this.callMaster(masterAddressString, _getScheduledJobsMethodKey1, new Object[0]);
        }
        this._readLock.lock();
        try {
            List list = this._schedulerEngine.getScheduledJobs();
            return list;
        }
        finally {
            this._readLock.unlock();
        }
    }

    public List<SchedulerResponse> getScheduledJobs(String groupName) throws SchedulerException {
        String masterAddressString;
        StorageType storageType = this.getStorageType(groupName);
        if (storageType.equals((Object)StorageType.MEMORY_CLUSTERED) && !this._localClusterNodeAddress.equals(masterAddressString = this.getMasterAddressString(false))) {
            return (List)this.callMaster(masterAddressString, _getScheduledJobsMethodKey2, groupName);
        }
        this._readLock.lock();
        try {
            List list = this._schedulerEngine.getScheduledJobs(groupName);
            return list;
        }
        finally {
            this._readLock.unlock();
        }
    }

    public void initialize() throws SchedulerException {
        try {
            ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
            this._readLock = readWriteLock.readLock();
            this._writeLock = readWriteLock.writeLock();
            this._localClusterNodeAddress = this.getSerializedString(ClusterExecutorUtil.getLocalClusterNodeAddress());
            this._clusterEventListener = new MemorySchedulerClusterEventListener();
            ClusterExecutorUtil.addClusterEventListener((ClusterEventListener)this._clusterEventListener);
            String masterAddressString = this.getMasterAddressString(false);
            if (!this._localClusterNodeAddress.equals(masterAddressString)) {
                List schedulerResponses = (List)this.callMaster(masterAddressString, _getScheduledJobsMethodKey3, StorageType.MEMORY_CLUSTERED);
                this.initMemoryClusteredJobs(schedulerResponses);
            }
        }
        catch (Exception e2) {
            throw new SchedulerException("Unable to initialize scheduler", (Throwable)e2);
        }
    }

    @Clusterable
    public void pause(String groupName) throws SchedulerException {
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(groupName);
        this._readLock.lock();
        try {
            if (memoryClusteredSlaveJob) {
                this.updateMemoryClusteredJobs(groupName, TriggerState.PAUSED);
                return;
            }
            this._schedulerEngine.pause(groupName);
        }
        finally {
            this._readLock.unlock();
        }
        this.skipClusterInvoking(groupName);
    }

    @Clusterable
    public void pause(String jobName, String groupName) throws SchedulerException {
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(groupName);
        this._readLock.lock();
        try {
            if (memoryClusteredSlaveJob) {
                this.updateMemoryClusteredJob(jobName, groupName, TriggerState.PAUSED);
                return;
            }
            this._schedulerEngine.pause(jobName, groupName);
        }
        finally {
            this._readLock.unlock();
        }
        this.skipClusterInvoking(groupName);
    }

    @Clusterable
    public void resume(String groupName) throws SchedulerException {
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(groupName);
        this._readLock.lock();
        try {
            if (memoryClusteredSlaveJob) {
                this.updateMemoryClusteredJobs(groupName, TriggerState.NORMAL);
                return;
            }
            this._schedulerEngine.resume(groupName);
        }
        finally {
            this._readLock.unlock();
        }
        this.skipClusterInvoking(groupName);
    }

    @Clusterable
    public void resume(String jobName, String groupName) throws SchedulerException {
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(groupName);
        this._readLock.lock();
        try {
            if (memoryClusteredSlaveJob) {
                this.updateMemoryClusteredJob(jobName, groupName, TriggerState.NORMAL);
                return;
            }
            this._schedulerEngine.resume(jobName, groupName);
        }
        finally {
            this._readLock.unlock();
        }
        this.skipClusterInvoking(groupName);
    }

    @Clusterable
    public void schedule(Trigger trigger, String description, String destinationName, Message message) throws SchedulerException {
        String groupName = trigger.getGroupName();
        String jobName = trigger.getJobName();
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(groupName);
        this._readLock.lock();
        try {
            if (memoryClusteredSlaveJob) {
                SchedulerResponse schedulerResponse = new SchedulerResponse();
                schedulerResponse.setDescription(description);
                schedulerResponse.setDestinationName(destinationName);
                schedulerResponse.setGroupName(groupName);
                schedulerResponse.setJobName(jobName);
                schedulerResponse.setMessage(message);
                schedulerResponse.setTrigger(trigger);
                this._memoryClusteredJobs.put(this.getFullName(jobName, groupName), (ObjectValuePair<SchedulerResponse, TriggerState>)new ObjectValuePair((Object)schedulerResponse, (Object)TriggerState.NORMAL));
                return;
            }
            this._schedulerEngine.schedule(trigger, description, destinationName, message);
        }
        finally {
            this._readLock.unlock();
        }
        this.skipClusterInvoking(groupName);
    }

    public void setBeanIdentifier(String beanIdentifier) {
        this._beanIdentifier = beanIdentifier;
    }

    public void shutdown() throws SchedulerException {
        try {
            ClusterExecutorUtil.removeClusterEventListener((ClusterEventListener)this._clusterEventListener);
            LockLocalServiceUtil.unlock((String)_LOCK_CLASS_NAME, (String)_LOCK_CLASS_NAME, (String)this._localClusterNodeAddress, (boolean)PropsValues.MEMORY_CLUSTER_SCHEDULER_LOCK_CACHE_ENABLED);
        }
        catch (Exception e2) {
            throw new SchedulerException("Unable to shutdown scheduler", (Throwable)e2);
        }
        this._schedulerEngine.shutdown();
    }

    public void start() throws SchedulerException {
        this._schedulerEngine.start();
    }

    @Clusterable
    public void suppressError(String jobName, String groupName) throws SchedulerException {
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(groupName);
        if (memoryClusteredSlaveJob) {
            return;
        }
        this._readLock.lock();
        try {
            this._schedulerEngine.suppressError(jobName, groupName);
        }
        finally {
            this._readLock.unlock();
        }
        this.skipClusterInvoking(groupName);
    }

    @Clusterable
    public void unschedule(String groupName) throws SchedulerException {
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(groupName);
        this._readLock.lock();
        try {
            if (memoryClusteredSlaveJob) {
                this.removeMemoryClusteredJobs(groupName);
            } else {
                this._schedulerEngine.unschedule(groupName);
            }
        }
        finally {
            this._readLock.unlock();
        }
        this.skipClusterInvoking(groupName);
    }

    @Clusterable
    public void unschedule(String jobName, String groupName) throws SchedulerException {
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(groupName);
        this._readLock.lock();
        try {
            if (memoryClusteredSlaveJob) {
                this._memoryClusteredJobs.remove(this.getFullName(jobName, groupName));
            } else {
                this._schedulerEngine.unschedule(jobName, groupName);
            }
        }
        finally {
            this._readLock.unlock();
        }
        this.skipClusterInvoking(groupName);
    }

    @Clusterable
    public void update(Trigger trigger) throws SchedulerException {
        String jobName = trigger.getJobName();
        String groupName = trigger.getGroupName();
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(groupName);
        this._readLock.lock();
        try {
            if (memoryClusteredSlaveJob) {
                for (ObjectValuePair<SchedulerResponse, TriggerState> memoryClusteredJob : this._memoryClusteredJobs.values()) {
                    SchedulerResponse schedulerResponse = (SchedulerResponse)memoryClusteredJob.getKey();
                    if (!jobName.equals(schedulerResponse.getJobName()) || !groupName.equals(schedulerResponse.getGroupName())) continue;
                    schedulerResponse.setTrigger(trigger);
                    return;
                }
                throw new SchedulerException("Unable to update trigger for memory clustered job");
            }
            this._schedulerEngine.update(trigger);
        }
        finally {
            this._readLock.unlock();
        }
        this.skipClusterInvoking(groupName);
    }

    public Lock updateMemorySchedulerClusterMaster() throws SchedulerException {
        this.getMasterAddressString(false);
        return null;
    }

    protected <T> T callMaster(String masterAddressString, MethodKey methodKey, Object ... arguments) throws SchedulerException {
        MethodHandler methodHandler = new MethodHandler(methodKey, arguments);
        Address address = (Address)this.getDeserializedObject(masterAddressString);
        ClusterRequest clusterRequest = ClusterRequest.createUnicastRequest((MethodHandler)methodHandler, (Address[])new Address[]{address});
        clusterRequest.setBeanIdentifier(this._beanIdentifier);
        try {
            FutureClusterResponses futureClusterResponses = ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
            ClusterNodeResponses clusterNodeResponses = futureClusterResponses.get(20L, TimeUnit.SECONDS);
            ClusterNodeResponse clusterNodeResponse = clusterNodeResponses.getClusterResponse(address);
            return (T)clusterNodeResponse.getResult();
        }
        catch (Exception e2) {
            throw new SchedulerException("Unable to load scheduled jobs from cluster node " + address.getDescription(), (Throwable)e2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object getDeserializedObject(String string) throws SchedulerException {
        Object object2;
        byte[] bytes = Base64.decode((String)string);
        UnsyncByteArrayInputStream byteArrayInputStream = new UnsyncByteArrayInputStream(bytes);
        ObjectInputStream objectInputStream = null;
        try {
            Object object;
            objectInputStream = new ObjectInputStream((InputStream)byteArrayInputStream);
            object2 = object = objectInputStream.readObject();
        }
        catch (Exception e2) {
            try {
                throw new SchedulerException("Unable to deserialize object from " + string, (Throwable)e2);
            }
            catch (Throwable throwable) {
                try {
                    objectInputStream.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            objectInputStream.close();
            return object2;
        }
        catch (Exception exception) {}
        return object2;
    }

    protected String getFullName(String jobName, String groupName) {
        return groupName.concat(".").concat(jobName);
    }

    protected String getMasterAddressString(boolean asynchronous) throws SchedulerException {
        String owner = null;
        Lock lock = null;
        while (true) {
            try {
                Address address;
                while (!ClusterExecutorUtil.isClusterNodeAlive((Address)(address = (Address)this.getDeserializedObject((lock = owner == null ? LockLocalServiceUtil.lock((String)_LOCK_CLASS_NAME, (String)_LOCK_CLASS_NAME, (String)this._localClusterNodeAddress, (boolean)PropsValues.MEMORY_CLUSTER_SCHEDULER_LOCK_CACHE_ENABLED) : LockLocalServiceUtil.lock((String)_LOCK_CLASS_NAME, (String)_LOCK_CLASS_NAME, owner, (String)this._localClusterNodeAddress, (boolean)PropsValues.MEMORY_CLUSTER_SCHEDULER_LOCK_CACHE_ENABLED)).getOwner())))) {
                    owner = lock.getOwner();
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)"Unable to obtain memory scheduler cluster lock. Trying again.");
                continue;
            }
            break;
        }
        boolean master = this._localClusterNodeAddress.equals(lock.getOwner());
        if (master == this._master) {
            return lock.getOwner();
        }
        if (master) {
            this.slaveToMaster();
        } else {
            this.masterToSlave(lock.getOwner(), asynchronous);
        }
        return lock.getOwner();
    }

    protected String getSerializedString(Object object) throws Exception {
        UnsyncByteArrayOutputStream byteArrayOutputStream = new UnsyncByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
        byte[] bytes = byteArrayOutputStream.toByteArray();
        return Base64.encode((byte[])bytes);
    }

    protected StorageType getStorageType(String groupName) {
        int pos = groupName.indexOf(35);
        String storageTypeString = groupName.substring(0, pos);
        return StorageType.valueOf((String)storageTypeString);
    }

    protected void initMemoryClusteredJobs(List<SchedulerResponse> schedulerResponses) throws Exception {
        for (SchedulerResponse schedulerResponse : schedulerResponses) {
            Trigger oldTrigger = schedulerResponse.getTrigger();
            String jobName = schedulerResponse.getJobName();
            String groupName = SchedulerEngineUtil.namespaceGroupName((String)schedulerResponse.getGroupName(), (StorageType)StorageType.MEMORY_CLUSTERED);
            Trigger newTrigger = TriggerFactoryUtil.buildTrigger((TriggerType)oldTrigger.getTriggerType(), (String)jobName, (String)groupName, (Date)oldTrigger.getStartDate(), (Date)oldTrigger.getEndDate(), (Object)oldTrigger.getTriggerContent());
            schedulerResponse.setTrigger(newTrigger);
            TriggerState triggerState = SchedulerEngineUtil.getJobState((SchedulerResponse)schedulerResponse);
            Message message = schedulerResponse.getMessage();
            message.remove("JOB_STATE");
            this._memoryClusteredJobs.put(this.getFullName(jobName, groupName), (ObjectValuePair<SchedulerResponse, TriggerState>)new ObjectValuePair((Object)schedulerResponse, (Object)triggerState));
        }
    }

    protected boolean isMemoryClusteredSlaveJob(String groupName) throws SchedulerException {
        StorageType storageType = this.getStorageType(groupName);
        if (!storageType.equals((Object)StorageType.MEMORY_CLUSTERED)) {
            return false;
        }
        String masterAddressString = this.getMasterAddressString(false);
        return !this._localClusterNodeAddress.equals(masterAddressString);
    }

    protected void masterToSlave(String masterAddressString, boolean asynchronous) throws SchedulerException {
        if (asynchronous) {
            MethodHandler methodHandler = new MethodHandler(_getScheduledJobsMethodKey3, new Object[]{StorageType.MEMORY_CLUSTERED});
            Address address = (Address)this.getDeserializedObject(masterAddressString);
            ClusterRequest clusterRequest = ClusterRequest.createUnicastRequest((MethodHandler)methodHandler, (Address[])new Address[]{address});
            clusterRequest.setBeanIdentifier(this._beanIdentifier);
            try {
                ClusterExecutorUtil.execute((ClusterRequest)clusterRequest, (ClusterResponseCallback)new MemorySchedulerClusterResponseCallback(address), (long)20L, (TimeUnit)TimeUnit.SECONDS);
                return;
            }
            catch (Exception e2) {
                throw new SchedulerException("Unable to load scheduled jobs from cluster node " + address.getDescription(), (Throwable)e2);
            }
        }
        List schedulerResponses = (List)this.callMaster(masterAddressString, _getScheduledJobsMethodKey3, StorageType.MEMORY_CLUSTERED);
        this._doMasterToSlave(schedulerResponses);
    }

    protected void removeMemoryClusteredJobs(String groupName) {
        Set<Map.Entry<String, ObjectValuePair<SchedulerResponse, TriggerState>>> memoryClusteredJobs = this._memoryClusteredJobs.entrySet();
        Iterator<Map.Entry<String, ObjectValuePair<SchedulerResponse, TriggerState>>> itr = memoryClusteredJobs.iterator();
        while (itr.hasNext()) {
            Map.Entry<String, ObjectValuePair<SchedulerResponse, TriggerState>> entry = itr.next();
            ObjectValuePair<SchedulerResponse, TriggerState> memoryClusteredJob = entry.getValue();
            SchedulerResponse schedulerResponse = (SchedulerResponse)memoryClusteredJob.getKey();
            if (!groupName.equals(schedulerResponse.getGroupName())) continue;
            itr.remove();
        }
    }

    protected void skipClusterInvoking(String groupName) throws SchedulerException {
        StorageType storageType = this.getStorageType(groupName);
        if (storageType.equals((Object)StorageType.PERSISTED) || PluginContextLifecycleThreadLocal.isDestroying()) {
            SchedulerException schedulerException = new SchedulerException();
            schedulerException.setSwallowable(true);
            throw schedulerException;
        }
    }

    protected void slaveToMaster() throws SchedulerException {
        boolean forceSync = ProxyModeThreadLocal.isForceSync();
        ProxyModeThreadLocal.setForceSync(true);
        this._writeLock.lock();
        try {
            for (ObjectValuePair<SchedulerResponse, TriggerState> memoryClusteredJob : this._memoryClusteredJobs.values()) {
                SchedulerResponse schedulerResponse = (SchedulerResponse)memoryClusteredJob.getKey();
                this._schedulerEngine.schedule(schedulerResponse.getTrigger(), schedulerResponse.getDescription(), schedulerResponse.getDestinationName(), schedulerResponse.getMessage());
                TriggerState triggerState = (TriggerState)memoryClusteredJob.getValue();
                if (!triggerState.equals((Object)TriggerState.PAUSED)) continue;
                this._schedulerEngine.pause(schedulerResponse.getJobName(), schedulerResponse.getGroupName());
            }
            this._memoryClusteredJobs.clear();
        }
        finally {
            ProxyModeThreadLocal.setForceSync(forceSync);
            this._master = true;
            this._writeLock.unlock();
        }
    }

    protected void updateMemoryClusteredJob(String jobName, String groupName, TriggerState triggerState) {
        ObjectValuePair<SchedulerResponse, TriggerState> memoryClusteredJob = this._memoryClusteredJobs.get(this.getFullName(jobName, groupName));
        if (memoryClusteredJob != null) {
            memoryClusteredJob.setValue((Object)triggerState);
        }
    }

    protected void updateMemoryClusteredJobs(String groupName, TriggerState triggerState) {
        for (ObjectValuePair<SchedulerResponse, TriggerState> memoryClusteredJob : this._memoryClusteredJobs.values()) {
            SchedulerResponse schedulerResponse = (SchedulerResponse)memoryClusteredJob.getKey();
            if (!groupName.equals(schedulerResponse.getGroupName())) continue;
            memoryClusteredJob.setValue((Object)triggerState);
        }
    }

    private void _doMasterToSlave(List<SchedulerResponse> schedulerResponses) throws SchedulerException {
        this._writeLock.lock();
        try {
            try {
                for (SchedulerResponse schedulerResponse : this._schedulerEngine.getScheduledJobs()) {
                    if (StorageType.MEMORY_CLUSTERED != schedulerResponse.getStorageType()) continue;
                    this._schedulerEngine.delete(schedulerResponse.getJobName(), schedulerResponse.getGroupName());
                }
                this.initMemoryClusteredJobs(schedulerResponses);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Switched current node from master to slave");
                }
            }
            catch (Exception e2) {
                throw new SchedulerException((Throwable)e2);
            }
        }
        finally {
            this._master = false;
            this._writeLock.unlock();
        }
    }

    private class MemorySchedulerClusterEventListener
    implements ClusterEventListener {
        private MemorySchedulerClusterEventListener() {
        }

        public void processClusterEvent(ClusterEvent clusterEvent) {
            try {
                ClusterSchedulerEngine.this.getMasterAddressString(true);
            }
            catch (Exception e2) {
                _log.error((Object)"Unable to update memory scheduler cluster lock", (Throwable)e2);
            }
        }
    }

    private class MemorySchedulerClusterResponseCallback
    extends BaseClusterResponseCallback {
        private Address _address;

        public MemorySchedulerClusterResponseCallback(Address address) {
            this._address = address;
        }

        public void callback(ClusterNodeResponses clusterNodeResponses) {
            try {
                ClusterNodeResponse clusterNodeResponse = clusterNodeResponses.getClusterResponse(this._address);
                List schedulerResponses = (List)clusterNodeResponse.getResult();
                ClusterSchedulerEngine.this._doMasterToSlave(schedulerResponses);
            }
            catch (Exception e2) {
                _log.error((Object)("Unable to load memory clustered jobs from cluster node " + this._address.getDescription()), (Throwable)e2);
            }
        }

        public void processTimeoutException(TimeoutException timeoutException) {
            _log.error((Object)("Unable to load memory clustered jobs from cluster node " + this._address.getDescription()), (Throwable)timeoutException);
        }
    }
}

