/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scripting.groovy;

import com.liferay.portal.kernel.cache.SingleVMPoolUtil;
import com.liferay.portal.kernel.scripting.BaseScriptingExecutor;
import com.liferay.portal.kernel.scripting.ExecutionException;
import com.liferay.portal.kernel.scripting.ScriptingException;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyExecutor
extends BaseScriptingExecutor {
    private static final String _CACHE_NAME = GroovyExecutor.class.getName();
    private static final String _LANGUAGE = "groovy";
    private volatile GroovyShell _groovyShell = new GroovyShell();
    private volatile Map<ClassLoader, GroovyShell> _groovyShells = new WeakHashMap<ClassLoader, GroovyShell>();

    public void clearCache() {
        SingleVMPoolUtil.clear((String)_CACHE_NAME);
    }

    public Map<String, Object> eval(Set<String> allowedClasses, Map<String, Object> inputObjects, Set<String> outputNames, String script, ClassLoader ... classLoaders) throws ScriptingException {
        if (allowedClasses != null) {
            throw new ExecutionException("Constrained execution not supported for Groovy");
        }
        Script compiledScript = this.getCompiledScript(script, classLoaders);
        Binding binding = new Binding(inputObjects);
        compiledScript.setBinding(binding);
        compiledScript.run();
        if (outputNames == null) {
            return null;
        }
        HashMap<String, Object> outputObjects = new HashMap<String, Object>();
        for (String outputName : outputNames) {
            outputObjects.put(outputName, binding.getVariable(outputName));
        }
        return outputObjects;
    }

    public String getLanguage() {
        return _LANGUAGE;
    }

    protected Script getCompiledScript(String script, ClassLoader[] classLoaders) {
        GroovyShell groovyShell = this.getGroovyShell(classLoaders);
        String key = String.valueOf(script.hashCode());
        Script compiledScript = (Script)SingleVMPoolUtil.get((String)_CACHE_NAME, (String)key);
        if (compiledScript == null) {
            compiledScript = groovyShell.parse(script);
            SingleVMPoolUtil.put((String)_CACHE_NAME, (String)key, (Object)compiledScript);
        }
        return compiledScript;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GroovyShell getGroovyShell(ClassLoader[] classLoaders) {
        if (classLoaders == null || classLoaders.length == 0) {
            if (this._groovyShell == null) {
                GroovyExecutor groovyExecutor = this;
                synchronized (groovyExecutor) {
                    if (this._groovyShell == null) {
                        this._groovyShell = new GroovyShell();
                    }
                }
            }
            return this._groovyShell;
        }
        ClassLoader aggregateClassLoader = AggregateClassLoader.getAggregateClassLoader((ClassLoader)PACLClassLoaderUtil.getPortalClassLoader(), (ClassLoader[])classLoaders);
        GroovyShell groovyShell = null;
        if (!this._groovyShells.containsKey(aggregateClassLoader)) {
            GroovyExecutor groovyExecutor = this;
            synchronized (groovyExecutor) {
                if (!this._groovyShells.containsKey(aggregateClassLoader)) {
                    groovyShell = new GroovyShell(aggregateClassLoader);
                    this._groovyShells.put(aggregateClassLoader, groovyShell);
                }
            }
        }
        return groovyShell;
    }
}

