/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scripting.javascript;

import com.liferay.portal.kernel.cache.SingleVMPoolUtil;
import com.liferay.portal.kernel.scripting.BaseScriptingExecutor;
import com.liferay.portal.kernel.scripting.ScriptingException;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.scripting.javascript.JavaScriptClassVisibilityChecker;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptExecutor
extends BaseScriptingExecutor {
    private static final String _CACHE_NAME = JavaScriptExecutor.class.getName();
    private static final String _LANGUAGE = "javascript";

    public void clearCache() {
        SingleVMPoolUtil.clear((String)_CACHE_NAME);
    }

    public Map<String, Object> eval(Set<String> allowedClasses, Map<String, Object> inputObjects, Set<String> outputNames, String script, ClassLoader ... classLoaders) throws ScriptingException {
        Script compiledScript = this.getCompiledScript(script, classLoaders);
        try {
            Context context = Context.enter();
            ScriptableObject scriptable = context.initStandardObjects();
            if (classLoaders != null && classLoaders.length > 0) {
                ClassLoader aggregateClassLoader = AggregateClassLoader.getAggregateClassLoader((ClassLoader)PACLClassLoaderUtil.getPortalClassLoader(), (ClassLoader[])classLoaders);
                context.setApplicationClassLoader(aggregateClassLoader);
            }
            for (Map.Entry<String, Object> entry : inputObjects.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                ScriptableObject.putProperty((Scriptable)scriptable, (String)key, (Object)Context.javaToJS((Object)value, (Scriptable)scriptable));
            }
            if (allowedClasses != null) {
                context.setClassShutter((ClassShutter)new JavaScriptClassVisibilityChecker(allowedClasses));
            }
            compiledScript.exec(context, (Scriptable)scriptable);
            if (outputNames == null) {
                return null;
            }
            HashMap<String, Object> outputObjects = new HashMap<String, Object>();
            for (String outputName : outputNames) {
                outputObjects.put(outputName, ScriptableObject.getProperty((Scriptable)scriptable, (String)outputName));
            }
            HashMap<String, Object> hashMap = outputObjects;
            return hashMap;
        }
        catch (Exception e2) {
            throw new ScriptingException(String.valueOf(e2.getMessage()) + "\n\n", (Throwable)e2);
        }
        finally {
            Context.exit();
        }
    }

    public String getLanguage() {
        return _LANGUAGE;
    }

    protected Script getCompiledScript(String script, ClassLoader ... classLoaders) {
        String key = String.valueOf(script.hashCode());
        Script compiledScript = (Script)SingleVMPoolUtil.get((String)_CACHE_NAME, (String)key);
        if (compiledScript == null) {
            try {
                Context context = Context.enter();
                if (classLoaders != null && classLoaders.length > 0) {
                    ClassLoader aggregateClassLoader = AggregateClassLoader.getAggregateClassLoader((ClassLoader)PACLClassLoaderUtil.getPortalClassLoader(), (ClassLoader[])classLoaders);
                    context.setApplicationClassLoader(aggregateClassLoader);
                }
                compiledScript = context.compileString(script, "script", 0, null);
            }
            finally {
                Context.exit();
            }
            SingleVMPoolUtil.put((String)_CACHE_NAME, (String)key, (Object)compiledScript);
        }
        return compiledScript;
    }
}

