/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scripting.python;

import com.liferay.portal.kernel.cache.SingleVMPoolUtil;
import com.liferay.portal.kernel.scripting.BaseScriptingExecutor;
import com.liferay.portal.kernel.scripting.ExecutionException;
import com.liferay.portal.kernel.scripting.ScriptingException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.python.core.CompileMode;
import org.python.core.CompilerFlags;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.util.InteractiveInterpreter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonExecutor
extends BaseScriptingExecutor {
    private static final String _CACHE_NAME = PythonExecutor.class.getName();
    private static final String _LANGUAGE = "python";
    private volatile boolean _initialized;

    public void clearCache() {
        SingleVMPoolUtil.clear((String)_CACHE_NAME);
    }

    public Map<String, Object> eval(Set<String> allowedClasses, Map<String, Object> inputObjects, Set<String> outputNames, String script, ClassLoader ... classLoaders) throws ScriptingException {
        if (allowedClasses != null) {
            throw new ExecutionException("Constrained execution not supported for Python");
        }
        PyCode compiledScript = this.getCompiledScript(script);
        InteractiveInterpreter interactiveInterpreter = new InteractiveInterpreter();
        for (Map.Entry<String, Object> entry : inputObjects.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            interactiveInterpreter.set(key, value);
        }
        interactiveInterpreter.exec((PyObject)compiledScript);
        if (outputNames == null) {
            return null;
        }
        HashMap<String, Object> outputObjects = new HashMap<String, Object>();
        for (String outputName : outputNames) {
            outputObjects.put(outputName, interactiveInterpreter.get(outputName));
        }
        return outputObjects;
    }

    public String getLanguage() {
        return _LANGUAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PyCode getCompiledScript(String script) {
        String key;
        PyCode compiledScript;
        if (!this._initialized) {
            PythonExecutor pythonExecutor = this;
            synchronized (pythonExecutor) {
                if (!this._initialized) {
                    PySystemState.initialize();
                    this._initialized = true;
                }
            }
        }
        if ((compiledScript = (PyCode)SingleVMPoolUtil.get((String)_CACHE_NAME, (String)(key = String.valueOf(script.hashCode())))) == null) {
            compiledScript = Py.compile_flags((String)script, (String)"<string>", (CompileMode)CompileMode.exec, (CompilerFlags)Py.getCompilerFlags());
            SingleVMPoolUtil.put((String)_CACHE_NAME, (String)key, (Serializable)compiledScript);
        }
        return compiledScript;
    }
}

