/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.DummyIndexer;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.spring.aop.ServiceBeanAopProxy;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexerRegistryImpl
implements IndexerRegistry {
    private static Log _log = LogFactoryUtil.getLog(IndexerRegistryImpl.class);
    private Indexer _dummyIndexer = new DummyIndexer();
    private Map<String, Indexer> _indexers = new ConcurrentHashMap<String, Indexer>();

    public Indexer getIndexer(String className) {
        return this._indexers.get(className);
    }

    public List<Indexer> getIndexers() {
        return ListUtil.fromMapValues(this._indexers);
    }

    public Indexer nullSafeGetIndexer(String className) {
        Indexer indexer = this._indexers.get(className);
        if (indexer != null) {
            return indexer;
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)("No indexer found for " + className));
        }
        return this._dummyIndexer;
    }

    public void register(String className, Indexer indexerInstance) {
        this._indexers.put(className, indexerInstance);
        ServiceBeanAopProxy.clearMethodInterceptorCache();
    }

    public void unregister(String className) {
        this._indexers.remove(className);
    }
}

