/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.BaseClusterResponseCallback;
import com.liferay.portal.kernel.cluster.ClusterEvent;
import com.liferay.portal.kernel.cluster.ClusterEventListener;
import com.liferay.portal.kernel.cluster.ClusterEventType;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.ClusterResponseCallback;
import com.liferay.portal.kernel.cluster.FutureClusterResponses;
import com.liferay.portal.kernel.concurrent.ThreadPoolExecutor;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.executor.PortalExecutorManagerUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncPrintWriter;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.proxy.MessageValuesThreadLocal;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnsyncPrintWriterPool;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.lucene.FieldWeightSimilarity;
import com.liferay.portal.search.lucene.IndexAccessor;
import com.liferay.portal.search.lucene.IndexAccessorImpl;
import com.liferay.portal.search.lucene.LikeKeywordAnalyzer;
import com.liferay.portal.search.lucene.LuceneHelper;
import com.liferay.portal.search.lucene.LuceneHelperUtil;
import com.liferay.portal.search.lucene.LuceneIndexer;
import com.liferay.portal.search.lucene.PerFieldAnalyzerWrapper;
import com.liferay.portal.search.lucene.SynchronizedIndexAccessorImpl;
import com.liferay.portal.search.lucene.cluster.LuceneClusterUtil;
import com.liferay.portal.search.lucene.highlight.QueryTermExtractor;
import com.liferay.portal.security.auth.TransientTokenUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.lucene.KeywordsUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.time.StopWatch;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleFragmenter;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.WeightedTerm;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneHelperImpl
implements LuceneHelper {
    private static final long _BOOTUP_CLUSTER_NODE_RESPONSE_TIMEOUT = 10000L;
    private static final long _TRANSIENT_TOKEN_KEEP_ALIVE_TIME = 10000L;
    private static Log _log = LogFactoryUtil.getLog(LuceneHelperImpl.class);
    private static MethodKey _createTokenMethodKey = new MethodKey(TransientTokenUtil.class.getName(), "createToken", new Class[]{Long.TYPE});
    private static MethodKey _getLastGenerationMethodKey = new MethodKey(LuceneHelperUtil.class.getName(), "getLastGeneration", new Class[]{Long.TYPE});
    private Analyzer _analyzer;
    private Map<Long, IndexAccessor> _indexAccessors = new ConcurrentHashMap<Long, IndexAccessor>();
    private LoadIndexClusterEventListener _loadIndexClusterEventListener;
    private ThreadPoolExecutor _luceneIndexThreadPoolExecutor;
    private Version _version;

    @Override
    public void addDocument(long companyId, Document document) throws IOException {
        IndexAccessor indexAccessor = this._getIndexAccessor(companyId);
        indexAccessor.addDocument(document);
    }

    @Override
    public void addExactTerm(BooleanQuery booleanQuery, String field, String value) {
        this.addTerm(booleanQuery, field, value, false);
    }

    @Override
    public void addNumericRangeTerm(BooleanQuery booleanQuery, String field, String startValue, String endValue) {
        NumericRangeQuery numericRangeQuery = NumericRangeQuery.newLongRange((String)field, (Long)GetterUtil.getLong((String)startValue), (Long)GetterUtil.getLong((String)endValue), (boolean)true, (boolean)true);
        booleanQuery.add((Query)numericRangeQuery, BooleanClause.Occur.SHOULD);
    }

    @Override
    public void addRangeTerm(BooleanQuery booleanQuery, String field, String startValue, String endValue) {
        boolean includesLower = true;
        if (startValue != null && startValue.equals("*")) {
            includesLower = false;
        }
        boolean includesUpper = true;
        if (endValue != null && endValue.equals("*")) {
            includesUpper = false;
        }
        TermRangeQuery termRangeQuery = new TermRangeQuery(field, startValue, endValue, includesLower, includesUpper);
        booleanQuery.add((Query)termRangeQuery, BooleanClause.Occur.SHOULD);
    }

    @Override
    public void addRequiredTerm(BooleanQuery booleanQuery, String field, String value, boolean like) {
        this.addRequiredTerm(booleanQuery, field, new String[]{value}, like);
    }

    @Override
    public void addRequiredTerm(BooleanQuery booleanQuery, String field, String[] values, boolean like) {
        if (values == null) {
            return;
        }
        BooleanQuery query = new BooleanQuery();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            this.addTerm(query, field, value, like);
            ++n2;
        }
        booleanQuery.add((Query)query, BooleanClause.Occur.MUST);
    }

    @Override
    public void addTerm(BooleanQuery booleanQuery, String field, String value, boolean like) {
        this.addTerm(booleanQuery, field, value, like, BooleanClauseOccur.SHOULD);
    }

    @Override
    public void addTerm(BooleanQuery booleanQuery, String field, String value, boolean like, BooleanClauseOccur booleanClauseOccur) {
        PerFieldAnalyzerWrapper perFieldAnalyzerWrapper;
        Analyzer fieldAnalyzer;
        if (Validator.isNull((String)value)) {
            return;
        }
        Analyzer analyzer = this.getAnalyzer();
        if (analyzer instanceof PerFieldAnalyzerWrapper && (fieldAnalyzer = (perFieldAnalyzerWrapper = (PerFieldAnalyzerWrapper)analyzer).getAnalyzer(field)) instanceof LikeKeywordAnalyzer) {
            like = true;
        }
        if (like) {
            value = StringUtil.replace((String)value, (String)"%", (String)"");
        }
        try {
            QueryParser queryParser = new QueryParser(this.getVersion(), field, analyzer);
            Query query = null;
            try {
                query = queryParser.parse(value);
            }
            catch (Exception exception) {
                query = queryParser.parse(KeywordsUtil.escape((String)value));
            }
            BooleanClause.Occur occur = null;
            occur = booleanClauseOccur.equals(BooleanClauseOccur.MUST) ? BooleanClause.Occur.MUST : (booleanClauseOccur.equals(BooleanClauseOccur.MUST_NOT) ? BooleanClause.Occur.MUST_NOT : BooleanClause.Occur.SHOULD);
            this._includeIfUnique(booleanQuery, query, occur, like);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    @Override
    public void addTerm(BooleanQuery booleanQuery, String field, String[] values, boolean like) {
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            this.addTerm(booleanQuery, field, value, like);
            ++n2;
        }
    }

    @Override
    public int countScoredFieldNames(Query query, String[] filedNames) {
        int count = 0;
        String[] stringArray = filedNames;
        int n = filedNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName = stringArray[n2];
            WeightedTerm[] weightedTerms = QueryTermExtractor.getTerms(query, false, fieldName);
            if (weightedTerms.length > 0 && !ArrayUtil.contains((Object[])Field.UNSCORED_FIELD_NAMES, (Object)fieldName)) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    @Override
    public void delete(long companyId) {
        IndexAccessor indexAccessor = this._indexAccessors.get(companyId);
        if (indexAccessor == null) {
            return;
        }
        indexAccessor.delete();
    }

    @Override
    public void deleteDocuments(long companyId, Term term) throws IOException {
        IndexAccessor indexAccessor = this._indexAccessors.get(companyId);
        if (indexAccessor == null) {
            return;
        }
        indexAccessor.deleteDocuments(term);
    }

    @Override
    public void dumpIndex(long companyId, OutputStream outputStream) throws IOException {
        long lastGeneration = this.getLastGeneration(companyId);
        if (lastGeneration == -1L) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Dump index from cluster is not enabled for " + companyId));
            }
            return;
        }
        IndexAccessor indexAccessor = this._indexAccessors.get(companyId);
        if (indexAccessor == null) {
            return;
        }
        indexAccessor.dumpIndex(outputStream);
    }

    @Override
    public Analyzer getAnalyzer() {
        return this._analyzer;
    }

    @Override
    public long getLastGeneration(long companyId) {
        if (!this.isLoadIndexFromClusterEnabled()) {
            return -1L;
        }
        IndexAccessor indexAccessor = this._indexAccessors.get(companyId);
        if (indexAccessor == null) {
            return -1L;
        }
        return indexAccessor.getLastGeneration();
    }

    @Override
    public InputStream getLoadIndexesInputStreamFromCluster(long companyId, Address bootupAddress) throws SystemException {
        if (!this.isLoadIndexFromClusterEnabled()) {
            return null;
        }
        InputStream inputStream = null;
        try {
            ObjectValuePair<String, URL> bootupClusterNodeObjectValuePair = this._getBootupClusterNodeObjectValuePair(bootupAddress);
            URL url = (URL)bootupClusterNodeObjectValuePair.getValue();
            URLConnection urlConnection = url.openConnection();
            urlConnection.setDoOutput(true);
            UnsyncPrintWriter unsyncPrintWriter = UnsyncPrintWriterPool.borrow((OutputStream)urlConnection.getOutputStream());
            unsyncPrintWriter.write("transientToken=");
            unsyncPrintWriter.write((String)bootupClusterNodeObjectValuePair.getKey());
            unsyncPrintWriter.write("&companyId=");
            unsyncPrintWriter.write(String.valueOf(companyId));
            unsyncPrintWriter.close();
            inputStream = urlConnection.getInputStream();
            return inputStream;
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    @Override
    public String[] getQueryTerms(Query query) {
        String queryString = StringUtil.replace((String)query.toString(), (String)"*", (String)"");
        Query tempQuery = null;
        try {
            QueryParser queryParser = new QueryParser(this.getVersion(), "", this.getAnalyzer());
            tempQuery = queryParser.parse(queryString);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to parse " + queryString));
            }
            tempQuery = query;
        }
        WeightedTerm[] weightedTerms = null;
        String[] stringArray = Field.KEYWORDS;
        int n = Field.KEYWORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName = stringArray[n2];
            weightedTerms = QueryTermExtractor.getTerms(tempQuery, false, fieldName);
            if (weightedTerms.length > 0) break;
            ++n2;
        }
        HashSet<String> queryTerms = new HashSet<String>();
        WeightedTerm[] weightedTermArray = weightedTerms;
        int n3 = weightedTerms.length;
        n = 0;
        while (n < n3) {
            WeightedTerm weightedTerm = weightedTermArray[n];
            queryTerms.add(weightedTerm.getTerm());
            ++n;
        }
        return queryTerms.toArray(new String[queryTerms.size()]);
    }

    @Override
    public IndexSearcher getSearcher(long companyId, boolean readOnly) throws IOException {
        IndexAccessor indexAccessor = this._getIndexAccessor(companyId);
        IndexSearcher indexSearcher = new IndexSearcher(indexAccessor.getLuceneDir(), readOnly);
        indexSearcher.setDefaultFieldSortScoring(true, true);
        indexSearcher.setSimilarity((Similarity)new FieldWeightSimilarity());
        return indexSearcher;
    }

    @Override
    public String getSnippet(Query query, String field, String s, int maxNumFragments, int fragmentLength, String fragmentSuffix, String preTag, String postTag) throws IOException {
        SimpleHTMLFormatter simpleHTMLFormatter = new SimpleHTMLFormatter(preTag, postTag);
        QueryScorer queryScorer = new QueryScorer(query, field);
        Highlighter highlighter = new Highlighter((Formatter)simpleHTMLFormatter, (Scorer)queryScorer);
        highlighter.setTextFragmenter((Fragmenter)new SimpleFragmenter(fragmentLength));
        TokenStream tokenStream = this.getAnalyzer().tokenStream(field, (Reader)new UnsyncStringReader(s));
        try {
            String snippet = highlighter.getBestFragments(tokenStream, s, maxNumFragments, fragmentSuffix);
            if (Validator.isNotNull((String)snippet) && !StringUtil.endsWith((String)snippet, (String)fragmentSuffix)) {
                snippet = snippet.concat(fragmentSuffix);
            }
            return snippet;
        }
        catch (InvalidTokenOffsetsException itoe) {
            throw new IOException(itoe.getMessage());
        }
    }

    @Override
    public Version getVersion() {
        return this._version;
    }

    @Override
    public boolean isLoadIndexFromClusterEnabled() {
        if (PropsValues.CLUSTER_LINK_ENABLED && PropsValues.LUCENE_REPLICATE_WRITE) {
            return true;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Load index from cluster is not enabled");
        }
        return false;
    }

    @Override
    public void loadIndex(long companyId, InputStream inputStream) throws IOException {
        if (!this.isLoadIndexFromClusterEnabled()) {
            return;
        }
        IndexAccessor indexAccessor = this._indexAccessors.get(companyId);
        if (indexAccessor == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Skip loading Lucene index files for company " + companyId + " in favor of lazy loading"));
            }
            return;
        }
        StopWatch stopWatch = null;
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Start loading Lucene index files for company " + companyId));
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        indexAccessor.loadIndex(inputStream);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Finished loading index files for company " + companyId + " in " + stopWatch.getTime() + " ms"));
        }
    }

    @Override
    public void loadIndexesFromCluster(long companyId) throws SystemException {
        if (!this.isLoadIndexFromClusterEnabled()) {
            return;
        }
        IndexAccessor indexAccessor = this._indexAccessors.get(companyId);
        if (indexAccessor == null) {
            return;
        }
        long localLastGeneration = this.getLastGeneration(companyId);
        this._loadIndexFromCluster(indexAccessor, localLastGeneration);
    }

    public void setAnalyzer(Analyzer analyzer) {
        this._analyzer = analyzer;
    }

    public void setVersion(Version version) {
        this._version = version;
    }

    @Override
    public void shutdown() {
        if (this._luceneIndexThreadPoolExecutor != null) {
            this._luceneIndexThreadPoolExecutor.shutdownNow();
            try {
                this._luceneIndexThreadPoolExecutor.awaitTermination(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ie) {
                _log.error((Object)"Lucene indexer shutdown interrupted", (Throwable)ie);
            }
        }
        if (this.isLoadIndexFromClusterEnabled()) {
            ClusterExecutorUtil.removeClusterEventListener((ClusterEventListener)this._loadIndexClusterEventListener);
        }
        for (IndexAccessor indexAccessor : this._indexAccessors.values()) {
            indexAccessor.close();
        }
    }

    @Override
    public void startup(long companyId) {
        if (PropsValues.INDEX_ON_STARTUP) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Indexing Lucene on startup");
            }
            LuceneIndexer luceneIndexer = new LuceneIndexer(companyId);
            if (PropsValues.INDEX_WITH_THREAD) {
                if (this._luceneIndexThreadPoolExecutor == null) {
                    this._luceneIndexThreadPoolExecutor = PortalExecutorManagerUtil.getPortalExecutor((String)LuceneHelperImpl.class.getName());
                }
                this._luceneIndexThreadPoolExecutor.execute((Runnable)luceneIndexer);
            } else {
                luceneIndexer.reindex();
            }
        }
    }

    @Override
    public void updateDocument(long companyId, Term term, Document document) throws IOException {
        IndexAccessor indexAccessor = this._getIndexAccessor(companyId);
        indexAccessor.updateDocument(term, document);
    }

    private LuceneHelperImpl() {
        if (PropsValues.INDEX_ON_STARTUP && PropsValues.INDEX_WITH_THREAD) {
            this._luceneIndexThreadPoolExecutor = PortalExecutorManagerUtil.getPortalExecutor((String)LuceneHelperImpl.class.getName());
        }
        if (this.isLoadIndexFromClusterEnabled()) {
            this._loadIndexClusterEventListener = new LoadIndexClusterEventListener();
            ClusterExecutorUtil.addClusterEventListener((ClusterEventListener)this._loadIndexClusterEventListener);
        }
    }

    private ObjectValuePair<String, URL> _getBootupClusterNodeObjectValuePair(Address bootupAddress) throws SystemException {
        ClusterRequest clusterRequest = ClusterRequest.createUnicastRequest((MethodHandler)new MethodHandler(_createTokenMethodKey, new Object[]{10000L}), (Address[])new Address[]{bootupAddress});
        FutureClusterResponses futureClusterResponses = ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
        BlockingQueue clusterNodeResponses = futureClusterResponses.getPartialResults();
        try {
            ClusterNodeResponse clusterNodeResponse = (ClusterNodeResponse)clusterNodeResponses.poll(10000L, TimeUnit.MILLISECONDS);
            String transientToken = (String)clusterNodeResponse.getResult();
            ClusterNode clusterNode = clusterNodeResponse.getClusterNode();
            InetAddress inetAddress = clusterNode.getInetAddress();
            URL url = new URL("http", inetAddress.getHostAddress(), clusterNode.getPort(), "/lucene/dump");
            return new ObjectValuePair((Object)transientToken, (Object)url);
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexAccessor _getIndexAccessor(long companyId) {
        IndexAccessor indexAccessor = this._indexAccessors.get(companyId);
        if (indexAccessor != null) {
            return indexAccessor;
        }
        LuceneHelperImpl luceneHelperImpl = this;
        synchronized (luceneHelperImpl) {
            indexAccessor = this._indexAccessors.get(companyId);
            if (indexAccessor == null) {
                indexAccessor = new IndexAccessorImpl(companyId);
                if (this.isLoadIndexFromClusterEnabled()) {
                    boolean clusterForwardMessage = GetterUtil.getBoolean((Object)MessageValuesThreadLocal.getValue((String)"CLUSTER_FORWARD_MESSAGE"));
                    if (clusterForwardMessage) {
                        if (_log.isInfoEnabled()) {
                            _log.info((Object)"Skip Luncene index files cluster loading since this is a manual reindex request");
                        }
                    } else {
                        indexAccessor = new SynchronizedIndexAccessorImpl(indexAccessor);
                        try {
                            this._loadIndexFromCluster(indexAccessor, indexAccessor.getLastGeneration());
                        }
                        catch (Exception e2) {
                            _log.error((Object)("Unable to load index for company " + indexAccessor.getCompanyId()), (Throwable)e2);
                        }
                    }
                }
                this._indexAccessors.put(companyId, indexAccessor);
            }
        }
        return indexAccessor;
    }

    private void _includeIfUnique(BooleanQuery booleanQuery, Query query, BooleanClause.Occur occur, boolean like) {
        if (query instanceof TermQuery) {
            HashSet terms = new HashSet();
            query.extractTerms(terms);
            for (Term term : terms) {
                String termValue = term.text();
                if (like) {
                    term = term.createTerm("*".concat(termValue).concat("*"));
                    query = new WildcardQuery(term);
                } else {
                    query = new TermQuery(term);
                }
                boolean included = false;
                BooleanClause[] booleanClauseArray = booleanQuery.getClauses();
                int n = booleanClauseArray.length;
                int n2 = 0;
                while (n2 < n) {
                    BooleanClause booleanClause = booleanClauseArray[n2];
                    if (query.equals((Object)booleanClause.getQuery())) {
                        included = true;
                    }
                    ++n2;
                }
                if (included) continue;
                booleanQuery.add(query, occur);
            }
        } else if (query instanceof BooleanQuery) {
            BooleanQuery curBooleanQuery = (BooleanQuery)query;
            BooleanQuery containerBooleanQuery = new BooleanQuery();
            BooleanClause[] booleanClauseArray = curBooleanQuery.getClauses();
            int n = booleanClauseArray.length;
            int n3 = 0;
            while (n3 < n) {
                BooleanClause booleanClause = booleanClauseArray[n3];
                this._includeIfUnique(containerBooleanQuery, booleanClause.getQuery(), booleanClause.getOccur(), like);
                ++n3;
            }
            if (containerBooleanQuery.getClauses().length > 0) {
                booleanQuery.add((Query)containerBooleanQuery, occur);
            }
        } else {
            boolean included = false;
            BooleanClause[] booleanClauseArray = booleanQuery.getClauses();
            int n = booleanClauseArray.length;
            int n4 = 0;
            while (n4 < n) {
                BooleanClause booleanClause = booleanClauseArray[n4];
                if (query.equals((Object)booleanClause.getQuery())) {
                    included = true;
                }
                ++n4;
            }
            if (!included) {
                booleanQuery.add(query, occur);
            }
        }
    }

    private void _loadIndexFromCluster(IndexAccessor indexAccessor, long localLastGeneration) throws SystemException {
        List clusterNodeAddresses = ClusterExecutorUtil.getClusterNodeAddresses();
        int clusterNodeAddressesCount = clusterNodeAddresses.size();
        if (clusterNodeAddressesCount <= 1) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Do not load indexes because there is either one portal instance or no portal instances in the cluster");
            }
            return;
        }
        ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((MethodHandler)new MethodHandler(_getLastGenerationMethodKey, new Object[]{indexAccessor.getCompanyId()}), (boolean)true);
        ClusterExecutorUtil.execute((ClusterRequest)clusterRequest, (ClusterResponseCallback)new LoadIndexClusterResponseCallback(indexAccessor, clusterNodeAddressesCount, localLastGeneration));
    }

    private class LoadIndexClusterEventListener
    implements ClusterEventListener {
        private LoadIndexClusterEventListener() {
        }

        public void processClusterEvent(ClusterEvent clusterEvent) {
            long[] companyIds;
            ClusterEventType clusterEventType = clusterEvent.getClusterEventType();
            if (!clusterEventType.equals((Object)ClusterEventType.JOIN)) {
                return;
            }
            List clusterNodeAddresses = ClusterExecutorUtil.getClusterNodeAddresses();
            List clusterNodes = clusterEvent.getClusterNodes();
            if (clusterNodeAddresses.size() - clusterNodes.size() > 1) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Number of original cluster members is greater than one");
                }
                return;
            }
            long[] lArray = companyIds = PortalInstances.getCompanyIds();
            int n = companyIds.length;
            int n2 = 0;
            while (n2 < n) {
                long companyId = lArray[n2];
                this.loadIndexes(companyId);
                ++n2;
            }
            this.loadIndexes(0L);
        }

        private void loadIndexes(long companyId) {
            long lastGeneration = LuceneHelperImpl.this.getLastGeneration(companyId);
            if (lastGeneration == -1L) {
                return;
            }
            try {
                LuceneClusterUtil.loadIndexesFromCluster(companyId);
            }
            catch (Exception e2) {
                _log.error((Object)("Unable to load indexes for company " + companyId), (Throwable)e2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LoadIndexClusterResponseCallback
    extends BaseClusterResponseCallback {
        private int _clusterNodeAddressesCount;
        private long _companyId;
        private IndexAccessor _indexAccessor;
        private long _localLastGeneration;

        public LoadIndexClusterResponseCallback(IndexAccessor indexAccessor, int clusterNodeAddressesCount, long localLastGeneration) {
            this._indexAccessor = indexAccessor;
            this._clusterNodeAddressesCount = clusterNodeAddressesCount;
            this._localLastGeneration = localLastGeneration;
            this._companyId = this._indexAccessor.getCompanyId();
        }

        public void callback(BlockingQueue<ClusterNodeResponse> blockingQueue) {
            block22: {
                Address bootupAddress = null;
                do {
                    --this._clusterNodeAddressesCount;
                    ClusterNodeResponse clusterNodeResponse = null;
                    try {
                        clusterNodeResponse = blockingQueue.poll(10000L, TimeUnit.MILLISECONDS);
                    }
                    catch (Exception e2) {
                        _log.error((Object)"Unable to get cluster node response", (Throwable)e2);
                    }
                    if (clusterNodeResponse == null) {
                        if (!_log.isDebugEnabled()) continue;
                        _log.debug((Object)("Unable to get cluster node response in 10000" + (Object)((Object)TimeUnit.MILLISECONDS)));
                        continue;
                    }
                    ClusterNode clusterNode = clusterNodeResponse.getClusterNode();
                    if (clusterNode.getPort() > 0) {
                        try {
                            long remoteLastGeneration = (Long)clusterNodeResponse.getResult();
                            if (remoteLastGeneration <= this._localLastGeneration) continue;
                            bootupAddress = clusterNodeResponse.getAddress();
                            break;
                        }
                        catch (Exception e3) {
                            if (!_log.isDebugEnabled()) continue;
                            _log.debug((Object)"Suppress exception caused by remote method invocation", (Throwable)e3);
                            continue;
                        }
                    }
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)("Cluster node " + clusterNode + " has invalid port"));
                } while (bootupAddress == null && this._clusterNodeAddressesCount > 1);
                if (bootupAddress == null) {
                    return;
                }
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Start loading lucene index files from cluster node " + bootupAddress));
                }
                InputStream inputStream = null;
                try {
                    try {
                        inputStream = LuceneHelperImpl.this.getLoadIndexesInputStreamFromCluster(this._companyId, bootupAddress);
                        this._indexAccessor.loadIndex(inputStream);
                        if (_log.isInfoEnabled()) {
                            _log.info((Object)"Lucene index files loaded successfully");
                        }
                    }
                    catch (Exception e4) {
                        _log.error((Object)("Unable to load index for company " + this._companyId), (Throwable)e4);
                        if (inputStream == null) break block22;
                        try {
                            inputStream.close();
                        }
                        catch (IOException ioe) {
                            _log.error((Object)("Unable to close input stream for company " + this._companyId), (Throwable)ioe);
                        }
                    }
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException ioe) {
                            _log.error((Object)("Unable to close input stream for company " + this._companyId), (Throwable)ioe);
                        }
                    }
                }
            }
        }

        public void processTimeoutException(TimeoutException timeoutException) {
            _log.error((Object)("Uanble to load index for company " + this._companyId), (Throwable)timeoutException);
        }
    }
}

