/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Fieldable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerFieldAnalyzerWrapper
extends org.apache.lucene.analysis.PerFieldAnalyzerWrapper {
    private Analyzer _analyzer;
    private Map<String, Analyzer> _analyzers = new HashMap<String, Analyzer>();

    public PerFieldAnalyzerWrapper(Analyzer defaultAnalyzer, Map<String, Analyzer> analyzerMap) {
        super(defaultAnalyzer, analyzerMap);
        this._analyzer = defaultAnalyzer;
        this._analyzers = analyzerMap;
    }

    public void addAnalyzer(String fieldName, Analyzer analyzer) {
        super.addAnalyzer(fieldName, analyzer);
        this._analyzers.put(fieldName, analyzer);
    }

    public Analyzer getAnalyzer(String fieldName) {
        Analyzer analyzer = this._analyzers.get(fieldName);
        if (analyzer != null) {
            return analyzer;
        }
        for (String key : this._analyzers.keySet()) {
            if (!Pattern.matches(key, fieldName)) continue;
            return this._analyzers.get(key);
        }
        return this._analyzer;
    }

    public int getOffsetGap(Fieldable field) {
        Analyzer analyzer = this.getAnalyzer(field.name());
        return analyzer.getOffsetGap(field);
    }

    public int getPositionIncrementGap(String fieldName) {
        Analyzer analyzer = this.getAnalyzer(fieldName);
        return analyzer.getPositionIncrementGap(fieldName);
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        Analyzer analyzer = this.getAnalyzer(fieldName);
        return analyzer.reusableTokenStream(fieldName, reader);
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        Analyzer analyzer = this.getAnalyzer(fieldName);
        return analyzer.tokenStream(fieldName, reader);
    }
}

