/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import com.liferay.portal.search.lucene.IndexAccessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;

public class SynchronizedIndexAccessorImpl
implements IndexAccessor {
    private IndexAccessor _indexAccessor;
    private Lock _readLock;
    private Lock _writeLock;

    public SynchronizedIndexAccessorImpl(IndexAccessor indexAccessor) {
        this._indexAccessor = indexAccessor;
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this._readLock = readWriteLock.readLock();
        this._writeLock = readWriteLock.writeLock();
    }

    public void addDocument(Document document) throws IOException {
        this._readLock.lock();
        try {
            this._indexAccessor.addDocument(document);
        }
        finally {
            this._readLock.unlock();
        }
    }

    public void close() {
        this._readLock.lock();
        try {
            this._indexAccessor.close();
        }
        finally {
            this._readLock.unlock();
        }
    }

    public void delete() {
        this._writeLock.lock();
        try {
            this._indexAccessor.delete();
        }
        finally {
            this._writeLock.unlock();
        }
    }

    public void deleteDocuments(Term term) throws IOException {
        this._readLock.lock();
        try {
            this._indexAccessor.deleteDocuments(term);
        }
        finally {
            this._readLock.unlock();
        }
    }

    public void dumpIndex(OutputStream outputStream) throws IOException {
        this._readLock.lock();
        try {
            this._indexAccessor.dumpIndex(outputStream);
        }
        finally {
            this._readLock.unlock();
        }
    }

    public long getCompanyId() {
        return this._indexAccessor.getCompanyId();
    }

    public long getLastGeneration() {
        return this._indexAccessor.getLastGeneration();
    }

    public Directory getLuceneDir() {
        return this._indexAccessor.getLuceneDir();
    }

    public void loadIndex(InputStream inputStream) throws IOException {
        this._writeLock.lock();
        try {
            this._indexAccessor.loadIndex(inputStream);
        }
        finally {
            this._writeLock.unlock();
        }
    }

    public void updateDocument(Term term, Document document) throws IOException {
        this._readLock.lock();
        try {
            this._indexAccessor.updateDocument(term, document);
        }
        finally {
            this._readLock.unlock();
        }
    }
}

