/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.security.auth.EmailAddressGenerator;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portal.util.PropsValues;

public class EmailAddressGeneratorFactory {
    private static Log _log = LogFactoryUtil.getLog(EmailAddressGeneratorFactory.class);
    private static EmailAddressGenerator _emailAddressGenerator;

    public static EmailAddressGenerator getInstance() {
        if (_emailAddressGenerator == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Instantiate " + PropsValues.USERS_EMAIL_ADDRESS_GENERATOR));
            }
            ClassLoader classLoader = PACLClassLoaderUtil.getPortalClassLoader();
            try {
                _emailAddressGenerator = (EmailAddressGenerator)InstanceFactory.newInstance((ClassLoader)classLoader, (String)PropsValues.USERS_EMAIL_ADDRESS_GENERATOR);
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Return " + _emailAddressGenerator.getClass().getName()));
        }
        return _emailAddressGenerator;
    }

    public static void setInstance(EmailAddressGenerator emailAddressGenerator) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Set " + emailAddressGenerator.getClass().getName()));
        }
        _emailAddressGenerator = emailAddressGenerator;
    }
}

