/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.facebook.FacebookConnectUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.AutoLogin;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class FacebookAutoLogin
implements AutoLogin {
    private static Log _log = LogFactoryUtil.getLog(FacebookAutoLogin.class);

    public String[] login(HttpServletRequest request, HttpServletResponse response) {
        String[] credentials = null;
        try {
            long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
            if (!FacebookConnectUtil.isEnabled((long)companyId)) {
                return credentials;
            }
            HttpSession session = request.getSession();
            String emailAddress = (String)session.getAttribute("FACEBOOK_USER_EMAIL_ADDRESS");
            User user = null;
            if (Validator.isNotNull((String)emailAddress)) {
                session.removeAttribute("FACEBOOK_USER_EMAIL_ADDRESS");
                try {
                    user = UserLocalServiceUtil.getUserByEmailAddress((long)companyId, (String)emailAddress);
                }
                catch (NoSuchUserException noSuchUserException) {}
            } else {
                long facebookId = GetterUtil.getLong((String)((String)session.getAttribute("FACEBOOK_USER_ID")));
                if (facebookId > 0L) {
                    try {
                        user = UserLocalServiceUtil.getUserByFacebookId((long)companyId, (long)facebookId);
                    }
                    catch (NoSuchUserException noSuchUserException) {
                        return credentials;
                    }
                } else {
                    return credentials;
                }
            }
            credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), Boolean.FALSE.toString()};
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return credentials;
    }
}

