/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.PwdEncryptorException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.security.pwd.PwdEncryptor;
import java.io.Serializable;

public class HttpPrincipal
implements Serializable {
    private static Log _log = LogFactoryUtil.getLog(HttpPrincipal.class);
    private long _companyId;
    private String _login;
    private String _password;
    private String _url;

    public HttpPrincipal(String url) {
        this._url = url;
    }

    public HttpPrincipal(String url, String login, String password) {
        this(url, login, password, false);
    }

    public HttpPrincipal(String url, String login, String password, boolean digested) {
        this._url = url;
        this._login = login;
        if (digested) {
            this._password = password;
        } else {
            try {
                this._password = PwdEncryptor.encrypt(password);
            }
            catch (PwdEncryptorException pee) {
                _log.error((Object)pee, (Throwable)pee);
            }
        }
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public String getLogin() {
        return this._login;
    }

    public String getPassword() {
        return this._password;
    }

    public String getUrl() {
        return this._url;
    }

    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }
}

