/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.AuthSettingsUtil;
import com.liferay.portal.security.auth.AutoLogin;
import com.liferay.portal.security.ldap.PortalLDAPImporterUtil;
import com.liferay.portal.util.PortalUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NtlmAutoLogin
implements AutoLogin {
    private static Log _log = LogFactoryUtil.getLog(NtlmAutoLogin.class);

    public String[] login(HttpServletRequest request, HttpServletResponse response) {
        String[] credentials = null;
        try {
            long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
            if (!AuthSettingsUtil.isNtlmEnabled(companyId)) {
                return credentials;
            }
            String screenName = (String)request.getAttribute("NTLM_REMOTE_USER");
            if (screenName == null) {
                return credentials;
            }
            request.removeAttribute("NTLM_REMOTE_USER");
            User user = PortalLDAPImporterUtil.importLDAPUserByScreenName((long)companyId, (String)screenName);
            if (user != null) {
                String redirect = ParamUtil.getString((HttpServletRequest)request, (String)"redirect");
                if (Validator.isNotNull((String)redirect)) {
                    request.setAttribute("AUTO_LOGIN_REDIRECT_AND_CONTINUE", (Object)redirect);
                }
                credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), Boolean.TRUE.toString()};
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return credentials;
    }
}

