/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.AutoLogin;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.OpenIdUtil;
import com.liferay.portal.util.PortalUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class OpenIdAutoLogin
implements AutoLogin {
    private static Log _log = LogFactoryUtil.getLog(OpenIdAutoLogin.class);

    public String[] login(HttpServletRequest request, HttpServletResponse response) {
        String[] credentials = null;
        try {
            long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
            if (!OpenIdUtil.isEnabled(companyId)) {
                return credentials;
            }
            HttpSession session = request.getSession();
            Long userId = (Long)session.getAttribute("OPEN_ID_LOGIN");
            if (userId == null) {
                return credentials;
            }
            session.removeAttribute("OPEN_ID_LOGIN");
            User user = UserLocalServiceUtil.getUserById((long)userId);
            credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), Boolean.TRUE.toString()};
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return credentials;
    }
}

