/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.AutoLogin;
import com.liferay.portal.security.auth.AutoLoginException;
import com.liferay.portal.security.pwd.PwdEncryptor;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ParameterAutoLogin
implements AutoLogin {
    private static final String _LOGIN_PARAM = "parameterAutoLoginLogin";
    private static final String _PASSWORD_PARAM = "parameterAutoLoginPassword";

    public String[] login(HttpServletRequest request, HttpServletResponse response) throws AutoLoginException {
        long userId;
        String password;
        block13: {
            block12: {
                String login;
                block11: {
                    block10: {
                        try {
                            login = ParamUtil.getString((HttpServletRequest)request, (String)this.getLoginParam());
                            if (!Validator.isNull((String)login)) break block10;
                            return null;
                        }
                        catch (Exception e2) {
                            throw new AutoLoginException((Throwable)e2);
                        }
                    }
                    password = ParamUtil.getString((HttpServletRequest)request, (String)this.getPasswordParam());
                    if (!Validator.isNull((String)password)) break block11;
                    return null;
                }
                Company company = PortalUtil.getCompany((HttpServletRequest)request);
                String authType = company.getAuthType();
                userId = 0L;
                if (authType.equals("emailAddress")) {
                    userId = UserLocalServiceUtil.getUserIdByEmailAddress((long)company.getCompanyId(), (String)login);
                    break block12;
                }
                if (authType.equals("screenName")) {
                    userId = UserLocalServiceUtil.getUserIdByScreenName((long)company.getCompanyId(), (String)login);
                    break block12;
                }
                if (authType.equals("userId")) {
                    userId = GetterUtil.getLong((String)login);
                    break block12;
                }
                return null;
            }
            if (userId <= 0L) break block13;
            User user = UserLocalServiceUtil.getUserById((long)userId);
            String userPassword = user.getPassword();
            if (!user.isPasswordEncrypted()) {
                userPassword = PwdEncryptor.encrypt(userPassword);
            }
            String encPassword = PwdEncryptor.encrypt(password);
            if (userPassword.equals(password) || userPassword.equals(encPassword)) break block13;
            return null;
        }
        String[] credentials = new String[]{String.valueOf(userId), password, Boolean.FALSE.toString()};
        return credentials;
    }

    protected String getLoginParam() {
        return _LOGIN_PARAM;
    }

    protected String getPasswordParam() {
        return _PASSWORD_PARAM;
    }
}

