/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.AutoLogin;
import com.liferay.portal.security.ldap.PortalLDAPImporterUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestHeaderAutoLogin
implements AutoLogin {
    private static Log _log = LogFactoryUtil.getLog(RequestHeaderAutoLogin.class);

    public String[] login(HttpServletRequest request, HttpServletResponse response) {
        String[] credentials = null;
        try {
            long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
            String screenName = request.getHeader("LIFERAY_SCREEN_NAME");
            if (Validator.isNull((String)screenName)) {
                return credentials;
            }
            User user = null;
            if (PrefsPropsUtil.getBoolean(companyId, "request.header.auth.import.from.ldap", PropsValues.REQUEST_HEADER_AUTH_IMPORT_FROM_LDAP)) {
                try {
                    user = PortalLDAPImporterUtil.importLDAPUser((long)companyId, (String)"", (String)screenName);
                }
                catch (Exception exception) {}
            }
            if (user == null) {
                user = UserLocalServiceUtil.getUserByScreenName((long)companyId, (String)screenName);
            }
            credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), Boolean.TRUE.toString()};
            return credentials;
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            return credentials;
        }
    }
}

