/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.lang;

import com.liferay.portal.jndi.pacl.PACLInitialContextFactoryBuilder;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.permission.PortalHookPermission;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.kernel.servlet.taglib.FileAvailabilityUtil;
import com.liferay.portal.kernel.util.JavaDetector;
import com.liferay.portal.security.lang.PortalSecurityManagerThreadLocal;
import com.liferay.portal.security.pacl.PACLClassUtil;
import com.liferay.portal.security.pacl.PACLPolicy;
import com.liferay.portal.security.pacl.PACLPolicyManager;
import com.liferay.portal.security.pacl.checker.CheckerUtil;
import java.lang.reflect.Field;
import java.security.Permission;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;

public class PortalSecurityManager
extends SecurityManager {
    private static Log _log = LogFactoryUtil.getLog((String)PortalSecurityManager.class.getName());
    private SecurityManager _parentSecurityManager;

    public PortalSecurityManager() {
        block3: {
            this._parentSecurityManager = System.getSecurityManager();
            this.initClasses();
            try {
                this.initInitialContextFactoryBuilder();
            }
            catch (Exception e2) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Unable to override the initial context factory builder because one already exists. JNDI security is not enabled.");
                }
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)e2, (Throwable)e2);
            }
        }
    }

    public void checkPermission(Permission permission) {
        this.checkPermission(permission, null);
    }

    public void checkPermission(Permission permission, Object context) {
        if (!PACLPolicyManager.isActive() || !PortalSecurityManagerThreadLocal.isEnabled()) {
            this.parentCheckPermission(permission, context);
            return;
        }
        PACLPolicy paclPolicy = PACLPolicyManager.getDefaultPACLPolicy();
        if (!paclPolicy.isCheckablePermission(permission)) {
            this.parentCheckPermission(permission, context);
            return;
        }
        paclPolicy = this.getPACLPolicy(permission);
        if (paclPolicy == null || !paclPolicy.isActive()) {
            this.parentCheckPermission(permission, context);
            return;
        }
        paclPolicy.checkPermission(permission);
        this.parentCheckPermission(permission, context);
    }

    protected PACLPolicy getPACLPolicy(Permission permission) {
        PortalRuntimePermission portalRuntimePermission;
        String name;
        PACLPolicy paclPolicy = PortalSecurityManagerThreadLocal.getPACLPolicy();
        if (paclPolicy != null) {
            return paclPolicy;
        }
        if (permission instanceof PortalHookPermission) {
            PortalHookPermission portalHookPermission = (PortalHookPermission)permission;
            ClassLoader classLoader = portalHookPermission.getClassLoader();
            paclPolicy = PACLPolicyManager.getPACLPolicy(classLoader);
            if (paclPolicy == null) {
                paclPolicy = PACLPolicyManager.getDefaultPACLPolicy();
            }
            return paclPolicy;
        }
        if (permission instanceof PortalRuntimePermission && (name = (portalRuntimePermission = (PortalRuntimePermission)permission).getName()).equals("expandoBridge")) {
            return PACLClassUtil.getPACLPolicyByReflection(true, _log.isDebugEnabled());
        }
        return PACLClassUtil.getPACLPolicyByReflection(false, _log.isDebugEnabled());
    }

    protected void initClasses() {
        _log.debug((Object)("Loading " + FileAvailabilityUtil.class.getName()));
        _log.debug((Object)("Loading " + PortalHookPermission.class.getName()));
        CheckerUtil.isAccessControllerDoPrivileged(0);
        PACLClassUtil.getPACLPolicyByReflection(false, false);
    }

    protected void initInitialContextFactoryBuilder() throws Exception {
        if (!NamingManager.hasInitialContextFactoryBuilder()) {
            PACLInitialContextFactoryBuilder paclInitialContextFactoryBuilder = new PACLInitialContextFactoryBuilder();
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Overriding the initial context factory builder");
            }
            NamingManager.setInitialContextFactoryBuilder(paclInitialContextFactoryBuilder);
        }
        Class<NamingManager> clazz = NamingManager.class;
        String fieldName = "initctx_factory_builder";
        if (JavaDetector.isIBM()) {
            fieldName = "icfb";
        }
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        InitialContextFactoryBuilder initialContextFactoryBuilder = (InitialContextFactoryBuilder)field.get(null);
        if (initialContextFactoryBuilder instanceof PACLInitialContextFactoryBuilder) {
            return;
        }
        PACLInitialContextFactoryBuilder paclInitialContextFactoryBuilder = new PACLInitialContextFactoryBuilder();
        paclInitialContextFactoryBuilder.setInitialContextFactoryBuilder(initialContextFactoryBuilder);
        field.set(null, paclInitialContextFactoryBuilder);
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Overriding the initial context factory builder using reflection");
        }
    }

    protected void parentCheckPermission(Permission permission, Object context) {
        if (this._parentSecurityManager != null) {
            if (context == null) {
                context = this.getSecurityContext();
            }
            this._parentSecurityManager.checkPermission(permission, context);
        }
    }
}

