/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.log.LogUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.ldap.LDAPSettingsUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalLDAPUtil {
    private static Log _log = LogFactoryUtil.getLog(PortalLDAPUtil.class);

    public static LdapContext getContext(long ldapServerId, long companyId) throws Exception {
        String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
        String baseProviderURL = PrefsPropsUtil.getString(companyId, "ldap.base.provider.url" + postfix);
        String pricipal = PrefsPropsUtil.getString(companyId, "ldap.security.principal" + postfix);
        String credentials = PrefsPropsUtil.getString(companyId, "ldap.security.credentials" + postfix);
        return PortalLDAPUtil.getContext(companyId, baseProviderURL, pricipal, credentials);
    }

    public static LdapContext getContext(long companyId, String providerURL, String principal, String credentials) throws Exception {
        InitialLdapContext ldapContext;
        block3: {
            Properties environmentProperties = new Properties();
            environmentProperties.put("java.naming.factory.initial", PrefsPropsUtil.getString(companyId, "ldap.factory.initial"));
            environmentProperties.put("java.naming.provider.url", providerURL);
            environmentProperties.put("java.naming.security.principal", principal);
            environmentProperties.put("java.naming.security.credentials", credentials);
            environmentProperties.put("java.naming.referral", PrefsPropsUtil.getString(companyId, "ldap.referral"));
            Properties ldapConnectionProperties = PropsUtil.getProperties("ldap.connection.", true);
            PropertiesUtil.merge((Properties)environmentProperties, (Properties)ldapConnectionProperties);
            LogUtil.debug((Log)_log, (Properties)environmentProperties);
            ldapContext = null;
            try {
                ldapContext = new InitialLdapContext(environmentProperties, null);
            }
            catch (Exception e2) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Failed to bind to the LDAP server");
                }
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)e2, (Throwable)e2);
            }
        }
        return ldapContext;
    }

    public static Binding getGroup(long ldapServerId, long companyId, String groupName) throws Exception {
        String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
        LdapContext ldapContext = PortalLDAPUtil.getContext(ldapServerId, companyId);
        NamingEnumeration<SearchResult> enu = null;
        try {
            if (ldapContext == null) {
                return null;
            }
            String baseDN = PrefsPropsUtil.getString(companyId, "ldap.base.dn" + postfix);
            Properties groupMappings = LDAPSettingsUtil.getGroupMappings(ldapServerId, companyId);
            StringBundler filter = new StringBundler(5);
            filter.append("(");
            filter.append(groupMappings.getProperty("groupName"));
            filter.append("=");
            filter.append(groupName);
            filter.append(")");
            SearchControls searchControls = new SearchControls(2, 1L, 0, null, false, false);
            enu = ldapContext.search(baseDN, filter.toString(), searchControls);
            if (enu.hasMoreElements()) {
                Binding binding;
                Binding binding2 = binding = (Binding)enu.nextElement();
                return binding2;
            }
            return null;
        }
        catch (Exception e2) {
            throw e2;
        }
        finally {
            if (enu != null) {
                enu.close();
            }
            if (ldapContext != null) {
                ldapContext.close();
            }
        }
    }

    public static Attributes getGroupAttributes(long ldapServerId, long companyId, LdapContext ldapContext, String fullDistinguishedName) throws Exception {
        return PortalLDAPUtil.getGroupAttributes(ldapServerId, companyId, ldapContext, fullDistinguishedName, false);
    }

    public static Attributes getGroupAttributes(long ldapServerId, long companyId, LdapContext ldapContext, String fullDistinguishedName, boolean includeReferenceAttributes) throws Exception {
        Properties groupMappings = LDAPSettingsUtil.getGroupMappings(ldapServerId, companyId);
        ArrayList<String> mappedGroupAttributeIds = new ArrayList<String>();
        mappedGroupAttributeIds.add(groupMappings.getProperty("groupName"));
        mappedGroupAttributeIds.add(groupMappings.getProperty("description"));
        if (includeReferenceAttributes) {
            mappedGroupAttributeIds.add(groupMappings.getProperty("user"));
        }
        return PortalLDAPUtil._getAttributes(ldapContext, fullDistinguishedName, mappedGroupAttributeIds.toArray(new String[mappedGroupAttributeIds.size()]));
    }

    public static byte[] getGroups(long companyId, LdapContext ldapContext, byte[] cookie, int maxResults, String baseDN, String groupFilter, List<SearchResult> searchResults) throws Exception {
        return PortalLDAPUtil.searchLDAP(companyId, ldapContext, cookie, maxResults, baseDN, groupFilter, null, searchResults);
    }

    public static byte[] getGroups(long companyId, LdapContext ldapContext, byte[] cookie, int maxResults, String baseDN, String groupFilter, String[] attributeIds, List<SearchResult> searchResults) throws Exception {
        return PortalLDAPUtil.searchLDAP(companyId, ldapContext, cookie, maxResults, baseDN, groupFilter, attributeIds, searchResults);
    }

    public static byte[] getGroups(long ldapServerId, long companyId, LdapContext ldapContext, byte[] cookie, int maxResults, List<SearchResult> searchResults) throws Exception {
        String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
        String baseDN = PrefsPropsUtil.getString(companyId, "ldap.base.dn" + postfix);
        String groupFilter = PrefsPropsUtil.getString(companyId, "ldap.import.group.search.filter" + postfix);
        return PortalLDAPUtil.getGroups(companyId, ldapContext, cookie, maxResults, baseDN, groupFilter, searchResults);
    }

    public static byte[] getGroups(long ldapServerId, long companyId, LdapContext ldapContext, byte[] cookie, int maxResults, String[] attributeIds, List<SearchResult> searchResults) throws Exception {
        String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
        String baseDN = PrefsPropsUtil.getString(companyId, "ldap.base.dn" + postfix);
        String groupFilter = PrefsPropsUtil.getString(companyId, "ldap.import.group.search.filter" + postfix);
        return PortalLDAPUtil.getGroups(companyId, ldapContext, cookie, maxResults, baseDN, groupFilter, attributeIds, searchResults);
    }

    public static String getGroupsDN(long ldapServerId, long companyId) throws Exception {
        String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
        return PrefsPropsUtil.getString(companyId, "ldap.groups.dn" + postfix);
    }

    public static long getLdapServerId(long companyId, String screenName, String emailAddress) throws Exception {
        String postfix;
        String providerUrl;
        long[] ldapServerIds;
        long[] lArray = ldapServerIds = StringUtil.split((String)PrefsPropsUtil.getString(companyId, "ldap.server.ids"), (long)0L);
        int n = ldapServerIds.length;
        int n2 = 0;
        while (n2 < n) {
            long ldapServerId = lArray[n2];
            if (PortalLDAPUtil.hasUser(ldapServerId, companyId, screenName, emailAddress)) {
                return ldapServerId;
            }
            ++n2;
        }
        boolean hasProperties = false;
        int ldapServerId = 0;
        while (!Validator.isNull((String)(providerUrl = PrefsPropsUtil.getString(companyId, "ldap.base.provider.url" + (postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId)))))) {
            hasProperties = true;
            if (PortalLDAPUtil.hasUser(ldapServerId, companyId, screenName, emailAddress)) {
                return ldapServerId;
            }
            ++ldapServerId;
        }
        if (hasProperties || ldapServerIds.length <= 0) {
            return 0L;
        }
        return ldapServerIds[0];
    }

    public static Attribute getMultivaluedAttribute(long companyId, LdapContext ldapContext, String baseDN, String filter, Attribute attribute) throws Exception {
        if (attribute.size() > 0) {
            return attribute;
        }
        String[] attributeIds = new String[]{PortalLDAPUtil._getNextRange(attribute.getID())};
        while (true) {
            SearchResult searchResult;
            Attributes attributes;
            ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
            PortalLDAPUtil.searchLDAP(companyId, ldapContext, new byte[0], 0, baseDN, filter, attributeIds, searchResults);
            if (searchResults.size() != 1 || (attributes = (searchResult = (SearchResult)searchResults.get(0)).getAttributes()).size() != 1) break;
            NamingEnumeration<? extends Attribute> enu = null;
            try {
                enu = attributes.getAll();
                if (!enu.hasMoreElements()) break;
                Attribute curAttribute = (Attribute)enu.nextElement();
                int i2 = 0;
                while (i2 < curAttribute.size()) {
                    attribute.add(curAttribute.get(i2));
                    ++i2;
                }
                if (StringUtil.endsWith((String)curAttribute.getID(), (String)"*") || curAttribute.size() < PropsValues.LDAP_RANGE_SIZE) {
                    break;
                }
            }
            finally {
                if (enu != null) {
                    enu.close();
                }
            }
            attributeIds[0] = PortalLDAPUtil._getNextRange(attributeIds[0]);
        }
        return attribute;
    }

    public static String getNameInNamespace(long ldapServerId, long companyId, Binding binding) throws Exception {
        String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
        String baseDN = PrefsPropsUtil.getString(companyId, "ldap.base.dn" + postfix);
        String name = binding.getName();
        if (name.startsWith("\"") && name.endsWith("\"")) {
            name = name.substring(1, name.length() - 1);
        }
        if (Validator.isNull((String)baseDN)) {
            return name.toString();
        }
        return name.concat(",").concat(baseDN);
    }

    public static Binding getUser(long ldapServerId, long companyId, String screenName, String emailAddress) throws Exception {
        String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
        LdapContext ldapContext = PortalLDAPUtil.getContext(ldapServerId, companyId);
        NamingEnumeration<SearchResult> enu = null;
        try {
            StringBundler sb;
            if (ldapContext == null) {
                return null;
            }
            String baseDN = PrefsPropsUtil.getString(companyId, "ldap.base.dn" + postfix);
            String filter = null;
            String userFilter = PrefsPropsUtil.getString(companyId, "ldap.import.user.search.filter" + postfix);
            Properties userMappings = LDAPSettingsUtil.getUserMappings(ldapServerId, companyId);
            String login = null;
            String loginMapping = null;
            String authType = PrefsPropsUtil.getString(companyId, "company.security.auth.type", PropsValues.COMPANY_SECURITY_AUTH_TYPE);
            if (authType.equals("screenName") && !PrefsPropsUtil.getBoolean(companyId, "users.screen.name.always.autogenerate")) {
                login = screenName;
                loginMapping = userMappings.getProperty("screenName");
            } else {
                login = emailAddress;
                loginMapping = userMappings.getProperty("emailAddress");
            }
            if (Validator.isNotNull((String)userFilter)) {
                sb = new StringBundler(11);
                sb.append("(");
                sb.append("&");
                sb.append("(");
                sb.append(loginMapping);
                sb.append("=");
                sb.append(login);
                sb.append(")");
                sb.append("(");
                sb.append(userFilter);
                sb.append(")");
                sb.append(")");
                filter = sb.toString();
            } else {
                sb = new StringBundler(5);
                sb.append("(");
                sb.append(loginMapping);
                sb.append("=");
                sb.append(login);
                sb.append(")");
                filter = sb.toString();
            }
            SearchControls searchControls = new SearchControls(2, 1L, 0, null, false, false);
            enu = ldapContext.search(baseDN, filter, searchControls);
            if (enu.hasMoreElements()) {
                Binding binding;
                Binding binding2 = binding = (Binding)enu.nextElement();
                return binding2;
            }
            return null;
        }
        catch (Exception e2) {
            throw e2;
        }
        finally {
            if (enu != null) {
                enu.close();
            }
            if (ldapContext != null) {
                ldapContext.close();
            }
        }
    }

    public static Attributes getUserAttributes(long ldapServerId, long companyId, LdapContext ldapContext, String fullDistinguishedName) throws Exception {
        Properties userMappings = LDAPSettingsUtil.getUserMappings(ldapServerId, companyId);
        Properties userExpandoMappings = LDAPSettingsUtil.getUserExpandoMappings(ldapServerId, companyId);
        PropertiesUtil.merge((Properties)userMappings, (Properties)userExpandoMappings);
        Properties contactMappings = LDAPSettingsUtil.getContactMappings(ldapServerId, companyId);
        Properties contactExpandoMappings = LDAPSettingsUtil.getContactExpandoMappings(ldapServerId, companyId);
        PropertiesUtil.merge((Properties)contactMappings, (Properties)contactExpandoMappings);
        PropertiesUtil.merge((Properties)userMappings, (Properties)contactMappings);
        String[] mappedUserAttributeIds = ArrayUtil.toStringArray((Object[])userMappings.values().toArray(new Object[userMappings.size()]));
        return PortalLDAPUtil._getAttributes(ldapContext, fullDistinguishedName, mappedUserAttributeIds);
    }

    public static byte[] getUsers(long companyId, LdapContext ldapContext, byte[] cookie, int maxResults, String baseDN, String userFilter, List<SearchResult> searchResults) throws Exception {
        return PortalLDAPUtil.searchLDAP(companyId, ldapContext, cookie, maxResults, baseDN, userFilter, null, searchResults);
    }

    public static byte[] getUsers(long companyId, LdapContext ldapContext, byte[] cookie, int maxResults, String baseDN, String userFilter, String[] attributeIds, List<SearchResult> searchResults) throws Exception {
        return PortalLDAPUtil.searchLDAP(companyId, ldapContext, cookie, maxResults, baseDN, userFilter, attributeIds, searchResults);
    }

    public static byte[] getUsers(long ldapServerId, long companyId, LdapContext ldapContext, byte[] cookie, int maxResults, List<SearchResult> searchResults) throws Exception {
        String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
        String baseDN = PrefsPropsUtil.getString(companyId, "ldap.base.dn" + postfix);
        String userFilter = PrefsPropsUtil.getString(companyId, "ldap.import.user.search.filter" + postfix);
        return PortalLDAPUtil.getUsers(companyId, ldapContext, cookie, maxResults, baseDN, userFilter, searchResults);
    }

    public static byte[] getUsers(long ldapServerId, long companyId, LdapContext ldapContext, byte[] cookie, int maxResults, String[] attributeIds, List<SearchResult> searchResults) throws Exception {
        String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
        String baseDN = PrefsPropsUtil.getString(companyId, "ldap.base.dn" + postfix);
        String userFilter = PrefsPropsUtil.getString(companyId, "ldap.import.user.search.filter" + postfix);
        return PortalLDAPUtil.getUsers(companyId, ldapContext, cookie, maxResults, baseDN, userFilter, attributeIds, searchResults);
    }

    public static String getUsersDN(long ldapServerId, long companyId) throws Exception {
        String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
        return PrefsPropsUtil.getString(companyId, "ldap.users.dn" + postfix);
    }

    public static boolean hasUser(long ldapServerId, long companyId, String screenName, String emailAddress) throws Exception {
        return PortalLDAPUtil.getUser(ldapServerId, companyId, screenName, emailAddress) != null;
    }

    public static boolean isGroupMember(long ldapServerId, long companyId, String groupDN, String userDN) throws Exception {
        LdapContext ldapContext = PortalLDAPUtil.getContext(ldapServerId, companyId);
        NamingEnumeration<SearchResult> enu = null;
        try {
            if (ldapContext == null) {
                return false;
            }
            Properties groupMappings = LDAPSettingsUtil.getGroupMappings(ldapServerId, companyId);
            StringBundler filter = new StringBundler(5);
            filter.append("(");
            filter.append(groupMappings.getProperty("user"));
            filter.append("=");
            filter.append(userDN);
            filter.append(")");
            SearchControls searchControls = new SearchControls(2, 1L, 0, null, false, false);
            enu = ldapContext.search(groupDN, filter.toString(), searchControls);
            if (enu.hasMoreElements()) {
                return true;
            }
        }
        catch (NameNotFoundException nnfe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to determine if user DN " + userDN + " is a member of group DN " + groupDN), (Throwable)nnfe);
            }
        }
        finally {
            if (enu != null) {
                enu.close();
            }
            if (ldapContext != null) {
                ldapContext.close();
            }
        }
        return false;
    }

    public static boolean isUserGroupMember(long ldapServerId, long companyId, String groupDN, String userDN) throws Exception {
        LdapContext ldapContext = PortalLDAPUtil.getContext(ldapServerId, companyId);
        NamingEnumeration<SearchResult> enu = null;
        try {
            if (ldapContext == null) {
                return false;
            }
            Properties userMappings = LDAPSettingsUtil.getUserMappings(ldapServerId, companyId);
            StringBundler filter = new StringBundler(5);
            filter.append("(");
            filter.append(userMappings.getProperty("group"));
            filter.append("=");
            filter.append(groupDN);
            filter.append(")");
            SearchControls searchControls = new SearchControls(2, 1L, 0, null, false, false);
            enu = ldapContext.search(userDN, filter.toString(), searchControls);
            if (enu.hasMoreElements()) {
                return true;
            }
        }
        catch (NameNotFoundException nnfe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to determine if group DN " + groupDN + " is a member of user DN " + userDN), (Throwable)nnfe);
            }
        }
        finally {
            if (enu != null) {
                enu.close();
            }
            if (ldapContext != null) {
                ldapContext.close();
            }
        }
        return false;
    }

    public static byte[] searchLDAP(long companyId, LdapContext ldapContext, byte[] cookie, int maxResults, String baseDN, String filter, String[] attributeIds, List<SearchResult> searchResults) throws Exception {
        SearchControls searchControls = new SearchControls(2, maxResults, 0, attributeIds, false, false);
        NamingEnumeration<SearchResult> enu = null;
        try {
            if (cookie != null) {
                if (cookie.length == 0) {
                    ldapContext.setRequestControls(new Control[]{new PagedResultsControl(PropsValues.LDAP_PAGE_SIZE, true)});
                } else {
                    ldapContext.setRequestControls(new Control[]{new PagedResultsControl(PropsValues.LDAP_PAGE_SIZE, cookie, true)});
                }
                enu = ldapContext.search(baseDN, filter, searchControls);
                while (enu.hasMoreElements()) {
                    searchResults.add((SearchResult)enu.nextElement());
                }
                byte[] byArray = PortalLDAPUtil._getCookie(ldapContext.getResponseControls());
                return byArray;
            }
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            if (enu != null) {
                enu.close();
            }
            ldapContext.setRequestControls(null);
            enu = ldapContext.search(baseDN, filter, searchControls);
            while (enu.hasMoreElements()) {
                searchResults.add((SearchResult)enu.nextElement());
            }
        }
        finally {
            if (enu != null) {
                enu.close();
            }
            ldapContext.setRequestControls(null);
        }
        return null;
    }

    private static Attributes _getAttributes(LdapContext ldapContext, String fullDistinguishedName, String[] attributeIds) throws Exception {
        Name fullDN = new CompositeName().add(fullDistinguishedName);
        Attributes attributes = null;
        String[] auditAttributeIds = new String[]{"creatorsName", "createTimestamp", "modifiersName", "modifyTimestamp"};
        if (attributeIds == null) {
            attributes = ldapContext.getAttributes(fullDN);
            NamingEnumeration<? extends Attribute> enu = null;
            try {
                enu = ldapContext.getAttributes(fullDN, auditAttributeIds).getAll();
                while (enu.hasMoreElements()) {
                    attributes.put((Attribute)enu.nextElement());
                }
            }
            finally {
                if (enu != null) {
                    enu.close();
                }
            }
        } else {
            int attributeCount = attributeIds.length + auditAttributeIds.length;
            String[] allAttributeIds = new String[attributeCount];
            System.arraycopy(attributeIds, 0, allAttributeIds, 0, attributeIds.length);
            System.arraycopy(auditAttributeIds, 0, allAttributeIds, attributeIds.length, auditAttributeIds.length);
            attributes = ldapContext.getAttributes(fullDN, allAttributeIds);
        }
        return attributes;
    }

    private static byte[] _getCookie(Control[] controls) {
        if (controls == null) {
            return null;
        }
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof PagedResultsResponseControl) {
                PagedResultsResponseControl pagedResultsResponseControl = (PagedResultsResponseControl)control;
                return pagedResultsResponseControl.getCookie();
            }
            ++n2;
        }
        return null;
    }

    private static String _getNextRange(String attributeId) {
        String originalAttributeId = null;
        int start = 0;
        int end = 0;
        int x = attributeId.indexOf(59);
        if (x < 0) {
            originalAttributeId = attributeId;
            end = PropsValues.LDAP_RANGE_SIZE - 1;
        } else {
            int y = attributeId.indexOf(61, x);
            int z = attributeId.indexOf(45, y);
            originalAttributeId = attributeId.substring(0, x);
            start = GetterUtil.getInteger((String)attributeId.substring(y + 1, z));
            end = GetterUtil.getInteger((String)attributeId.substring(z + 1));
            start += PropsValues.LDAP_RANGE_SIZE;
            end += PropsValues.LDAP_RANGE_SIZE;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(originalAttributeId);
        sb.append(";");
        sb.append("range=");
        sb.append(start);
        sb.append("-");
        sb.append(end);
        return sb.toString();
    }
}

