/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.permission.PortalServicePermission;
import com.liferay.portal.security.pacl.BasePACLPolicy;
import com.liferay.portal.security.pacl.checker.Checker;
import com.liferay.portal.security.pacl.checker.JNDIChecker;
import com.liferay.portal.security.pacl.checker.PortalServiceChecker;
import com.liferay.portal.security.pacl.checker.SQLChecker;
import java.lang.reflect.Method;
import java.security.Permission;
import java.util.Properties;

public class ActivePACLPolicy
extends BasePACLPolicy {
    private static Log _log = LogFactoryUtil.getLog(ActivePACLPolicy.class);
    private JNDIChecker _jndiChecker;
    private PortalServiceChecker _portalServiceChecker;
    private SQLChecker _sqlChecker;

    public ActivePACLPolicy(String servletContextName, ClassLoader classLoader, Properties properties) {
        super(servletContextName, classLoader, properties);
        try {
            this.initJNDIChecker();
            this.initPortalServiceChecker();
            this.initSQLChecker();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public void checkPermission(Permission permission) {
        Checker checker = this.getChecker(permission.getClass());
        checker.checkPermission(permission);
    }

    public boolean hasJNDI(String name) {
        return this._jndiChecker.hasJNDI(name);
    }

    public boolean hasPortalService(Object object, Method method, Object[] arguments) {
        return this._portalServiceChecker.hasService(object, method, arguments);
    }

    public boolean hasSQL(String sql) {
        return this._sqlChecker.hasSQL(sql);
    }

    public boolean isActive() {
        return true;
    }

    protected void initJNDIChecker() {
        this._jndiChecker = new JNDIChecker();
        this.initChecker(this._jndiChecker);
    }

    protected void initPortalServiceChecker() {
        this._portalServiceChecker = (PortalServiceChecker)this.getChecker(PortalServicePermission.class);
        if (this._portalServiceChecker == null) {
            this._portalServiceChecker = new PortalServiceChecker();
            this.initChecker(this._portalServiceChecker);
        }
    }

    protected void initSQLChecker() {
        this._sqlChecker = new SQLChecker();
        this.initChecker(this._sqlChecker);
    }
}

