/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.SortedProperties;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.pacl.PACLPolicy;
import com.liferay.portal.security.pacl.checker.Checker;
import java.security.Permission;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasePACLPolicy
implements PACLPolicy {
    private static Log _log = LogFactoryUtil.getLog(BasePACLPolicy.class);
    private Map<String, Checker> _checkers = new HashMap<String, Checker>();
    private ClassLoader _classLoader;
    private Properties _properties;
    private String _servletContextName;

    public BasePACLPolicy(String servletContextName, ClassLoader classLoader, Properties properties) {
        this._servletContextName = servletContextName;
        this._classLoader = classLoader;
        this._properties = properties;
        try {
            this.initCheckers();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    @Override
    public Properties getProperties() {
        return this._properties;
    }

    @Override
    public String getProperty(String key) {
        return this._properties.getProperty(key);
    }

    @Override
    public String[] getPropertyArray(String key) {
        return StringUtil.split((String)this.getProperty(key));
    }

    @Override
    public boolean getPropertyBoolean(String key) {
        return GetterUtil.getBoolean((String)this.getProperty(key));
    }

    @Override
    public Set<String> getPropertySet(String key) {
        return SetUtil.fromArray((Object[])this.getPropertyArray(key));
    }

    @Override
    public String getServletContextName() {
        return this._servletContextName;
    }

    @Override
    public boolean isCheckablePermission(Permission permission) {
        Class<?> clazz = permission.getClass();
        return this._checkers.containsKey(clazz.getName());
    }

    public String toString() {
        StringBundler sb = new StringBundler(7);
        sb.append("{active=");
        sb.append(this.isActive());
        sb.append(", hashCode=");
        sb.append(this.hashCode());
        sb.append(", servletContextName=");
        sb.append(this._servletContextName);
        sb.append("}");
        return sb.toString();
    }

    protected Checker getChecker(Class<? extends Permission> clazz) {
        return this._checkers.get(clazz.getName());
    }

    protected Checker initChecker(Checker checker) {
        checker.setPACLPolicy(this);
        checker.afterPropertiesSet();
        return checker;
    }

    protected void initCheckers() throws Exception {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        Properties portalProperties = PropsUtil.getProperties((String)"portal.security.manager.pacl.policy.checker", (boolean)false);
        portalProperties = new SortedProperties(portalProperties);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Registering " + portalProperties.size() + " PACL policy checkers"));
        }
        for (Map.Entry<Object, Object> entry : portalProperties.entrySet()) {
            String key = (String)entry.getKey();
            int x = key.indexOf("[");
            int y = key.indexOf("]");
            String permissionClassName = key.substring(x + 1, y);
            String checkerClassName = (String)entry.getValue();
            Class<?> checkerClass = classLoader.loadClass(checkerClassName);
            Checker checker = (Checker)checkerClass.newInstance();
            this.initChecker(checker);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Registering permission " + permissionClassName + " with PACL policy " + checkerClassName));
            }
            this._checkers.put(permissionClassName, checker);
        }
    }
}

