/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.security.lang.PortalSecurityManagerThreadLocal;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portal.security.pacl.PACLClassUtil;
import com.liferay.portal.security.pacl.PACLPolicy;
import com.liferay.portal.security.pacl.PACLPolicyManager;
import com.liferay.portal.service.impl.PortalServiceImpl;
import com.liferay.portal.spring.aop.ChainableMethodAdvice;
import com.liferay.portal.spring.aop.ServiceBeanAopProxy;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;

public class PACLAdvice
extends ChainableMethodAdvice {
    private static final String _ENTRY_LOCAL_SERVICE_IMPL_CLASS_NAME = "com.liferay.chat.service.impl.EntryLocalServiceImpl";
    private static final String _STATUS_LOCAL_SERVICE_IMPL_CLASS_NAME = "com.liferay.chat.service.impl.StatusLocalServiceImpl";
    private static Log _log = LogFactoryUtil.getLog(PACLAdvice.class);

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Class<?> clazz;
        String className;
        if (!PortalSecurityManagerThreadLocal.isEnabled()) {
            return methodInvocation.proceed();
        }
        if (!PACLPolicyManager.isActive()) {
            ServiceBeanAopProxy.removeMethodInterceptor(methodInvocation, this);
            return methodInvocation.proceed();
        }
        Object thisObject = methodInvocation.getThis();
        Method method = methodInvocation.getMethod();
        Object[] arguments = methodInvocation.getArguments();
        boolean debug = false;
        if (_log.isDebugEnabled() && ((className = (clazz = thisObject.getClass()).getName()).equals(PortalServiceImpl.class.getName()) || className.equals(_ENTRY_LOCAL_SERVICE_IMPL_CLASS_NAME) || className.equals(_STATUS_LOCAL_SERVICE_IMPL_CLASS_NAME))) {
            debug = true;
            _log.debug((Object)("Intercepting " + className + "#" + method.getName()));
        }
        if (method.getDeclaringClass() == Object.class) {
            String methodName = method.getName();
            if (methodName.equals("equals")) {
                if (thisObject == arguments[0]) {
                    return true;
                }
                return false;
            }
            if (methodName.equals("toString")) {
                return method.invoke(thisObject, arguments);
            }
        }
        if (!PACLPolicyManager.isActive()) {
            return method.invoke(thisObject, arguments);
        }
        PACLPolicy paclPolicy = PACLClassUtil.getPACLPolicy(false, debug);
        if (debug && paclPolicy != null) {
            _log.debug((Object)("Retrieved PACL policy for " + paclPolicy.getServletContextName()));
        }
        if (paclPolicy == null) {
            return methodInvocation.proceed();
        }
        if (!paclPolicy.hasPortalService(thisObject, method, arguments)) {
            throw new SecurityException("Attempted to invoke " + method);
        }
        boolean checkSQL = PortalSecurityManagerThreadLocal.isCheckSQL();
        try {
            Class<?> thisObjectClass = thisObject.getClass();
            if (paclPolicy.getClassLoader() != PACLClassLoaderUtil.getClassLoader(thisObjectClass)) {
                PortalSecurityManagerThreadLocal.setCheckSQL(false);
            }
            Object object = methodInvocation.proceed();
            return object;
        }
        finally {
            PortalSecurityManagerThreadLocal.setCheckSQL(checkSQL);
        }
    }
}

