/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.security.lang.PortalSecurityManagerThreadLocal;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portal.security.pacl.PACLClassUtil;
import com.liferay.portal.security.pacl.PACLPolicy;
import com.liferay.portal.security.pacl.PACLPolicyManager;
import com.liferay.portal.service.persistence.GroupPersistenceImpl;
import com.liferay.portal.service.persistence.UserPersistenceImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PACLBeanHandler
implements InvocationHandler {
    private static Log _log = LogFactoryUtil.getLog(PACLBeanHandler.class);
    private Object _bean;

    public PACLBeanHandler(Object bean) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Creating handler for " + bean));
        }
        this._bean = bean;
    }

    public Object getBean() {
        return this._bean;
    }

    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        try {
            return this.doInvoke(proxy, method, arguments);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    protected Object doInvoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        Class<?> clazz;
        String className;
        boolean debug = false;
        if (_log.isDebugEnabled() && ((className = (clazz = this._bean.getClass()).getName()).equals(GroupPersistenceImpl.class.getName()) || className.equals(UserPersistenceImpl.class.getName()))) {
            debug = true;
            _log.debug((Object)("Intercepting " + className + "#" + method.getName()));
        }
        if (method.getDeclaringClass() == Object.class) {
            String methodName = method.getName();
            if (methodName.equals("equals")) {
                if (proxy == arguments[0]) {
                    return true;
                }
                return false;
            }
            if (methodName.equals("toString")) {
                return method.invoke(this._bean, arguments);
            }
        }
        if (!PACLPolicyManager.isActive()) {
            return method.invoke(this._bean, arguments);
        }
        PACLPolicy paclPolicy = PACLClassUtil.getPACLPolicy(false, debug);
        if (debug && paclPolicy != null) {
            _log.debug((Object)("Retrieved PACL policy for " + paclPolicy.getServletContextName()));
        }
        if (paclPolicy == null) {
            return method.invoke(this._bean, arguments);
        }
        if (!paclPolicy.hasPortalService(this._bean, method, arguments)) {
            throw new SecurityException("Attempted to invoke " + method);
        }
        boolean checkSQL = PortalSecurityManagerThreadLocal.isCheckSQL();
        try {
            Class<?> beanClass = this._bean.getClass();
            if (paclPolicy.getClassLoader() != PACLClassLoaderUtil.getClassLoader(beanClass)) {
                PortalSecurityManagerThreadLocal.setCheckSQL(false);
            }
            Object object = method.invoke(this._bean, arguments);
            return object;
        }
        finally {
            PortalSecurityManagerThreadLocal.setCheckSQL(checkSQL);
        }
    }
}

