/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl;

import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.security.lang.PortalSecurityManagerThreadLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PACLClassLoaderUtil {
    public static ClassLoader getClassLoader(Class<?> clazz) {
        boolean checkGetClassLoader = PortalSecurityManagerThreadLocal.isCheckGetClassLoader();
        try {
            PortalSecurityManagerThreadLocal.setCheckGetClassLoader(false);
            ClassLoader classLoader = clazz.getClassLoader();
            return classLoader;
        }
        finally {
            PortalSecurityManagerThreadLocal.setCheckGetClassLoader(checkGetClassLoader);
        }
    }

    public static ClassLoader getContextClassLoader() {
        boolean checkGetClassLoader = PortalSecurityManagerThreadLocal.isCheckGetClassLoader();
        try {
            PortalSecurityManagerThreadLocal.setCheckGetClassLoader(false);
            Thread thread = Thread.currentThread();
            ClassLoader classLoader = thread.getContextClassLoader();
            return classLoader;
        }
        finally {
            PortalSecurityManagerThreadLocal.setCheckGetClassLoader(checkGetClassLoader);
        }
    }

    public static ClassLoader getPortalClassLoader() {
        boolean checkGetClassLoader = PortalSecurityManagerThreadLocal.isCheckGetClassLoader();
        try {
            PortalSecurityManagerThreadLocal.setCheckGetClassLoader(false);
            ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
            return classLoader;
        }
        finally {
            PortalSecurityManagerThreadLocal.setCheckGetClassLoader(checkGetClassLoader);
        }
    }

    public static void setContextClassLoader(ClassLoader classLoader) {
        boolean checkGetClassLoader = PortalSecurityManagerThreadLocal.isCheckGetClassLoader();
        try {
            PortalSecurityManagerThreadLocal.setCheckGetClassLoader(false);
            Thread thread = Thread.currentThread();
            thread.setContextClassLoader(classLoader);
        }
        finally {
            PortalSecurityManagerThreadLocal.setCheckGetClassLoader(checkGetClassLoader);
        }
    }
}

