/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.lang.PortalSecurityManagerThreadLocal;
import com.liferay.portal.security.pacl.PACLAdvice;
import com.liferay.portal.security.pacl.PACLPolicy;
import com.liferay.portal.security.pacl.PACLPolicyManager;
import com.liferay.portal.spring.util.FilterClassLoader;
import java.net.URL;
import sun.reflect.Reflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PACLClassUtil {
    private static final String _ClASS_NAME_DYNAMIC_CLASS_LOADER = "com.caucho.loader.DynamicClassLoader";
    private static final String _ClASS_NAME_JASPER_LOADER = "org.apache.jasper.servlet.JasperLoader";
    private static final String _CLASS_NAME_JSP_CLASS_LOADER = "weblogic.servlet.jsp.JspClassLoader";
    private static final String _CLASS_NAME_JSP_EXTENSION_CLASS_LOADER = "com.ibm.ws.jsp.webcontainerext.JSPExtensionClassLoader";
    private static Log _log = LogFactoryUtil.getLog(PACLClassUtil.class);
    private static PACLClassUtil _instance = new PACLClassUtil();
    private ClassLoader _commonClassLoader;
    private ClassLoader _portalClassLoader;
    private ClassLoader _systemClassLoader = ClassLoader.getSystemClassLoader();

    public static ClassLoader getCallerClassLoader(Class<?> callerClass) {
        boolean enabled = PortalSecurityManagerThreadLocal.isEnabled();
        try {
            PortalSecurityManagerThreadLocal.setEnabled(false);
            ClassLoader classLoader = _instance._getCallerClassLoader(callerClass);
            return classLoader;
        }
        finally {
            PortalSecurityManagerThreadLocal.setEnabled(enabled);
        }
    }

    public static String getClassLocation(Class<?> clazz) {
        boolean enabled = PortalSecurityManagerThreadLocal.isEnabled();
        try {
            PortalSecurityManagerThreadLocal.setEnabled(false);
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader == null) {
                return "";
            }
            String className = clazz.getName();
            String name = StringUtil.replace((String)className, (String)".", (String)"/");
            name = String.valueOf(name) + ".class";
            URL url = classLoader.getResource(name);
            String string = url.toString();
            return string;
        }
        finally {
            PortalSecurityManagerThreadLocal.setEnabled(enabled);
        }
    }

    public static PACLPolicy getPACLPolicy(boolean deep, boolean debug) {
        PACLPolicy paclPolicy = PortalSecurityManagerThreadLocal.getPACLPolicy();
        if (paclPolicy != null) {
            return paclPolicy;
        }
        return PACLClassUtil.getPACLPolicyByReflection(deep, debug);
    }

    public static PACLPolicy getPACLPolicyByReflection(boolean deep, boolean debug) {
        boolean enabled = PortalSecurityManagerThreadLocal.isEnabled();
        try {
            PortalSecurityManagerThreadLocal.setEnabled(false);
            PACLPolicy pACLPolicy = _instance._getPACLPolicyByReflection(deep, debug);
            return pACLPolicy;
        }
        finally {
            PortalSecurityManagerThreadLocal.setEnabled(enabled);
        }
    }

    private PACLClassUtil() {
        this._portalClassLoader = PACLAdvice.class.getClassLoader();
        this._commonClassLoader = this._portalClassLoader.getParent();
    }

    private ClassLoader _getCallerClassLoader(Class<?> callerClass) {
        ClassLoader callerClassLoader = callerClass.getClassLoader();
        if (callerClassLoader == null) {
            return null;
        }
        Class<?> callerClassLoaderClass = callerClassLoader.getClass();
        String callerClassLoaderClassName = callerClassLoaderClass.getName();
        if (callerClassLoader instanceof FilterClassLoader && (callerClassLoader = callerClassLoader.getParent()) instanceof AggregateClassLoader) {
            callerClassLoader = callerClassLoader.getParent();
        }
        if (callerClassLoaderClassName.equals(_ClASS_NAME_JASPER_LOADER)) {
            callerClassLoader = callerClassLoader.getParent();
        } else if (ServerDetector.isResin()) {
            if (callerClassLoaderClassName.equals(_ClASS_NAME_DYNAMIC_CLASS_LOADER)) {
                callerClassLoader = callerClassLoader.getParent();
            }
        } else if (ServerDetector.isWebLogic()) {
            if (callerClassLoaderClassName.equals(_CLASS_NAME_JSP_CLASS_LOADER)) {
                callerClassLoader = callerClassLoader.getParent();
                callerClassLoader = callerClassLoader.getParent();
            }
        } else if (ServerDetector.isWebSphere() && callerClassLoaderClassName.equals(_CLASS_NAME_JSP_EXTENSION_CLASS_LOADER)) {
            callerClassLoader = callerClassLoader.getParent();
        }
        return callerClassLoader;
    }

    private PACLPolicy _getPACLPolicyByReflection(boolean deep, boolean debug) {
        Class callerClass;
        PACLPolicy paclPolicy = null;
        boolean initialPortalClassLoaderPhase = true;
        int i2 = 1;
        while ((callerClass = Reflection.getCallerClass((int)i2)) != null) {
            if (debug) {
                _log.debug((Object)("Frame " + i2 + " has caller class " + callerClass.getName()));
            }
            if (ProxyUtil.isProxyClass((Class)callerClass)) {
                if (debug) {
                    _log.debug((Object)"Skipping frame because it is proxy class");
                }
            } else {
                ClassLoader callerClassLoader = this._getCallerClassLoader(callerClass);
                if (callerClassLoader != null) {
                    if (!initialPortalClassLoaderPhase && callerClassLoader == this._portalClassLoader) {
                        PACLPolicy defaultPACLPolicy = PACLPolicyManager.getDefaultPACLPolicy();
                        if (paclPolicy == null) {
                            if (debug) {
                                _log.debug((Object)("Possibly return default PACL policy " + defaultPACLPolicy));
                            }
                            paclPolicy = defaultPACLPolicy;
                        }
                        if (!deep) {
                            break;
                        }
                    } else {
                        if (initialPortalClassLoaderPhase && callerClassLoader != this._portalClassLoader) {
                            initialPortalClassLoaderPhase = false;
                        }
                        if (callerClassLoader != this._commonClassLoader && callerClassLoader != this._portalClassLoader && callerClassLoader != this._systemClassLoader) {
                            PACLPolicy callerPACLPolicy;
                            if (debug) {
                                _log.debug((Object)("Lookup PACL policy for caller class loader " + callerClassLoader));
                            }
                            if ((callerPACLPolicy = PACLPolicyManager.getPACLPolicy(callerClassLoader)) != null) {
                                paclPolicy = callerPACLPolicy;
                                if (debug) {
                                    _log.debug((Object)("Possibly return PACL policy " + paclPolicy));
                                }
                                if (!deep) break;
                            }
                        }
                    }
                }
            }
            ++i2;
        }
        if (debug) {
            _log.debug((Object)("Returning PACL policy " + paclPolicy));
        }
        return paclPolicy;
    }
}

